/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageFieldArgument;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;

public class MessageUpserter<M extends PMessage<M>> {
    private final String queryPrefix;
    private final String querySuffix;
    private final Map<String, PField<M>> columnToFieldMap;
    private final Map<String, Integer> columnTypeMap;
    private final List<String> columnOrder;
    private final String valueMarkers;

    private MessageUpserter(String queryPrefix, String querySuffix, List<String> columnOrder, Map<String, PField<M>> columnToFieldMap, Map<String, Integer> columnTypeMap) {
        this.queryPrefix = queryPrefix;
        this.querySuffix = querySuffix;
        this.columnOrder = UnmodifiableList.copyOf(columnOrder);
        this.columnToFieldMap = UnmodifiableMap.copyOf(columnToFieldMap);
        this.columnTypeMap = UnmodifiableMap.copyOf(columnTypeMap);
        this.valueMarkers = "(" + columnOrder.stream().map(k -> "?").collect(Collectors.joining(",")) + ")";
    }

    public String toString() {
        return this.queryPrefix + " (...) " + this.querySuffix;
    }

    @SafeVarargs
    public final int execute(@Nonnull Handle handle, PMessageOrBuilder<M> ... items) {
        return this.execute(handle, (Collection)UnmodifiableList.copyOf((Object[])items));
    }

    public <MB extends PMessageOrBuilder<M>> int execute(@Nonnull Handle handle, @Nonnull Collection<MB> items) {
        if (items.isEmpty()) {
            return 0;
        }
        String query = this.queryPrefix + items.stream().map(item -> this.valueMarkers).collect(Collectors.joining(", ")) + this.querySuffix;
        Update update = handle.createUpdate(query);
        int offset = 0;
        for (PMessageOrBuilder item2 : items) {
            for (String column : this.columnOrder) {
                PField<M> field = this.columnToFieldMap.get(column);
                int type = this.columnTypeMap.get(column);
                update.bind(offset++, new MessageFieldArgument<M>(item2, field, type));
            }
        }
        return update.execute();
    }

    public static class Builder<M extends PMessage<M>> {
        private final String intoTable;
        private final Map<String, PField<M>> columnToFieldMap;
        private final Map<String, Integer> columnTypeMap;
        private final Set<String> onDuplicateUpdate;
        private final AtomicBoolean onDuplicateIgnore;
        private final PMessageDescriptor<M> descriptor;

        public Builder(@Nonnull PMessageDescriptor<M> descriptor, @Nonnull String intoTable) {
            this.descriptor = descriptor;
            this.intoTable = intoTable;
            this.columnToFieldMap = new LinkedHashMap<String, PField<M>>();
            this.columnTypeMap = new HashMap<String, Integer>();
            this.onDuplicateUpdate = new TreeSet<String>();
            this.onDuplicateIgnore = new AtomicBoolean();
        }

        public final Builder<M> setAll() {
            for (PField field : this.descriptor.getFields()) {
                if (this.columnToFieldMap.values().contains(field)) continue;
                this.set(field);
            }
            return this;
        }

        @SafeVarargs
        public final Builder<M> setAllExcept(PField<M> ... except) {
            return this.setAllExcept((Collection<PField<M>>)UnmodifiableSet.copyOf((Object[])except));
        }

        public Builder<M> setAllExcept(Collection<PField<M>> except) {
            for (PField field : this.descriptor.getFields()) {
                if (except.contains(field)) continue;
                this.set(field.getName(), field, MessageFieldArgument.getDefaultColumnType(field));
            }
            return this;
        }

        @SafeVarargs
        public final Builder<M> set(PField<M> ... fields) {
            return this.set((Collection<PField<M>>)UnmodifiableList.copyOf((Object[])fields));
        }

        public final Builder<M> set(Collection<PField<M>> fields) {
            for (PField<M> field : fields) {
                this.set(field.getName(), field, MessageFieldArgument.getDefaultColumnType(field));
            }
            return this;
        }

        public final Builder<M> set(String column, PField<M> field) {
            return this.set(column, field, MessageFieldArgument.getDefaultColumnType(field));
        }

        public final Builder<M> set(PField<M> field, int type) {
            return this.set(field.getName(), field, type);
        }

        public final Builder<M> set(String column, PField<M> field, int type) {
            if (this.columnToFieldMap.containsKey(column)) {
                throw new IllegalArgumentException("Column " + column + " already inserted");
            }
            if (this.onDuplicateIgnore.get() || this.onDuplicateUpdate.size() > 0) {
                throw new IllegalStateException("Duplicate key behavior already determined");
            }
            this.columnToFieldMap.put(column, field);
            this.columnTypeMap.put(column, type);
            return this;
        }

        @SafeVarargs
        public final Builder<M> onDuplicateKeyUpdate(PField<M> ... fields) {
            return this.onDuplicateKeyUpdate((Collection<PField<M>>)UnmodifiableList.copyOf((Object[])fields));
        }

        public final Builder<M> onDuplicateKeyUpdate(Collection<PField<M>> fields) {
            ArrayList columns = new ArrayList(fields.size());
            fields.forEach(field -> {
                AtomicBoolean found = new AtomicBoolean();
                this.columnToFieldMap.forEach((column, f) -> {
                    if (f.equals(field)) {
                        columns.add(column);
                        found.set(true);
                    }
                });
                if (!found.get()) {
                    throw new IllegalArgumentException("Field " + field + " not inserted");
                }
            });
            return this.onDuplicateKeyUpdate(columns.toArray(new String[0]));
        }

        @SafeVarargs
        public final Builder<M> onDuplicateKeyUpdateAllExcept(PField<M> ... fields) {
            return this.onDuplicateKeyUpdateAllExcept((Collection<PField<M>>)UnmodifiableList.copyOf((Object[])fields));
        }

        public final Builder<M> onDuplicateKeyUpdateAllExcept(Collection<PField<M>> fields) {
            ArrayList columns = new ArrayList(fields.size());
            fields.forEach(field -> {
                AtomicBoolean found = new AtomicBoolean();
                this.columnToFieldMap.forEach((column, f) -> {
                    if (f.equals(field)) {
                        columns.add(column);
                        found.set(true);
                    }
                });
                if (!found.get()) {
                    throw new IllegalArgumentException("Field " + field + " not inserted");
                }
            });
            return this.onDuplicateKeyUpdateAllExcept(columns.toArray(new String[0]));
        }

        public final Builder<M> onDuplicateKeyUpdateAllExcept(String ... exceptColumns) {
            TreeSet<String> columns = new TreeSet<String>(this.columnToFieldMap.keySet());
            columns.removeAll(Arrays.asList(exceptColumns));
            return this.onDuplicateKeyUpdate(columns.toArray(new String[0]));
        }

        public final Builder<M> onDuplicateKeyUpdate(String ... columns) {
            if (this.onDuplicateIgnore.get()) {
                throw new IllegalStateException("Duplicate key behavior already set to ignore");
            }
            Collections.addAll(this.onDuplicateUpdate, columns);
            return this;
        }

        public final Builder<M> onDuplicateKeyIgnore() {
            if (this.onDuplicateUpdate.size() > 0) {
                throw new IllegalStateException("Duplicate key behavior already set to update");
            }
            this.onDuplicateIgnore.set(true);
            return this;
        }

        public MessageUpserter<M> build() {
            if (this.columnToFieldMap.isEmpty()) {
                throw new IllegalStateException("No columns inserted");
            }
            ArrayList<String> columnOrder = new ArrayList<String>(this.columnToFieldMap.keySet());
            StringBuilder prefixBuilder = new StringBuilder("INSERT ");
            if (this.onDuplicateIgnore.get()) {
                prefixBuilder.append("IGNORE ");
            }
            prefixBuilder.append("INTO ").append(this.intoTable).append(" (").append(columnOrder.stream().map(col -> "`" + col + "`").collect(Collectors.joining(", "))).append(") VALUES ");
            StringBuilder suffixBuilder = new StringBuilder();
            if (this.onDuplicateUpdate.size() > 0) {
                suffixBuilder.append(" ON DUPLICATE KEY UPDATE");
                boolean first = true;
                for (String column : this.onDuplicateUpdate) {
                    if (first) {
                        first = false;
                    } else {
                        suffixBuilder.append(",");
                    }
                    suffixBuilder.append(" `").append(column).append("` = VALUES(`").append(column).append("`)");
                }
            }
            return new MessageUpserter(prefixBuilder.toString(), suffixBuilder.toString(), columnOrder, this.columnToFieldMap, this.columnTypeMap);
        }
    }
}

