/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageRowMapper;
import net.morimekta.providence.jdbi.v3.annotations.RegisterMessageMapper;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface RegisterMessageMappers {
    public RegisterMessageMapper[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            RegisterMessageMappers registers = (RegisterMessageMappers)annotation;
            HashMap mappers = new HashMap();
            for (RegisterMessageMapper register : registers.value()) {
                if (register.value().isInterface()) {
                    throw new IllegalArgumentException("Interfaces cannot be used as message return types");
                }
                PMessageDescriptor descriptor = RegisterMessageMapper.Factory.getDescriptor(register);
                Map fieldMap = RegisterMessageMapper.Factory.makeFieldMap(descriptor, register);
                MessageRowMapper mapper = new MessageRowMapper(descriptor, fieldMap);
                mappers.put(register.value(), mapper);
            }
            return stmt -> mappers.forEach((arg_0, arg_1) -> ((SqlStatement)stmt).registerRowMapper(arg_0, arg_1));
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.createForType(annotation, sqlObjectType);
        }
    }
}

