/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.jdbi.v3.EnumValueArgumentFactory;
import net.morimekta.providence.jdbi.v3.EnumValueMapper;
import net.morimekta.providence.jdbi.v3.annotations.RegisterEnumValueMappers;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Repeatable(value=RegisterEnumValueMappers.class)
public @interface RegisterEnumValueMapper {
    public Class<? extends PEnumValue<?>>[] value();

    public boolean acceptUnknown() default false;

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            RegisterEnumValueMapper register = (RegisterEnumValueMapper)annotation;
            ArrayList mappers = new ArrayList();
            ArrayList<EnumValueArgumentFactory> factories = new ArrayList<EnumValueArgumentFactory>();
            for (Class<? extends PEnumValue<?>> klass : register.value()) {
                PEnumDescriptor descriptor = Factory.getDescriptor(klass);
                mappers.add(new EnumValueMapper(register.acceptUnknown(), descriptor));
                factories.add(new EnumValueArgumentFactory(klass));
            }
            return stmt -> {
                for (EnumValueMapper mapper : mappers) {
                    stmt.registerColumnMapper(mapper.getType(), (ColumnMapper)mapper);
                }
                for (EnumValueArgumentFactory factory : factories) {
                    stmt.registerArgument((ArgumentFactory)factory);
                }
            };
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            return this.createForType(annotation, sqlObjectType);
        }

        @Nonnull
        static PEnumDescriptor getDescriptor(Class<?> register) {
            try {
                return Objects.requireNonNull((PEnumDescriptor)register.getDeclaredField("kDescriptor").get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
                throw new IllegalArgumentException("Not a valid providence enum class " + register.getName());
            }
        }
    }
}

