/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.lang.reflect.Type;
import java.util.Optional;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.jdbi.v3.EnumValueArgument;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.config.ConfigRegistry;

public class EnumValueArgumentFactory
implements ArgumentFactory {
    private final Class<? extends PEnumValue> enumClass;

    public EnumValueArgumentFactory() {
        this(PEnumValue.class);
    }

    public EnumValueArgumentFactory(Class<? extends PEnumValue> enumClass) {
        this.enumClass = enumClass;
    }

    public Optional<Argument> build(Type type, Object value, ConfigRegistry config) {
        Class klass;
        if (type instanceof Class && this.enumClass.isAssignableFrom(klass = (Class)type)) {
            if (value == null) {
                return Optional.of(new NullArgument(4));
            }
            return Optional.of(new EnumValueArgument((PEnumValue)value));
        }
        return Optional.empty();
    }
}

