/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import net.morimekta.providence.PEnumValue;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindEnumValue {
    public String value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            if (!(paramType instanceof Class)) {
                throw new IllegalArgumentException(paramType.getTypeName() + " is not a providence enum type");
            }
            Class paramClass = (Class)paramType;
            if (!PEnumValue.class.isAssignableFrom(paramClass)) {
                throw new IllegalArgumentException(paramClass.getName() + " is not a providence enum class");
            }
            BindEnumValue bind = (BindEnumValue)annotation;
            return (stmt, arg) -> {
                if (arg == null) {
                    stmt.bindNull(bind.value(), 4);
                } else {
                    stmt.bind(bind.value(), ((PEnumValue)arg).asInteger());
                }
            };
        }
    }
}

