/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageRowMapper;
import net.morimekta.providence.jdbi.v3.annotations.BindField;
import net.morimekta.util.collect.UnmodifiableMap;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface RegisterMessageMapper {
    public Class<? extends PMessage<?>> value();

    public BindField[] fields() default {};

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class<?> sqlObjectType) {
            RegisterMessageMapper register = (RegisterMessageMapper)annotation;
            if (register.value().isInterface()) {
                throw new IllegalArgumentException("Interfaces cannot be used as message return types");
            }
            PMessageDescriptor descriptor = this.getDescriptor(register);
            Map fieldMap = this.makeFieldMap(descriptor, register);
            MessageRowMapper mapper = new MessageRowMapper(descriptor, fieldMap);
            return stmt -> stmt.registerRowMapper(register.value(), (RowMapper)mapper);
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            RegisterMessageMapper register = (RegisterMessageMapper)annotation;
            if (register.value().isInterface()) {
                throw new IllegalArgumentException("Interfaces cannot be used as message return types");
            }
            PMessageDescriptor descriptor = this.getDescriptor(register);
            Map fieldMap = this.makeFieldMap(descriptor, register);
            MessageRowMapper mapper = new MessageRowMapper(descriptor, fieldMap);
            return stmt -> stmt.registerRowMapper(register.value(), (RowMapper)mapper);
        }

        private Map<String, PField> makeFieldMap(@Nonnull PMessageDescriptor descriptor, @Nonnull RegisterMessageMapper register) {
            HashMap<String, PField> map = new HashMap<String, PField>();
            for (PField pField : descriptor.getFields()) {
                map.put(pField.getName(), pField);
            }
            for (BindField bindField : register.fields()) {
                PField field = descriptor.fieldForName(bindField.field());
                map.put(bindField.column(), field);
            }
            return UnmodifiableMap.copyOf(map);
        }

        @Nonnull
        private PMessageDescriptor getDescriptor(RegisterMessageMapper register) {
            try {
                return Objects.requireNonNull((PMessageDescriptor)register.value().getDeclaredField("kDescriptor").get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
                throw new IllegalArgumentException("Not a valid message class " + register.value().getName());
            }
        }
    }
}

