/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageNamedArgumentFinder;
import net.morimekta.providence.jdbi.v3.annotations.BindType;
import net.morimekta.util.collect.UnmodifiableMap;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindMessage {
    public String value() default "";

    public BindType[] types() default {};

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type paramType) {
            if (!(paramType instanceof Class)) {
                throw new IllegalArgumentException(paramType.getTypeName() + " is not a message type");
            }
            Class paramClass = (Class)paramType;
            if (!PMessageOrBuilder.class.isAssignableFrom(paramClass)) {
                throw new IllegalArgumentException(paramClass.getName() + " is not a message class");
            }
            try {
                PMessageDescriptor descriptor = (PMessageDescriptor)paramClass.getDeclaredField("kDescriptor").get(null);
                BindMessage bind = (BindMessage)annotation;
                LinkedHashMap<PField, Integer> typeMapBuilder = new LinkedHashMap<PField, Integer>();
                for (BindType type : bind.types()) {
                    PField field = descriptor.findFieldByName(type.name());
                    if (field == null) {
                        throw new IllegalArgumentException("No field " + type.name() + " in " + descriptor.getQualifiedName());
                    }
                    typeMapBuilder.put(field, type.type());
                }
                UnmodifiableMap map = UnmodifiableMap.copyOf(typeMapBuilder);
                return (stmt, arg) -> stmt.bindNamedArgumentFinder(new MessageNamedArgumentFinder(bind.value(), (PMessageOrBuilder)arg, map));
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Not a valid message class " + paramClass.getName(), e);
            }
        }
    }
}

