/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

public class EnumValueMapper<E extends PEnumValue<E>>
implements ColumnMapper<E> {
    private final boolean acceptUnknown;
    private final PEnumDescriptor<E> descriptor;

    public EnumValueMapper(boolean acceptUnknown, @Nonnull PEnumDescriptor<E> descriptor) {
        this.acceptUnknown = acceptUnknown;
        this.descriptor = descriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.descriptor.getQualifiedName() + "}";
    }

    public E map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        int columnType = r.getMetaData().getColumnType(columnNumber);
        switch (columnType) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                int id = r.getInt(columnNumber);
                if (r.wasNull()) {
                    return null;
                }
                PEnumValue out = this.descriptor.findById(id);
                if (out != null || this.acceptUnknown) {
                    return (E)out;
                }
                throw new ResultSetException("Unknown value " + id + " for enum " + this.descriptor.getQualifiedName(), null, ctx);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: {
                String name = r.getString(columnNumber);
                if (name == null) {
                    return null;
                }
                PEnumValue out = this.descriptor.findByName(name);
                if (out != null || this.acceptUnknown) {
                    return (E)out;
                }
                throw new ResultSetException("Unknown value " + name + " for enum " + this.descriptor.getQualifiedName(), null, ctx);
            }
        }
        throw new ResultSetException("Unhandled column type " + r.getMetaData().getColumnTypeName(columnNumber) + "(" + columnType + ") for enum " + this.descriptor.getQualifiedName(), null, ctx);
    }

    public Type getType() {
        return this.descriptor.getValues()[0].getClass();
    }
}

