/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageFieldArgument;
import net.morimekta.util.collect.UnmodifiableMap;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.NullArgument;
import org.jdbi.v3.core.statement.StatementContext;

public class MessageNamedArgumentFinder<M extends PMessage<M, F>, F extends PField>
implements NamedArgumentFinder {
    private final String prefix;
    private final M message;
    private final Map<PField, Integer> fieldTypes;

    public MessageNamedArgumentFinder(@Nullable String prefix, @Nonnull M message, @Nonnull Map<PField, Integer> fieldTypes) {
        this.message = message;
        this.prefix = prefix == null || prefix.isEmpty() ? "" : prefix + ".";
        this.fieldTypes = UnmodifiableMap.copyOf(fieldTypes);
    }

    public String toString() {
        return this.prefix + "{" + this.message.descriptor().getQualifiedName() + "}";
    }

    @Nonnull
    public Optional<Argument> find(String name, StatementContext ctx) {
        if (!this.prefix.isEmpty()) {
            if (name.startsWith(this.prefix)) {
                name = name.substring(this.prefix.length());
            } else {
                return Optional.empty();
            }
        }
        String[] parts = name.split("[.]");
        Object leaf = this.message;
        PMessageDescriptor leafDescriptor = this.message.descriptor();
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            PField field = leafDescriptor.findFieldByName(part);
            if (field == null) {
                return Optional.empty();
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("");
            }
            leafDescriptor = (PMessageDescriptor)field.getDescriptor();
            if (leaf == null) continue;
            leaf = (PMessage)leaf.get(field.getId());
        }
        String leafName = parts[parts.length - 1];
        PField field = leafDescriptor.findFieldByName(leafName);
        if (field != null) {
            if (leaf != null) {
                return Optional.of(new MessageFieldArgument<M, PField>(leaf, field, this.getColumnType(field)));
            }
            return Optional.of(new NullArgument(this.getColumnType(field)));
        }
        return Optional.empty();
    }

    private int getColumnType(PField field) {
        return this.fieldTypes.getOrDefault(field, MessageFieldArgument.getDefaultColumnType(field));
    }
}

