/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v3.MessageFieldArgument;
import net.morimekta.providence.jdbi.v3.MessageNamedArgumentFinder;
import net.morimekta.providence.jdbi.v3.MessageRowMapper;
import net.morimekta.util.collect.UnmodifiableMap;

public class ProvidenceJdbi {
    public static <M extends PMessage<M, F>, F extends PField> MessageFieldArgument<M, F> toField(M message, F field) {
        return new MessageFieldArgument<M, F>(message, field);
    }

    public static <M extends PMessage<M, F>, F extends PField> MessageFieldArgument<M, F> toField(M message, F field, int type) {
        return new MessageFieldArgument<M, F>(message, field, type);
    }

    public static <F extends PField> MappedField<F> columnsFromAllFields() {
        return new MappedField<Object>("*", null);
    }

    public static <F extends PField> MappedField<F> withColumn(F field) {
        return new MappedField<F>(field.getName(), field);
    }

    public static <F extends PField> MappedField<F> withColumn(String name, F field) {
        return new MappedField<F>(name, field);
    }

    @SafeVarargs
    public static <M extends PMessage<M, F>, F extends PField> MessageRowMapper<M, F> toMessage(@Nonnull PMessageDescriptor<M, F> descriptor, MappedField<F> ... fieldMapping) {
        return new MessageRowMapper<M, F>(descriptor, ProvidenceJdbi.makeMapping(fieldMapping));
    }

    @SafeVarargs
    public static <M extends PMessage<M, F>, F extends PField> MessageRowMapper<M, F> toMessage(@Nonnull String tableName, @Nonnull PMessageDescriptor<M, F> descriptor, MappedField<F> ... fieldMapping) {
        return new MessageRowMapper<M, F>(tableName, descriptor, ProvidenceJdbi.makeMapping(fieldMapping));
    }

    public static FieldType withType(PField field, int type) {
        return new FieldType(field, type);
    }

    public static <M extends PMessage<M, F>, F extends PField> MessageNamedArgumentFinder<M, F> forMessage(@Nonnull M message, FieldType ... fieldTypes) {
        return new MessageNamedArgumentFinder(null, message, ProvidenceJdbi.makeFieldTypes(fieldTypes));
    }

    public static <M extends PMessage<M, F>, F extends PField> MessageNamedArgumentFinder<M, F> forMessage(@Nonnull String prefix, @Nonnull M message, FieldType ... fieldTypes) {
        return new MessageNamedArgumentFinder(prefix, message, ProvidenceJdbi.makeFieldTypes(fieldTypes));
    }

    private static Map<PField, Integer> makeFieldTypes(FieldType ... mappings) {
        UnmodifiableMap.Builder builder = UnmodifiableMap.builder();
        for (FieldType mapping : mappings) {
            builder.put((Object)mapping.field, (Object)mapping.type);
        }
        return builder.build();
    }

    @SafeVarargs
    private static <F extends PField> Map<String, F> makeMapping(MappedField<F> ... mappedFields) {
        HashMap<String, PField> out = new HashMap<String, PField>();
        for (MappedField<F> mappedField : mappedFields) {
            out.put(((MappedField)mappedField).name.toUpperCase(Locale.US), ((MappedField)mappedField).field);
        }
        return out;
    }

    public static class FieldType {
        private PField field;
        private int type;

        FieldType(PField field, int type) {
            this.field = field;
            this.type = type;
        }
    }

    public static class MappedField<F extends PField> {
        private final String name;
        private final F field;

        MappedField(String name, F field) {
            this.name = name;
            this.field = field;
        }
    }
}

