/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.collect.UnmodifiableMap;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

public class MessageRowMapper<M extends PMessage<M, F>, F extends PField>
implements RowMapper<M> {
    public static final String ALL_FIELDS = "*";
    private static final BinarySerializer BINARY = new BinarySerializer();
    private static final JsonSerializer JSON = new JsonSerializer();
    private final PMessageDescriptor<M, F> descriptor;
    private final Map<String, F> fieldNameMapping;
    private final String tableName;

    public MessageRowMapper(@Nonnull PMessageDescriptor<M, F> descriptor) {
        this(descriptor, (Map<String, F>)UnmodifiableMap.mapOf());
    }

    public MessageRowMapper(@Nonnull String tableName, @Nonnull PMessageDescriptor<M, F> descriptor) {
        this(tableName, descriptor, (Map<String, F>)UnmodifiableMap.mapOf());
    }

    public MessageRowMapper(@Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Map<String, F> fieldMapping) {
        this("", descriptor, fieldMapping);
    }

    public MessageRowMapper(@Nonnull String tableName, @Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Map<String, F> fieldMapping) {
        HashMap<String, PField> mappingBuilder = new HashMap<String, PField>();
        if (fieldMapping.isEmpty()) {
            for (PField field : descriptor.getFields()) {
                mappingBuilder.put(field.getName().toUpperCase(Locale.US), field);
            }
        } else {
            fieldMapping.forEach((name, addField) -> {
                if (ALL_FIELDS.equals(name)) {
                    for (PField field : descriptor.getFields()) {
                        String fieldName = field.getName().toUpperCase(Locale.US);
                        if (mappingBuilder.containsKey(fieldName)) continue;
                        mappingBuilder.put(fieldName, field);
                    }
                } else {
                    mappingBuilder.put(name.toUpperCase(Locale.US), (PField)addField);
                }
            });
        }
        this.tableName = tableName;
        this.descriptor = descriptor;
        this.fieldNameMapping = UnmodifiableMap.copyOf(mappingBuilder);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.descriptor.getQualifiedName() + (this.tableName == null ? "" : ", tableName=" + this.tableName) + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public M map(ResultSet rs, StatementContext ctx) throws SQLException {
        PMessageBuilder builder = this.descriptor.builder();
        int i = 1;
        while (i <= rs.getMetaData().getColumnCount()) {
            String name;
            PField field;
            if ((this.tableName.isEmpty() || this.tableName.equalsIgnoreCase(rs.getMetaData().getTableName(i))) && (field = (PField)this.fieldNameMapping.get(name = rs.getMetaData().getColumnLabel(i).toUpperCase(Locale.US))) != null) {
                int columnType = rs.getMetaData().getColumnType(i);
                block3 : switch (field.getType()) {
                    case BOOL: {
                        if (columnType == 16 || columnType == -7) {
                            boolean b = rs.getBoolean(i);
                            if (rs.wasNull()) break;
                            builder.set(field, (Object)b);
                            break;
                        }
                        int b = rs.getInt(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)(b != 0 ? 1 : 0));
                        break;
                    }
                    case BYTE: {
                        byte b = rs.getByte(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)b);
                        break;
                    }
                    case I16: {
                        short b = rs.getShort(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)b);
                        break;
                    }
                    case I32: {
                        if (columnType == 93) {
                            Timestamp ts = rs.getTimestamp(i);
                            if (ts == null) break;
                            builder.set(field, (Object)((int)(ts.getTime() / 1000L)));
                            break;
                        }
                        if (columnType == 91) {
                            Date date = rs.getDate(i);
                            if (date == null) break;
                            builder.set(field, (Object)((int)(date.getTime() / 1000L)));
                            break;
                        }
                        int b = rs.getInt(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)b);
                        break;
                    }
                    case I64: {
                        if (columnType == 93) {
                            Timestamp ts = rs.getTimestamp(i);
                            if (ts == null) break;
                            builder.set(field, (Object)ts.getTime());
                            break;
                        }
                        if (columnType == 91) {
                            Date date = rs.getDate(i);
                            if (date == null) break;
                            builder.set(field, (Object)date.getTime());
                            break;
                        }
                        long b = rs.getLong(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)b);
                        break;
                    }
                    case DOUBLE: {
                        double b = rs.getDouble(i);
                        if (rs.wasNull()) break;
                        builder.set(field, (Object)b);
                        break;
                    }
                    case STRING: {
                        builder.set(field, (Object)rs.getString(i));
                        break;
                    }
                    case BINARY: {
                        InputStream is;
                        switch (columnType) {
                            case -3: 
                            case -2: {
                                byte[] ts = rs.getBytes(i);
                                if (ts == null) break block3;
                                builder.set(field, (Object)Binary.copy((byte[])ts));
                                break block3;
                            }
                            case -4: {
                                is = rs.getBinaryStream(i);
                                if (is == null) break block3;
                                try {
                                    builder.set(field, (Object)Binary.read((InputStream)is));
                                    break block3;
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e.getMessage(), e);
                                }
                            }
                            case 2004: {
                                Blob blob = rs.getBlob(i);
                                if (blob == null) break block3;
                                try {
                                    builder.set(field, (Object)Binary.read((InputStream)blob.getBinaryStream(), (int)((int)blob.length())));
                                    break block3;
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e.getMessage(), e);
                                }
                            }
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                String tmp = rs.getString(i);
                                if (tmp == null) break block3;
                                builder.set(field, (Object)Binary.fromBase64((String)tmp));
                                break block3;
                            }
                            case 0: {
                                break block3;
                            }
                            default: {
                                throw new ResultSetException("Unknown column type " + rs.getMetaData().getColumnTypeName(i) + "(" + columnType + ") for " + this.descriptor.getType().toString() + " field " + field.getName() + " in " + this.descriptor.getQualifiedName(), null, ctx);
                            }
                        }
                    }
                    case ENUM: {
                        int val = rs.getInt(i);
                        if (rs.wasNull()) break;
                        PEnumDescriptor ed = (PEnumDescriptor)field.getDescriptor();
                        builder.set(field, (Object)ed.findById(val));
                        break;
                    }
                    case MESSAGE: {
                        InputStream is;
                        try {
                            PMessageDescriptor md = (PMessageDescriptor)field.getDescriptor();
                            switch (columnType) {
                                case -3: 
                                case -2: {
                                    byte[] data = rs.getBytes(i);
                                    if (data == null) break block3;
                                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                                    builder.set(field, (Object)BINARY.deserialize((InputStream)in, md));
                                    break;
                                }
                                case -4: {
                                    is = rs.getBinaryStream(i);
                                    if (is == null) break block3;
                                    builder.set(field, (Object)BINARY.deserialize(is, md));
                                    break;
                                }
                                case 2004: {
                                    Blob blob = rs.getBlob(i);
                                    if (blob == null) break block3;
                                    builder.set(field, (Object)BINARY.deserialize(blob.getBinaryStream(), md));
                                    break;
                                }
                                case -15: 
                                case -9: 
                                case 1: 
                                case 12: {
                                    String tmp = rs.getString(i);
                                    if (tmp == null) break block3;
                                    StringReader reader = new StringReader(tmp);
                                    builder.set(field, (Object)JSON.deserialize((Reader)reader, md));
                                    break;
                                }
                                case -1: 
                                case 2005: 
                                case 2011: {
                                    Clob clob = rs.getClob(i);
                                    if (clob == null) break block3;
                                    builder.set(field, (Object)JSON.deserialize(clob.getCharacterStream(), md));
                                    break;
                                }
                                case 0: {
                                    break;
                                }
                                default: {
                                    throw new ResultSetException("Unknown column type " + rs.getMetaData().getColumnTypeName(i) + "(" + columnType + ") for " + this.descriptor.getType().toString() + " field " + field.getName() + " in " + this.descriptor.getQualifiedName(), null, ctx);
                                }
                            }
                            break;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e.getMessage(), e);
                        }
                    }
                    default: {
                        throw new ResultSetException("Unhandled column of type " + rs.getMetaData().getColumnTypeName(i) + "(" + columnType + ") for " + this.descriptor.getType().toString() + " field " + field.getName() + " in " + this.descriptor.getQualifiedName(), null, ctx);
                    }
                }
            }
            ++i;
        }
        return (M)((PMessage)builder.build());
    }
}

