/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.jdbi.v2.util.NullArgument;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;
import org.skife.jdbi.v2.tweak.Argument;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@BindingAnnotation(value=Factory.class)
public @interface BindEnumName {
    public String value();

    public static class EnumNameArgument
    implements Argument {
        private final PEnumValue value;

        EnumNameArgument(@Nonnull PEnumValue value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setString(position, this.value.asString());
        }
    }

    public static class Factory
    implements BinderFactory<BindEnumName> {
        public Binder<BindEnumName, Object> build(BindEnumName bind) {
            return (sqlStatement, annotation, arg) -> {
                if (arg instanceof PEnumValue) {
                    PEnumValue value = (PEnumValue)arg;
                    sqlStatement.bind(annotation.value(), (Argument)new EnumNameArgument(value));
                } else if (arg == null) {
                    sqlStatement.bind(annotation.value(), (Argument)new NullArgument(12));
                } else {
                    throw new IllegalArgumentException("Not a providence enum value: " + arg.getClass().toString());
                }
            };
        }
    }
}

