/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.jdbi.v2.EnumValueMapper;
import net.morimekta.providence.jdbi.v2.annotations.RegisterEnumValueMappers;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
@Repeatable(value=RegisterEnumValueMappers.class)
public @interface RegisterEnumValueMapper {
    public Class<? extends PEnumValue<?>>[] value();

    public boolean acceptUnknown() default false;

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return this.createForType(annotation, sqlObjectType);
        }

        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterEnumValueMapper register = (RegisterEnumValueMapper)annotation;
            ArrayList<1> factories = new ArrayList<1>();
            for (Class<? extends PEnumValue<?>> klass : register.value()) {
                PEnumDescriptor descriptor = Factory.getDescriptor(klass);
                final EnumValueMapper mapper = new EnumValueMapper(register.acceptUnknown(), descriptor);
                factories.add(new ResultColumnMapperFactory(){

                    public boolean accepts(Class type, StatementContext ctx) {
                        return mapper.getType().equals(type);
                    }

                    public ResultColumnMapper columnMapperFor(Class type, StatementContext ctx) {
                        return mapper;
                    }
                });
            }
            return stmt -> {
                if (stmt instanceof Query) {
                    Query q = (Query)stmt;
                    for (ResultColumnMapperFactory factory : factories) {
                        q.registerColumnMapper(factory);
                    }
                }
            };
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            return stmt -> {};
        }

        @Nonnull
        static PEnumDescriptor getDescriptor(Class<?> register) {
            try {
                return Objects.requireNonNull((PEnumDescriptor)register.getDeclaredField("kDescriptor").get(null));
            }
            catch (IllegalAccessException | NoSuchFieldException | NullPointerException e) {
                throw new IllegalArgumentException("Not a valid providence enum class " + register.getName());
            }
        }
    }
}

