/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v2.MessageFieldArgument;
import net.morimekta.providence.jdbi.v2.util.NullArgument;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableMap;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.NamedArgumentFinder;

public class MessageNamedArgumentFinder<M extends PMessage<M>>
implements NamedArgumentFinder {
    private final String prefix;
    private final PMessageOrBuilder<M> message;
    private final Map<PField<M>, Integer> fieldTypes;

    public MessageNamedArgumentFinder(@Nullable String prefix, @Nonnull PMessageOrBuilder<M> message, @Nonnull Map<PField<M>, Integer> fieldTypes) {
        this.message = message;
        this.prefix = Strings.isNullOrEmpty((String)prefix) ? "" : prefix + ".";
        this.fieldTypes = UnmodifiableMap.copyOf(fieldTypes);
    }

    public String toString() {
        return this.prefix + "{" + this.message.descriptor().getQualifiedName() + "}";
    }

    public Argument find(String name) {
        if (!this.prefix.isEmpty()) {
            if (name.startsWith(this.prefix)) {
                name = name.substring(this.prefix.length());
            } else {
                return null;
            }
        }
        String[] parts = name.split("\\.", 127);
        PMessageOrBuilder leaf = this.message;
        PMessageDescriptor leafDescriptor = this.message.descriptor();
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            PField field = leafDescriptor.findFieldByName(part);
            if (field == null) {
                return null;
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("");
            }
            leafDescriptor = (PMessageDescriptor)field.getDescriptor();
            if (leaf == null) continue;
            leaf = (PMessageOrBuilder)leaf.get(field.getId());
        }
        String leafName = parts[parts.length - 1];
        PField field = leafDescriptor.findFieldByName(leafName);
        if (field != null) {
            if (leaf != null) {
                return new MessageFieldArgument<M>(leaf, field, this.getColumnType(field));
            }
            return new NullArgument(this.getColumnType(field));
        }
        return null;
    }

    private int getColumnType(PField field) {
        return this.fieldTypes.getOrDefault(field, MessageFieldArgument.getDefaultColumnType(field));
    }
}

