/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v2.MessageRowMapper;
import net.morimekta.providence.jdbi.v2.annotations.RegisterMessageMapper;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface RegisterMessageMappers {
    public RegisterMessageMapper[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            RegisterMessageMappers registers = (RegisterMessageMappers)annotation;
            final HashMap mappers = new HashMap();
            for (RegisterMessageMapper register : registers.value()) {
                if (register.value().isInterface()) {
                    throw new IllegalArgumentException("Interfaces cannot be used as message return types");
                }
                PMessageDescriptor descriptor = RegisterMessageMapper.Factory.getDescriptor(register);
                Map fieldMap = RegisterMessageMapper.Factory.makeFieldMap(descriptor, register);
                MessageRowMapper mapper = new MessageRowMapper(descriptor, fieldMap);
                mappers.put(register.value(), mapper);
            }
            return stmt -> {
                if (stmt instanceof Query) {
                    Query q = (Query)stmt;
                    q.registerMapper(new ResultSetMapperFactory(){

                        public boolean accepts(Class type, StatementContext ctx) {
                            return mappers.containsKey(type);
                        }

                        public ResultSetMapper mapperFor(Class type, StatementContext ctx) {
                            return (ResultSetMapper)mappers.get(type);
                        }
                    });
                }
            };
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return this.createForType(annotation, sqlObjectType);
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            return stmt -> {};
        }
    }
}

