/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.jdbi.v2.EnumValueMapper;
import net.morimekta.providence.jdbi.v2.annotations.RegisterEnumValueMapper;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface RegisterEnumValueMappers {
    public RegisterEnumValueMapper[] value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            ArrayList<1> factories = new ArrayList<1>();
            for (RegisterEnumValueMapper register : ((RegisterEnumValueMappers)annotation).value()) {
                for (Class<? extends PEnumValue<?>> klass : register.value()) {
                    PEnumDescriptor descriptor = RegisterEnumValueMapper.Factory.getDescriptor(klass);
                    final EnumValueMapper mapper = new EnumValueMapper(register.acceptUnknown(), descriptor);
                    factories.add(new ResultColumnMapperFactory(){

                        public boolean accepts(Class type, StatementContext ctx) {
                            return mapper.getType().equals(type);
                        }

                        public ResultColumnMapper columnMapperFor(Class type, StatementContext ctx) {
                            return mapper;
                        }
                    });
                }
            }
            return stmt -> {
                if (stmt instanceof Query) {
                    Query q = (Query)stmt;
                    for (ResultColumnMapperFactory factory : factories) {
                        q.registerColumnMapper(factory);
                    }
                }
            };
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return this.createForType(annotation, sqlObjectType);
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            return stmt -> {};
        }
    }
}

