package net.morimekta.providence.jdbi.v2;

import net.morimekta.providence.PEnumValue;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

import javax.annotation.Nonnull;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class EnumValueArgument implements Argument {
    private final PEnumValue value;

    public EnumValueArgument(@Nonnull PEnumValue value) {
        this.value = value;
    }

    @Override
    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        statement.setInt(position, value.asInteger());
    }
}
