/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v2.MessageNamedArgumentFinder;
import net.morimekta.providence.jdbi.v2.annotations.BindType;
import net.morimekta.providence.jdbi.v2.util.NullArgument;
import net.morimekta.util.collect.UnmodifiableMap;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;
import org.skife.jdbi.v2.tweak.Argument;

@Target(value={ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@BindingAnnotation(value=Factory.class)
public @interface BindMessage {
    public String value() default "";

    public BindType[] types() default {};

    public static class Factory
    implements BinderFactory<BindMessage> {
        private AtomicReference<Map<PField, Integer>> fieldTypesInstance = new AtomicReference();

        private Map<PField, Integer> getFieldTypes(BindMessage annotation, PMessageDescriptor descriptor) {
            return this.fieldTypesInstance.updateAndGet(map -> {
                if (map != null) {
                    return map;
                }
                map = new LinkedHashMap<PField, Integer>();
                for (BindType field : annotation.types()) {
                    PField pf = descriptor.fieldForName(field.name());
                    map.put(pf, field.type());
                }
                return UnmodifiableMap.copyOf(map);
            });
        }

        public Binder<BindMessage, Object> build(BindMessage bind) {
            return (sqlStatement, annotation, o) -> {
                if (o instanceof PMessageOrBuilder) {
                    PMessageOrBuilder message = (PMessageOrBuilder)o;
                    Map ft = this.getFieldTypes((BindMessage)annotation, message.descriptor());
                    sqlStatement.bindNamedArgumentFinder(new MessageNamedArgumentFinder(annotation.value(), message, ft));
                } else if (o == null) {
                    sqlStatement.bind(annotation.value(), (Argument)new NullArgument(1111));
                } else {
                    throw new IllegalArgumentException("Not a message: " + o.getClass().toString());
                }
            };
        }
    }
}

