/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.jdbi.v2.MessageFieldArgument;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Update;

public class MessageInserter<M extends PMessage<M, F>, F extends PField> {
    private final String queryPrefix;
    private final String querySuffix;
    private final Map<String, F> columnToFieldMap;
    private final Map<String, Integer> columnTypeMap;
    private final ImmutableList<String> columnOrder;
    private final String valueMarkers;

    private MessageInserter(String queryPrefix, String querySuffix, List<String> columnOrder, Map<String, F> columnToFieldMap, Map<String, Integer> columnTypeMap) {
        this.queryPrefix = queryPrefix;
        this.querySuffix = querySuffix;
        this.columnOrder = ImmutableList.copyOf(columnOrder);
        this.columnToFieldMap = ImmutableMap.copyOf(columnToFieldMap);
        this.columnTypeMap = ImmutableMap.copyOf(columnTypeMap);
        this.valueMarkers = "(" + columnOrder.stream().map(k -> "?").collect(Collectors.joining(",")) + ")";
    }

    @SafeVarargs
    public final int execute(Handle handle, M ... items) {
        return this.execute(handle, (Collection<M>)ImmutableList.copyOf((Object[])items));
    }

    public int execute(Handle handle, Collection<M> items) {
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Nothing to insert");
        }
        String query = this.queryPrefix + items.stream().map(item -> this.valueMarkers).collect(Collectors.joining(", ")) + this.querySuffix;
        Update update = handle.createStatement(query);
        int offset = 0;
        for (PMessage item2 : items) {
            for (String column : this.columnOrder) {
                PField field = (PField)this.columnToFieldMap.get(column);
                int type = this.columnTypeMap.get(column);
                update.bind(offset++, new MessageFieldArgument<PMessage, PField>(item2, field, type));
            }
        }
        return update.execute();
    }

    public static class Builder<M extends PMessage<M, F>, F extends PField> {
        private final String intoTable;
        private final Map<String, F> columnToFieldMap;
        private final Map<String, Integer> columnTypeMap;
        private final Set<String> onDuplicateUpdate;
        private final AtomicBoolean onDuplicateIgnore;
        private final PMessageDescriptor<M, F> descriptor;

        @Deprecated
        public Builder(@Nonnull String intoTable) {
            this(intoTable, null);
        }

        public Builder(@Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull String intoTable) {
            this(intoTable, descriptor);
        }

        private Builder(@Nonnull String intoTable, @Nullable PMessageDescriptor<M, F> descriptor) {
            this.descriptor = descriptor;
            this.intoTable = intoTable;
            this.columnToFieldMap = new LinkedHashMap<String, F>();
            this.columnTypeMap = new HashMap<String, Integer>();
            this.onDuplicateUpdate = new TreeSet<String>();
            this.onDuplicateIgnore = new AtomicBoolean();
        }

        public final Builder<M, F> setAll() {
            if (this.descriptor == null) {
                throw new IllegalStateException("No descriptor in builder");
            }
            return this.set(this.descriptor.getFields());
        }

        @SafeVarargs
        public final Builder<M, F> setAllExcept(F ... except) {
            if (this.descriptor == null) {
                throw new IllegalStateException("No descriptor in builder");
            }
            return this.setAllExcept((Collection<F>)ImmutableSet.copyOf((Object[])except), this.descriptor);
        }

        public Builder<M, F> setAllExcept(Collection<F> except) {
            if (this.descriptor == null) {
                throw new IllegalStateException("No descriptor in builder");
            }
            return this.setAllExcept(except, this.descriptor);
        }

        @Deprecated
        @SafeVarargs
        public final Builder<M, F> setAllExcept(PMessageDescriptor<M, F> descriptor, F ... except) {
            return this.setAllExcept((Collection<F>)ImmutableSet.copyOf((Object[])except), descriptor);
        }

        @Deprecated
        public Builder<M, F> setAllExcept(PMessageDescriptor<M, F> descriptor, Collection<F> except) {
            return this.setAllExcept(except, descriptor);
        }

        private Builder<M, F> setAllExcept(@Nonnull Collection<F> except, @Nonnull PMessageDescriptor<M, F> descriptor) {
            for (PField field : descriptor.getFields()) {
                if (except.contains(field)) continue;
                this.set(field.getName(), (F)field, MessageFieldArgument.getDefaultColumnType(field));
            }
            return this;
        }

        @SafeVarargs
        public final Builder<M, F> set(F ... fields) {
            return this.set((Collection<F>)ImmutableList.copyOf((Object[])fields));
        }

        public final Builder<M, F> set(Collection<F> fields) {
            for (PField field : fields) {
                this.set(field.getName(), (F)field, MessageFieldArgument.getDefaultColumnType(field));
            }
            return this;
        }

        public final Builder<M, F> set(String column, F field) {
            return this.set(column, field, MessageFieldArgument.getDefaultColumnType(field));
        }

        public final Builder<M, F> set(F field, int type) {
            return this.set(field.getName(), field, type);
        }

        public final Builder<M, F> set(String column, F field, int type) {
            if (this.columnToFieldMap.containsKey(column)) {
                throw new IllegalArgumentException("Column " + column + " already inserted");
            }
            if (this.onDuplicateIgnore.get() || this.onDuplicateUpdate.size() > 0) {
                throw new IllegalStateException("Duplicate key behavior already determined");
            }
            this.columnToFieldMap.put(column, field);
            this.columnTypeMap.put(column, type);
            return this;
        }

        @SafeVarargs
        public final Builder<M, F> onDuplicateKeyUpdate(F ... fields) {
            return this.onDuplicateKeyUpdate((Collection<F>)ImmutableList.copyOf((Object[])fields));
        }

        public final Builder<M, F> onDuplicateKeyUpdate(Collection<F> fields) {
            ArrayList columns = new ArrayList(fields.size());
            fields.forEach(field -> {
                AtomicBoolean found = new AtomicBoolean();
                this.columnToFieldMap.forEach((column, f) -> {
                    if (f.equals(field)) {
                        columns.add(column);
                        found.set(true);
                    }
                });
                if (!found.get()) {
                    throw new IllegalArgumentException("Field " + field + " not inserted");
                }
            });
            return this.onDuplicateKeyUpdate(columns.toArray(new String[0]));
        }

        @SafeVarargs
        public final Builder<M, F> onDuplicateKeyUpdateAllExcept(F ... fields) {
            return this.onDuplicateKeyUpdateAllExcept((Collection<F>)ImmutableList.copyOf((Object[])fields));
        }

        public final Builder<M, F> onDuplicateKeyUpdateAllExcept(Collection<F> fields) {
            ArrayList columns = new ArrayList(fields.size());
            fields.forEach(field -> {
                AtomicBoolean found = new AtomicBoolean();
                this.columnToFieldMap.forEach((column, f) -> {
                    if (f.equals(field)) {
                        columns.add(column);
                        found.set(true);
                    }
                });
                if (!found.get()) {
                    throw new IllegalArgumentException("Field " + field + " not inserted");
                }
            });
            return this.onDuplicateKeyUpdateAllExcept(columns.toArray(new String[0]));
        }

        public final Builder<M, F> onDuplicateKeyUpdateAllExcept(String ... exceptColumns) {
            TreeSet<String> columns = new TreeSet<String>(this.columnToFieldMap.keySet());
            columns.removeAll((Collection<?>)ImmutableList.copyOf((Object[])exceptColumns));
            return this.onDuplicateKeyUpdate(columns.toArray(new String[0]));
        }

        public final Builder<M, F> onDuplicateKeyUpdate(String ... columns) {
            if (this.onDuplicateIgnore.get()) {
                throw new IllegalStateException("Duplicate key behavior already set to ignore");
            }
            Collections.addAll(this.onDuplicateUpdate, columns);
            return this;
        }

        public final Builder<M, F> onDuplicateKeyIgnore() {
            if (this.onDuplicateUpdate.size() > 0) {
                throw new IllegalStateException("Duplicate key behavior already set to update");
            }
            this.onDuplicateIgnore.set(true);
            return this;
        }

        public MessageInserter<M, F> build() {
            if (this.columnToFieldMap.isEmpty()) {
                throw new IllegalStateException("No columns inserted");
            }
            ArrayList<String> columnOrder = new ArrayList<String>(this.columnToFieldMap.keySet());
            StringBuilder prefixBuilder = new StringBuilder("INSERT ");
            if (this.onDuplicateIgnore.get()) {
                prefixBuilder.append("IGNORE ");
            }
            prefixBuilder.append("INTO ").append(this.intoTable).append(" (").append(columnOrder.stream().map(col -> "`" + col + "`").collect(Collectors.joining(", "))).append(") VALUES ");
            StringBuilder suffixBuilder = new StringBuilder();
            if (this.onDuplicateUpdate.size() > 0) {
                suffixBuilder.append(" ON DUPLICATE KEY UPDATE");
                boolean first = true;
                for (String column : this.onDuplicateUpdate) {
                    if (first) {
                        first = false;
                    } else {
                        suffixBuilder.append(",");
                    }
                    suffixBuilder.append(" `").append(column).append("` = VALUES(`").append(column).append("`)");
                }
            }
            return new MessageInserter(prefixBuilder.toString(), suffixBuilder.toString(), columnOrder, this.columnToFieldMap, this.columnTypeMap);
        }
    }
}

