/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.util.Binary;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class MessageFieldArgument<M extends PMessage<M, F>, F extends PField>
implements Argument {
    private static final BinarySerializer BINARY = new BinarySerializer();
    private static final JsonSerializer JSON = new JsonSerializer().named();
    private final M message;
    private final F field;
    private final int type;

    public MessageFieldArgument(M message, F field) {
        this(message, field, MessageFieldArgument.getDefaultColumnType(field));
    }

    public MessageFieldArgument(M message, F field, int type) {
        this.message = message;
        this.field = field;
        this.type = type;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        block41: {
            block42: {
                if (!this.message.has(this.field)) break block42;
                switch (this.field.getType()) {
                    case BOOL: {
                        boolean value = (Boolean)this.message.get(this.field);
                        if (this.type == 16 || this.type == -7) {
                            statement.setBoolean(position, value);
                        } else {
                            statement.setInt(position, value ? 1 : 0);
                        }
                        break block41;
                    }
                    case BYTE: {
                        statement.setByte(position, (Byte)this.message.get(this.field));
                        break block41;
                    }
                    case I16: {
                        statement.setShort(position, (Short)this.message.get(this.field));
                        break block41;
                    }
                    case I32: {
                        if (this.type == 93) {
                            Timestamp timestamp = new Timestamp(1000L * (long)((Integer)this.message.get(this.field)).intValue());
                            statement.setTimestamp(position, timestamp);
                        } else if (this.type == 91) {
                            Date date = new Date(1000L * (long)((Integer)this.message.get(this.field)).intValue());
                            statement.setDate(position, date);
                        } else {
                            statement.setInt(position, (Integer)this.message.get(this.field));
                        }
                        break block41;
                    }
                    case I64: {
                        if (this.type == 93) {
                            Timestamp timestamp = new Timestamp((Long)this.message.get(this.field));
                            statement.setTimestamp(position, timestamp);
                        } else if (this.type == 91) {
                            Date date = new Date((Long)this.message.get(this.field));
                            statement.setDate(position, date);
                        } else {
                            statement.setLong(position, (Long)this.message.get(this.field));
                        }
                        break block41;
                    }
                    case DOUBLE: {
                        statement.setDouble(position, (Double)this.message.get(this.field));
                        break block41;
                    }
                    case STRING: {
                        statement.setString(position, (String)this.message.get(this.field));
                        break block41;
                    }
                    case BINARY: {
                        Binary binary = (Binary)this.message.get(this.field);
                        switch (this.type) {
                            case -4: 
                            case -3: 
                            case -2: {
                                statement.setBytes(position, binary.get());
                                break block41;
                            }
                            case 2004: {
                                statement.setBlob(position, binary.getInputStream());
                                break block41;
                            }
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                statement.setString(position, binary.toBase64());
                                break block41;
                            }
                            default: {
                                throw new SQLDataException("Unknown binary field type: " + this.type + " for " + this.field);
                            }
                        }
                    }
                    case ENUM: {
                        PEnumValue value = (PEnumValue)this.message.get(this.field);
                        statement.setInt(position, value.asInteger());
                        break block41;
                    }
                    case MESSAGE: {
                        PMessage value = (PMessage)this.message.get(this.field);
                        switch (this.type) {
                            case -4: 
                            case -3: 
                            case -2: {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    BINARY.serialize((OutputStream)out, value);
                                    statement.setBytes(position, out.toByteArray());
                                    break block41;
                                }
                                catch (IOException e) {
                                    throw new SQLDataException(e.getMessage(), e);
                                }
                            }
                            case 2004: {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    BINARY.serialize((OutputStream)out, value);
                                    statement.setBlob(position, new ByteArrayInputStream(out.toByteArray()));
                                    break block41;
                                }
                                catch (IOException e) {
                                    throw new SQLDataException(e.getMessage(), e);
                                }
                            }
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                StringWriter writer = new StringWriter();
                                try {
                                    JSON.serialize(new PrintWriter(writer), value);
                                    statement.setString(position, writer.getBuffer().toString());
                                    break block41;
                                }
                                catch (IOException e) {
                                    throw new SQLDataException(e.getMessage(), e);
                                }
                            }
                            case 2005: 
                            case 2011: {
                                StringWriter writer = new StringWriter();
                                try {
                                    JSON.serialize(new PrintWriter(writer), value);
                                    statement.setClob(position, new StringReader(writer.getBuffer().toString()));
                                    break block41;
                                }
                                catch (IOException e) {
                                    throw new SQLDataException(e.getMessage(), e);
                                }
                            }
                            default: {
                                throw new SQLDataException("Unknown message field type: " + this.type + " for " + this.field);
                            }
                        }
                    }
                    default: {
                        throw new SQLDataException("Unhandled field type in SQL: " + this.field);
                    }
                }
            }
            statement.setNull(position, this.type);
        }
    }

    static int getDefaultColumnType(PField field) {
        switch (field.getType()) {
            case BOOL: {
                return -7;
            }
            case BYTE: {
                return -6;
            }
            case I16: {
                return 5;
            }
            case I32: {
                return 4;
            }
            case I64: {
                return -5;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: {
                return 12;
            }
            case BINARY: {
                return -3;
            }
            case ENUM: {
                return 4;
            }
            case MESSAGE: {
                return 12;
            }
        }
        throw new IllegalArgumentException("No default column type for " + field.toString());
    }
}

