/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.morimekta.providence.jax.rs.schema.CompactObjectSchema;
import net.morimekta.providence.jax.rs.schema.SchemaWrapper;

public class OpenAPIUtils {
    private static final ObjectMapper JSON;
    private static final ObjectMapper YAML;

    public static void setIncludeNonNullOnSchema(ObjectMapper objectMapper) {
        objectMapper.addMixIn(Schema.class, SchemaWrapper.class);
        objectMapper.addMixIn(ArraySchema.class, CompactObjectSchema.class);
        OpenAPIUtils.setIncludeNonNull(objectMapper, Schema.class, ObjectSchema.class, ArraySchema.class, MapSchema.class, BooleanSchema.class, NumberSchema.class, IntegerSchema.class, StringSchema.class, OpenAPI.class, Server.class, Info.class, Components.class, Paths.class, PathItem.class, Operation.class, Content.class, MediaType.class, Schema.class, Parameter.class, Contact.class, ApiResponse.class, Callback.class, RequestBody.class, Header.class);
    }

    private static void setIncludeNonNull(ObjectMapper objectMapper, Class<?> ... types) {
        JsonInclude.Value includeNonNull = new JsonInclude.Value(SchemaWrapper.class.getAnnotation(JsonInclude.class));
        for (Class<?> type : types) {
            objectMapper.configOverride(type).setInclude(includeNonNull);
        }
    }

    @Nonnull
    public static OpenAPI parseOpenAPIYaml(String yaml) {
        try {
            return (OpenAPI)YAML.readValue(yaml, OpenAPI.class);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    @Nonnull
    public static OpenAPI parseOpenAPIJson(String json) {
        try {
            return (OpenAPI)JSON.readValue(json, OpenAPI.class);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    @Nonnull
    public static OpenAPI normalizeOpenAPI(@Nonnull OpenAPI openAPI) {
        TreeMap paths = new TreeMap(openAPI.getPaths());
        openAPI.getPaths().clear();
        openAPI.getPaths().putAll(paths);
        Components components = openAPI.getComponents();
        if (components.getSchemas() != null) {
            components.setSchemas(new TreeMap(components.getSchemas()));
        }
        if (components.getParameters() != null) {
            components.setParameters(new TreeMap(components.getParameters()));
        }
        if (components.getResponses() != null) {
            components.setResponses(new TreeMap(components.getResponses()));
        }
        if (components.getCallbacks() != null) {
            components.setCallbacks(new TreeMap(components.getCallbacks()));
        }
        if (components.getRequestBodies() != null) {
            components.setRequestBodies(new TreeMap(components.getRequestBodies()));
        }
        if (components.getExtensions() != null) {
            components.setExtensions(new TreeMap(components.getExtensions()));
        }
        if (components.getHeaders() != null) {
            components.setHeaders(new TreeMap(components.getHeaders()));
        }
        if (components.getLinks() != null) {
            components.setLinks(new TreeMap(components.getLinks()));
        }
        if (components.getSecuritySchemes() != null) {
            components.setSecuritySchemes(new TreeMap(components.getSecuritySchemes()));
        }
        return openAPI;
    }

    @Nonnull
    public static String toYaml(OpenAPI openAPI) {
        try {
            return YAML.writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    @Nonnull
    public static String toJson(OpenAPI openAPI) {
        try {
            return JSON.writerWithDefaultPrettyPrinter().writeValueAsString((Object)openAPI);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    static {
        ObjectMapper yaml;
        JSON = new ObjectMapper();
        OpenAPIUtils.setIncludeNonNullOnSchema(JSON);
        try {
            YAMLFactory yamlFactory = new YAMLFactory();
            yamlFactory.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true);
            yamlFactory.configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
            yamlFactory.configure(YAMLGenerator.Feature.USE_NATIVE_OBJECT_ID, false);
            yamlFactory.configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false);
            yaml = new ObjectMapper((JsonFactory)yamlFactory);
            OpenAPIUtils.setIncludeNonNullOnSchema(yaml);
        }
        catch (Error e) {
            yaml = JSON;
        }
        YAML = yaml;
    }
}

