/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import com.fasterxml.jackson.databind.type.SimpleType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.jax.rs.schema.AllOfSchema;
import net.morimekta.providence.jax.rs.schema.CompactObjectSchema;
import net.morimekta.providence.jax.rs.schema.OneOfSchema;
import net.morimekta.providence.serializer.json.JsonCompactibleDescriptor;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidenceModelConverter
implements ModelConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidenceModelConverter.class);
    private final String $refPrefix;
    private final boolean complexUnions;
    private final boolean allowCompact;
    private final boolean allowEnumId;

    public ProvidenceModelConverter() {
        this("#/components/schemas/", false, false, false);
    }

    public ProvidenceModelConverter(@Nonnull String $refPrefix, boolean complexUnions, boolean allowCompact, boolean allowEnumId) {
        this.$refPrefix = $refPrefix;
        this.complexUnions = complexUnions;
        this.allowCompact = allowCompact;
        this.allowEnumId = allowEnumId;
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        try {
            if (type.getType() instanceof Class) {
                Class klass = (Class)type.getType();
                if (PMessage.class.isAssignableFrom(klass)) {
                    Field kDescriptor = klass.getDeclaredField("kDescriptor");
                    PMessageDescriptor descriptor = (PMessageDescriptor)kDescriptor.get(null);
                    return this.resolveMessage(context, descriptor);
                }
                if (klass.isInstance(PEnumValue.class)) {
                    Field kDescriptor = klass.getDeclaredField("kDescriptor");
                    PEnumDescriptor descriptor = (PEnumDescriptor)kDescriptor.get(null);
                    return this.resolveEnum(context, descriptor);
                }
            } else if (type.getType() instanceof SimpleType) {
                SimpleType simple = (SimpleType)type.getType();
                String className = simple.toCanonical();
                Class<?> klass = this.getClass().getClassLoader().loadClass(className);
                if (PMessage.class.isAssignableFrom(klass)) {
                    Field kDescriptor = klass.getDeclaredField("kDescriptor");
                    PMessageDescriptor descriptor = (PMessageDescriptor)kDescriptor.get(null);
                    return this.resolveMessage(context, descriptor);
                }
                if (klass.isInstance(PEnumValue.class)) {
                    Field kDescriptor = klass.getDeclaredField("kDescriptor");
                    PEnumDescriptor descriptor = (PEnumDescriptor)kDescriptor.get(null);
                    return this.resolveEnum(context, descriptor);
                }
            } else if (type.getType() instanceof PDeclaredDescriptor) {
                PDeclaredDescriptor descriptor = (PDeclaredDescriptor)type.getType();
                if (descriptor.getType() == PType.MESSAGE) {
                    return this.resolveMessage(context, (PMessageDescriptor)descriptor);
                }
                if (descriptor.getType() == PType.ENUM) {
                    return this.resolveEnum(context, (PEnumDescriptor)descriptor);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve type: {}", (Object)e.getMessage(), (Object)e);
        }
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    private Schema resolveEnum(ModelConverterContext context, PEnumDescriptor<?> descriptor) {
        StringSchema schema;
        if (context.getDefinedModels().containsKey(descriptor.getQualifiedName())) {
            return new Schema().$ref(this.$refPrefix + descriptor.getQualifiedName());
        }
        StringSchema outSchema = schema = new StringSchema();
        schema.setName(descriptor.getQualifiedName());
        for (PEnumValue value : descriptor.getValues()) {
            schema.addEnumItem(value.asString());
        }
        if (this.allowEnumId) {
            NumberSchema idSchema = new NumberSchema();
            idSchema.setName(descriptor.getQualifiedName());
            for (PEnumValue value : descriptor.getValues()) {
                idSchema.addEnumItem(new BigDecimal(value.asInteger()));
            }
            outSchema = new OneOfSchema().oneOf((List<Schema>)UnmodifiableList.listOf((Object)schema, (Object)idSchema)).name(descriptor.getQualifiedName());
        }
        context.defineModel(descriptor.getQualifiedName(), (Schema)outSchema);
        return new Schema().$ref(this.$refPrefix + descriptor.getQualifiedName());
    }

    private Schema resolveMessage(ModelConverterContext context, PMessageDescriptor<?> descriptor) {
        ObjectSchema objectSchema;
        if (context.getDefinedModels().containsKey(descriptor.getQualifiedName())) {
            return new Schema().$ref(this.$refPrefix + descriptor.getQualifiedName());
        }
        context.defineModel(descriptor.getQualifiedName(), new ObjectSchema().name(descriptor.getQualifiedName()));
        Object outSchema = objectSchema = new ObjectSchema();
        outSchema.setName(descriptor.getQualifiedName());
        if (this.complexUnions && descriptor.getVariant() == PMessageVariant.UNION) {
            OneOfSchema unionSchema = new OneOfSchema();
            unionSchema.setName(descriptor.getQualifiedName());
            for (PField field : descriptor.getFields()) {
                if (field.getName().startsWith("__") || field.getDescriptor().getName().startsWith("__")) continue;
                objectSchema = new ObjectSchema();
                objectSchema.setName(descriptor.getQualifiedName() + "." + field.getName());
                objectSchema.addProperties(field.getName(), this.resolveProperty(context, field.getDescriptor()));
                objectSchema.addRequiredItem(field.getName());
                objectSchema.additionalProperties((Object)false);
                unionSchema.getOneOf().add((Schema)objectSchema);
            }
            outSchema = unionSchema;
        } else {
            PInterfaceDescriptor iFace = descriptor.getImplementing();
            Object iFaceMethods = UnmodifiableSet.setOf();
            if (iFace != null && descriptor.getVariant() == PMessageVariant.STRUCT) {
                outSchema = new AllOfSchema().allOf((List<Schema>)UnmodifiableList.listOf((Object)new Schema().$ref(this.$refPrefix + iFace.getQualifiedName()), (Object)objectSchema)).name(descriptor.getQualifiedName());
                iFaceMethods = Arrays.stream(iFace.getFields()).map(PField::getName).collect(Collectors.toSet());
            }
            for (PField field : descriptor.getFields()) {
                if (field.getName().startsWith("__") || field.getDescriptor().getName().startsWith("__") || iFaceMethods.contains(field.getName())) continue;
                objectSchema.addProperties(field.getName(), this.resolveProperty(context, field.getDescriptor()));
                if (field.getRequirement() != PRequirement.REQUIRED) continue;
                objectSchema.addRequiredItem(field.getName());
            }
        }
        if (this.allowCompact && descriptor instanceof JsonCompactibleDescriptor && ((JsonCompactibleDescriptor)descriptor).isJsonCompactible()) {
            CompactObjectSchema compact = new CompactObjectSchema();
            int minItems = 0;
            for (PField field : descriptor.getFields()) {
                if (field.getRequirement() == PRequirement.REQUIRED) {
                    ++minItems;
                }
                compact.getItems().add(this.resolveProperty(context, field.getDescriptor()));
            }
            if (minItems > 0) {
                compact.setMinItems(minItems);
            }
            outSchema = new OneOfSchema().oneOf((List<Schema>)UnmodifiableList.listOf((Object)outSchema, (Object)((Object)compact))).name(descriptor.getQualifiedName());
        }
        context.defineModel(descriptor.getQualifiedName(), (Schema)outSchema);
        return new Schema().$ref(this.$refPrefix + descriptor.getQualifiedName());
    }

    private Schema resolveProperty(ModelConverterContext context, PDescriptor descriptor) {
        switch (descriptor.getType()) {
            case ENUM: {
                return this.resolveEnum(context, (PEnumDescriptor)descriptor);
            }
            case MESSAGE: {
                return this.resolveMessage(context, (PMessageDescriptor)descriptor);
            }
            case LIST: {
                PList list = (PList)descriptor;
                return new ArraySchema().items(this.resolveProperty(context, list.itemDescriptor()));
            }
            case SET: {
                PSet set = (PSet)descriptor;
                return new ArraySchema().items(this.resolveProperty(context, set.itemDescriptor())).uniqueItems(Boolean.valueOf(true));
            }
            case MAP: {
                PMap map = (PMap)descriptor;
                this.resolveProperty(context, map.keyDescriptor());
                return new MapSchema().additionalProperties((Object)this.resolveProperty(context, map.itemDescriptor()));
            }
            case BOOL: {
                return new BooleanSchema();
            }
            case BYTE: {
                return new IntegerSchema().format("byte");
            }
            case I16: 
            case I32: {
                return new IntegerSchema();
            }
            case I64: {
                return new IntegerSchema().format("int64");
            }
            case DOUBLE: {
                return new NumberSchema().format("double");
            }
            case BINARY: {
                return new StringSchema().format("base64");
            }
            case STRING: {
                return new StringSchema();
            }
        }
        throw new IllegalArgumentException("Unhandled OpenAPI type: " + descriptor.getQualifiedName());
    }
}

