package net.morimekta.providence.jax.rs.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class SchemaUtils {
    public static void setIncludeNonNullOnSchema(ObjectMapper objectMapper) {
        setIncludeNonNull(objectMapper,
                          Schema.class,
                          ObjectSchema.class,
                          ArraySchema.class,
                          MapSchema.class,
                          BooleanSchema.class,
                          NumberSchema.class,
                          IntegerSchema.class,
                          StringSchema.class);
    }

    private static void setIncludeNonNull(ObjectMapper objectMapper, Class<?>... types) {
        JsonInclude.Value includeNonNull = new JsonInclude.Value(SchemaUtils.class.getAnnotation(JsonInclude.class));
        for (Class<?> type : types) {
            objectMapper.configOverride(type).setInclude(includeNonNull);
        }
    }
}
