/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class ProvidenceMessageBodyWriter
implements MessageBodyWriter<PMessageOrBuilder> {
    private final SerializerProvider provider;

    protected ProvidenceMessageBodyWriter(@Nonnull SerializerProvider provider) {
        this.provider = provider;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!PMessage.class.isAssignableFrom(type) || MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
            return false;
        }
        try {
            this.provider.getSerializer(mediaType.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getSize(PMessageOrBuilder t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    public void writeTo(PMessageOrBuilder entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            this.provider.getSerializer(mediaType.toString()).serialize(entityStream, entity);
        }
        catch (NotSupportedException e) {
            throw new ProcessingException("Unknown media type: " + mediaType, (Throwable)e);
        }
        catch (SerializerException se) {
            throw new ProcessingException("Unable to serialize entity", (Throwable)se);
        }
    }
}

