/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class ProvidenceMessageBodyReader
implements MessageBodyReader<PMessage> {
    private final SerializerProvider provider;

    protected ProvidenceMessageBodyReader(SerializerProvider provider) {
        this.provider = provider;
    }

    @Nullable
    private PMessageDescriptor getDescriptor(Class<?> type) {
        try {
            if (!PMessage.class.isAssignableFrom(type)) {
                return null;
            }
            Field descField = type.getDeclaredField("kDescriptor");
            Object desc = descField.get(null);
            if (desc instanceof PMessageDescriptor) {
                return (PMessageDescriptor)desc;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    private PMessageDescriptor getDescriptorOrFail(Class<?> type) {
        PMessageDescriptor descriptor = this.getDescriptor(type);
        if (descriptor == null) {
            throw new NotSupportedException("No providence descriptor for class " + type.getName());
        }
        return descriptor;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == null || this.getDescriptor(type) == null || MediaType.WILDCARD_TYPE.equals((Object)mediaType)) {
            return false;
        }
        try {
            this.provider.getSerializer(mediaType.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public PMessage readFrom(Class<PMessage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            PMessageDescriptor descriptor = this.getDescriptorOrFail(type);
            return this.provider.getSerializer(mediaType.toString()).deserialize(entityStream, descriptor);
        }
        catch (SerializerException e) {
            throw new ProcessingException("Unable to deserialize entity", (Throwable)e);
        }
    }
}

