/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.SerializerProvider;

public abstract class ProvidenceMessageBodyReader
implements MessageBodyReader<PMessage> {
    private final SerializerProvider provider;

    protected ProvidenceMessageBodyReader(SerializerProvider provider) {
        this.provider = provider;
    }

    private PMessageDescriptor getDescriptor(Class<?> type) {
        try {
            if (!PMessage.class.isAssignableFrom(type)) {
                return null;
            }
            Field descField = type.getDeclaredField("kDescriptor");
            Object desc = descField.get(null);
            if (desc instanceof PMessageDescriptor) {
                return (PMessageDescriptor)desc;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == null || this.getDescriptor(type) == null) {
            return false;
        }
        String contentType = mediaType.getType() + "/" + mediaType.getSubtype();
        try {
            this.provider.getSerializer(contentType);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public PMessage readFrom(Class<PMessage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String contentType = mediaType.getType() + "/" + mediaType.getSubtype();
        try {
            PMessageDescriptor descriptor = this.getDescriptor(type);
            return this.provider.getSerializer(contentType).deserialize(entityStream, descriptor);
        }
        catch (NullPointerException e) {
            throw new NotSupportedException("Unknown media type: " + mediaType, (Throwable)e);
        }
        catch (SerializerException e) {
            throw new ProcessingException("Unable to deserialize entity", (Throwable)e);
        }
    }
}

