/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jax.rs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;

public abstract class ProvidenceMessageBodyReader<T extends PMessage<T, F>, F extends PField>
implements MessageBodyReader<T> {
    private final Serializer mSerializer;

    public ProvidenceMessageBodyReader(Serializer serializer) {
        this.mSerializer = serializer;
    }

    private PStructDescriptor<T, F> getDescriptor(Class<?> type) {
        try {
            if (!PMessage.class.isAssignableFrom(type)) {
                return null;
            }
            Field descField = type.getDeclaredField("kDescriptor");
            Object desc = descField.get(null);
            if (desc instanceof PStructDescriptor) {
                return (PStructDescriptor)desc;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type != null && this.getDescriptor(type) != null;
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            PStructDescriptor<T, F> descriptor = this.getDescriptor(type);
            return (T)this.mSerializer.deserialize(entityStream, descriptor);
        }
        catch (SerializerException e) {
            throw new ProcessingException("", (Throwable)e);
        }
    }
}

