/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.test.providence;

import android.os.Parcel;
import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Objects;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.jackson.BinaryJsonSerializer;
import net.morimekta.providence.util.PTypeUtils;
import net.morimekta.test.providence.CompactFields;
import net.morimekta.test.providence.Value;
import net.morimekta.util.Binary;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class UnionFields
implements PUnion<UnionFields>,
Serializable,
Comparable<UnionFields>,
Parcelable {
    private static final long serialVersionUID = 5567571546617352666L;
    private static final boolean kDefaultBooleanValue = false;
    private static final byte kDefaultByteValue = 0;
    private static final short kDefaultShortValue = 0;
    private static final int kDefaultIntegerValue = 0;
    private static final long kDefaultLongValue = 0L;
    private static final double kDefaultDoubleValue = 0.0;
    private final boolean mBooleanValue;
    private final byte mByteValue;
    private final short mShortValue;
    private final int mIntegerValue;
    private final long mLongValue;
    private final double mDoubleValue;
    private final String mStringValue;
    private final Binary mBinaryValue;
    private final Value mEnumValue;
    private final CompactFields mCompactValue;
    private final _Field tUnionField;
    private volatile int tHashCode;
    public static final PUnionDescriptor<UnionFields, _Field> kDescriptor = new _Descriptor();
    public static final Parcelable.Creator<UnionFields> CREATOR = new Parcelable.Creator<UnionFields>(){

        public UnionFields createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            block13: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: {
                        break block13;
                    }
                    case 1: {
                        builder.setBooleanValue(source.readByte() > 0);
                        break;
                    }
                    case 2: {
                        builder.setByteValue(source.readByte());
                        break;
                    }
                    case 3: {
                        builder.setShortValue((short)source.readInt());
                        break;
                    }
                    case 4: {
                        builder.setIntegerValue(source.readInt());
                        break;
                    }
                    case 5: {
                        builder.setLongValue(source.readLong());
                        break;
                    }
                    case 6: {
                        builder.setDoubleValue(source.readDouble());
                        break;
                    }
                    case 7: {
                        builder.setStringValue(source.readString());
                        break;
                    }
                    case 8: {
                        builder.setBinaryValue(Binary.wrap((byte[])source.createByteArray()));
                        break;
                    }
                    case 9: {
                        builder.setEnumValue(Value.forValue(source.readInt()));
                        break;
                    }
                    case 10: {
                        builder.setCompactValue((CompactFields)source.readTypedObject(CompactFields.CREATOR));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field ID: " + field);
                    }
                }
            }
            return builder.build();
        }

        public UnionFields[] newArray(int size) {
            return new UnionFields[size];
        }
    };

    private UnionFields(_Builder builder) {
        this.tUnionField = builder.tUnionField;
        this.mBooleanValue = this.tUnionField == _Field.BOOLEAN_VALUE ? builder.mBooleanValue : false;
        this.mByteValue = this.tUnionField == _Field.BYTE_VALUE ? builder.mByteValue : (byte)0;
        this.mShortValue = this.tUnionField == _Field.SHORT_VALUE ? builder.mShortValue : (short)0;
        this.mIntegerValue = this.tUnionField == _Field.INTEGER_VALUE ? builder.mIntegerValue : 0;
        this.mLongValue = this.tUnionField == _Field.LONG_VALUE ? builder.mLongValue : 0L;
        this.mDoubleValue = this.tUnionField == _Field.DOUBLE_VALUE ? builder.mDoubleValue : 0.0;
        this.mStringValue = this.tUnionField == _Field.STRING_VALUE ? builder.mStringValue : null;
        this.mBinaryValue = this.tUnionField == _Field.BINARY_VALUE ? builder.mBinaryValue : null;
        this.mEnumValue = this.tUnionField == _Field.ENUM_VALUE ? builder.mEnumValue : null;
        this.mCompactValue = this.tUnionField == _Field.COMPACT_VALUE ? builder.mCompactValue : null;
    }

    public static UnionFields withBooleanValue(boolean value) {
        return new _Builder().setBooleanValue(value).build();
    }

    public static UnionFields withByteValue(byte value) {
        return new _Builder().setByteValue(value).build();
    }

    public static UnionFields withShortValue(short value) {
        return new _Builder().setShortValue(value).build();
    }

    public static UnionFields withIntegerValue(int value) {
        return new _Builder().setIntegerValue(value).build();
    }

    public static UnionFields withLongValue(long value) {
        return new _Builder().setLongValue(value).build();
    }

    public static UnionFields withDoubleValue(double value) {
        return new _Builder().setDoubleValue(value).build();
    }

    public static UnionFields withStringValue(String value) {
        return new _Builder().setStringValue(value).build();
    }

    public static UnionFields withBinaryValue(Binary value) {
        return new _Builder().setBinaryValue(value).build();
    }

    public static UnionFields withEnumValue(Value value) {
        return new _Builder().setEnumValue(value).build();
    }

    public static UnionFields withCompactValue(CompactFields value) {
        return new _Builder().setCompactValue(value).build();
    }

    public boolean hasBooleanValue() {
        return this.tUnionField == _Field.BOOLEAN_VALUE;
    }

    @JsonProperty(value="booleanValue")
    public boolean isBooleanValue() {
        return this.mBooleanValue;
    }

    public boolean hasByteValue() {
        return this.tUnionField == _Field.BYTE_VALUE;
    }

    @JsonProperty(value="byteValue")
    public byte getByteValue() {
        return this.mByteValue;
    }

    public boolean hasShortValue() {
        return this.tUnionField == _Field.SHORT_VALUE;
    }

    @JsonProperty(value="shortValue")
    public short getShortValue() {
        return this.mShortValue;
    }

    public boolean hasIntegerValue() {
        return this.tUnionField == _Field.INTEGER_VALUE;
    }

    @JsonProperty(value="integerValue")
    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public boolean hasLongValue() {
        return this.tUnionField == _Field.LONG_VALUE;
    }

    @JsonProperty(value="longValue")
    public long getLongValue() {
        return this.mLongValue;
    }

    public boolean hasDoubleValue() {
        return this.tUnionField == _Field.DOUBLE_VALUE;
    }

    @JsonProperty(value="doubleValue")
    public double getDoubleValue() {
        return this.mDoubleValue;
    }

    public boolean hasStringValue() {
        return this.tUnionField == _Field.STRING_VALUE && this.mStringValue != null;
    }

    @JsonProperty(value="stringValue")
    public String getStringValue() {
        return this.mStringValue;
    }

    public boolean hasBinaryValue() {
        return this.tUnionField == _Field.BINARY_VALUE && this.mBinaryValue != null;
    }

    @JsonProperty(value="binaryValue")
    @JsonSerialize(using=BinaryJsonSerializer.class)
    public Binary getBinaryValue() {
        return this.mBinaryValue;
    }

    public boolean hasEnumValue() {
        return this.tUnionField == _Field.ENUM_VALUE && this.mEnumValue != null;
    }

    @JsonProperty(value="enumValue")
    public Value getEnumValue() {
        return this.mEnumValue;
    }

    public boolean hasCompactValue() {
        return this.tUnionField == _Field.COMPACT_VALUE && this.mCompactValue != null;
    }

    @JsonProperty(value="compactValue")
    public CompactFields getCompactValue() {
        return this.mCompactValue;
    }

    public _Field unionField() {
        return this.tUnionField;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasBooleanValue();
            }
            case 2: {
                return this.hasByteValue();
            }
            case 3: {
                return this.hasShortValue();
            }
            case 4: {
                return this.hasIntegerValue();
            }
            case 5: {
                return this.hasLongValue();
            }
            case 6: {
                return this.hasDoubleValue();
            }
            case 7: {
                return this.hasStringValue();
            }
            case 8: {
                return this.hasBinaryValue();
            }
            case 9: {
                return this.hasEnumValue();
            }
            case 10: {
                return this.hasCompactValue();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasBooleanValue() ? 1 : 0;
            }
            case 2: {
                return this.hasByteValue() ? 1 : 0;
            }
            case 3: {
                return this.hasShortValue() ? 1 : 0;
            }
            case 4: {
                return this.hasIntegerValue() ? 1 : 0;
            }
            case 5: {
                return this.hasLongValue() ? 1 : 0;
            }
            case 6: {
                return this.hasDoubleValue() ? 1 : 0;
            }
            case 7: {
                return this.hasStringValue() ? 1 : 0;
            }
            case 8: {
                return this.hasBinaryValue() ? 1 : 0;
            }
            case 9: {
                return this.hasEnumValue() ? 1 : 0;
            }
            case 10: {
                return this.hasCompactValue() ? 1 : 0;
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.isBooleanValue();
            }
            case 2: {
                return this.getByteValue();
            }
            case 3: {
                return this.getShortValue();
            }
            case 4: {
                return this.getIntegerValue();
            }
            case 5: {
                return this.getLongValue();
            }
            case 6: {
                return this.getDoubleValue();
            }
            case 7: {
                return this.getStringValue();
            }
            case 8: {
                return this.getBinaryValue();
            }
            case 9: {
                return this.getEnumValue();
            }
            case 10: {
                return this.getCompactValue();
            }
        }
        return null;
    }

    @JsonIgnore
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UnionFields)) {
            return false;
        }
        UnionFields other = (UnionFields)o;
        return Objects.equals((Object)this.tUnionField, (Object)other.tUnionField) && Objects.equals(this.mBooleanValue, other.mBooleanValue) && Objects.equals(this.mByteValue, other.mByteValue) && Objects.equals(this.mShortValue, other.mShortValue) && Objects.equals(this.mIntegerValue, other.mIntegerValue) && Objects.equals(this.mLongValue, other.mLongValue) && Objects.equals(this.mDoubleValue, other.mDoubleValue) && Objects.equals(this.mStringValue, other.mStringValue) && Objects.equals(this.mBinaryValue, other.mBinaryValue) && Objects.equals((Object)this.mEnumValue, (Object)other.mEnumValue) && Objects.equals(this.mCompactValue, other.mCompactValue);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{UnionFields.class, _Field.BOOLEAN_VALUE, this.mBooleanValue, _Field.BYTE_VALUE, this.mByteValue, _Field.SHORT_VALUE, this.mShortValue, _Field.INTEGER_VALUE, this.mIntegerValue, _Field.LONG_VALUE, this.mLongValue, _Field.DOUBLE_VALUE, this.mDoubleValue, _Field.STRING_VALUE, this.mStringValue, _Field.BINARY_VALUE, this.mBinaryValue, _Field.ENUM_VALUE, this.mEnumValue, _Field.COMPACT_VALUE, this.mCompactValue});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "test.UnionFields" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        switch (this.tUnionField) {
            case BOOLEAN_VALUE: {
                out.append("booleanValue:");
                out.append(this.mBooleanValue);
                break;
            }
            case BYTE_VALUE: {
                out.append("byteValue:");
                out.append(this.mByteValue);
                break;
            }
            case SHORT_VALUE: {
                out.append("shortValue:");
                out.append(this.mShortValue);
                break;
            }
            case INTEGER_VALUE: {
                out.append("integerValue:");
                out.append(this.mIntegerValue);
                break;
            }
            case LONG_VALUE: {
                out.append("longValue:");
                out.append(this.mLongValue);
                break;
            }
            case DOUBLE_VALUE: {
                out.append("doubleValue:");
                out.append(PTypeUtils.toString((double)this.mDoubleValue));
                break;
            }
            case STRING_VALUE: {
                out.append("stringValue:");
                out.append('\"').append(this.mStringValue).append('\"');
                break;
            }
            case BINARY_VALUE: {
                out.append("binaryValue:");
                out.append("b64(").append(this.mBinaryValue.toBase64()).append(')');
                break;
            }
            case ENUM_VALUE: {
                out.append("enumValue:");
                out.append(this.mEnumValue.getName());
                break;
            }
            case COMPACT_VALUE: {
                out.append("compactValue:");
                out.append(this.mCompactValue.asString());
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(UnionFields other) {
        int c = Integer.compare(this.tUnionField.getKey(), other.tUnionField.getKey());
        if (c != 0) {
            return c;
        }
        switch (this.tUnionField) {
            case BOOLEAN_VALUE: {
                return Boolean.compare(this.mBooleanValue, other.mBooleanValue);
            }
            case BYTE_VALUE: {
                return Byte.compare(this.mByteValue, other.mByteValue);
            }
            case SHORT_VALUE: {
                return Short.compare(this.mShortValue, other.mShortValue);
            }
            case INTEGER_VALUE: {
                return Integer.compare(this.mIntegerValue, other.mIntegerValue);
            }
            case LONG_VALUE: {
                return Long.compare(this.mLongValue, other.mLongValue);
            }
            case DOUBLE_VALUE: {
                return Double.compare(this.mDoubleValue, other.mDoubleValue);
            }
            case STRING_VALUE: {
                return this.mStringValue.compareTo(other.mStringValue);
            }
            case BINARY_VALUE: {
                return this.mBinaryValue.compareTo(other.mBinaryValue);
            }
            case ENUM_VALUE: {
                return Integer.compare(this.mEnumValue.getValue(), other.mEnumValue.getValue());
            }
            case COMPACT_VALUE: {
                return this.mCompactValue.compareTo(other.mCompactValue);
            }
        }
        return 0;
    }

    public static PUnionDescriptorProvider<UnionFields, _Field> provider() {
        return new _Provider();
    }

    public PUnionDescriptor<UnionFields, _Field> descriptor() {
        return kDescriptor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.tUnionField != null) {
            switch (this.tUnionField) {
                case BOOLEAN_VALUE: {
                    dest.writeInt(1);
                    dest.writeByte(this.mBooleanValue ? (byte)1 : 0);
                    break;
                }
                case BYTE_VALUE: {
                    dest.writeInt(2);
                    dest.writeByte(this.mByteValue);
                    break;
                }
                case SHORT_VALUE: {
                    dest.writeInt(3);
                    dest.writeInt((int)this.mShortValue);
                    break;
                }
                case INTEGER_VALUE: {
                    dest.writeInt(4);
                    dest.writeInt(this.mIntegerValue);
                    break;
                }
                case LONG_VALUE: {
                    dest.writeInt(5);
                    dest.writeLong(this.mLongValue);
                    break;
                }
                case DOUBLE_VALUE: {
                    dest.writeInt(6);
                    dest.writeDouble(this.mDoubleValue);
                    break;
                }
                case STRING_VALUE: {
                    dest.writeInt(7);
                    dest.writeString(this.mStringValue);
                    break;
                }
                case BINARY_VALUE: {
                    dest.writeInt(8);
                    dest.writeByteArray(this.mBinaryValue.get());
                    break;
                }
                case ENUM_VALUE: {
                    dest.writeInt(9);
                    dest.writeInt(this.mEnumValue.getValue());
                    break;
                }
                case COMPACT_VALUE: {
                    dest.writeInt(10);
                    dest.writeTypedObject((Parcelable)this.mCompactValue, 0);
                }
            }
        }
        dest.writeInt(0);
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<UnionFields> {
        private _Field tUnionField;
        private boolean mBooleanValue = false;
        private byte mByteValue = 0;
        private short mShortValue = 0;
        private int mIntegerValue = 0;
        private long mLongValue = 0L;
        private double mDoubleValue = 0.0;
        private String mStringValue;
        private Binary mBinaryValue;
        private Value mEnumValue;
        private CompactFields mCompactValue;

        public _Builder() {
        }

        public _Builder(UnionFields base) {
            this();
            this.tUnionField = base.tUnionField;
            this.mBooleanValue = base.mBooleanValue;
            this.mByteValue = base.mByteValue;
            this.mShortValue = base.mShortValue;
            this.mIntegerValue = base.mIntegerValue;
            this.mLongValue = base.mLongValue;
            this.mDoubleValue = base.mDoubleValue;
            this.mStringValue = base.mStringValue;
            this.mBinaryValue = base.mBinaryValue;
            this.mEnumValue = base.mEnumValue;
            this.mCompactValue = base.mCompactValue;
        }

        public _Builder setBooleanValue(boolean value) {
            this.tUnionField = _Field.BOOLEAN_VALUE;
            this.mBooleanValue = value;
            return this;
        }

        public _Builder clearBooleanValue() {
            if (this.tUnionField == _Field.BOOLEAN_VALUE) {
                this.tUnionField = null;
            }
            this.mBooleanValue = false;
            return this;
        }

        public _Builder setByteValue(byte value) {
            this.tUnionField = _Field.BYTE_VALUE;
            this.mByteValue = value;
            return this;
        }

        public _Builder clearByteValue() {
            if (this.tUnionField == _Field.BYTE_VALUE) {
                this.tUnionField = null;
            }
            this.mByteValue = 0;
            return this;
        }

        public _Builder setShortValue(short value) {
            this.tUnionField = _Field.SHORT_VALUE;
            this.mShortValue = value;
            return this;
        }

        public _Builder clearShortValue() {
            if (this.tUnionField == _Field.SHORT_VALUE) {
                this.tUnionField = null;
            }
            this.mShortValue = 0;
            return this;
        }

        public _Builder setIntegerValue(int value) {
            this.tUnionField = _Field.INTEGER_VALUE;
            this.mIntegerValue = value;
            return this;
        }

        public _Builder clearIntegerValue() {
            if (this.tUnionField == _Field.INTEGER_VALUE) {
                this.tUnionField = null;
            }
            this.mIntegerValue = 0;
            return this;
        }

        public _Builder setLongValue(long value) {
            this.tUnionField = _Field.LONG_VALUE;
            this.mLongValue = value;
            return this;
        }

        public _Builder clearLongValue() {
            if (this.tUnionField == _Field.LONG_VALUE) {
                this.tUnionField = null;
            }
            this.mLongValue = 0L;
            return this;
        }

        public _Builder setDoubleValue(double value) {
            this.tUnionField = _Field.DOUBLE_VALUE;
            this.mDoubleValue = value;
            return this;
        }

        public _Builder clearDoubleValue() {
            if (this.tUnionField == _Field.DOUBLE_VALUE) {
                this.tUnionField = null;
            }
            this.mDoubleValue = 0.0;
            return this;
        }

        public _Builder setStringValue(String value) {
            this.tUnionField = _Field.STRING_VALUE;
            this.mStringValue = value;
            return this;
        }

        public _Builder clearStringValue() {
            if (this.tUnionField == _Field.STRING_VALUE) {
                this.tUnionField = null;
            }
            this.mStringValue = null;
            return this;
        }

        public _Builder setBinaryValue(Binary value) {
            this.tUnionField = _Field.BINARY_VALUE;
            this.mBinaryValue = value;
            return this;
        }

        public _Builder clearBinaryValue() {
            if (this.tUnionField == _Field.BINARY_VALUE) {
                this.tUnionField = null;
            }
            this.mBinaryValue = null;
            return this;
        }

        public _Builder setEnumValue(Value value) {
            this.tUnionField = _Field.ENUM_VALUE;
            this.mEnumValue = value;
            return this;
        }

        public _Builder clearEnumValue() {
            if (this.tUnionField == _Field.ENUM_VALUE) {
                this.tUnionField = null;
            }
            this.mEnumValue = null;
            return this;
        }

        public _Builder setCompactValue(CompactFields value) {
            this.tUnionField = _Field.COMPACT_VALUE;
            this.mCompactValue = value;
            return this;
        }

        public _Builder clearCompactValue() {
            if (this.tUnionField == _Field.COMPACT_VALUE) {
                this.tUnionField = null;
            }
            this.mCompactValue = null;
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setBooleanValue((Boolean)value);
                    break;
                }
                case 2: {
                    this.setByteValue((Byte)value);
                    break;
                }
                case 3: {
                    this.setShortValue((Short)value);
                    break;
                }
                case 4: {
                    this.setIntegerValue((Integer)value);
                    break;
                }
                case 5: {
                    this.setLongValue((Long)value);
                    break;
                }
                case 6: {
                    this.setDoubleValue((Double)value);
                    break;
                }
                case 7: {
                    this.setStringValue((String)value);
                    break;
                }
                case 8: {
                    this.setBinaryValue((Binary)value);
                    break;
                }
                case 9: {
                    this.setEnumValue((Value)((Object)value));
                    break;
                }
                case 10: {
                    this.setCompactValue((CompactFields)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearBooleanValue();
                    break;
                }
                case 2: {
                    this.clearByteValue();
                    break;
                }
                case 3: {
                    this.clearShortValue();
                    break;
                }
                case 4: {
                    this.clearIntegerValue();
                    break;
                }
                case 5: {
                    this.clearLongValue();
                    break;
                }
                case 6: {
                    this.clearDoubleValue();
                    break;
                }
                case 7: {
                    this.clearStringValue();
                    break;
                }
                case 8: {
                    this.clearBinaryValue();
                    break;
                }
                case 9: {
                    this.clearEnumValue();
                    break;
                }
                case 10: {
                    this.clearCompactValue();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.tUnionField != null;
        }

        public UnionFields build() {
            return new UnionFields(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<UnionFields> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PUnionDescriptorProvider<UnionFields, _Field> {
        private _Provider() {
        }

        public PUnionDescriptor<UnionFields, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PUnionDescriptor<UnionFields, _Field> {
        public _Descriptor() {
            super(null, "test", "UnionFields", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        BOOLEAN_VALUE(1, PRequirement.DEFAULT, "booleanValue", (PDescriptorProvider<?>)PPrimitive.BOOL.provider(), null),
        BYTE_VALUE(2, PRequirement.DEFAULT, "byteValue", (PDescriptorProvider<?>)PPrimitive.BYTE.provider(), null),
        SHORT_VALUE(3, PRequirement.DEFAULT, "shortValue", (PDescriptorProvider<?>)PPrimitive.I16.provider(), null),
        INTEGER_VALUE(4, PRequirement.DEFAULT, "integerValue", (PDescriptorProvider<?>)PPrimitive.I32.provider(), null),
        LONG_VALUE(5, PRequirement.DEFAULT, "longValue", (PDescriptorProvider<?>)PPrimitive.I64.provider(), null),
        DOUBLE_VALUE(6, PRequirement.DEFAULT, "doubleValue", (PDescriptorProvider<?>)PPrimitive.DOUBLE.provider(), null),
        STRING_VALUE(7, PRequirement.DEFAULT, "stringValue", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        BINARY_VALUE(8, PRequirement.DEFAULT, "binaryValue", (PDescriptorProvider<?>)PPrimitive.BINARY.provider(), null),
        ENUM_VALUE(9, PRequirement.DEFAULT, "enumValue", (PDescriptorProvider<?>)Value.provider(), null),
        COMPACT_VALUE(10, PRequirement.DEFAULT, "compactValue", (PDescriptorProvider<?>)CompactFields.provider(), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UnionFields._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return BOOLEAN_VALUE;
                }
                case 2: {
                    return BYTE_VALUE;
                }
                case 3: {
                    return SHORT_VALUE;
                }
                case 4: {
                    return INTEGER_VALUE;
                }
                case 5: {
                    return LONG_VALUE;
                }
                case 6: {
                    return DOUBLE_VALUE;
                }
                case 7: {
                    return STRING_VALUE;
                }
                case 8: {
                    return BINARY_VALUE;
                }
                case 9: {
                    return ENUM_VALUE;
                }
                case 10: {
                    return COMPACT_VALUE;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "booleanValue": {
                    return BOOLEAN_VALUE;
                }
                case "byteValue": {
                    return BYTE_VALUE;
                }
                case "shortValue": {
                    return SHORT_VALUE;
                }
                case "integerValue": {
                    return INTEGER_VALUE;
                }
                case "longValue": {
                    return LONG_VALUE;
                }
                case "doubleValue": {
                    return DOUBLE_VALUE;
                }
                case "stringValue": {
                    return STRING_VALUE;
                }
                case "binaryValue": {
                    return BINARY_VALUE;
                }
                case "enumValue": {
                    return ENUM_VALUE;
                }
                case "compactValue": {
                    return COMPACT_VALUE;
                }
            }
            return null;
        }
    }
}

