/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.test.providence;

import android.os.Parcel;
import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.jackson.BinaryJsonDeserializer;
import net.morimekta.providence.jackson.BinaryJsonSerializer;
import net.morimekta.providence.util.PTypeUtils;
import net.morimekta.test.providence.CompactFields;
import net.morimekta.test.providence.Value;
import net.morimekta.util.Binary;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RequiredFields
implements PMessage<RequiredFields>,
Serializable,
Comparable<RequiredFields>,
Parcelable {
    private static final long serialVersionUID = 1362996204471280110L;
    private static final boolean kDefaultBooleanValue = false;
    private static final byte kDefaultByteValue = 0;
    private static final short kDefaultShortValue = 0;
    private static final int kDefaultIntegerValue = 0;
    private static final long kDefaultLongValue = 0L;
    private static final double kDefaultDoubleValue = 0.0;
    private final boolean mBooleanValue;
    private final byte mByteValue;
    private final short mShortValue;
    private final int mIntegerValue;
    private final long mLongValue;
    private final double mDoubleValue;
    private final String mStringValue;
    private final Binary mBinaryValue;
    private final Value mEnumValue;
    private final CompactFields mCompactValue;
    private volatile int tHashCode;
    public static final PStructDescriptor<RequiredFields, _Field> kDescriptor = new _Descriptor();
    public static final Parcelable.Creator<RequiredFields> CREATOR = new Parcelable.Creator<RequiredFields>(){

        public RequiredFields createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            block13: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: {
                        break block13;
                    }
                    case 1: {
                        builder.setBooleanValue(source.readByte() > 0);
                        break;
                    }
                    case 2: {
                        builder.setByteValue(source.readByte());
                        break;
                    }
                    case 3: {
                        builder.setShortValue((short)source.readInt());
                        break;
                    }
                    case 4: {
                        builder.setIntegerValue(source.readInt());
                        break;
                    }
                    case 5: {
                        builder.setLongValue(source.readLong());
                        break;
                    }
                    case 6: {
                        builder.setDoubleValue(source.readDouble());
                        break;
                    }
                    case 7: {
                        builder.setStringValue(source.readString());
                        break;
                    }
                    case 8: {
                        builder.setBinaryValue(Binary.wrap((byte[])source.createByteArray()));
                        break;
                    }
                    case 9: {
                        builder.setEnumValue(Value.forValue(source.readInt()));
                        break;
                    }
                    case 10: {
                        builder.setCompactValue((CompactFields)source.readTypedObject(CompactFields.CREATOR));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field ID: " + field);
                    }
                }
            }
            return builder.build();
        }

        public RequiredFields[] newArray(int size) {
            return new RequiredFields[size];
        }
    };

    private RequiredFields(_Builder builder) {
        this.mBooleanValue = builder.mBooleanValue;
        this.mByteValue = builder.mByteValue;
        this.mShortValue = builder.mShortValue;
        this.mIntegerValue = builder.mIntegerValue;
        this.mLongValue = builder.mLongValue;
        this.mDoubleValue = builder.mDoubleValue;
        this.mStringValue = builder.mStringValue;
        this.mBinaryValue = builder.mBinaryValue;
        this.mEnumValue = builder.mEnumValue;
        this.mCompactValue = builder.mCompactValue;
    }

    @JsonCreator
    public RequiredFields(@JsonProperty(value="booleanValue") boolean pBooleanValue, @JsonProperty(value="byteValue") byte pByteValue, @JsonProperty(value="shortValue") short pShortValue, @JsonProperty(value="integerValue") int pIntegerValue, @JsonProperty(value="longValue") long pLongValue, @JsonProperty(value="doubleValue") double pDoubleValue, @JsonProperty(value="stringValue") String pStringValue, @JsonProperty(value="binaryValue") @JsonDeserialize(using=BinaryJsonDeserializer.class) Binary pBinaryValue, @JsonProperty(value="enumValue") Value pEnumValue, @JsonProperty(value="compactValue") CompactFields pCompactValue) {
        this.mBooleanValue = pBooleanValue;
        this.mByteValue = pByteValue;
        this.mShortValue = pShortValue;
        this.mIntegerValue = pIntegerValue;
        this.mLongValue = pLongValue;
        this.mDoubleValue = pDoubleValue;
        this.mStringValue = pStringValue;
        this.mBinaryValue = pBinaryValue;
        this.mEnumValue = pEnumValue;
        this.mCompactValue = pCompactValue;
    }

    public boolean hasBooleanValue() {
        return true;
    }

    @JsonProperty(value="booleanValue")
    public boolean isBooleanValue() {
        return this.mBooleanValue;
    }

    public boolean hasByteValue() {
        return true;
    }

    @JsonProperty(value="byteValue")
    public byte getByteValue() {
        return this.mByteValue;
    }

    public boolean hasShortValue() {
        return true;
    }

    @JsonProperty(value="shortValue")
    public short getShortValue() {
        return this.mShortValue;
    }

    public boolean hasIntegerValue() {
        return true;
    }

    @JsonProperty(value="integerValue")
    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public boolean hasLongValue() {
        return true;
    }

    @JsonProperty(value="longValue")
    public long getLongValue() {
        return this.mLongValue;
    }

    public boolean hasDoubleValue() {
        return true;
    }

    @JsonProperty(value="doubleValue")
    public double getDoubleValue() {
        return this.mDoubleValue;
    }

    public boolean hasStringValue() {
        return this.mStringValue != null;
    }

    @JsonProperty(value="stringValue")
    public String getStringValue() {
        return this.mStringValue;
    }

    public boolean hasBinaryValue() {
        return this.mBinaryValue != null;
    }

    @JsonProperty(value="binaryValue")
    @JsonSerialize(using=BinaryJsonSerializer.class)
    public Binary getBinaryValue() {
        return this.mBinaryValue;
    }

    public boolean hasEnumValue() {
        return this.mEnumValue != null;
    }

    @JsonProperty(value="enumValue")
    public Value getEnumValue() {
        return this.mEnumValue;
    }

    public boolean hasCompactValue() {
        return this.mCompactValue != null;
    }

    @JsonProperty(value="compactValue")
    public CompactFields getCompactValue() {
        return this.mCompactValue;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return this.hasStringValue();
            }
            case 8: {
                return this.hasBinaryValue();
            }
            case 9: {
                return this.hasEnumValue();
            }
            case 10: {
                return this.hasCompactValue();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return this.hasStringValue() ? 1 : 0;
            }
            case 8: {
                return this.hasBinaryValue() ? 1 : 0;
            }
            case 9: {
                return this.hasEnumValue() ? 1 : 0;
            }
            case 10: {
                return this.hasCompactValue() ? 1 : 0;
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.isBooleanValue();
            }
            case 2: {
                return this.getByteValue();
            }
            case 3: {
                return this.getShortValue();
            }
            case 4: {
                return this.getIntegerValue();
            }
            case 5: {
                return this.getLongValue();
            }
            case 6: {
                return this.getDoubleValue();
            }
            case 7: {
                return this.getStringValue();
            }
            case 8: {
                return this.getBinaryValue();
            }
            case 9: {
                return this.getEnumValue();
            }
            case 10: {
                return this.getCompactValue();
            }
        }
        return null;
    }

    @JsonIgnore
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RequiredFields)) {
            return false;
        }
        RequiredFields other = (RequiredFields)o;
        return Objects.equals(this.mBooleanValue, other.mBooleanValue) && Objects.equals(this.mByteValue, other.mByteValue) && Objects.equals(this.mShortValue, other.mShortValue) && Objects.equals(this.mIntegerValue, other.mIntegerValue) && Objects.equals(this.mLongValue, other.mLongValue) && Objects.equals(this.mDoubleValue, other.mDoubleValue) && Objects.equals(this.mStringValue, other.mStringValue) && Objects.equals(this.mBinaryValue, other.mBinaryValue) && Objects.equals((Object)this.mEnumValue, (Object)other.mEnumValue) && Objects.equals(this.mCompactValue, other.mCompactValue);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{RequiredFields.class, _Field.BOOLEAN_VALUE, this.mBooleanValue, _Field.BYTE_VALUE, this.mByteValue, _Field.SHORT_VALUE, this.mShortValue, _Field.INTEGER_VALUE, this.mIntegerValue, _Field.LONG_VALUE, this.mLongValue, _Field.DOUBLE_VALUE, this.mDoubleValue, _Field.STRING_VALUE, this.mStringValue, _Field.BINARY_VALUE, this.mBinaryValue, _Field.ENUM_VALUE, this.mEnumValue, _Field.COMPACT_VALUE, this.mCompactValue});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "test.RequiredFields" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasBooleanValue()) {
            first = false;
            out.append("booleanValue:");
            out.append(this.mBooleanValue ? "true" : "false");
        }
        if (this.hasByteValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("byteValue:");
            out.append(Byte.toString(this.mByteValue));
        }
        if (this.hasShortValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("shortValue:");
            out.append(Short.toString(this.mShortValue));
        }
        if (this.hasIntegerValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("integerValue:");
            out.append(Integer.toString(this.mIntegerValue));
        }
        if (this.hasLongValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("longValue:");
            out.append(Long.toString(this.mLongValue));
        }
        if (this.hasDoubleValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("doubleValue:");
            out.append(PTypeUtils.toString((double)this.mDoubleValue));
        }
        if (this.hasStringValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("stringValue:");
            out.append('\"').append(this.mStringValue).append('\"');
        }
        if (this.hasBinaryValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("binaryValue:");
            out.append("hex(").append(this.mBinaryValue.toHexString()).append(')');
        }
        if (this.hasEnumValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("enumValue:");
            out.append(this.mEnumValue.getName());
        }
        if (this.hasCompactValue()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("compactValue:");
            out.append(this.mCompactValue.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(RequiredFields other) {
        int c = Boolean.compare(this.mBooleanValue, other.mBooleanValue);
        if (c != 0) {
            return c;
        }
        c = Byte.compare(this.mByteValue, other.mByteValue);
        if (c != 0) {
            return c;
        }
        c = Short.compare(this.mShortValue, other.mShortValue);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.mIntegerValue, other.mIntegerValue);
        if (c != 0) {
            return c;
        }
        c = Long.compare(this.mLongValue, other.mLongValue);
        if (c != 0) {
            return c;
        }
        c = Double.compare(this.mDoubleValue, other.mDoubleValue);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mStringValue != null, other.mStringValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mStringValue != null && (c = this.mStringValue.compareTo(other.mStringValue)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mBinaryValue != null, other.mBinaryValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mBinaryValue != null && (c = this.mBinaryValue.compareTo(other.mBinaryValue)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mEnumValue != null, other.mEnumValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mEnumValue != null && (c = Integer.compare(this.mEnumValue.getValue(), this.mEnumValue.getValue())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mCompactValue != null, other.mCompactValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mCompactValue != null && (c = this.mCompactValue.compareTo(other.mCompactValue)) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<RequiredFields, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<RequiredFields, _Field> descriptor() {
        return kDescriptor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeByte(this.mBooleanValue ? (byte)1 : 0);
        dest.writeInt(2);
        dest.writeByte(this.mByteValue);
        dest.writeInt(3);
        dest.writeInt((int)this.mShortValue);
        dest.writeInt(4);
        dest.writeInt(this.mIntegerValue);
        dest.writeInt(5);
        dest.writeLong(this.mLongValue);
        dest.writeInt(6);
        dest.writeDouble(this.mDoubleValue);
        if (this.hasStringValue()) {
            dest.writeInt(7);
            dest.writeString(this.mStringValue);
        }
        if (this.hasBinaryValue()) {
            dest.writeInt(8);
            dest.writeByteArray(this.mBinaryValue.get());
        }
        if (this.hasEnumValue()) {
            dest.writeInt(9);
            dest.writeInt(this.mEnumValue.getValue());
        }
        if (this.hasCompactValue()) {
            dest.writeInt(10);
            dest.writeTypedObject((Parcelable)this.mCompactValue, 0);
        }
        dest.writeInt(0);
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<RequiredFields> {
        private BitSet optionals = new BitSet(10);
        private boolean mBooleanValue = false;
        private byte mByteValue = 0;
        private short mShortValue = 0;
        private int mIntegerValue = 0;
        private long mLongValue = 0L;
        private double mDoubleValue = 0.0;
        private String mStringValue;
        private Binary mBinaryValue;
        private Value mEnumValue;
        private CompactFields mCompactValue;

        public _Builder() {
        }

        public _Builder(RequiredFields base) {
            this();
            this.optionals.set(0);
            this.mBooleanValue = base.mBooleanValue;
            this.optionals.set(1);
            this.mByteValue = base.mByteValue;
            this.optionals.set(2);
            this.mShortValue = base.mShortValue;
            this.optionals.set(3);
            this.mIntegerValue = base.mIntegerValue;
            this.optionals.set(4);
            this.mLongValue = base.mLongValue;
            this.optionals.set(5);
            this.mDoubleValue = base.mDoubleValue;
            if (base.hasStringValue()) {
                this.optionals.set(6);
                this.mStringValue = base.mStringValue;
            }
            if (base.hasBinaryValue()) {
                this.optionals.set(7);
                this.mBinaryValue = base.mBinaryValue;
            }
            if (base.hasEnumValue()) {
                this.optionals.set(8);
                this.mEnumValue = base.mEnumValue;
            }
            if (base.hasCompactValue()) {
                this.optionals.set(9);
                this.mCompactValue = base.mCompactValue;
            }
        }

        public _Builder setBooleanValue(boolean value) {
            this.optionals.set(0);
            this.mBooleanValue = value;
            return this;
        }

        public _Builder clearBooleanValue() {
            this.optionals.set(0, false);
            this.mBooleanValue = false;
            return this;
        }

        public _Builder setByteValue(byte value) {
            this.optionals.set(1);
            this.mByteValue = value;
            return this;
        }

        public _Builder clearByteValue() {
            this.optionals.set(1, false);
            this.mByteValue = 0;
            return this;
        }

        public _Builder setShortValue(short value) {
            this.optionals.set(2);
            this.mShortValue = value;
            return this;
        }

        public _Builder clearShortValue() {
            this.optionals.set(2, false);
            this.mShortValue = 0;
            return this;
        }

        public _Builder setIntegerValue(int value) {
            this.optionals.set(3);
            this.mIntegerValue = value;
            return this;
        }

        public _Builder clearIntegerValue() {
            this.optionals.set(3, false);
            this.mIntegerValue = 0;
            return this;
        }

        public _Builder setLongValue(long value) {
            this.optionals.set(4);
            this.mLongValue = value;
            return this;
        }

        public _Builder clearLongValue() {
            this.optionals.set(4, false);
            this.mLongValue = 0L;
            return this;
        }

        public _Builder setDoubleValue(double value) {
            this.optionals.set(5);
            this.mDoubleValue = value;
            return this;
        }

        public _Builder clearDoubleValue() {
            this.optionals.set(5, false);
            this.mDoubleValue = 0.0;
            return this;
        }

        public _Builder setStringValue(String value) {
            this.optionals.set(6);
            this.mStringValue = value;
            return this;
        }

        public _Builder clearStringValue() {
            this.optionals.set(6, false);
            this.mStringValue = null;
            return this;
        }

        public _Builder setBinaryValue(Binary value) {
            this.optionals.set(7);
            this.mBinaryValue = value;
            return this;
        }

        public _Builder clearBinaryValue() {
            this.optionals.set(7, false);
            this.mBinaryValue = null;
            return this;
        }

        public _Builder setEnumValue(Value value) {
            this.optionals.set(8);
            this.mEnumValue = value;
            return this;
        }

        public _Builder clearEnumValue() {
            this.optionals.set(8, false);
            this.mEnumValue = null;
            return this;
        }

        public _Builder setCompactValue(CompactFields value) {
            this.optionals.set(9);
            this.mCompactValue = value;
            return this;
        }

        public _Builder clearCompactValue() {
            this.optionals.set(9, false);
            this.mCompactValue = null;
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setBooleanValue((Boolean)value);
                    break;
                }
                case 2: {
                    this.setByteValue((Byte)value);
                    break;
                }
                case 3: {
                    this.setShortValue((Short)value);
                    break;
                }
                case 4: {
                    this.setIntegerValue((Integer)value);
                    break;
                }
                case 5: {
                    this.setLongValue((Long)value);
                    break;
                }
                case 6: {
                    this.setDoubleValue((Double)value);
                    break;
                }
                case 7: {
                    this.setStringValue((String)value);
                    break;
                }
                case 8: {
                    this.setBinaryValue((Binary)value);
                    break;
                }
                case 9: {
                    this.setEnumValue((Value)((Object)value));
                    break;
                }
                case 10: {
                    this.setCompactValue((CompactFields)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearBooleanValue();
                    break;
                }
                case 2: {
                    this.clearByteValue();
                    break;
                }
                case 3: {
                    this.clearShortValue();
                    break;
                }
                case 4: {
                    this.clearIntegerValue();
                    break;
                }
                case 5: {
                    this.clearLongValue();
                    break;
                }
                case 6: {
                    this.clearDoubleValue();
                    break;
                }
                case 7: {
                    this.clearStringValue();
                    break;
                }
                case 8: {
                    this.clearBinaryValue();
                    break;
                }
                case 9: {
                    this.clearEnumValue();
                    break;
                }
                case 10: {
                    this.clearCompactValue();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(0) && this.optionals.get(1) && this.optionals.get(2) && this.optionals.get(3) && this.optionals.get(4) && this.optionals.get(5) && this.optionals.get(6) && this.optionals.get(7) && this.optionals.get(8) && this.optionals.get(9);
        }

        public RequiredFields build() {
            return new RequiredFields(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<RequiredFields> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<RequiredFields, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<RequiredFields, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<RequiredFields, _Field> {
        public _Descriptor() {
            super(null, "test", "RequiredFields", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        BOOLEAN_VALUE(1, PRequirement.REQUIRED, "booleanValue", (PDescriptorProvider<?>)PPrimitive.BOOL.provider(), null),
        BYTE_VALUE(2, PRequirement.REQUIRED, "byteValue", (PDescriptorProvider<?>)PPrimitive.BYTE.provider(), null),
        SHORT_VALUE(3, PRequirement.REQUIRED, "shortValue", (PDescriptorProvider<?>)PPrimitive.I16.provider(), null),
        INTEGER_VALUE(4, PRequirement.REQUIRED, "integerValue", (PDescriptorProvider<?>)PPrimitive.I32.provider(), null),
        LONG_VALUE(5, PRequirement.REQUIRED, "longValue", (PDescriptorProvider<?>)PPrimitive.I64.provider(), null),
        DOUBLE_VALUE(6, PRequirement.REQUIRED, "doubleValue", (PDescriptorProvider<?>)PPrimitive.DOUBLE.provider(), null),
        STRING_VALUE(7, PRequirement.REQUIRED, "stringValue", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        BINARY_VALUE(8, PRequirement.REQUIRED, "binaryValue", (PDescriptorProvider<?>)PPrimitive.BINARY.provider(), null),
        ENUM_VALUE(9, PRequirement.REQUIRED, "enumValue", (PDescriptorProvider<?>)Value.provider(), null),
        COMPACT_VALUE(10, PRequirement.REQUIRED, "compactValue", (PDescriptorProvider<?>)CompactFields.provider(), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RequiredFields._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return BOOLEAN_VALUE;
                }
                case 2: {
                    return BYTE_VALUE;
                }
                case 3: {
                    return SHORT_VALUE;
                }
                case 4: {
                    return INTEGER_VALUE;
                }
                case 5: {
                    return LONG_VALUE;
                }
                case 6: {
                    return DOUBLE_VALUE;
                }
                case 7: {
                    return STRING_VALUE;
                }
                case 8: {
                    return BINARY_VALUE;
                }
                case 9: {
                    return ENUM_VALUE;
                }
                case 10: {
                    return COMPACT_VALUE;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "booleanValue": {
                    return BOOLEAN_VALUE;
                }
                case "byteValue": {
                    return BYTE_VALUE;
                }
                case "shortValue": {
                    return SHORT_VALUE;
                }
                case "integerValue": {
                    return INTEGER_VALUE;
                }
                case "longValue": {
                    return LONG_VALUE;
                }
                case "doubleValue": {
                    return DOUBLE_VALUE;
                }
                case "stringValue": {
                    return STRING_VALUE;
                }
                case "binaryValue": {
                    return BINARY_VALUE;
                }
                case "enumValue": {
                    return ENUM_VALUE;
                }
                case "compactValue": {
                    return COMPACT_VALUE;
                }
            }
            return null;
        }
    }
}

