/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.test.providence;

import android.os.Parcel;
import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class CompactFields
implements PMessage<CompactFields>,
Serializable,
Comparable<CompactFields>,
Parcelable {
    private static final long serialVersionUID = 4165755115179900852L;
    private static final int kDefaultId = 0;
    private final String mName;
    private final int mId;
    private final String mLabel;
    private volatile int tHashCode;
    public static final PStructDescriptor<CompactFields, _Field> kDescriptor = new _Descriptor();
    public static final Parcelable.Creator<CompactFields> CREATOR = new Parcelable.Creator<CompactFields>(){

        public CompactFields createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            block6: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: {
                        break block6;
                    }
                    case 1: {
                        builder.setName(source.readString());
                        break;
                    }
                    case 2: {
                        builder.setId(source.readInt());
                        break;
                    }
                    case 3: {
                        builder.setLabel(source.readString());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field ID: " + field);
                    }
                }
            }
            return builder.build();
        }

        public CompactFields[] newArray(int size) {
            return new CompactFields[size];
        }
    };

    private CompactFields(_Builder builder) {
        this.mName = builder.mName;
        this.mId = builder.mId;
        this.mLabel = builder.mLabel;
    }

    @JsonCreator
    public CompactFields(@JsonProperty(value="name") String pName, @JsonProperty(value="id") int pId, @JsonProperty(value="label") String pLabel) {
        this.mName = pName;
        this.mId = pId;
        this.mLabel = pLabel;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.mName;
    }

    public boolean hasId() {
        return true;
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.mId;
    }

    public boolean hasLabel() {
        return this.mLabel != null;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.mLabel;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasName();
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.hasLabel();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasName() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.hasLabel() ? 1 : 0;
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getId();
            }
            case 3: {
                return this.getLabel();
            }
        }
        return null;
    }

    @JsonIgnore
    public boolean isCompact() {
        boolean missing = false;
        if (this.hasName()) {
            if (missing) {
                return false;
            }
        } else {
            missing = true;
        }
        if (missing) {
            return false;
        }
        if (this.hasLabel()) {
            if (missing) {
                return false;
            }
        } else {
            missing = true;
        }
        return true;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompactFields)) {
            return false;
        }
        CompactFields other = (CompactFields)o;
        return Objects.equals(this.mName, other.mName) && Objects.equals(this.mId, other.mId) && Objects.equals(this.mLabel, other.mLabel);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{CompactFields.class, _Field.NAME, this.mName, _Field.ID, this.mId, _Field.LABEL, this.mLabel});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "test.CompactFields" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasName()) {
            first = false;
            out.append("name:");
            out.append('\"').append(this.mName).append('\"');
        }
        if (this.hasId()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("id:");
            out.append(Integer.toString(this.mId));
        }
        if (this.hasLabel()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("label:");
            out.append('\"').append(this.mLabel).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(CompactFields other) {
        int c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Integer.compare(this.mId, other.mId);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mLabel != null, other.mLabel != null);
        if (c != 0) {
            return c;
        }
        if (this.mLabel != null && (c = this.mLabel.compareTo(other.mLabel)) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<CompactFields, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<CompactFields, _Field> descriptor() {
        return kDescriptor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.hasName()) {
            dest.writeInt(1);
            dest.writeString(this.mName);
        }
        dest.writeInt(2);
        dest.writeInt(this.mId);
        if (this.hasLabel()) {
            dest.writeInt(3);
            dest.writeString(this.mLabel);
        }
        dest.writeInt(0);
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<CompactFields> {
        private BitSet optionals = new BitSet(3);
        private String mName;
        private int mId = 0;
        private String mLabel;

        public _Builder() {
        }

        public _Builder(CompactFields base) {
            this();
            if (base.hasName()) {
                this.optionals.set(0);
                this.mName = base.mName;
            }
            this.optionals.set(1);
            this.mId = base.mId;
            if (base.hasLabel()) {
                this.optionals.set(2);
                this.mLabel = base.mLabel;
            }
        }

        public _Builder setName(String value) {
            this.optionals.set(0);
            this.mName = value;
            return this;
        }

        public _Builder clearName() {
            this.optionals.set(0, false);
            this.mName = null;
            return this;
        }

        public _Builder setId(int value) {
            this.optionals.set(1);
            this.mId = value;
            return this;
        }

        public _Builder clearId() {
            this.optionals.set(1, false);
            this.mId = 0;
            return this;
        }

        public _Builder setLabel(String value) {
            this.optionals.set(2);
            this.mLabel = value;
            return this;
        }

        public _Builder clearLabel() {
            this.optionals.set(2, false);
            this.mLabel = null;
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setName((String)value);
                    break;
                }
                case 2: {
                    this.setId((Integer)value);
                    break;
                }
                case 3: {
                    this.setLabel((String)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearName();
                    break;
                }
                case 2: {
                    this.clearId();
                    break;
                }
                case 3: {
                    this.clearLabel();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(0) && this.optionals.get(1);
        }

        public CompactFields build() {
            return new CompactFields(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<CompactFields> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<CompactFields, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<CompactFields, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<CompactFields, _Field> {
        public _Descriptor() {
            super(null, "test", "CompactFields", (PMessageBuilderFactory)new _Factory(), true, true);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        NAME(1, PRequirement.REQUIRED, "name", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        ID(2, PRequirement.REQUIRED, "id", (PDescriptorProvider<?>)PPrimitive.I32.provider(), null),
        LABEL(3, PRequirement.DEFAULT, "label", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CompactFields._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return ID;
                }
                case 3: {
                    return LABEL;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "name": {
                    return NAME;
                }
                case "id": {
                    return ID;
                }
                case "label": {
                    return LABEL;
                }
            }
            return null;
        }
    }
}

