/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.test.calculator;

import android.os.Parcel;
import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;
import net.morimekta.test.calculator.Operand;
import net.morimekta.test.calculator.Operator;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Operation
implements PMessage<Operation>,
Serializable,
Comparable<Operation>,
Parcelable {
    private static final long serialVersionUID = -2122462501055525645L;
    private final Operator mOperator;
    private final List<Operand> mOperands;
    private volatile int tHashCode;
    public static final PStructDescriptor<Operation, _Field> kDescriptor = new _Descriptor();
    public static final Parcelable.Creator<Operation> CREATOR = new Parcelable.Creator<Operation>(){

        public Operation createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            block5: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: {
                        break block5;
                    }
                    case 1: {
                        builder.setOperator(Operator.forValue(source.readInt()));
                        break;
                    }
                    case 2: {
                        builder.setOperands(source.createTypedArrayList(Operand.CREATOR));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field ID: " + field);
                    }
                }
            }
            return builder.build();
        }

        public Operation[] newArray(int size) {
            return new Operation[size];
        }
    };

    private Operation(_Builder builder) {
        this.mOperator = builder.mOperator;
        this.mOperands = Collections.unmodifiableList(new LinkedList(builder.mOperands));
    }

    @JsonCreator
    public Operation(@JsonProperty(value="operator") Operator pOperator, @JsonProperty(value="operands") List<Operand> pOperands) {
        this.mOperator = pOperator;
        this.mOperands = Collections.unmodifiableList(new LinkedList<Operand>(pOperands));
    }

    public boolean hasOperator() {
        return this.mOperator != null;
    }

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.mOperator;
    }

    public int numOperands() {
        return this.mOperands != null ? this.mOperands.size() : 0;
    }

    @JsonProperty(value="operands")
    public List<Operand> getOperands() {
        return this.mOperands;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasOperator();
            }
            case 2: {
                return this.numOperands() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasOperator() ? 1 : 0;
            }
            case 2: {
                return this.numOperands();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getOperator();
            }
            case 2: {
                return this.getOperands();
            }
        }
        return null;
    }

    @JsonIgnore
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        return Objects.equals((Object)this.mOperator, (Object)other.mOperator) && PTypeUtils.equals(this.mOperands, other.mOperands);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Operation.class, _Field.OPERATOR, this.mOperator, _Field.OPERANDS, PTypeUtils.hashCode(this.mOperands)});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "calculator.Operation" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasOperator()) {
            first = false;
            out.append("operator:");
            out.append(this.mOperator.getName());
        }
        if (this.numOperands() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("operands:");
            out.append(PTypeUtils.toString(this.mOperands));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Operation other) {
        int c = Boolean.compare(this.mOperator != null, other.mOperator != null);
        if (c != 0) {
            return c;
        }
        if (this.mOperator != null && (c = Integer.compare(this.mOperator.getValue(), this.mOperator.getValue())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mOperands != null, other.mOperands != null);
        if (c != 0) {
            return c;
        }
        if (this.mOperands != null && (c = Integer.compare(this.mOperands.hashCode(), other.mOperands.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<Operation, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<Operation, _Field> descriptor() {
        return kDescriptor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.hasOperator()) {
            dest.writeInt(1);
            dest.writeInt(this.mOperator.getValue());
        }
        if (this.numOperands() > 0) {
            dest.writeInt(2);
            dest.writeTypedList(this.mOperands);
        }
        dest.writeInt(0);
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Operation> {
        private BitSet optionals = new BitSet(2);
        private Operator mOperator;
        private List<Operand> mOperands = new LinkedList<Operand>();

        public _Builder() {
        }

        public _Builder(Operation base) {
            this();
            if (base.hasOperator()) {
                this.optionals.set(0);
                this.mOperator = base.mOperator;
            }
            if (base.numOperands() > 0) {
                this.optionals.set(1);
                this.mOperands.addAll(base.mOperands);
            }
        }

        public _Builder setOperator(Operator value) {
            this.optionals.set(0);
            this.mOperator = value;
            return this;
        }

        public _Builder clearOperator() {
            this.optionals.set(0, false);
            this.mOperator = null;
            return this;
        }

        public _Builder setOperands(Collection<Operand> value) {
            this.optionals.set(1);
            this.mOperands.clear();
            this.mOperands.addAll(value);
            return this;
        }

        public _Builder addToOperands(Operand ... values) {
            this.optionals.set(1);
            for (Operand item : values) {
                this.mOperands.add(item);
            }
            return this;
        }

        public _Builder clearOperands() {
            this.optionals.set(1, false);
            this.mOperands.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setOperator((Operator)((Object)value));
                    break;
                }
                case 2: {
                    this.setOperands((List)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 2: {
                    this.addToOperands((Operand)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearOperator();
                    break;
                }
                case 2: {
                    this.clearOperands();
                }
            }
            return this;
        }

        public boolean isValid() {
            return true;
        }

        public Operation build() {
            return new Operation(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<Operation> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Operation, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<Operation, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<Operation, _Field> {
        public _Descriptor() {
            super(null, "calculator", "Operation", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        OPERATOR(1, PRequirement.DEFAULT, "operator", (PDescriptorProvider<?>)Operator.provider(), null),
        OPERANDS(2, PRequirement.DEFAULT, "operands", (PDescriptorProvider<?>)PList.provider(Operand.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Operation._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return OPERATOR;
                }
                case 2: {
                    return OPERANDS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "operator": {
                    return OPERATOR;
                }
                case "operands": {
                    return OPERANDS;
                }
            }
            return null;
        }
    }
}

