/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.test.calculator;

import android.os.Parcel;
import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;
import net.morimekta.test.calculator.Operation;
import net.morimekta.test.number.Imaginary;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Operand
implements PUnion<Operand>,
Serializable,
Comparable<Operand>,
Parcelable {
    private static final long serialVersionUID = -7034870678901672325L;
    private static final double kDefaultNumber = 0.0;
    private final Operation mOperation;
    private final double mNumber;
    private final Imaginary mImaginary;
    private final _Field tUnionField;
    private volatile int tHashCode;
    public static final PUnionDescriptor<Operand, _Field> kDescriptor = new _Descriptor();
    public static final Parcelable.Creator<Operand> CREATOR = new Parcelable.Creator<Operand>(){

        public Operand createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            block6: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: {
                        break block6;
                    }
                    case 1: {
                        builder.setOperation((Operation)source.readTypedObject(Operation.CREATOR));
                        break;
                    }
                    case 2: {
                        builder.setNumber(source.readDouble());
                        break;
                    }
                    case 3: {
                        builder.setImaginary((Imaginary)source.readTypedObject(Imaginary.CREATOR));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown field ID: " + field);
                    }
                }
            }
            return builder.build();
        }

        public Operand[] newArray(int size) {
            return new Operand[size];
        }
    };

    private Operand(_Builder builder) {
        this.tUnionField = builder.tUnionField;
        this.mOperation = this.tUnionField == _Field.OPERATION ? builder.mOperation : null;
        this.mNumber = this.tUnionField == _Field.NUMBER ? builder.mNumber : 0.0;
        this.mImaginary = this.tUnionField == _Field.IMAGINARY ? builder.mImaginary : null;
    }

    public static Operand withOperation(Operation value) {
        return new _Builder().setOperation(value).build();
    }

    public static Operand withNumber(double value) {
        return new _Builder().setNumber(value).build();
    }

    public static Operand withImaginary(Imaginary value) {
        return new _Builder().setImaginary(value).build();
    }

    public boolean hasOperation() {
        return this.tUnionField == _Field.OPERATION && this.mOperation != null;
    }

    @JsonProperty(value="operation")
    public Operation getOperation() {
        return this.mOperation;
    }

    public boolean hasNumber() {
        return this.tUnionField == _Field.NUMBER;
    }

    @JsonProperty(value="number")
    public double getNumber() {
        return this.mNumber;
    }

    public boolean hasImaginary() {
        return this.tUnionField == _Field.IMAGINARY && this.mImaginary != null;
    }

    @JsonProperty(value="imaginary")
    public Imaginary getImaginary() {
        return this.mImaginary;
    }

    public _Field unionField() {
        return this.tUnionField;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasOperation();
            }
            case 2: {
                return this.hasNumber();
            }
            case 3: {
                return this.hasImaginary();
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasOperation() ? 1 : 0;
            }
            case 2: {
                return this.hasNumber() ? 1 : 0;
            }
            case 3: {
                return this.hasImaginary() ? 1 : 0;
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getOperation();
            }
            case 2: {
                return this.getNumber();
            }
            case 3: {
                return this.getImaginary();
            }
        }
        return null;
    }

    @JsonIgnore
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Operand)) {
            return false;
        }
        Operand other = (Operand)o;
        return Objects.equals((Object)this.tUnionField, (Object)other.tUnionField) && Objects.equals(this.mOperation, other.mOperation) && Objects.equals(this.mNumber, other.mNumber) && Objects.equals(this.mImaginary, other.mImaginary);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Operand.class, _Field.OPERATION, this.mOperation, _Field.NUMBER, this.mNumber, _Field.IMAGINARY, this.mImaginary});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "calculator.Operand" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        switch (this.tUnionField) {
            case OPERATION: {
                out.append("operation:");
                out.append(this.mOperation.asString());
                break;
            }
            case NUMBER: {
                out.append("number:");
                out.append(PTypeUtils.toString((double)this.mNumber));
                break;
            }
            case IMAGINARY: {
                out.append("imaginary:");
                out.append(this.mImaginary.asString());
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Operand other) {
        int c = Integer.compare(this.tUnionField.getKey(), other.tUnionField.getKey());
        if (c != 0) {
            return c;
        }
        switch (this.tUnionField) {
            case OPERATION: {
                return this.mOperation.compareTo(other.mOperation);
            }
            case NUMBER: {
                return Double.compare(this.mNumber, other.mNumber);
            }
            case IMAGINARY: {
                return this.mImaginary.compareTo(other.mImaginary);
            }
        }
        return 0;
    }

    public static PUnionDescriptorProvider<Operand, _Field> provider() {
        return new _Provider();
    }

    public PUnionDescriptor<Operand, _Field> descriptor() {
        return kDescriptor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.tUnionField != null) {
            switch (this.tUnionField) {
                case OPERATION: {
                    dest.writeInt(1);
                    dest.writeTypedObject((Parcelable)this.mOperation, 0);
                    break;
                }
                case NUMBER: {
                    dest.writeInt(2);
                    dest.writeDouble(this.mNumber);
                    break;
                }
                case IMAGINARY: {
                    dest.writeInt(3);
                    dest.writeTypedObject((Parcelable)this.mImaginary, 0);
                }
            }
        }
        dest.writeInt(0);
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Operand> {
        private _Field tUnionField;
        private Operation mOperation;
        private double mNumber = 0.0;
        private Imaginary mImaginary;

        public _Builder() {
        }

        public _Builder(Operand base) {
            this();
            this.tUnionField = base.tUnionField;
            this.mOperation = base.mOperation;
            this.mNumber = base.mNumber;
            this.mImaginary = base.mImaginary;
        }

        public _Builder setOperation(Operation value) {
            this.tUnionField = _Field.OPERATION;
            this.mOperation = value;
            return this;
        }

        public _Builder clearOperation() {
            if (this.tUnionField == _Field.OPERATION) {
                this.tUnionField = null;
            }
            this.mOperation = null;
            return this;
        }

        public _Builder setNumber(double value) {
            this.tUnionField = _Field.NUMBER;
            this.mNumber = value;
            return this;
        }

        public _Builder clearNumber() {
            if (this.tUnionField == _Field.NUMBER) {
                this.tUnionField = null;
            }
            this.mNumber = 0.0;
            return this;
        }

        public _Builder setImaginary(Imaginary value) {
            this.tUnionField = _Field.IMAGINARY;
            this.mImaginary = value;
            return this;
        }

        public _Builder clearImaginary() {
            if (this.tUnionField == _Field.IMAGINARY) {
                this.tUnionField = null;
            }
            this.mImaginary = null;
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setOperation((Operation)value);
                    break;
                }
                case 2: {
                    this.setNumber((Double)value);
                    break;
                }
                case 3: {
                    this.setImaginary((Imaginary)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearOperation();
                    break;
                }
                case 2: {
                    this.clearNumber();
                    break;
                }
                case 3: {
                    this.clearImaginary();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.tUnionField != null;
        }

        public Operand build() {
            return new Operand(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<Operand> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PUnionDescriptorProvider<Operand, _Field> {
        private _Provider() {
        }

        public PUnionDescriptor<Operand, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PUnionDescriptor<Operand, _Field> {
        public _Descriptor() {
            super(null, "calculator", "Operand", (PMessageBuilderFactory)new _Factory(), false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        OPERATION(1, PRequirement.DEFAULT, "operation", (PDescriptorProvider<?>)Operation.provider(), null),
        NUMBER(2, PRequirement.DEFAULT, "number", (PDescriptorProvider<?>)PPrimitive.DOUBLE.provider(), null),
        IMAGINARY(3, PRequirement.DEFAULT, "imaginary", (PDescriptorProvider<?>)Imaginary.provider(), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Operand._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return OPERATION;
                }
                case 2: {
                    return NUMBER;
                }
                case 3: {
                    return IMAGINARY;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "operation": {
                    return OPERATION;
                }
                case "number": {
                    return NUMBER;
                }
                case "imaginary": {
                    return IMAGINARY;
                }
            }
            return null;
        }
    }
}

