/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.util.PTypeUtils;

public class ServiceMethod
implements PMessage<ServiceMethod>,
Serializable,
Comparable<ServiceMethod> {
    private static final long serialVersionUID = -8952857258512990537L;
    private static final boolean kDefaultOneWay = false;
    private final String mComment;
    private final boolean mOneWay;
    private final String mReturnType;
    private final String mName;
    private final List<ThriftField> mParams;
    private final List<ThriftField> mExceptions;
    private volatile int tHashCode;
    public static final PStructDescriptor<ServiceMethod, _Field> kDescriptor = new _Descriptor();

    private ServiceMethod(_Builder builder) {
        this.mComment = builder.mComment;
        this.mOneWay = builder.mOneWay;
        this.mReturnType = builder.mReturnType;
        this.mName = builder.mName;
        this.mParams = Collections.unmodifiableList(new LinkedList(builder.mParams));
        this.mExceptions = Collections.unmodifiableList(new LinkedList(builder.mExceptions));
    }

    public ServiceMethod(String pComment, boolean pOneWay, String pReturnType, String pName, List<ThriftField> pParams, List<ThriftField> pExceptions) {
        this.mComment = pComment;
        this.mOneWay = pOneWay;
        this.mReturnType = pReturnType;
        this.mName = pName;
        this.mParams = Collections.unmodifiableList(new LinkedList<ThriftField>(pParams));
        this.mExceptions = Collections.unmodifiableList(new LinkedList<ThriftField>(pExceptions));
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasOneWay() {
        return true;
    }

    public boolean isOneWay() {
        return this.mOneWay;
    }

    public boolean hasReturnType() {
        return this.mReturnType != null;
    }

    public String getReturnType() {
        return this.mReturnType;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public int numParams() {
        return this.mParams != null ? this.mParams.size() : 0;
    }

    public List<ThriftField> getParams() {
        return this.mParams;
    }

    public int numExceptions() {
        return this.mExceptions != null ? this.mExceptions.size() : 0;
    }

    public List<ThriftField> getExceptions() {
        return this.mExceptions;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.hasReturnType();
            }
            case 4: {
                return this.hasName();
            }
            case 5: {
                return this.numParams() > 0;
            }
            case 6: {
                return this.numExceptions() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.hasReturnType() ? 1 : 0;
            }
            case 4: {
                return this.hasName() ? 1 : 0;
            }
            case 5: {
                return this.numParams();
            }
            case 6: {
                return this.numExceptions();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.isOneWay();
            }
            case 3: {
                return this.getReturnType();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getParams();
            }
            case 6: {
                return this.getExceptions();
            }
        }
        return null;
    }

    public boolean isCompact() {
        return false;
    }

    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ServiceMethod)) {
            return false;
        }
        ServiceMethod other = (ServiceMethod)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mOneWay, other.mOneWay) && Objects.equals(this.mReturnType, other.mReturnType) && Objects.equals(this.mName, other.mName) && PTypeUtils.equals(this.mParams, other.mParams) && PTypeUtils.equals(this.mExceptions, other.mExceptions);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ServiceMethod.class, _Field.COMMENT, this.mComment, _Field.ONE_WAY, this.mOneWay, _Field.RETURN_TYPE, this.mReturnType, _Field.NAME, this.mName, _Field.PARAMS, PTypeUtils.hashCode(this.mParams), _Field.EXCEPTIONS, PTypeUtils.hashCode(this.mExceptions)});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ServiceMethod" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasComment()) {
            first = false;
            out.append("comment:");
            out.append('\"').append(this.mComment).append('\"');
        }
        if (this.hasOneWay()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("one_way:");
            out.append(this.mOneWay ? "true" : "false");
        }
        if (this.hasReturnType()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("return_type:");
            out.append('\"').append(this.mReturnType).append('\"');
        }
        if (this.hasName()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("name:");
            out.append('\"').append(this.mName).append('\"');
        }
        if (this.numParams() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("params:");
            out.append(PTypeUtils.toString(this.mParams));
        }
        if (this.numExceptions() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("exceptions:");
            out.append(PTypeUtils.toString(this.mExceptions));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ServiceMethod other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mOneWay, other.mOneWay);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mReturnType != null, other.mReturnType != null);
        if (c != 0) {
            return c;
        }
        if (this.mReturnType != null && (c = this.mReturnType.compareTo(other.mReturnType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mParams != null, other.mParams != null);
        if (c != 0) {
            return c;
        }
        if (this.mParams != null && (c = Integer.compare(this.mParams.hashCode(), other.mParams.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mExceptions != null, other.mExceptions != null);
        if (c != 0) {
            return c;
        }
        if (this.mExceptions != null && (c = Integer.compare(this.mExceptions.hashCode(), other.mExceptions.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<ServiceMethod, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ServiceMethod, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ServiceMethod> {
        private BitSet optionals = new BitSet(6);
        private String mComment;
        private boolean mOneWay = false;
        private String mReturnType;
        private String mName;
        private List<ThriftField> mParams = new LinkedList<ThriftField>();
        private List<ThriftField> mExceptions = new LinkedList<ThriftField>();

        public _Builder() {
        }

        public _Builder(ServiceMethod base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            this.optionals.set(1);
            this.mOneWay = base.mOneWay;
            if (base.hasReturnType()) {
                this.optionals.set(2);
                this.mReturnType = base.mReturnType;
            }
            if (base.hasName()) {
                this.optionals.set(3);
                this.mName = base.mName;
            }
            if (base.numParams() > 0) {
                this.optionals.set(4);
                this.mParams.addAll(base.mParams);
            }
            if (base.numExceptions() > 0) {
                this.optionals.set(5);
                this.mExceptions.addAll(base.mExceptions);
            }
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public _Builder clearComment() {
            this.optionals.set(0, false);
            this.mComment = null;
            return this;
        }

        public _Builder setOneWay(boolean value) {
            this.optionals.set(1);
            this.mOneWay = value;
            return this;
        }

        public _Builder clearOneWay() {
            this.optionals.set(1, false);
            this.mOneWay = false;
            return this;
        }

        public _Builder setReturnType(String value) {
            this.optionals.set(2);
            this.mReturnType = value;
            return this;
        }

        public _Builder clearReturnType() {
            this.optionals.set(2, false);
            this.mReturnType = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(3);
            this.mName = value;
            return this;
        }

        public _Builder clearName() {
            this.optionals.set(3, false);
            this.mName = null;
            return this;
        }

        public _Builder setParams(Collection<ThriftField> value) {
            this.optionals.set(4);
            this.mParams.clear();
            this.mParams.addAll(value);
            return this;
        }

        public _Builder addToParams(ThriftField ... values) {
            this.optionals.set(4);
            for (ThriftField item : values) {
                this.mParams.add(item);
            }
            return this;
        }

        public _Builder clearParams() {
            this.optionals.set(4, false);
            this.mParams.clear();
            return this;
        }

        public _Builder setExceptions(Collection<ThriftField> value) {
            this.optionals.set(5);
            this.mExceptions.clear();
            this.mExceptions.addAll(value);
            return this;
        }

        public _Builder addToExceptions(ThriftField ... values) {
            this.optionals.set(5);
            for (ThriftField item : values) {
                this.mExceptions.add(item);
            }
            return this;
        }

        public _Builder clearExceptions() {
            this.optionals.set(5, false);
            this.mExceptions.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setOneWay((Boolean)value);
                    break;
                }
                case 3: {
                    this.setReturnType((String)value);
                    break;
                }
                case 4: {
                    this.setName((String)value);
                    break;
                }
                case 5: {
                    this.setParams((List)value);
                    break;
                }
                case 6: {
                    this.setExceptions((List)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 5: {
                    this.addToParams((ThriftField)value);
                    break;
                }
                case 6: {
                    this.addToExceptions((ThriftField)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearOneWay();
                    break;
                }
                case 3: {
                    this.clearReturnType();
                    break;
                }
                case 4: {
                    this.clearName();
                    break;
                }
                case 5: {
                    this.clearParams();
                    break;
                }
                case 6: {
                    this.clearExceptions();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(3);
        }

        public ServiceMethod build() {
            return new ServiceMethod(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ServiceMethod> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ServiceMethod, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ServiceMethod, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ServiceMethod, _Field> {
        public _Descriptor() {
            super(null, "model", "ServiceMethod", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        ONE_WAY(2, PRequirement.DEFAULT, "one_way", (PDescriptorProvider<?>)PPrimitive.BOOL.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)false)),
        RETURN_TYPE(3, PRequirement.DEFAULT, "return_type", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        NAME(4, PRequirement.REQUIRED, "name", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        PARAMS(5, PRequirement.DEFAULT, "params", (PDescriptorProvider<?>)PList.provider(ThriftField.provider()), null),
        EXCEPTIONS(6, PRequirement.DEFAULT, "exceptions", (PDescriptorProvider<?>)PList.provider(ThriftField.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServiceMethod._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return ONE_WAY;
                }
                case 3: {
                    return RETURN_TYPE;
                }
                case 4: {
                    return NAME;
                }
                case 5: {
                    return PARAMS;
                }
                case 6: {
                    return EXCEPTIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "one_way": {
                    return ONE_WAY;
                }
                case "return_type": {
                    return RETURN_TYPE;
                }
                case "name": {
                    return NAME;
                }
                case "params": {
                    return PARAMS;
                }
                case "exceptions": {
                    return EXCEPTIONS;
                }
            }
            return null;
        }
    }
}

