package net.morimekta.test.providence;

import java.io.Serializable;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.jackson.BinaryJsonDeserializer;
import net.morimekta.providence.jackson.BinaryJsonSerializer;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import net.morimekta.util.Binary;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class UnionFields
        implements PUnion<UnionFields>, Serializable, Comparable<UnionFields>, Parcelable {
    private final static long serialVersionUID = 5567571546617352666L;

    private final static boolean kDefaultBooleanValue = false;
    private final static byte kDefaultByteValue = (byte)0;
    private final static short kDefaultShortValue = (short)0;
    private final static int kDefaultIntegerValue = 0;
    private final static long kDefaultLongValue = 0L;
    private final static double kDefaultDoubleValue = 0.0d;

    private final boolean mBooleanValue;
    private final byte mByteValue;
    private final short mShortValue;
    private final int mIntegerValue;
    private final long mLongValue;
    private final double mDoubleValue;
    private final String mStringValue;
    private final Binary mBinaryValue;
    private final Value mEnumValue;
    private final CompactFields mCompactValue;

    private final _Field tUnionField;
    
    private volatile int tHashCode;

    private UnionFields(_Builder builder) {
        tUnionField = builder.tUnionField;

        mBooleanValue = tUnionField == _Field.BOOLEAN_VALUE ? builder.mBooleanValue : kDefaultBooleanValue;
        mByteValue = tUnionField == _Field.BYTE_VALUE ? builder.mByteValue : kDefaultByteValue;
        mShortValue = tUnionField == _Field.SHORT_VALUE ? builder.mShortValue : kDefaultShortValue;
        mIntegerValue = tUnionField == _Field.INTEGER_VALUE ? builder.mIntegerValue : kDefaultIntegerValue;
        mLongValue = tUnionField == _Field.LONG_VALUE ? builder.mLongValue : kDefaultLongValue;
        mDoubleValue = tUnionField == _Field.DOUBLE_VALUE ? builder.mDoubleValue : kDefaultDoubleValue;
        mStringValue = tUnionField == _Field.STRING_VALUE ? builder.mStringValue : null;
        mBinaryValue = tUnionField == _Field.BINARY_VALUE ? builder.mBinaryValue : null;
        mEnumValue = tUnionField == _Field.ENUM_VALUE ? builder.mEnumValue : null;
        mCompactValue = tUnionField == _Field.COMPACT_VALUE ? builder.mCompactValue : null;
    }

    public static UnionFields withBooleanValue(boolean value) {
        return new _Builder().setBooleanValue(value).build();
    }

    public static UnionFields withByteValue(byte value) {
        return new _Builder().setByteValue(value).build();
    }

    public static UnionFields withShortValue(short value) {
        return new _Builder().setShortValue(value).build();
    }

    public static UnionFields withIntegerValue(int value) {
        return new _Builder().setIntegerValue(value).build();
    }

    public static UnionFields withLongValue(long value) {
        return new _Builder().setLongValue(value).build();
    }

    public static UnionFields withDoubleValue(double value) {
        return new _Builder().setDoubleValue(value).build();
    }

    public static UnionFields withStringValue(String value) {
        return new _Builder().setStringValue(value).build();
    }

    public static UnionFields withBinaryValue(Binary value) {
        return new _Builder().setBinaryValue(value).build();
    }

    public static UnionFields withEnumValue(Value value) {
        return new _Builder().setEnumValue(value).build();
    }

    public static UnionFields withCompactValue(CompactFields value) {
        return new _Builder().setCompactValue(value).build();
    }

    public boolean hasBooleanValue() {
        return tUnionField == _Field.BOOLEAN_VALUE;
    }

    @JsonProperty("booleanValue")
    public boolean isBooleanValue() {
        return mBooleanValue;
    }

    public boolean hasByteValue() {
        return tUnionField == _Field.BYTE_VALUE;
    }

    @JsonProperty("byteValue")
    public byte getByteValue() {
        return mByteValue;
    }

    public boolean hasShortValue() {
        return tUnionField == _Field.SHORT_VALUE;
    }

    @JsonProperty("shortValue")
    public short getShortValue() {
        return mShortValue;
    }

    public boolean hasIntegerValue() {
        return tUnionField == _Field.INTEGER_VALUE;
    }

    @JsonProperty("integerValue")
    public int getIntegerValue() {
        return mIntegerValue;
    }

    public boolean hasLongValue() {
        return tUnionField == _Field.LONG_VALUE;
    }

    @JsonProperty("longValue")
    public long getLongValue() {
        return mLongValue;
    }

    public boolean hasDoubleValue() {
        return tUnionField == _Field.DOUBLE_VALUE;
    }

    @JsonProperty("doubleValue")
    public double getDoubleValue() {
        return mDoubleValue;
    }

    public boolean hasStringValue() {
        return tUnionField == _Field.STRING_VALUE && mStringValue != null;
    }

    @JsonProperty("stringValue")
    public String getStringValue() {
        return mStringValue;
    }

    public boolean hasBinaryValue() {
        return tUnionField == _Field.BINARY_VALUE && mBinaryValue != null;
    }

    @JsonProperty("binaryValue")
    @JsonSerialize(using = BinaryJsonSerializer.class) 
    public Binary getBinaryValue() {
        return mBinaryValue;
    }

    public boolean hasEnumValue() {
        return tUnionField == _Field.ENUM_VALUE && mEnumValue != null;
    }

    @JsonProperty("enumValue")
    public Value getEnumValue() {
        return mEnumValue;
    }

    public boolean hasCompactValue() {
        return tUnionField == _Field.COMPACT_VALUE && mCompactValue != null;
    }

    @JsonProperty("compactValue")
    public CompactFields getCompactValue() {
        return mCompactValue;
    }

    @Override
    public _Field unionField() {
        return tUnionField;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasBooleanValue();
            case 2: return hasByteValue();
            case 3: return hasShortValue();
            case 4: return hasIntegerValue();
            case 5: return hasLongValue();
            case 6: return hasDoubleValue();
            case 7: return hasStringValue();
            case 8: return hasBinaryValue();
            case 9: return hasEnumValue();
            case 10: return hasCompactValue();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasBooleanValue() ? 1 : 0;
            case 2: return hasByteValue() ? 1 : 0;
            case 3: return hasShortValue() ? 1 : 0;
            case 4: return hasIntegerValue() ? 1 : 0;
            case 5: return hasLongValue() ? 1 : 0;
            case 6: return hasDoubleValue() ? 1 : 0;
            case 7: return hasStringValue() ? 1 : 0;
            case 8: return hasBinaryValue() ? 1 : 0;
            case 9: return hasEnumValue() ? 1 : 0;
            case 10: return hasCompactValue() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return isBooleanValue();
            case 2: return getByteValue();
            case 3: return getShortValue();
            case 4: return getIntegerValue();
            case 5: return getLongValue();
            case 6: return getDoubleValue();
            case 7: return getStringValue();
            case 8: return getBinaryValue();
            case 9: return getEnumValue();
            case 10: return getCompactValue();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof UnionFields)) return false;
        UnionFields other = (UnionFields) o;
        return Objects.equals(tUnionField, other.tUnionField) &&
               Objects.equals(mBooleanValue, other.mBooleanValue) &&
               Objects.equals(mByteValue, other.mByteValue) &&
               Objects.equals(mShortValue, other.mShortValue) &&
               Objects.equals(mIntegerValue, other.mIntegerValue) &&
               Objects.equals(mLongValue, other.mLongValue) &&
               Objects.equals(mDoubleValue, other.mDoubleValue) &&
               Objects.equals(mStringValue, other.mStringValue) &&
               Objects.equals(mBinaryValue, other.mBinaryValue) &&
               Objects.equals(mEnumValue, other.mEnumValue) &&
               Objects.equals(mCompactValue, other.mCompactValue);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    UnionFields.class,
                    _Field.BOOLEAN_VALUE, mBooleanValue,
                    _Field.BYTE_VALUE, mByteValue,
                    _Field.SHORT_VALUE, mShortValue,
                    _Field.INTEGER_VALUE, mIntegerValue,
                    _Field.LONG_VALUE, mLongValue,
                    _Field.DOUBLE_VALUE, mDoubleValue,
                    _Field.STRING_VALUE, mStringValue,
                    _Field.BINARY_VALUE, mBinaryValue,
                    _Field.ENUM_VALUE, mEnumValue,
                    _Field.COMPACT_VALUE, mCompactValue);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "test.UnionFields" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        switch (tUnionField) {
            case BOOLEAN_VALUE: {
                out.append("booleanValue:");
                out.append(mBooleanValue);
                break;
            }
            case BYTE_VALUE: {
                out.append("byteValue:");
                out.append(mByteValue);
                break;
            }
            case SHORT_VALUE: {
                out.append("shortValue:");
                out.append(mShortValue);
                break;
            }
            case INTEGER_VALUE: {
                out.append("integerValue:");
                out.append(mIntegerValue);
                break;
            }
            case LONG_VALUE: {
                out.append("longValue:");
                out.append(mLongValue);
                break;
            }
            case DOUBLE_VALUE: {
                out.append("doubleValue:");
                out.append(PTypeUtils.toString(mDoubleValue));
                break;
            }
            case STRING_VALUE: {
                out.append("stringValue:");
                out.append('\"').append(mStringValue).append('\"');
                break;
            }
            case BINARY_VALUE: {
                out.append("binaryValue:");
                out.append("b64(").append(mBinaryValue.toBase64()).append(')');
                break;
            }
            case ENUM_VALUE: {
                out.append("enumValue:");
                out.append(mEnumValue.getName());
                break;
            }
            case COMPACT_VALUE: {
                out.append("compactValue:");
                out.append(mCompactValue.asString());
                break;
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(UnionFields other) {
        int c = Integer.compare(tUnionField.getKey(), other.tUnionField.getKey());
        if (c != 0) return c;

        switch (tUnionField) {
            case BOOLEAN_VALUE:
                return Boolean.compare(mBooleanValue, other.mBooleanValue);
            case BYTE_VALUE:
                return Byte.compare(mByteValue, other.mByteValue);
            case SHORT_VALUE:
                return Short.compare(mShortValue, other.mShortValue);
            case INTEGER_VALUE:
                return Integer.compare(mIntegerValue, other.mIntegerValue);
            case LONG_VALUE:
                return Long.compare(mLongValue, other.mLongValue);
            case DOUBLE_VALUE:
                return Double.compare(mDoubleValue, other.mDoubleValue);
            case STRING_VALUE:
                return mStringValue.compareTo(other.mStringValue);
            case BINARY_VALUE:
                return mBinaryValue.compareTo(other.mBinaryValue);
            case ENUM_VALUE:
                return Integer.compare(mEnumValue.getValue(), other.mEnumValue.getValue());
            case COMPACT_VALUE:
                return mCompactValue.compareTo(other.mCompactValue);
            default: return 0;
        }
    }

    public enum _Field implements PField {
        BOOLEAN_VALUE(1, PRequirement.DEFAULT, "booleanValue", PPrimitive.BOOL.provider(), null),
        BYTE_VALUE(2, PRequirement.DEFAULT, "byteValue", PPrimitive.BYTE.provider(), null),
        SHORT_VALUE(3, PRequirement.DEFAULT, "shortValue", PPrimitive.I16.provider(), null),
        INTEGER_VALUE(4, PRequirement.DEFAULT, "integerValue", PPrimitive.I32.provider(), null),
        LONG_VALUE(5, PRequirement.DEFAULT, "longValue", PPrimitive.I64.provider(), null),
        DOUBLE_VALUE(6, PRequirement.DEFAULT, "doubleValue", PPrimitive.DOUBLE.provider(), null),
        STRING_VALUE(7, PRequirement.DEFAULT, "stringValue", PPrimitive.STRING.provider(), null),
        BINARY_VALUE(8, PRequirement.DEFAULT, "binaryValue", PPrimitive.BINARY.provider(), null),
        ENUM_VALUE(9, PRequirement.DEFAULT, "enumValue", Value.provider(), null),
        COMPACT_VALUE(10, PRequirement.DEFAULT, "compactValue", CompactFields.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("UnionFields._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.BOOLEAN_VALUE;
                case 2: return _Field.BYTE_VALUE;
                case 3: return _Field.SHORT_VALUE;
                case 4: return _Field.INTEGER_VALUE;
                case 5: return _Field.LONG_VALUE;
                case 6: return _Field.DOUBLE_VALUE;
                case 7: return _Field.STRING_VALUE;
                case 8: return _Field.BINARY_VALUE;
                case 9: return _Field.ENUM_VALUE;
                case 10: return _Field.COMPACT_VALUE;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "booleanValue": return _Field.BOOLEAN_VALUE;
                case "byteValue": return _Field.BYTE_VALUE;
                case "shortValue": return _Field.SHORT_VALUE;
                case "integerValue": return _Field.INTEGER_VALUE;
                case "longValue": return _Field.LONG_VALUE;
                case "doubleValue": return _Field.DOUBLE_VALUE;
                case "stringValue": return _Field.STRING_VALUE;
                case "binaryValue": return _Field.BINARY_VALUE;
                case "enumValue": return _Field.ENUM_VALUE;
                case "compactValue": return _Field.COMPACT_VALUE;
            }
            return null;
        }
    }

    public static PUnionDescriptorProvider<UnionFields,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PUnionDescriptor<UnionFields,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PUnionDescriptor<UnionFields,_Field> kDescriptor;

    private static class _Descriptor
            extends PUnionDescriptor<UnionFields,_Field> {
        public _Descriptor() {
            super(null, "test", "UnionFields", new _Factory(), false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PUnionDescriptorProvider<UnionFields,_Field> {
        @Override
        public PUnionDescriptor<UnionFields,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<UnionFields> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (tUnionField != null) {
            switch (tUnionField) {
                case BOOLEAN_VALUE:
                    dest.writeInt(1);
                    dest.writeByte(mBooleanValue ? (byte) 1 : (byte) 0);
                    break;
                case BYTE_VALUE:
                    dest.writeInt(2);
                    dest.writeByte(mByteValue);
                    break;
                case SHORT_VALUE:
                    dest.writeInt(3);
                    dest.writeInt(mShortValue);
                    break;
                case INTEGER_VALUE:
                    dest.writeInt(4);
                    dest.writeInt(mIntegerValue);
                    break;
                case LONG_VALUE:
                    dest.writeInt(5);
                    dest.writeLong(mLongValue);
                    break;
                case DOUBLE_VALUE:
                    dest.writeInt(6);
                    dest.writeDouble(mDoubleValue);
                    break;
                case STRING_VALUE:
                    dest.writeInt(7);
                    dest.writeString(mStringValue);
                    break;
                case BINARY_VALUE:
                    dest.writeInt(8);
                    dest.writeByteArray(mBinaryValue.get());
                    break;
                case ENUM_VALUE:
                    dest.writeInt(9);
                    dest.writeInt(mEnumValue.getValue());
                    break;
                case COMPACT_VALUE:
                    dest.writeInt(10);
                    dest.writeTypedObject(mCompactValue, 0);
                    break;
            }
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<UnionFields> CREATOR = new Parcelable.Creator<UnionFields>() {
        @Override
        public UnionFields createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setBooleanValue(source.readByte() > 0);
                        break;
                    }
                    case 2: {
                        builder.setByteValue(source.readByte());
                        break;
                    }
                    case 3: {
                        builder.setShortValue((short)source.readInt());
                        break;
                    }
                    case 4: {
                        builder.setIntegerValue(source.readInt());
                        break;
                    }
                    case 5: {
                        builder.setLongValue(source.readLong());
                        break;
                    }
                    case 6: {
                        builder.setDoubleValue(source.readDouble());
                        break;
                    }
                    case 7: {
                        builder.setStringValue(source.readString());
                        break;
                    }
                    case 8: {
                        builder.setBinaryValue(Binary.wrap(source.createByteArray()));
                        break;
                    }
                    case 9: {
                        builder.setEnumValue(Value.forValue(source.readInt()));
                        break;
                    }
                    case 10: {
                        builder.setCompactValue((CompactFields) source.readTypedObject(CompactFields.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public UnionFields[] newArray(int size) {
            return new UnionFields[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<UnionFields> {
        private _Field tUnionField;

        private boolean mBooleanValue;
        private byte mByteValue;
        private short mShortValue;
        private int mIntegerValue;
        private long mLongValue;
        private double mDoubleValue;
        private String mStringValue;
        private Binary mBinaryValue;
        private Value mEnumValue;
        private CompactFields mCompactValue;


        public _Builder() {
            mBooleanValue = kDefaultBooleanValue;
            mByteValue = kDefaultByteValue;
            mShortValue = kDefaultShortValue;
            mIntegerValue = kDefaultIntegerValue;
            mLongValue = kDefaultLongValue;
            mDoubleValue = kDefaultDoubleValue;
        }

        public _Builder(UnionFields base) {
            this();

            tUnionField = base.tUnionField;

            mBooleanValue = base.mBooleanValue;
            mByteValue = base.mByteValue;
            mShortValue = base.mShortValue;
            mIntegerValue = base.mIntegerValue;
            mLongValue = base.mLongValue;
            mDoubleValue = base.mDoubleValue;
            mStringValue = base.mStringValue;
            mBinaryValue = base.mBinaryValue;
            mEnumValue = base.mEnumValue;
            mCompactValue = base.mCompactValue;
        }

        public _Builder setBooleanValue(boolean value) {
            tUnionField = _Field.BOOLEAN_VALUE;
            mBooleanValue = value;
            return this;
        }
        public _Builder clearBooleanValue() {
            if (tUnionField == _Field.BOOLEAN_VALUE) tUnionField = null;
            mBooleanValue = kDefaultBooleanValue;
            return this;
        }
        public _Builder setByteValue(byte value) {
            tUnionField = _Field.BYTE_VALUE;
            mByteValue = value;
            return this;
        }
        public _Builder clearByteValue() {
            if (tUnionField == _Field.BYTE_VALUE) tUnionField = null;
            mByteValue = kDefaultByteValue;
            return this;
        }
        public _Builder setShortValue(short value) {
            tUnionField = _Field.SHORT_VALUE;
            mShortValue = value;
            return this;
        }
        public _Builder clearShortValue() {
            if (tUnionField == _Field.SHORT_VALUE) tUnionField = null;
            mShortValue = kDefaultShortValue;
            return this;
        }
        public _Builder setIntegerValue(int value) {
            tUnionField = _Field.INTEGER_VALUE;
            mIntegerValue = value;
            return this;
        }
        public _Builder clearIntegerValue() {
            if (tUnionField == _Field.INTEGER_VALUE) tUnionField = null;
            mIntegerValue = kDefaultIntegerValue;
            return this;
        }
        public _Builder setLongValue(long value) {
            tUnionField = _Field.LONG_VALUE;
            mLongValue = value;
            return this;
        }
        public _Builder clearLongValue() {
            if (tUnionField == _Field.LONG_VALUE) tUnionField = null;
            mLongValue = kDefaultLongValue;
            return this;
        }
        public _Builder setDoubleValue(double value) {
            tUnionField = _Field.DOUBLE_VALUE;
            mDoubleValue = value;
            return this;
        }
        public _Builder clearDoubleValue() {
            if (tUnionField == _Field.DOUBLE_VALUE) tUnionField = null;
            mDoubleValue = kDefaultDoubleValue;
            return this;
        }
        public _Builder setStringValue(String value) {
            tUnionField = _Field.STRING_VALUE;
            mStringValue = value;
            return this;
        }
        public _Builder clearStringValue() {
            if (tUnionField == _Field.STRING_VALUE) tUnionField = null;
            mStringValue = null;
            return this;
        }
        public _Builder setBinaryValue(Binary value) {
            tUnionField = _Field.BINARY_VALUE;
            mBinaryValue = value;
            return this;
        }
        public _Builder clearBinaryValue() {
            if (tUnionField == _Field.BINARY_VALUE) tUnionField = null;
            mBinaryValue = null;
            return this;
        }
        public _Builder setEnumValue(Value value) {
            tUnionField = _Field.ENUM_VALUE;
            mEnumValue = value;
            return this;
        }
        public _Builder clearEnumValue() {
            if (tUnionField == _Field.ENUM_VALUE) tUnionField = null;
            mEnumValue = null;
            return this;
        }
        public _Builder setCompactValue(CompactFields value) {
            tUnionField = _Field.COMPACT_VALUE;
            mCompactValue = value;
            return this;
        }
        public _Builder clearCompactValue() {
            if (tUnionField == _Field.COMPACT_VALUE) tUnionField = null;
            mCompactValue = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setBooleanValue((boolean) value); break;
                case 2: setByteValue((byte) value); break;
                case 3: setShortValue((short) value); break;
                case 4: setIntegerValue((int) value); break;
                case 5: setLongValue((long) value); break;
                case 6: setDoubleValue((double) value); break;
                case 7: setStringValue((String) value); break;
                case 8: setBinaryValue((Binary) value); break;
                case 9: setEnumValue((Value) value); break;
                case 10: setCompactValue((CompactFields) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearBooleanValue(); break;
                case 2: clearByteValue(); break;
                case 3: clearShortValue(); break;
                case 4: clearIntegerValue(); break;
                case 5: clearLongValue(); break;
                case 6: clearDoubleValue(); break;
                case 7: clearStringValue(); break;
                case 8: clearBinaryValue(); break;
                case 9: clearEnumValue(); break;
                case 10: clearCompactValue(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return tUnionField != null;
        }

        @Override
        public UnionFields build() {
            return new UnionFields(this);
        }
    }
}
