package net.morimekta.test.providence;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.jackson.BinaryJsonDeserializer;
import net.morimekta.providence.jackson.BinaryJsonSerializer;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import net.morimekta.util.Binary;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class DefaultValues
        implements PMessage<DefaultValues>, Serializable, Comparable<DefaultValues>, Parcelable {
    private final static long serialVersionUID = -4218236026421774387L;

    private final static boolean kDefaultBooleanValue = true;
    private final static byte kDefaultByteValue = (byte)-125;
    private final static short kDefaultShortValue = (short)13579;
    private final static int kDefaultIntegerValue = 1234567890;
    private final static long kDefaultLongValue = 1234567891L;
    private final static double kDefaultDoubleValue = 2.99792458E8d;
    private final static String kDefaultStringValue = "test\\twith escapes\\nand\\u00a0ũñı©ôðé.";
    private final static Value kDefaultEnumValue = Value.SECOND;

    private final boolean mBooleanValue;
    private final byte mByteValue;
    private final short mShortValue;
    private final int mIntegerValue;
    private final long mLongValue;
    private final double mDoubleValue;
    private final String mStringValue;
    private final Binary mBinaryValue;
    private final Value mEnumValue;
    private final CompactFields mCompactValue;
    
    private volatile int tHashCode;

    private DefaultValues(_Builder builder) {
        mBooleanValue = builder.mBooleanValue;
        mByteValue = builder.mByteValue;
        mShortValue = builder.mShortValue;
        mIntegerValue = builder.mIntegerValue;
        mLongValue = builder.mLongValue;
        mDoubleValue = builder.mDoubleValue;
        mStringValue = builder.mStringValue;
        mBinaryValue = builder.mBinaryValue;
        mEnumValue = builder.mEnumValue;
        mCompactValue = builder.mCompactValue;
    }

    @JsonCreator
    public DefaultValues(@JsonProperty("booleanValue") boolean pBooleanValue,
                         @JsonProperty("byteValue") byte pByteValue,
                         @JsonProperty("shortValue") short pShortValue,
                         @JsonProperty("integerValue") int pIntegerValue,
                         @JsonProperty("longValue") long pLongValue,
                         @JsonProperty("doubleValue") double pDoubleValue,
                         @JsonProperty("stringValue") String pStringValue,
                         @JsonProperty("binaryValue") @JsonDeserialize(using = BinaryJsonDeserializer.class) Binary pBinaryValue,
                         @JsonProperty("enumValue") Value pEnumValue,
                         @JsonProperty("compactValue") CompactFields pCompactValue) {
        mBooleanValue = pBooleanValue;
        mByteValue = pByteValue;
        mShortValue = pShortValue;
        mIntegerValue = pIntegerValue;
        mLongValue = pLongValue;
        mDoubleValue = pDoubleValue;
        mStringValue = pStringValue;
        mBinaryValue = pBinaryValue;
        mEnumValue = pEnumValue;
        mCompactValue = pCompactValue;
    }

    public boolean hasBooleanValue() {
        return true;
    }

    @JsonProperty("booleanValue")
    public boolean isBooleanValue() {
        return mBooleanValue;
    }

    public boolean hasByteValue() {
        return true;
    }

    @JsonProperty("byteValue")
    public byte getByteValue() {
        return mByteValue;
    }

    public boolean hasShortValue() {
        return true;
    }

    @JsonProperty("shortValue")
    public short getShortValue() {
        return mShortValue;
    }

    public boolean hasIntegerValue() {
        return true;
    }

    @JsonProperty("integerValue")
    public int getIntegerValue() {
        return mIntegerValue;
    }

    public boolean hasLongValue() {
        return true;
    }

    @JsonProperty("longValue")
    public long getLongValue() {
        return mLongValue;
    }

    public boolean hasDoubleValue() {
        return true;
    }

    @JsonProperty("doubleValue")
    public double getDoubleValue() {
        return mDoubleValue;
    }

    public boolean hasStringValue() {
        return mStringValue != null;
    }

    @JsonProperty("stringValue")
    public String getStringValue() {
        return hasStringValue() ? mStringValue : kDefaultStringValue;
    }

    public boolean hasBinaryValue() {
        return mBinaryValue != null;
    }

    @JsonProperty("binaryValue")
    @JsonSerialize(using = BinaryJsonSerializer.class) 
    public Binary getBinaryValue() {
        return mBinaryValue;
    }

    public boolean hasEnumValue() {
        return mEnumValue != null;
    }

    @JsonProperty("enumValue")
    public Value getEnumValue() {
        return hasEnumValue() ? mEnumValue : kDefaultEnumValue;
    }

    public boolean hasCompactValue() {
        return mCompactValue != null;
    }

    @JsonProperty("compactValue")
    public CompactFields getCompactValue() {
        return mCompactValue;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return true;
            case 3: return true;
            case 4: return true;
            case 5: return true;
            case 6: return true;
            case 7: return hasStringValue();
            case 8: return hasBinaryValue();
            case 9: return hasEnumValue();
            case 10: return hasCompactValue();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return 1;
            case 2: return 1;
            case 3: return 1;
            case 4: return 1;
            case 5: return 1;
            case 6: return 1;
            case 7: return hasStringValue() ? 1 : 0;
            case 8: return hasBinaryValue() ? 1 : 0;
            case 9: return hasEnumValue() ? 1 : 0;
            case 10: return hasCompactValue() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return isBooleanValue();
            case 2: return getByteValue();
            case 3: return getShortValue();
            case 4: return getIntegerValue();
            case 5: return getLongValue();
            case 6: return getDoubleValue();
            case 7: return getStringValue();
            case 8: return getBinaryValue();
            case 9: return getEnumValue();
            case 10: return getCompactValue();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DefaultValues)) return false;
        DefaultValues other = (DefaultValues) o;
        return Objects.equals(mBooleanValue, other.mBooleanValue) &&
               Objects.equals(mByteValue, other.mByteValue) &&
               Objects.equals(mShortValue, other.mShortValue) &&
               Objects.equals(mIntegerValue, other.mIntegerValue) &&
               Objects.equals(mLongValue, other.mLongValue) &&
               Objects.equals(mDoubleValue, other.mDoubleValue) &&
               Objects.equals(mStringValue, other.mStringValue) &&
               Objects.equals(mBinaryValue, other.mBinaryValue) &&
               Objects.equals(mEnumValue, other.mEnumValue) &&
               Objects.equals(mCompactValue, other.mCompactValue);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    DefaultValues.class,
                    _Field.BOOLEAN_VALUE, mBooleanValue,
                    _Field.BYTE_VALUE, mByteValue,
                    _Field.SHORT_VALUE, mShortValue,
                    _Field.INTEGER_VALUE, mIntegerValue,
                    _Field.LONG_VALUE, mLongValue,
                    _Field.DOUBLE_VALUE, mDoubleValue,
                    _Field.STRING_VALUE, mStringValue,
                    _Field.BINARY_VALUE, mBinaryValue,
                    _Field.ENUM_VALUE, mEnumValue,
                    _Field.COMPACT_VALUE, mCompactValue);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "test.DefaultValues" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasBooleanValue()) {
            first = false;
            out.append("booleanValue:");
            out.append(mBooleanValue ? "true" : "false");
        }
        if (hasByteValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("byteValue:");
            out.append(Byte.toString(mByteValue));
        }
        if (hasShortValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("shortValue:");
            out.append(Short.toString(mShortValue));
        }
        if (hasIntegerValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("integerValue:");
            out.append(Integer.toString(mIntegerValue));
        }
        if (hasLongValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("longValue:");
            out.append(Long.toString(mLongValue));
        }
        if (hasDoubleValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("doubleValue:");
            out.append(PTypeUtils.toString(mDoubleValue));
        }
        if (hasStringValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("stringValue:");
            out.append('\"').append(mStringValue).append('\"');
        }
        if (hasBinaryValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("binaryValue:");
            out.append("hex(").append(mBinaryValue.toHexString()).append(')');
        }
        if (hasEnumValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("enumValue:");
            out.append(mEnumValue.getName());
        }
        if (hasCompactValue()) {
            if (!first) out.append(',');
            first = false;
            out.append("compactValue:");
            out.append(mCompactValue.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(DefaultValues other) {
        int c;

        c = Boolean.compare(mBooleanValue, other.mBooleanValue);
        if (c != 0) return c;

        c = Byte.compare(mByteValue, other.mByteValue);
        if (c != 0) return c;

        c = Short.compare(mShortValue, other.mShortValue);
        if (c != 0) return c;

        c = Integer.compare(mIntegerValue, other.mIntegerValue);
        if (c != 0) return c;

        c = Long.compare(mLongValue, other.mLongValue);
        if (c != 0) return c;

        c = Double.compare(mDoubleValue, other.mDoubleValue);
        if (c != 0) return c;

        c = Boolean.compare(mStringValue != null, other.mStringValue != null);
        if (c != 0) return c;
        if (mStringValue != null) {
            c = mStringValue.compareTo(other.mStringValue);
            if (c != 0) return c;
        }

        c = Boolean.compare(mBinaryValue != null, other.mBinaryValue != null);
        if (c != 0) return c;
        if (mBinaryValue != null) {
            c = mBinaryValue.compareTo(other.mBinaryValue);
            if (c != 0) return c;
        }

        c = Boolean.compare(mEnumValue != null, other.mEnumValue != null);
        if (c != 0) return c;
        if (mEnumValue != null) {
            c = Integer.compare(mEnumValue.getValue(), mEnumValue.getValue());
            if (c != 0) return c;
        }

        c = Boolean.compare(mCompactValue != null, other.mCompactValue != null);
        if (c != 0) return c;
        if (mCompactValue != null) {
            c = mCompactValue.compareTo(other.mCompactValue);
            if (c != 0) return c;
        }

        return 0;
    }

    public enum _Field implements PField {
        BOOLEAN_VALUE(1, PRequirement.DEFAULT, "booleanValue", PPrimitive.BOOL.provider(), new PDefaultValueProvider<>(kDefaultBooleanValue)),
        BYTE_VALUE(2, PRequirement.DEFAULT, "byteValue", PPrimitive.BYTE.provider(), new PDefaultValueProvider<>(kDefaultByteValue)),
        SHORT_VALUE(3, PRequirement.DEFAULT, "shortValue", PPrimitive.I16.provider(), new PDefaultValueProvider<>(kDefaultShortValue)),
        INTEGER_VALUE(4, PRequirement.DEFAULT, "integerValue", PPrimitive.I32.provider(), new PDefaultValueProvider<>(kDefaultIntegerValue)),
        LONG_VALUE(5, PRequirement.DEFAULT, "longValue", PPrimitive.I64.provider(), new PDefaultValueProvider<>(kDefaultLongValue)),
        DOUBLE_VALUE(6, PRequirement.DEFAULT, "doubleValue", PPrimitive.DOUBLE.provider(), new PDefaultValueProvider<>(kDefaultDoubleValue)),
        STRING_VALUE(7, PRequirement.DEFAULT, "stringValue", PPrimitive.STRING.provider(), new PDefaultValueProvider<>(kDefaultStringValue)),
        BINARY_VALUE(8, PRequirement.DEFAULT, "binaryValue", PPrimitive.BINARY.provider(), null),
        ENUM_VALUE(9, PRequirement.DEFAULT, "enumValue", Value.provider(), new PDefaultValueProvider<>(kDefaultEnumValue)),
        COMPACT_VALUE(10, PRequirement.DEFAULT, "compactValue", CompactFields.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DefaultValues._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.BOOLEAN_VALUE;
                case 2: return _Field.BYTE_VALUE;
                case 3: return _Field.SHORT_VALUE;
                case 4: return _Field.INTEGER_VALUE;
                case 5: return _Field.LONG_VALUE;
                case 6: return _Field.DOUBLE_VALUE;
                case 7: return _Field.STRING_VALUE;
                case 8: return _Field.BINARY_VALUE;
                case 9: return _Field.ENUM_VALUE;
                case 10: return _Field.COMPACT_VALUE;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "booleanValue": return _Field.BOOLEAN_VALUE;
                case "byteValue": return _Field.BYTE_VALUE;
                case "shortValue": return _Field.SHORT_VALUE;
                case "integerValue": return _Field.INTEGER_VALUE;
                case "longValue": return _Field.LONG_VALUE;
                case "doubleValue": return _Field.DOUBLE_VALUE;
                case "stringValue": return _Field.STRING_VALUE;
                case "binaryValue": return _Field.BINARY_VALUE;
                case "enumValue": return _Field.ENUM_VALUE;
                case "compactValue": return _Field.COMPACT_VALUE;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<DefaultValues,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<DefaultValues,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<DefaultValues,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<DefaultValues,_Field> {
        public _Descriptor() {
            super(null, "test", "DefaultValues", new _Factory(), false, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<DefaultValues,_Field> {
        @Override
        public PStructDescriptor<DefaultValues,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<DefaultValues> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeByte(mBooleanValue ? (byte) 1 : (byte) 0);
        dest.writeInt(2);
        dest.writeByte(mByteValue);
        dest.writeInt(3);
        dest.writeInt(mShortValue);
        dest.writeInt(4);
        dest.writeInt(mIntegerValue);
        dest.writeInt(5);
        dest.writeLong(mLongValue);
        dest.writeInt(6);
        dest.writeDouble(mDoubleValue);
        if (hasStringValue()) {
            dest.writeInt(7);
            dest.writeString(mStringValue);
        }
        if (hasBinaryValue()) {
            dest.writeInt(8);
            dest.writeByteArray(mBinaryValue.get());
        }
        if (hasEnumValue()) {
            dest.writeInt(9);
            dest.writeInt(mEnumValue.getValue());
        }
        if (hasCompactValue()) {
            dest.writeInt(10);
            dest.writeTypedObject(mCompactValue, 0);
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<DefaultValues> CREATOR = new Parcelable.Creator<DefaultValues>() {
        @Override
        public DefaultValues createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setBooleanValue(source.readByte() > 0);
                        break;
                    }
                    case 2: {
                        builder.setByteValue(source.readByte());
                        break;
                    }
                    case 3: {
                        builder.setShortValue((short)source.readInt());
                        break;
                    }
                    case 4: {
                        builder.setIntegerValue(source.readInt());
                        break;
                    }
                    case 5: {
                        builder.setLongValue(source.readLong());
                        break;
                    }
                    case 6: {
                        builder.setDoubleValue(source.readDouble());
                        break;
                    }
                    case 7: {
                        builder.setStringValue(source.readString());
                        break;
                    }
                    case 8: {
                        builder.setBinaryValue(Binary.wrap(source.createByteArray()));
                        break;
                    }
                    case 9: {
                        builder.setEnumValue(Value.forValue(source.readInt()));
                        break;
                    }
                    case 10: {
                        builder.setCompactValue((CompactFields) source.readTypedObject(CompactFields.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public DefaultValues[] newArray(int size) {
            return new DefaultValues[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<DefaultValues> {
        private BitSet optionals;

        private boolean mBooleanValue;
        private byte mByteValue;
        private short mShortValue;
        private int mIntegerValue;
        private long mLongValue;
        private double mDoubleValue;
        private String mStringValue;
        private Binary mBinaryValue;
        private Value mEnumValue;
        private CompactFields mCompactValue;


        public _Builder() {
            optionals = new BitSet(10);
            mBooleanValue = kDefaultBooleanValue;
            mByteValue = kDefaultByteValue;
            mShortValue = kDefaultShortValue;
            mIntegerValue = kDefaultIntegerValue;
            mLongValue = kDefaultLongValue;
            mDoubleValue = kDefaultDoubleValue;
        }

        public _Builder(DefaultValues base) {
            this();

            optionals.set(0);
            mBooleanValue = base.mBooleanValue;
            optionals.set(1);
            mByteValue = base.mByteValue;
            optionals.set(2);
            mShortValue = base.mShortValue;
            optionals.set(3);
            mIntegerValue = base.mIntegerValue;
            optionals.set(4);
            mLongValue = base.mLongValue;
            optionals.set(5);
            mDoubleValue = base.mDoubleValue;
            if (base.hasStringValue()) {
                optionals.set(6);
                mStringValue = base.mStringValue;
            }
            if (base.hasBinaryValue()) {
                optionals.set(7);
                mBinaryValue = base.mBinaryValue;
            }
            if (base.hasEnumValue()) {
                optionals.set(8);
                mEnumValue = base.mEnumValue;
            }
            if (base.hasCompactValue()) {
                optionals.set(9);
                mCompactValue = base.mCompactValue;
            }
        }

        public _Builder setBooleanValue(boolean value) {
            optionals.set(0);
            mBooleanValue = value;
            return this;
        }
        public _Builder clearBooleanValue() {
            optionals.set(0, false);
            mBooleanValue = kDefaultBooleanValue;
            return this;
        }
        public _Builder setByteValue(byte value) {
            optionals.set(1);
            mByteValue = value;
            return this;
        }
        public _Builder clearByteValue() {
            optionals.set(1, false);
            mByteValue = kDefaultByteValue;
            return this;
        }
        public _Builder setShortValue(short value) {
            optionals.set(2);
            mShortValue = value;
            return this;
        }
        public _Builder clearShortValue() {
            optionals.set(2, false);
            mShortValue = kDefaultShortValue;
            return this;
        }
        public _Builder setIntegerValue(int value) {
            optionals.set(3);
            mIntegerValue = value;
            return this;
        }
        public _Builder clearIntegerValue() {
            optionals.set(3, false);
            mIntegerValue = kDefaultIntegerValue;
            return this;
        }
        public _Builder setLongValue(long value) {
            optionals.set(4);
            mLongValue = value;
            return this;
        }
        public _Builder clearLongValue() {
            optionals.set(4, false);
            mLongValue = kDefaultLongValue;
            return this;
        }
        public _Builder setDoubleValue(double value) {
            optionals.set(5);
            mDoubleValue = value;
            return this;
        }
        public _Builder clearDoubleValue() {
            optionals.set(5, false);
            mDoubleValue = kDefaultDoubleValue;
            return this;
        }
        public _Builder setStringValue(String value) {
            optionals.set(6);
            mStringValue = value;
            return this;
        }
        public _Builder clearStringValue() {
            optionals.set(6, false);
            mStringValue = null;
            return this;
        }
        public _Builder setBinaryValue(Binary value) {
            optionals.set(7);
            mBinaryValue = value;
            return this;
        }
        public _Builder clearBinaryValue() {
            optionals.set(7, false);
            mBinaryValue = null;
            return this;
        }
        public _Builder setEnumValue(Value value) {
            optionals.set(8);
            mEnumValue = value;
            return this;
        }
        public _Builder clearEnumValue() {
            optionals.set(8, false);
            mEnumValue = null;
            return this;
        }
        public _Builder setCompactValue(CompactFields value) {
            optionals.set(9);
            mCompactValue = value;
            return this;
        }
        public _Builder clearCompactValue() {
            optionals.set(9, false);
            mCompactValue = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setBooleanValue((boolean) value); break;
                case 2: setByteValue((byte) value); break;
                case 3: setShortValue((short) value); break;
                case 4: setIntegerValue((int) value); break;
                case 5: setLongValue((long) value); break;
                case 6: setDoubleValue((double) value); break;
                case 7: setStringValue((String) value); break;
                case 8: setBinaryValue((Binary) value); break;
                case 9: setEnumValue((Value) value); break;
                case 10: setCompactValue((CompactFields) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearBooleanValue(); break;
                case 2: clearByteValue(); break;
                case 3: clearShortValue(); break;
                case 4: clearIntegerValue(); break;
                case 5: clearLongValue(); break;
                case 6: clearDoubleValue(); break;
                case 7: clearStringValue(); break;
                case 8: clearBinaryValue(); break;
                case 9: clearEnumValue(); break;
                case 10: clearCompactValue(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public DefaultValues build() {
            return new DefaultValues(this);
        }
    }
}
