package net.morimekta.test.providence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.morimekta.util.Binary;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Containers
        implements PMessage<Containers>, Serializable, Comparable<Containers>, Parcelable {
    private final static long serialVersionUID = 1349608529274328224L;

    private final List<Boolean> mBooleanList;
    private final List<Byte> mByteList;
    private final List<Short> mShortList;
    private final List<Integer> mIntegerList;
    private final List<Long> mLongList;
    private final List<Double> mDoubleList;
    private final List<String> mStringList;
    private final List<Binary> mBinaryList;
    private final Set<Boolean> mBooleanSet;
    private final Set<Byte> mByteSet;
    private final Set<Short> mShortSet;
    private final Set<Integer> mIntegerSet;
    private final Set<Long> mLongSet;
    private final Set<Double> mDoubleSet;
    private final Set<String> mStringSet;
    private final Set<Binary> mBinarySet;
    private final Map<Boolean,Boolean> mBooleanMap;
    private final Map<Byte,Byte> mByteMap;
    private final Map<Short,Short> mShortMap;
    private final Map<Integer,Integer> mIntegerMap;
    private final Map<Long,Long> mLongMap;
    private final Map<Double,Double> mDoubleMap;
    private final Map<String,String> mStringMap;
    private final Map<Binary,Binary> mBinaryMap;
    private final List<Value> mEnumList;
    private final Set<Value> mEnumSet;
    private final Map<Value,Value> mEnumMap;
    private final List<DefaultFields> mMessageList;
    private final Set<DefaultFields> mMessageSet;
    private final Map<String,DefaultFields> mMessageMap;
    private final RequiredFields mRequiredFields;
    private final DefaultFields mDefaultFields;
    private final OptionalFields mOptionalFields;
    private final UnionFields mUnionFields;
    private final ExceptionFields mExceptionFields;
    private final DefaultValues mDefaultValues;
    
    private volatile int tHashCode;

    private Containers(_Builder builder) {
        mBooleanList = Collections.unmodifiableList(new LinkedList<>(builder.mBooleanList));
        mByteList = Collections.unmodifiableList(new LinkedList<>(builder.mByteList));
        mShortList = Collections.unmodifiableList(new LinkedList<>(builder.mShortList));
        mIntegerList = Collections.unmodifiableList(new LinkedList<>(builder.mIntegerList));
        mLongList = Collections.unmodifiableList(new LinkedList<>(builder.mLongList));
        mDoubleList = Collections.unmodifiableList(new LinkedList<>(builder.mDoubleList));
        mStringList = Collections.unmodifiableList(new LinkedList<>(builder.mStringList));
        mBinaryList = Collections.unmodifiableList(new LinkedList<>(builder.mBinaryList));
        mBooleanSet = Collections.unmodifiableSet(new TreeSet<>(builder.mBooleanSet));
        mByteSet = Collections.unmodifiableSet(new TreeSet<>(builder.mByteSet));
        mShortSet = Collections.unmodifiableSet(new TreeSet<>(builder.mShortSet));
        mIntegerSet = Collections.unmodifiableSet(new TreeSet<>(builder.mIntegerSet));
        mLongSet = Collections.unmodifiableSet(new TreeSet<>(builder.mLongSet));
        mDoubleSet = Collections.unmodifiableSet(new TreeSet<>(builder.mDoubleSet));
        mStringSet = Collections.unmodifiableSet(new TreeSet<>(builder.mStringSet));
        mBinarySet = Collections.unmodifiableSet(new TreeSet<>(builder.mBinarySet));
        mBooleanMap = Collections.unmodifiableMap(new TreeMap<>(builder.mBooleanMap));
        mByteMap = Collections.unmodifiableMap(new TreeMap<>(builder.mByteMap));
        mShortMap = Collections.unmodifiableMap(new TreeMap<>(builder.mShortMap));
        mIntegerMap = Collections.unmodifiableMap(new TreeMap<>(builder.mIntegerMap));
        mLongMap = Collections.unmodifiableMap(new TreeMap<>(builder.mLongMap));
        mDoubleMap = Collections.unmodifiableMap(new TreeMap<>(builder.mDoubleMap));
        mStringMap = Collections.unmodifiableMap(new TreeMap<>(builder.mStringMap));
        mBinaryMap = Collections.unmodifiableMap(new TreeMap<>(builder.mBinaryMap));
        mEnumList = Collections.unmodifiableList(new LinkedList<>(builder.mEnumList));
        mEnumSet = Collections.unmodifiableSet(new TreeSet<>(builder.mEnumSet));
        mEnumMap = Collections.unmodifiableMap(new TreeMap<>(builder.mEnumMap));
        mMessageList = Collections.unmodifiableList(new LinkedList<>(builder.mMessageList));
        mMessageSet = Collections.unmodifiableSet(new TreeSet<>(builder.mMessageSet));
        mMessageMap = Collections.unmodifiableMap(new TreeMap<>(builder.mMessageMap));
        mRequiredFields = builder.mRequiredFields;
        mDefaultFields = builder.mDefaultFields;
        mOptionalFields = builder.mOptionalFields;
        mUnionFields = builder.mUnionFields;
        mExceptionFields = builder.mExceptionFields;
        mDefaultValues = builder.mDefaultValues;
    }

    @JsonCreator
    public Containers(@JsonProperty("booleanList") List<Boolean> pBooleanList,
                      @JsonProperty("byteList") List<Byte> pByteList,
                      @JsonProperty("shortList") List<Short> pShortList,
                      @JsonProperty("integerList") List<Integer> pIntegerList,
                      @JsonProperty("longList") List<Long> pLongList,
                      @JsonProperty("doubleList") List<Double> pDoubleList,
                      @JsonProperty("stringList") List<String> pStringList,
                      @JsonProperty("binaryList") List<Binary> pBinaryList,
                      @JsonProperty("booleanSet") Set<Boolean> pBooleanSet,
                      @JsonProperty("byteSet") Set<Byte> pByteSet,
                      @JsonProperty("shortSet") Set<Short> pShortSet,
                      @JsonProperty("integerSet") Set<Integer> pIntegerSet,
                      @JsonProperty("longSet") Set<Long> pLongSet,
                      @JsonProperty("doubleSet") Set<Double> pDoubleSet,
                      @JsonProperty("stringSet") Set<String> pStringSet,
                      @JsonProperty("binarySet") Set<Binary> pBinarySet,
                      @JsonProperty("booleanMap") Map<Boolean,Boolean> pBooleanMap,
                      @JsonProperty("byteMap") Map<Byte,Byte> pByteMap,
                      @JsonProperty("shortMap") Map<Short,Short> pShortMap,
                      @JsonProperty("integerMap") Map<Integer,Integer> pIntegerMap,
                      @JsonProperty("longMap") Map<Long,Long> pLongMap,
                      @JsonProperty("doubleMap") Map<Double,Double> pDoubleMap,
                      @JsonProperty("stringMap") Map<String,String> pStringMap,
                      @JsonProperty("binaryMap") Map<Binary,Binary> pBinaryMap,
                      @JsonProperty("enumList") List<Value> pEnumList,
                      @JsonProperty("enumSet") Set<Value> pEnumSet,
                      @JsonProperty("enumMap") Map<Value,Value> pEnumMap,
                      @JsonProperty("messageList") List<DefaultFields> pMessageList,
                      @JsonProperty("messageSet") Set<DefaultFields> pMessageSet,
                      @JsonProperty("messageMap") Map<String,DefaultFields> pMessageMap,
                      @JsonProperty("requiredFields") RequiredFields pRequiredFields,
                      @JsonProperty("defaultFields") DefaultFields pDefaultFields,
                      @JsonProperty("optionalFields") OptionalFields pOptionalFields,
                      @JsonProperty("unionFields") UnionFields pUnionFields,
                      @JsonProperty("exceptionFields") ExceptionFields pExceptionFields,
                      @JsonProperty("defaultValues") DefaultValues pDefaultValues) {
        mBooleanList = Collections.unmodifiableList(new LinkedList<>(pBooleanList));
        mByteList = Collections.unmodifiableList(new LinkedList<>(pByteList));
        mShortList = Collections.unmodifiableList(new LinkedList<>(pShortList));
        mIntegerList = Collections.unmodifiableList(new LinkedList<>(pIntegerList));
        mLongList = Collections.unmodifiableList(new LinkedList<>(pLongList));
        mDoubleList = Collections.unmodifiableList(new LinkedList<>(pDoubleList));
        mStringList = Collections.unmodifiableList(new LinkedList<>(pStringList));
        mBinaryList = Collections.unmodifiableList(new LinkedList<>(pBinaryList));
        mBooleanSet = Collections.unmodifiableSet(new TreeSet<>(pBooleanSet));
        mByteSet = Collections.unmodifiableSet(new TreeSet<>(pByteSet));
        mShortSet = Collections.unmodifiableSet(new TreeSet<>(pShortSet));
        mIntegerSet = Collections.unmodifiableSet(new TreeSet<>(pIntegerSet));
        mLongSet = Collections.unmodifiableSet(new TreeSet<>(pLongSet));
        mDoubleSet = Collections.unmodifiableSet(new TreeSet<>(pDoubleSet));
        mStringSet = Collections.unmodifiableSet(new TreeSet<>(pStringSet));
        mBinarySet = Collections.unmodifiableSet(new TreeSet<>(pBinarySet));
        mBooleanMap = Collections.unmodifiableMap(new TreeMap<>(pBooleanMap));
        mByteMap = Collections.unmodifiableMap(new TreeMap<>(pByteMap));
        mShortMap = Collections.unmodifiableMap(new TreeMap<>(pShortMap));
        mIntegerMap = Collections.unmodifiableMap(new TreeMap<>(pIntegerMap));
        mLongMap = Collections.unmodifiableMap(new TreeMap<>(pLongMap));
        mDoubleMap = Collections.unmodifiableMap(new TreeMap<>(pDoubleMap));
        mStringMap = Collections.unmodifiableMap(new TreeMap<>(pStringMap));
        mBinaryMap = Collections.unmodifiableMap(new TreeMap<>(pBinaryMap));
        mEnumList = Collections.unmodifiableList(new LinkedList<>(pEnumList));
        mEnumSet = Collections.unmodifiableSet(new TreeSet<>(pEnumSet));
        mEnumMap = Collections.unmodifiableMap(new TreeMap<>(pEnumMap));
        mMessageList = Collections.unmodifiableList(new LinkedList<>(pMessageList));
        mMessageSet = Collections.unmodifiableSet(new TreeSet<>(pMessageSet));
        mMessageMap = Collections.unmodifiableMap(new TreeMap<>(pMessageMap));
        mRequiredFields = pRequiredFields;
        mDefaultFields = pDefaultFields;
        mOptionalFields = pOptionalFields;
        mUnionFields = pUnionFields;
        mExceptionFields = pExceptionFields;
        mDefaultValues = pDefaultValues;
    }

    public int numBooleanList() {
        return mBooleanList != null ? mBooleanList.size() : 0;
    }

    /** all types as list<x>. */
    @JsonProperty("booleanList")
    public List<Boolean> getBooleanList() {
        return mBooleanList;
    }

    public int numByteList() {
        return mByteList != null ? mByteList.size() : 0;
    }

    @JsonProperty("byteList")
    public List<Byte> getByteList() {
        return mByteList;
    }

    public int numShortList() {
        return mShortList != null ? mShortList.size() : 0;
    }

    @JsonProperty("shortList")
    public List<Short> getShortList() {
        return mShortList;
    }

    public int numIntegerList() {
        return mIntegerList != null ? mIntegerList.size() : 0;
    }

    @JsonProperty("integerList")
    public List<Integer> getIntegerList() {
        return mIntegerList;
    }

    public int numLongList() {
        return mLongList != null ? mLongList.size() : 0;
    }

    @JsonProperty("longList")
    public List<Long> getLongList() {
        return mLongList;
    }

    public int numDoubleList() {
        return mDoubleList != null ? mDoubleList.size() : 0;
    }

    @JsonProperty("doubleList")
    public List<Double> getDoubleList() {
        return mDoubleList;
    }

    public int numStringList() {
        return mStringList != null ? mStringList.size() : 0;
    }

    @JsonProperty("stringList")
    public List<String> getStringList() {
        return mStringList;
    }

    public int numBinaryList() {
        return mBinaryList != null ? mBinaryList.size() : 0;
    }

    @JsonProperty("binaryList")
    public List<Binary> getBinaryList() {
        return mBinaryList;
    }

    public int numBooleanSet() {
        return mBooleanSet != null ? mBooleanSet.size() : 0;
    }

    /** all types as set<x>. */
    @JsonProperty("booleanSet")
    public Set<Boolean> getBooleanSet() {
        return mBooleanSet;
    }

    public int numByteSet() {
        return mByteSet != null ? mByteSet.size() : 0;
    }

    @JsonProperty("byteSet")
    public Set<Byte> getByteSet() {
        return mByteSet;
    }

    public int numShortSet() {
        return mShortSet != null ? mShortSet.size() : 0;
    }

    @JsonProperty("shortSet")
    public Set<Short> getShortSet() {
        return mShortSet;
    }

    public int numIntegerSet() {
        return mIntegerSet != null ? mIntegerSet.size() : 0;
    }

    @JsonProperty("integerSet")
    public Set<Integer> getIntegerSet() {
        return mIntegerSet;
    }

    public int numLongSet() {
        return mLongSet != null ? mLongSet.size() : 0;
    }

    @JsonProperty("longSet")
    public Set<Long> getLongSet() {
        return mLongSet;
    }

    public int numDoubleSet() {
        return mDoubleSet != null ? mDoubleSet.size() : 0;
    }

    @JsonProperty("doubleSet")
    public Set<Double> getDoubleSet() {
        return mDoubleSet;
    }

    public int numStringSet() {
        return mStringSet != null ? mStringSet.size() : 0;
    }

    @JsonProperty("stringSet")
    public Set<String> getStringSet() {
        return mStringSet;
    }

    public int numBinarySet() {
        return mBinarySet != null ? mBinarySet.size() : 0;
    }

    @JsonProperty("binarySet")
    public Set<Binary> getBinarySet() {
        return mBinarySet;
    }

    public int numBooleanMap() {
        return mBooleanMap != null ? mBooleanMap.size() : 0;
    }

    /** all types as map<x,x>. */
    @JsonProperty("booleanMap")
    public Map<Boolean,Boolean> getBooleanMap() {
        return mBooleanMap;
    }

    public int numByteMap() {
        return mByteMap != null ? mByteMap.size() : 0;
    }

    @JsonProperty("byteMap")
    public Map<Byte,Byte> getByteMap() {
        return mByteMap;
    }

    public int numShortMap() {
        return mShortMap != null ? mShortMap.size() : 0;
    }

    @JsonProperty("shortMap")
    public Map<Short,Short> getShortMap() {
        return mShortMap;
    }

    public int numIntegerMap() {
        return mIntegerMap != null ? mIntegerMap.size() : 0;
    }

    @JsonProperty("integerMap")
    public Map<Integer,Integer> getIntegerMap() {
        return mIntegerMap;
    }

    public int numLongMap() {
        return mLongMap != null ? mLongMap.size() : 0;
    }

    @JsonProperty("longMap")
    public Map<Long,Long> getLongMap() {
        return mLongMap;
    }

    public int numDoubleMap() {
        return mDoubleMap != null ? mDoubleMap.size() : 0;
    }

    @JsonProperty("doubleMap")
    public Map<Double,Double> getDoubleMap() {
        return mDoubleMap;
    }

    public int numStringMap() {
        return mStringMap != null ? mStringMap.size() : 0;
    }

    @JsonProperty("stringMap")
    public Map<String,String> getStringMap() {
        return mStringMap;
    }

    public int numBinaryMap() {
        return mBinaryMap != null ? mBinaryMap.size() : 0;
    }

    @JsonProperty("binaryMap")
    public Map<Binary,Binary> getBinaryMap() {
        return mBinaryMap;
    }

    public int numEnumList() {
        return mEnumList != null ? mEnumList.size() : 0;
    }

    /** Using enum as key and value in containers. */
    @JsonProperty("enumList")
    public List<Value> getEnumList() {
        return mEnumList;
    }

    public int numEnumSet() {
        return mEnumSet != null ? mEnumSet.size() : 0;
    }

    @JsonProperty("enumSet")
    public Set<Value> getEnumSet() {
        return mEnumSet;
    }

    public int numEnumMap() {
        return mEnumMap != null ? mEnumMap.size() : 0;
    }

    @JsonProperty("enumMap")
    public Map<Value,Value> getEnumMap() {
        return mEnumMap;
    }

    public int numMessageList() {
        return mMessageList != null ? mMessageList.size() : 0;
    }

    /** Using struct as key and value in containers. */
    @JsonProperty("messageList")
    public List<DefaultFields> getMessageList() {
        return mMessageList;
    }

    public int numMessageSet() {
        return mMessageSet != null ? mMessageSet.size() : 0;
    }

    @JsonProperty("messageSet")
    public Set<DefaultFields> getMessageSet() {
        return mMessageSet;
    }

    public int numMessageMap() {
        return mMessageMap != null ? mMessageMap.size() : 0;
    }

    @JsonProperty("messageMap")
    public Map<String,DefaultFields> getMessageMap() {
        return mMessageMap;
    }

    public boolean hasRequiredFields() {
        return mRequiredFields != null;
    }

    @JsonProperty("requiredFields")
    public RequiredFields getRequiredFields() {
        return mRequiredFields;
    }

    public boolean hasDefaultFields() {
        return mDefaultFields != null;
    }

    @JsonProperty("defaultFields")
    public DefaultFields getDefaultFields() {
        return mDefaultFields;
    }

    public boolean hasOptionalFields() {
        return mOptionalFields != null;
    }

    @JsonProperty("optionalFields")
    public OptionalFields getOptionalFields() {
        return mOptionalFields;
    }

    public boolean hasUnionFields() {
        return mUnionFields != null;
    }

    @JsonProperty("unionFields")
    public UnionFields getUnionFields() {
        return mUnionFields;
    }

    public boolean hasExceptionFields() {
        return mExceptionFields != null;
    }

    @JsonProperty("exceptionFields")
    public ExceptionFields getExceptionFields() {
        return mExceptionFields;
    }

    public boolean hasDefaultValues() {
        return mDefaultValues != null;
    }

    @JsonProperty("defaultValues")
    public DefaultValues getDefaultValues() {
        return mDefaultValues;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return numBooleanList() > 0;
            case 2: return numByteList() > 0;
            case 3: return numShortList() > 0;
            case 4: return numIntegerList() > 0;
            case 5: return numLongList() > 0;
            case 6: return numDoubleList() > 0;
            case 7: return numStringList() > 0;
            case 8: return numBinaryList() > 0;
            case 11: return numBooleanSet() > 0;
            case 12: return numByteSet() > 0;
            case 13: return numShortSet() > 0;
            case 14: return numIntegerSet() > 0;
            case 15: return numLongSet() > 0;
            case 16: return numDoubleSet() > 0;
            case 17: return numStringSet() > 0;
            case 18: return numBinarySet() > 0;
            case 21: return numBooleanMap() > 0;
            case 22: return numByteMap() > 0;
            case 23: return numShortMap() > 0;
            case 24: return numIntegerMap() > 0;
            case 25: return numLongMap() > 0;
            case 26: return numDoubleMap() > 0;
            case 27: return numStringMap() > 0;
            case 28: return numBinaryMap() > 0;
            case 31: return numEnumList() > 0;
            case 32: return numEnumSet() > 0;
            case 33: return numEnumMap() > 0;
            case 41: return numMessageList() > 0;
            case 42: return numMessageSet() > 0;
            case 43: return numMessageMap() > 0;
            case 51: return hasRequiredFields();
            case 52: return hasDefaultFields();
            case 53: return hasOptionalFields();
            case 54: return hasUnionFields();
            case 55: return hasExceptionFields();
            case 56: return hasDefaultValues();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return numBooleanList();
            case 2: return numByteList();
            case 3: return numShortList();
            case 4: return numIntegerList();
            case 5: return numLongList();
            case 6: return numDoubleList();
            case 7: return numStringList();
            case 8: return numBinaryList();
            case 11: return numBooleanSet();
            case 12: return numByteSet();
            case 13: return numShortSet();
            case 14: return numIntegerSet();
            case 15: return numLongSet();
            case 16: return numDoubleSet();
            case 17: return numStringSet();
            case 18: return numBinarySet();
            case 21: return numBooleanMap();
            case 22: return numByteMap();
            case 23: return numShortMap();
            case 24: return numIntegerMap();
            case 25: return numLongMap();
            case 26: return numDoubleMap();
            case 27: return numStringMap();
            case 28: return numBinaryMap();
            case 31: return numEnumList();
            case 32: return numEnumSet();
            case 33: return numEnumMap();
            case 41: return numMessageList();
            case 42: return numMessageSet();
            case 43: return numMessageMap();
            case 51: return hasRequiredFields() ? 1 : 0;
            case 52: return hasDefaultFields() ? 1 : 0;
            case 53: return hasOptionalFields() ? 1 : 0;
            case 54: return hasUnionFields() ? 1 : 0;
            case 55: return hasExceptionFields() ? 1 : 0;
            case 56: return hasDefaultValues() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getBooleanList();
            case 2: return getByteList();
            case 3: return getShortList();
            case 4: return getIntegerList();
            case 5: return getLongList();
            case 6: return getDoubleList();
            case 7: return getStringList();
            case 8: return getBinaryList();
            case 11: return getBooleanSet();
            case 12: return getByteSet();
            case 13: return getShortSet();
            case 14: return getIntegerSet();
            case 15: return getLongSet();
            case 16: return getDoubleSet();
            case 17: return getStringSet();
            case 18: return getBinarySet();
            case 21: return getBooleanMap();
            case 22: return getByteMap();
            case 23: return getShortMap();
            case 24: return getIntegerMap();
            case 25: return getLongMap();
            case 26: return getDoubleMap();
            case 27: return getStringMap();
            case 28: return getBinaryMap();
            case 31: return getEnumList();
            case 32: return getEnumSet();
            case 33: return getEnumMap();
            case 41: return getMessageList();
            case 42: return getMessageSet();
            case 43: return getMessageMap();
            case 51: return getRequiredFields();
            case 52: return getDefaultFields();
            case 53: return getOptionalFields();
            case 54: return getUnionFields();
            case 55: return getExceptionFields();
            case 56: return getDefaultValues();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Containers)) return false;
        Containers other = (Containers) o;
        return PTypeUtils.equals(mBooleanList, other.mBooleanList) &&
               PTypeUtils.equals(mByteList, other.mByteList) &&
               PTypeUtils.equals(mShortList, other.mShortList) &&
               PTypeUtils.equals(mIntegerList, other.mIntegerList) &&
               PTypeUtils.equals(mLongList, other.mLongList) &&
               PTypeUtils.equals(mDoubleList, other.mDoubleList) &&
               PTypeUtils.equals(mStringList, other.mStringList) &&
               PTypeUtils.equals(mBinaryList, other.mBinaryList) &&
               PTypeUtils.equals(mBooleanSet, other.mBooleanSet) &&
               PTypeUtils.equals(mByteSet, other.mByteSet) &&
               PTypeUtils.equals(mShortSet, other.mShortSet) &&
               PTypeUtils.equals(mIntegerSet, other.mIntegerSet) &&
               PTypeUtils.equals(mLongSet, other.mLongSet) &&
               PTypeUtils.equals(mDoubleSet, other.mDoubleSet) &&
               PTypeUtils.equals(mStringSet, other.mStringSet) &&
               PTypeUtils.equals(mBinarySet, other.mBinarySet) &&
               PTypeUtils.equals(mBooleanMap, other.mBooleanMap) &&
               PTypeUtils.equals(mByteMap, other.mByteMap) &&
               PTypeUtils.equals(mShortMap, other.mShortMap) &&
               PTypeUtils.equals(mIntegerMap, other.mIntegerMap) &&
               PTypeUtils.equals(mLongMap, other.mLongMap) &&
               PTypeUtils.equals(mDoubleMap, other.mDoubleMap) &&
               PTypeUtils.equals(mStringMap, other.mStringMap) &&
               PTypeUtils.equals(mBinaryMap, other.mBinaryMap) &&
               PTypeUtils.equals(mEnumList, other.mEnumList) &&
               PTypeUtils.equals(mEnumSet, other.mEnumSet) &&
               PTypeUtils.equals(mEnumMap, other.mEnumMap) &&
               PTypeUtils.equals(mMessageList, other.mMessageList) &&
               PTypeUtils.equals(mMessageSet, other.mMessageSet) &&
               PTypeUtils.equals(mMessageMap, other.mMessageMap) &&
               Objects.equals(mRequiredFields, other.mRequiredFields) &&
               Objects.equals(mDefaultFields, other.mDefaultFields) &&
               Objects.equals(mOptionalFields, other.mOptionalFields) &&
               Objects.equals(mUnionFields, other.mUnionFields) &&
               Objects.equals(mExceptionFields, other.mExceptionFields) &&
               Objects.equals(mDefaultValues, other.mDefaultValues);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Containers.class,
                    _Field.BOOLEAN_LIST, PTypeUtils.hashCode(mBooleanList),
                    _Field.BYTE_LIST, PTypeUtils.hashCode(mByteList),
                    _Field.SHORT_LIST, PTypeUtils.hashCode(mShortList),
                    _Field.INTEGER_LIST, PTypeUtils.hashCode(mIntegerList),
                    _Field.LONG_LIST, PTypeUtils.hashCode(mLongList),
                    _Field.DOUBLE_LIST, PTypeUtils.hashCode(mDoubleList),
                    _Field.STRING_LIST, PTypeUtils.hashCode(mStringList),
                    _Field.BINARY_LIST, PTypeUtils.hashCode(mBinaryList),
                    _Field.BOOLEAN_SET, PTypeUtils.hashCode(mBooleanSet),
                    _Field.BYTE_SET, PTypeUtils.hashCode(mByteSet),
                    _Field.SHORT_SET, PTypeUtils.hashCode(mShortSet),
                    _Field.INTEGER_SET, PTypeUtils.hashCode(mIntegerSet),
                    _Field.LONG_SET, PTypeUtils.hashCode(mLongSet),
                    _Field.DOUBLE_SET, PTypeUtils.hashCode(mDoubleSet),
                    _Field.STRING_SET, PTypeUtils.hashCode(mStringSet),
                    _Field.BINARY_SET, PTypeUtils.hashCode(mBinarySet),
                    _Field.BOOLEAN_MAP, PTypeUtils.hashCode(mBooleanMap),
                    _Field.BYTE_MAP, PTypeUtils.hashCode(mByteMap),
                    _Field.SHORT_MAP, PTypeUtils.hashCode(mShortMap),
                    _Field.INTEGER_MAP, PTypeUtils.hashCode(mIntegerMap),
                    _Field.LONG_MAP, PTypeUtils.hashCode(mLongMap),
                    _Field.DOUBLE_MAP, PTypeUtils.hashCode(mDoubleMap),
                    _Field.STRING_MAP, PTypeUtils.hashCode(mStringMap),
                    _Field.BINARY_MAP, PTypeUtils.hashCode(mBinaryMap),
                    _Field.ENUM_LIST, PTypeUtils.hashCode(mEnumList),
                    _Field.ENUM_SET, PTypeUtils.hashCode(mEnumSet),
                    _Field.ENUM_MAP, PTypeUtils.hashCode(mEnumMap),
                    _Field.MESSAGE_LIST, PTypeUtils.hashCode(mMessageList),
                    _Field.MESSAGE_SET, PTypeUtils.hashCode(mMessageSet),
                    _Field.MESSAGE_MAP, PTypeUtils.hashCode(mMessageMap),
                    _Field.REQUIRED_FIELDS, mRequiredFields,
                    _Field.DEFAULT_FIELDS, mDefaultFields,
                    _Field.OPTIONAL_FIELDS, mOptionalFields,
                    _Field.UNION_FIELDS, mUnionFields,
                    _Field.EXCEPTION_FIELDS, mExceptionFields,
                    _Field.DEFAULT_VALUES, mDefaultValues);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "test.Containers" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (numBooleanList() > 0) {
            first = false;
            out.append("booleanList:");
            out.append(PTypeUtils.toString(mBooleanList));
        }
        if (numByteList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("byteList:");
            out.append(PTypeUtils.toString(mByteList));
        }
        if (numShortList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("shortList:");
            out.append(PTypeUtils.toString(mShortList));
        }
        if (numIntegerList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("integerList:");
            out.append(PTypeUtils.toString(mIntegerList));
        }
        if (numLongList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("longList:");
            out.append(PTypeUtils.toString(mLongList));
        }
        if (numDoubleList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("doubleList:");
            out.append(PTypeUtils.toString(mDoubleList));
        }
        if (numStringList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("stringList:");
            out.append(PTypeUtils.toString(mStringList));
        }
        if (numBinaryList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("binaryList:");
            out.append(PTypeUtils.toString(mBinaryList));
        }
        if (numBooleanSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("booleanSet:");
            out.append(PTypeUtils.toString(mBooleanSet));
        }
        if (numByteSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("byteSet:");
            out.append(PTypeUtils.toString(mByteSet));
        }
        if (numShortSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("shortSet:");
            out.append(PTypeUtils.toString(mShortSet));
        }
        if (numIntegerSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("integerSet:");
            out.append(PTypeUtils.toString(mIntegerSet));
        }
        if (numLongSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("longSet:");
            out.append(PTypeUtils.toString(mLongSet));
        }
        if (numDoubleSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("doubleSet:");
            out.append(PTypeUtils.toString(mDoubleSet));
        }
        if (numStringSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("stringSet:");
            out.append(PTypeUtils.toString(mStringSet));
        }
        if (numBinarySet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("binarySet:");
            out.append(PTypeUtils.toString(mBinarySet));
        }
        if (numBooleanMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("booleanMap:");
            out.append(PTypeUtils.toString(mBooleanMap));
        }
        if (numByteMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("byteMap:");
            out.append(PTypeUtils.toString(mByteMap));
        }
        if (numShortMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("shortMap:");
            out.append(PTypeUtils.toString(mShortMap));
        }
        if (numIntegerMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("integerMap:");
            out.append(PTypeUtils.toString(mIntegerMap));
        }
        if (numLongMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("longMap:");
            out.append(PTypeUtils.toString(mLongMap));
        }
        if (numDoubleMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("doubleMap:");
            out.append(PTypeUtils.toString(mDoubleMap));
        }
        if (numStringMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("stringMap:");
            out.append(PTypeUtils.toString(mStringMap));
        }
        if (numBinaryMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("binaryMap:");
            out.append(PTypeUtils.toString(mBinaryMap));
        }
        if (numEnumList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("enumList:");
            out.append(PTypeUtils.toString(mEnumList));
        }
        if (numEnumSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("enumSet:");
            out.append(PTypeUtils.toString(mEnumSet));
        }
        if (numEnumMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("enumMap:");
            out.append(PTypeUtils.toString(mEnumMap));
        }
        if (numMessageList() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("messageList:");
            out.append(PTypeUtils.toString(mMessageList));
        }
        if (numMessageSet() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("messageSet:");
            out.append(PTypeUtils.toString(mMessageSet));
        }
        if (numMessageMap() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("messageMap:");
            out.append(PTypeUtils.toString(mMessageMap));
        }
        if (hasRequiredFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("requiredFields:");
            out.append(mRequiredFields.asString());
        }
        if (hasDefaultFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("defaultFields:");
            out.append(mDefaultFields.asString());
        }
        if (hasOptionalFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("optionalFields:");
            out.append(mOptionalFields.asString());
        }
        if (hasUnionFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("unionFields:");
            out.append(mUnionFields.asString());
        }
        if (hasExceptionFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("exceptionFields:");
            out.append(mExceptionFields.asString());
        }
        if (hasDefaultValues()) {
            if (!first) out.append(',');
            first = false;
            out.append("defaultValues:");
            out.append(mDefaultValues.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Containers other) {
        int c;

        c = Boolean.compare(mBooleanList != null, other.mBooleanList != null);
        if (c != 0) return c;
        if (mBooleanList != null) {
            c = Integer.compare(mBooleanList.hashCode(), other.mBooleanList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mByteList != null, other.mByteList != null);
        if (c != 0) return c;
        if (mByteList != null) {
            c = Integer.compare(mByteList.hashCode(), other.mByteList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mShortList != null, other.mShortList != null);
        if (c != 0) return c;
        if (mShortList != null) {
            c = Integer.compare(mShortList.hashCode(), other.mShortList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mIntegerList != null, other.mIntegerList != null);
        if (c != 0) return c;
        if (mIntegerList != null) {
            c = Integer.compare(mIntegerList.hashCode(), other.mIntegerList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mLongList != null, other.mLongList != null);
        if (c != 0) return c;
        if (mLongList != null) {
            c = Integer.compare(mLongList.hashCode(), other.mLongList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mDoubleList != null, other.mDoubleList != null);
        if (c != 0) return c;
        if (mDoubleList != null) {
            c = Integer.compare(mDoubleList.hashCode(), other.mDoubleList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mStringList != null, other.mStringList != null);
        if (c != 0) return c;
        if (mStringList != null) {
            c = Integer.compare(mStringList.hashCode(), other.mStringList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mBinaryList != null, other.mBinaryList != null);
        if (c != 0) return c;
        if (mBinaryList != null) {
            c = Integer.compare(mBinaryList.hashCode(), other.mBinaryList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mBooleanSet != null, other.mBooleanSet != null);
        if (c != 0) return c;
        if (mBooleanSet != null) {
            c = Integer.compare(mBooleanSet.hashCode(), other.mBooleanSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mByteSet != null, other.mByteSet != null);
        if (c != 0) return c;
        if (mByteSet != null) {
            c = Integer.compare(mByteSet.hashCode(), other.mByteSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mShortSet != null, other.mShortSet != null);
        if (c != 0) return c;
        if (mShortSet != null) {
            c = Integer.compare(mShortSet.hashCode(), other.mShortSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mIntegerSet != null, other.mIntegerSet != null);
        if (c != 0) return c;
        if (mIntegerSet != null) {
            c = Integer.compare(mIntegerSet.hashCode(), other.mIntegerSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mLongSet != null, other.mLongSet != null);
        if (c != 0) return c;
        if (mLongSet != null) {
            c = Integer.compare(mLongSet.hashCode(), other.mLongSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mDoubleSet != null, other.mDoubleSet != null);
        if (c != 0) return c;
        if (mDoubleSet != null) {
            c = Integer.compare(mDoubleSet.hashCode(), other.mDoubleSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mStringSet != null, other.mStringSet != null);
        if (c != 0) return c;
        if (mStringSet != null) {
            c = Integer.compare(mStringSet.hashCode(), other.mStringSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mBinarySet != null, other.mBinarySet != null);
        if (c != 0) return c;
        if (mBinarySet != null) {
            c = Integer.compare(mBinarySet.hashCode(), other.mBinarySet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mBooleanMap != null, other.mBooleanMap != null);
        if (c != 0) return c;
        if (mBooleanMap != null) {
            c = Integer.compare(mBooleanMap.hashCode(), other.mBooleanMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mByteMap != null, other.mByteMap != null);
        if (c != 0) return c;
        if (mByteMap != null) {
            c = Integer.compare(mByteMap.hashCode(), other.mByteMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mShortMap != null, other.mShortMap != null);
        if (c != 0) return c;
        if (mShortMap != null) {
            c = Integer.compare(mShortMap.hashCode(), other.mShortMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mIntegerMap != null, other.mIntegerMap != null);
        if (c != 0) return c;
        if (mIntegerMap != null) {
            c = Integer.compare(mIntegerMap.hashCode(), other.mIntegerMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mLongMap != null, other.mLongMap != null);
        if (c != 0) return c;
        if (mLongMap != null) {
            c = Integer.compare(mLongMap.hashCode(), other.mLongMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mDoubleMap != null, other.mDoubleMap != null);
        if (c != 0) return c;
        if (mDoubleMap != null) {
            c = Integer.compare(mDoubleMap.hashCode(), other.mDoubleMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mStringMap != null, other.mStringMap != null);
        if (c != 0) return c;
        if (mStringMap != null) {
            c = Integer.compare(mStringMap.hashCode(), other.mStringMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mBinaryMap != null, other.mBinaryMap != null);
        if (c != 0) return c;
        if (mBinaryMap != null) {
            c = Integer.compare(mBinaryMap.hashCode(), other.mBinaryMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mEnumList != null, other.mEnumList != null);
        if (c != 0) return c;
        if (mEnumList != null) {
            c = Integer.compare(mEnumList.hashCode(), other.mEnumList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mEnumSet != null, other.mEnumSet != null);
        if (c != 0) return c;
        if (mEnumSet != null) {
            c = Integer.compare(mEnumSet.hashCode(), other.mEnumSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mEnumMap != null, other.mEnumMap != null);
        if (c != 0) return c;
        if (mEnumMap != null) {
            c = Integer.compare(mEnumMap.hashCode(), other.mEnumMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mMessageList != null, other.mMessageList != null);
        if (c != 0) return c;
        if (mMessageList != null) {
            c = Integer.compare(mMessageList.hashCode(), other.mMessageList.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mMessageSet != null, other.mMessageSet != null);
        if (c != 0) return c;
        if (mMessageSet != null) {
            c = Integer.compare(mMessageSet.hashCode(), other.mMessageSet.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mMessageMap != null, other.mMessageMap != null);
        if (c != 0) return c;
        if (mMessageMap != null) {
            c = Integer.compare(mMessageMap.hashCode(), other.mMessageMap.hashCode());
            if (c != 0) return c;
        }

        c = Boolean.compare(mRequiredFields != null, other.mRequiredFields != null);
        if (c != 0) return c;
        if (mRequiredFields != null) {
            c = mRequiredFields.compareTo(other.mRequiredFields);
            if (c != 0) return c;
        }

        c = Boolean.compare(mDefaultFields != null, other.mDefaultFields != null);
        if (c != 0) return c;
        if (mDefaultFields != null) {
            c = mDefaultFields.compareTo(other.mDefaultFields);
            if (c != 0) return c;
        }

        c = Boolean.compare(mOptionalFields != null, other.mOptionalFields != null);
        if (c != 0) return c;
        if (mOptionalFields != null) {
            c = mOptionalFields.compareTo(other.mOptionalFields);
            if (c != 0) return c;
        }

        c = Boolean.compare(mUnionFields != null, other.mUnionFields != null);
        if (c != 0) return c;
        if (mUnionFields != null) {
            c = mUnionFields.compareTo(other.mUnionFields);
            if (c != 0) return c;
        }

        c = Boolean.compare(mExceptionFields != null, other.mExceptionFields != null);
        if (c != 0) return c;
        if (mExceptionFields != null) {
            c = mExceptionFields.compareTo(other.mExceptionFields);
            if (c != 0) return c;
        }

        c = Boolean.compare(mDefaultValues != null, other.mDefaultValues != null);
        if (c != 0) return c;
        if (mDefaultValues != null) {
            c = mDefaultValues.compareTo(other.mDefaultValues);
            if (c != 0) return c;
        }

        return 0;
    }

    public enum _Field implements PField {
        BOOLEAN_LIST(1, PRequirement.OPTIONAL, "booleanList", PList.provider(PPrimitive.BOOL.provider()), null),
        BYTE_LIST(2, PRequirement.OPTIONAL, "byteList", PList.provider(PPrimitive.BYTE.provider()), null),
        SHORT_LIST(3, PRequirement.OPTIONAL, "shortList", PList.provider(PPrimitive.I16.provider()), null),
        INTEGER_LIST(4, PRequirement.OPTIONAL, "integerList", PList.provider(PPrimitive.I32.provider()), null),
        LONG_LIST(5, PRequirement.OPTIONAL, "longList", PList.provider(PPrimitive.I64.provider()), null),
        DOUBLE_LIST(6, PRequirement.OPTIONAL, "doubleList", PList.provider(PPrimitive.DOUBLE.provider()), null),
        STRING_LIST(7, PRequirement.OPTIONAL, "stringList", PList.provider(PPrimitive.STRING.provider()), null),
        BINARY_LIST(8, PRequirement.OPTIONAL, "binaryList", PList.provider(PPrimitive.BINARY.provider()), null),
        BOOLEAN_SET(11, PRequirement.OPTIONAL, "booleanSet", PSet.provider(PPrimitive.BOOL.provider()), null),
        BYTE_SET(12, PRequirement.OPTIONAL, "byteSet", PSet.provider(PPrimitive.BYTE.provider()), null),
        SHORT_SET(13, PRequirement.OPTIONAL, "shortSet", PSet.provider(PPrimitive.I16.provider()), null),
        INTEGER_SET(14, PRequirement.OPTIONAL, "integerSet", PSet.provider(PPrimitive.I32.provider()), null),
        LONG_SET(15, PRequirement.OPTIONAL, "longSet", PSet.provider(PPrimitive.I64.provider()), null),
        DOUBLE_SET(16, PRequirement.OPTIONAL, "doubleSet", PSet.provider(PPrimitive.DOUBLE.provider()), null),
        STRING_SET(17, PRequirement.OPTIONAL, "stringSet", PSet.provider(PPrimitive.STRING.provider()), null),
        BINARY_SET(18, PRequirement.OPTIONAL, "binarySet", PSet.provider(PPrimitive.BINARY.provider()), null),
        BOOLEAN_MAP(21, PRequirement.OPTIONAL, "booleanMap", PMap.provider(PPrimitive.BOOL.provider(),PPrimitive.BOOL.provider()), null),
        BYTE_MAP(22, PRequirement.OPTIONAL, "byteMap", PMap.provider(PPrimitive.BYTE.provider(),PPrimitive.BYTE.provider()), null),
        SHORT_MAP(23, PRequirement.OPTIONAL, "shortMap", PMap.provider(PPrimitive.I16.provider(),PPrimitive.I16.provider()), null),
        INTEGER_MAP(24, PRequirement.OPTIONAL, "integerMap", PMap.provider(PPrimitive.I32.provider(),PPrimitive.I32.provider()), null),
        LONG_MAP(25, PRequirement.OPTIONAL, "longMap", PMap.provider(PPrimitive.I64.provider(),PPrimitive.I64.provider()), null),
        DOUBLE_MAP(26, PRequirement.OPTIONAL, "doubleMap", PMap.provider(PPrimitive.DOUBLE.provider(),PPrimitive.DOUBLE.provider()), null),
        STRING_MAP(27, PRequirement.OPTIONAL, "stringMap", PMap.provider(PPrimitive.STRING.provider(),PPrimitive.STRING.provider()), null),
        BINARY_MAP(28, PRequirement.OPTIONAL, "binaryMap", PMap.provider(PPrimitive.BINARY.provider(),PPrimitive.BINARY.provider()), null),
        ENUM_LIST(31, PRequirement.OPTIONAL, "enumList", PList.provider(Value.provider()), null),
        ENUM_SET(32, PRequirement.OPTIONAL, "enumSet", PSet.provider(Value.provider()), null),
        ENUM_MAP(33, PRequirement.OPTIONAL, "enumMap", PMap.provider(Value.provider(),Value.provider()), null),
        MESSAGE_LIST(41, PRequirement.OPTIONAL, "messageList", PList.provider(DefaultFields.provider()), null),
        MESSAGE_SET(42, PRequirement.OPTIONAL, "messageSet", PSet.provider(DefaultFields.provider()), null),
        MESSAGE_MAP(43, PRequirement.OPTIONAL, "messageMap", PMap.provider(PPrimitive.STRING.provider(),DefaultFields.provider()), null),
        REQUIRED_FIELDS(51, PRequirement.OPTIONAL, "requiredFields", RequiredFields.provider(), null),
        DEFAULT_FIELDS(52, PRequirement.OPTIONAL, "defaultFields", DefaultFields.provider(), null),
        OPTIONAL_FIELDS(53, PRequirement.OPTIONAL, "optionalFields", OptionalFields.provider(), null),
        UNION_FIELDS(54, PRequirement.OPTIONAL, "unionFields", UnionFields.provider(), null),
        EXCEPTION_FIELDS(55, PRequirement.OPTIONAL, "exceptionFields", ExceptionFields.provider(), null),
        DEFAULT_VALUES(56, PRequirement.OPTIONAL, "defaultValues", DefaultValues.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Containers._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.BOOLEAN_LIST;
                case 2: return _Field.BYTE_LIST;
                case 3: return _Field.SHORT_LIST;
                case 4: return _Field.INTEGER_LIST;
                case 5: return _Field.LONG_LIST;
                case 6: return _Field.DOUBLE_LIST;
                case 7: return _Field.STRING_LIST;
                case 8: return _Field.BINARY_LIST;
                case 11: return _Field.BOOLEAN_SET;
                case 12: return _Field.BYTE_SET;
                case 13: return _Field.SHORT_SET;
                case 14: return _Field.INTEGER_SET;
                case 15: return _Field.LONG_SET;
                case 16: return _Field.DOUBLE_SET;
                case 17: return _Field.STRING_SET;
                case 18: return _Field.BINARY_SET;
                case 21: return _Field.BOOLEAN_MAP;
                case 22: return _Field.BYTE_MAP;
                case 23: return _Field.SHORT_MAP;
                case 24: return _Field.INTEGER_MAP;
                case 25: return _Field.LONG_MAP;
                case 26: return _Field.DOUBLE_MAP;
                case 27: return _Field.STRING_MAP;
                case 28: return _Field.BINARY_MAP;
                case 31: return _Field.ENUM_LIST;
                case 32: return _Field.ENUM_SET;
                case 33: return _Field.ENUM_MAP;
                case 41: return _Field.MESSAGE_LIST;
                case 42: return _Field.MESSAGE_SET;
                case 43: return _Field.MESSAGE_MAP;
                case 51: return _Field.REQUIRED_FIELDS;
                case 52: return _Field.DEFAULT_FIELDS;
                case 53: return _Field.OPTIONAL_FIELDS;
                case 54: return _Field.UNION_FIELDS;
                case 55: return _Field.EXCEPTION_FIELDS;
                case 56: return _Field.DEFAULT_VALUES;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "booleanList": return _Field.BOOLEAN_LIST;
                case "byteList": return _Field.BYTE_LIST;
                case "shortList": return _Field.SHORT_LIST;
                case "integerList": return _Field.INTEGER_LIST;
                case "longList": return _Field.LONG_LIST;
                case "doubleList": return _Field.DOUBLE_LIST;
                case "stringList": return _Field.STRING_LIST;
                case "binaryList": return _Field.BINARY_LIST;
                case "booleanSet": return _Field.BOOLEAN_SET;
                case "byteSet": return _Field.BYTE_SET;
                case "shortSet": return _Field.SHORT_SET;
                case "integerSet": return _Field.INTEGER_SET;
                case "longSet": return _Field.LONG_SET;
                case "doubleSet": return _Field.DOUBLE_SET;
                case "stringSet": return _Field.STRING_SET;
                case "binarySet": return _Field.BINARY_SET;
                case "booleanMap": return _Field.BOOLEAN_MAP;
                case "byteMap": return _Field.BYTE_MAP;
                case "shortMap": return _Field.SHORT_MAP;
                case "integerMap": return _Field.INTEGER_MAP;
                case "longMap": return _Field.LONG_MAP;
                case "doubleMap": return _Field.DOUBLE_MAP;
                case "stringMap": return _Field.STRING_MAP;
                case "binaryMap": return _Field.BINARY_MAP;
                case "enumList": return _Field.ENUM_LIST;
                case "enumSet": return _Field.ENUM_SET;
                case "enumMap": return _Field.ENUM_MAP;
                case "messageList": return _Field.MESSAGE_LIST;
                case "messageSet": return _Field.MESSAGE_SET;
                case "messageMap": return _Field.MESSAGE_MAP;
                case "requiredFields": return _Field.REQUIRED_FIELDS;
                case "defaultFields": return _Field.DEFAULT_FIELDS;
                case "optionalFields": return _Field.OPTIONAL_FIELDS;
                case "unionFields": return _Field.UNION_FIELDS;
                case "exceptionFields": return _Field.EXCEPTION_FIELDS;
                case "defaultValues": return _Field.DEFAULT_VALUES;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<Containers,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<Containers,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<Containers,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<Containers,_Field> {
        public _Descriptor() {
            super(null, "test", "Containers", new _Factory(), false, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<Containers,_Field> {
        @Override
        public PStructDescriptor<Containers,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Containers> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (numBooleanList() > 0) {
            dest.writeInt(1);
            boolean[] arr = new boolean[mBooleanList.size()];
            int pos = 0;
            for (Boolean item : mBooleanList) {
                arr[pos++] = item;
            }
            dest.writeBooleanArray(arr);
        }
        if (numByteList() > 0) {
            dest.writeInt(2);
            byte[] arr = new byte[mByteList.size()];
            int pos = 0;
            for (Byte item : mByteList) {
                arr[pos++] = item;
            }
            dest.writeByteArray(arr);
        }
        if (numShortList() > 0) {
            dest.writeInt(3);
            int[] arr = new int[mShortList.size()];
            int pos = 0;
            for (Short item : mShortList) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numIntegerList() > 0) {
            dest.writeInt(4);
            int[] arr = new int[mIntegerList.size()];
            int pos = 0;
            for (Integer item : mIntegerList) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numLongList() > 0) {
            dest.writeInt(5);
            long[] arr = new long[mLongList.size()];
            int pos = 0;
            for (Long item : mLongList) {
                arr[pos++] = item;
            }
            dest.writeLongArray(arr);
        }
        if (numDoubleList() > 0) {
            dest.writeInt(6);
            double[] arr = new double[mDoubleList.size()];
            int pos = 0;
            for (Double item : mDoubleList) {
                arr[pos++] = item;
            }
            dest.writeDoubleArray(arr);
        }
        if (numStringList() > 0) {
            dest.writeInt(7);
            dest.writeStringArray(mStringList.toArray(new String[mStringList.size()]));
        }
        if (numBinaryList() > 0) {
            dest.writeInt(8);
            dest.writeInt(mBinaryList.size());
            for (Binary item : mBinaryList) {
                dest.writeByteArray(item.get());
            }
        }
        if (numBooleanSet() > 0) {
            dest.writeInt(11);
            boolean[] arr = new boolean[mBooleanSet.size()];
            int pos = 0;
            for (Boolean item : mBooleanSet) {
                arr[pos++] = item;
            }
            dest.writeBooleanArray(arr);
        }
        if (numByteSet() > 0) {
            dest.writeInt(12);
            byte[] arr = new byte[mByteSet.size()];
            int pos = 0;
            for (Byte item : mByteSet) {
                arr[pos++] = item;
            }
            dest.writeByteArray(arr);
        }
        if (numShortSet() > 0) {
            dest.writeInt(13);
            int[] arr = new int[mShortSet.size()];
            int pos = 0;
            for (Short item : mShortSet) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numIntegerSet() > 0) {
            dest.writeInt(14);
            int[] arr = new int[mIntegerSet.size()];
            int pos = 0;
            for (Integer item : mIntegerSet) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numLongSet() > 0) {
            dest.writeInt(15);
            long[] arr = new long[mLongSet.size()];
            int pos = 0;
            for (Long item : mLongSet) {
                arr[pos++] = item;
            }
            dest.writeLongArray(arr);
        }
        if (numDoubleSet() > 0) {
            dest.writeInt(16);
            double[] arr = new double[mDoubleSet.size()];
            int pos = 0;
            for (Double item : mDoubleSet) {
                arr[pos++] = item;
            }
            dest.writeDoubleArray(arr);
        }
        if (numStringSet() > 0) {
            dest.writeInt(17);
            dest.writeStringArray(mStringSet.toArray(new String[mStringSet.size()]));
        }
        if (numBinarySet() > 0) {
            dest.writeInt(18);
            dest.writeInt(mBinarySet.size());
            for (Binary item : mBinarySet) {
                dest.writeByteArray(item.get());
            }
        }
        if (numBooleanMap() > 0) {
            dest.writeInt(21);
            {
                boolean[] arr = new boolean[mBooleanMap.keySet().size()];
                int pos = 0;
                for (Boolean item : mBooleanMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeBooleanArray(arr);
            }
            boolean[] arr = new boolean[mBooleanMap.values().size()];
            int pos = 0;
            for (Boolean item : mBooleanMap.values()) {
                arr[pos++] = item;
            }
            dest.writeBooleanArray(arr);
        }
        if (numByteMap() > 0) {
            dest.writeInt(22);
            {
                byte[] arr = new byte[mByteMap.keySet().size()];
                int pos = 0;
                for (Byte item : mByteMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeByteArray(arr);
            }
            byte[] arr = new byte[mByteMap.values().size()];
            int pos = 0;
            for (Byte item : mByteMap.values()) {
                arr[pos++] = item;
            }
            dest.writeByteArray(arr);
        }
        if (numShortMap() > 0) {
            dest.writeInt(23);
            {
                int[] arr = new int[mShortMap.keySet().size()];
                int pos = 0;
                for (Short item : mShortMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeIntArray(arr);
            }
            int[] arr = new int[mShortMap.values().size()];
            int pos = 0;
            for (Short item : mShortMap.values()) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numIntegerMap() > 0) {
            dest.writeInt(24);
            {
                int[] arr = new int[mIntegerMap.keySet().size()];
                int pos = 0;
                for (Integer item : mIntegerMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeIntArray(arr);
            }
            int[] arr = new int[mIntegerMap.values().size()];
            int pos = 0;
            for (Integer item : mIntegerMap.values()) {
                arr[pos++] = item;
            }
            dest.writeIntArray(arr);
        }
        if (numLongMap() > 0) {
            dest.writeInt(25);
            {
                long[] arr = new long[mLongMap.keySet().size()];
                int pos = 0;
                for (Long item : mLongMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeLongArray(arr);
            }
            long[] arr = new long[mLongMap.values().size()];
            int pos = 0;
            for (Long item : mLongMap.values()) {
                arr[pos++] = item;
            }
            dest.writeLongArray(arr);
        }
        if (numDoubleMap() > 0) {
            dest.writeInt(26);
            {
                double[] arr = new double[mDoubleMap.keySet().size()];
                int pos = 0;
                for (Double item : mDoubleMap.keySet()) {
                    arr[pos++] = item;
                }
                dest.writeDoubleArray(arr);
            }
            double[] arr = new double[mDoubleMap.values().size()];
            int pos = 0;
            for (Double item : mDoubleMap.values()) {
                arr[pos++] = item;
            }
            dest.writeDoubleArray(arr);
        }
        if (numStringMap() > 0) {
            dest.writeInt(27);
            {
                dest.writeStringArray(mStringMap.keySet().toArray(new String[mStringMap.keySet().size()]));
            }
            dest.writeStringArray(mStringMap.values().toArray(new String[mStringMap.values().size()]));
        }
        if (numBinaryMap() > 0) {
            dest.writeInt(28);
            {
                dest.writeInt(mBinaryMap.keySet().size());
                for (Binary item : mBinaryMap.keySet()) {
                    dest.writeByteArray(item.get());
                }
            }
            dest.writeInt(mBinaryMap.values().size());
            for (Binary item : mBinaryMap.values()) {
                dest.writeByteArray(item.get());
            }
        }
        if (numEnumList() > 0) {
            dest.writeInt(31);
            int[] arr = new int[mEnumList.size()];
            int pos = 0;
            for (Value item : mEnumList) {
                arr[pos++] = item.getValue();
            }
            dest.writeIntArray(arr);
        }
        if (numEnumSet() > 0) {
            dest.writeInt(32);
            int[] arr = new int[mEnumSet.size()];
            int pos = 0;
            for (Value item : mEnumSet) {
                arr[pos++] = item.getValue();
            }
            dest.writeIntArray(arr);
        }
        if (numEnumMap() > 0) {
            dest.writeInt(33);
            {
                int[] arr = new int[mEnumMap.keySet().size()];
                int pos = 0;
                for (Value item : mEnumMap.keySet()) {
                    arr[pos++] = item.getValue();
                }
                dest.writeIntArray(arr);
            }
            int[] arr = new int[mEnumMap.values().size()];
            int pos = 0;
            for (Value item : mEnumMap.values()) {
                arr[pos++] = item.getValue();
            }
            dest.writeIntArray(arr);
        }
        if (numMessageList() > 0) {
            dest.writeInt(41);
            dest.writeTypedList(mMessageList);
        }
        if (numMessageSet() > 0) {
            dest.writeInt(42);
            dest.writeTypedList(new ArrayList<>(mMessageSet));
        }
        if (numMessageMap() > 0) {
            dest.writeInt(43);
            {
                dest.writeStringArray(mMessageMap.keySet().toArray(new String[mMessageMap.keySet().size()]));
            }
            dest.writeParcelableArray(mMessageMap.values().toArray(new DefaultFields[mMessageMap.values().size()]), 0);
        }
        if (hasRequiredFields()) {
            dest.writeInt(51);
            dest.writeTypedObject(mRequiredFields, 0);
        }
        if (hasDefaultFields()) {
            dest.writeInt(52);
            dest.writeTypedObject(mDefaultFields, 0);
        }
        if (hasOptionalFields()) {
            dest.writeInt(53);
            dest.writeTypedObject(mOptionalFields, 0);
        }
        if (hasUnionFields()) {
            dest.writeInt(54);
            dest.writeTypedObject(mUnionFields, 0);
        }
        if (hasExceptionFields()) {
            dest.writeInt(55);
            dest.writeTypedObject(mExceptionFields, 0);
        }
        if (hasDefaultValues()) {
            dest.writeInt(56);
            dest.writeTypedObject(mDefaultValues, 0);
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Containers> CREATOR = new Parcelable.Creator<Containers>() {
        @Override
        public Containers createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.addToBooleanList(source.createBooleanArray());
                        break;
                    }
                    case 2: {
                        builder.addToByteList(source.createByteArray());
                        break;
                    }
                    case 3: {
                        int[] tmp = source.createIntArray();
                        for (int i = 0; i < tmp.length; ++i) {
                            builder.addToShortList((short)tmp[i]);
                        }
                        break;
                    }
                    case 4: {
                        builder.addToIntegerList(source.createIntArray());
                        break;
                    }
                    case 5: {
                        builder.addToLongList(source.createLongArray());
                        break;
                    }
                    case 6: {
                        builder.addToDoubleList(source.createDoubleArray());
                        break;
                    }
                    case 7: {
                        builder.addToStringList(source.createStringArray());
                        break;
                    }
                    case 8: {
                        final int len = source.readInt();
                        for (int i = 0; i < len; ++i) {
                            builder.addToBinaryList(Binary.wrap(source.createByteArray()));
                        }
                        break;
                    }
                    case 11: {
                        builder.addToBooleanSet(source.createBooleanArray());
                        break;
                    }
                    case 12: {
                        builder.addToByteSet(source.createByteArray());
                        break;
                    }
                    case 13: {
                        int[] tmp = source.createIntArray();
                        for (int i = 0; i < tmp.length; ++i) {
                            builder.addToShortSet((short)tmp[i]);
                        }
                        break;
                    }
                    case 14: {
                        builder.addToIntegerSet(source.createIntArray());
                        break;
                    }
                    case 15: {
                        builder.addToLongSet(source.createLongArray());
                        break;
                    }
                    case 16: {
                        builder.addToDoubleSet(source.createDoubleArray());
                        break;
                    }
                    case 17: {
                        builder.addToStringSet(source.createStringArray());
                        break;
                    }
                    case 18: {
                        final int len = source.readInt();
                        for (int i = 0; i < len; ++i) {
                            builder.addToBinarySet(Binary.wrap(source.createByteArray()));
                        }
                        break;
                    }
                    case 21: {
                        boolean[] keys = source.createBooleanArray();
                        boolean[] values = source.createBooleanArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInBooleanMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 22: {
                        byte[] keys = source.createByteArray();
                        byte[] values = source.createByteArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInByteMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 23: {
                        int[] key_tmp = source.createIntArray();
                        short[] keys = new short[key_tmp.length];
                        for (int i = 0; i < key_tmp.length; ++i) {
                            keys[i] = (short) key_tmp[i];
                        }
                        int[] val_tmp = source.createIntArray();
                        short[] values = new short[val_tmp.length];
                        for (int i = 0; i < val_tmp.length; ++i) {
                            values[i] = (short) val_tmp[i];
                        }
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInShortMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 24: {
                        int[] keys = source.createIntArray();
                        int[] values = source.createIntArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInIntegerMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 25: {
                        long[] keys = source.createLongArray();
                        long[] values = source.createLongArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInLongMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 26: {
                        double[] keys = source.createDoubleArray();
                        double[] values = source.createDoubleArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInDoubleMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 27: {
                        String[] keys = source.createStringArray();
                        String[] values = source.createStringArray();
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInStringMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 28: {
                        final int len = source.readInt();
                        Binary[] keys = new Binary[len];
                        for (int i = 0; i < len; ++i) {
                            keys[i] = Binary.wrap(source.createByteArray());
                        }
                        Binary[] values = new Binary[keys.length];
                        for (int i = 0; i < keys.length; ++i) {
                            values[i] = Binary.wrap(source.createByteArray());
                        }
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInBinaryMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 31: {
                        int[] tmp = source.createIntArray();
                        Value[] values = new Value[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            values[i] = Value.forValue(tmp[i]);
                        }
                        builder.addToEnumList(values);
                        break;
                    }
                    case 32: {
                        int[] tmp = source.createIntArray();
                        Value[] values = new Value[tmp.length];
                        for (int i = 0; i < tmp.length; ++i) {
                            values[i] = Value.forValue(tmp[i]);
                        }
                        builder.addToEnumSet(values);
                        break;
                    }
                    case 33: {
                        int[] key_tmp = source.createIntArray();
                        Value[] keys = new Value[key_tmp.length];
                        for (int i = 0; i < key_tmp.length; ++i) {
                            keys[i] = Value.forValue(key_tmp[i]);
                        }
                        int[] val_tmp = source.createIntArray();
                        Value[] values = new Value[val_tmp.length];
                        for (int i = 0; i < val_tmp.length; ++i) {
                            values[i] = Value.forValue(val_tmp[i]);
                        }
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInEnumMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 41: {
                        builder.setMessageList(source.createTypedArrayList(DefaultFields.CREATOR));
                        break;
                    }
                    case 42: {
                        builder.setMessageSet(source.createTypedArrayList(DefaultFields.CREATOR));
                        break;
                    }
                    case 43: {
                        String[] keys = source.createStringArray();
                        DefaultFields[] values = source.createTypedArray(DefaultFields.CREATOR);
                        for (int i = 0; i < keys.length; ++i) {
                            builder.putInMessageMap(keys[i], values[i]);
                        }
                        break;
                    }
                    case 51: {
                        builder.setRequiredFields((RequiredFields) source.readTypedObject(RequiredFields.CREATOR));
                        break;
                    }
                    case 52: {
                        builder.setDefaultFields((DefaultFields) source.readTypedObject(DefaultFields.CREATOR));
                        break;
                    }
                    case 53: {
                        builder.setOptionalFields((OptionalFields) source.readTypedObject(OptionalFields.CREATOR));
                        break;
                    }
                    case 54: {
                        builder.setUnionFields((UnionFields) source.readTypedObject(UnionFields.CREATOR));
                        break;
                    }
                    case 55: {
                        builder.setExceptionFields((ExceptionFields) source.readTypedObject(ExceptionFields.CREATOR));
                        break;
                    }
                    case 56: {
                        builder.setDefaultValues((DefaultValues) source.readTypedObject(DefaultValues.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Containers[] newArray(int size) {
            return new Containers[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Containers> {
        private BitSet optionals;

        private List<Boolean> mBooleanList;
        private List<Byte> mByteList;
        private List<Short> mShortList;
        private List<Integer> mIntegerList;
        private List<Long> mLongList;
        private List<Double> mDoubleList;
        private List<String> mStringList;
        private List<Binary> mBinaryList;
        private Set<Boolean> mBooleanSet;
        private Set<Byte> mByteSet;
        private Set<Short> mShortSet;
        private Set<Integer> mIntegerSet;
        private Set<Long> mLongSet;
        private Set<Double> mDoubleSet;
        private Set<String> mStringSet;
        private Set<Binary> mBinarySet;
        private Map<Boolean,Boolean> mBooleanMap;
        private Map<Byte,Byte> mByteMap;
        private Map<Short,Short> mShortMap;
        private Map<Integer,Integer> mIntegerMap;
        private Map<Long,Long> mLongMap;
        private Map<Double,Double> mDoubleMap;
        private Map<String,String> mStringMap;
        private Map<Binary,Binary> mBinaryMap;
        private List<Value> mEnumList;
        private Set<Value> mEnumSet;
        private Map<Value,Value> mEnumMap;
        private List<DefaultFields> mMessageList;
        private Set<DefaultFields> mMessageSet;
        private Map<String,DefaultFields> mMessageMap;
        private RequiredFields mRequiredFields;
        private DefaultFields mDefaultFields;
        private OptionalFields mOptionalFields;
        private UnionFields mUnionFields;
        private ExceptionFields mExceptionFields;
        private DefaultValues mDefaultValues;


        public _Builder() {
            optionals = new BitSet(36);
            mBooleanList = new LinkedList<>();
            mByteList = new LinkedList<>();
            mShortList = new LinkedList<>();
            mIntegerList = new LinkedList<>();
            mLongList = new LinkedList<>();
            mDoubleList = new LinkedList<>();
            mStringList = new LinkedList<>();
            mBinaryList = new LinkedList<>();
            mBooleanSet = new TreeSet<>();
            mByteSet = new TreeSet<>();
            mShortSet = new TreeSet<>();
            mIntegerSet = new TreeSet<>();
            mLongSet = new TreeSet<>();
            mDoubleSet = new TreeSet<>();
            mStringSet = new TreeSet<>();
            mBinarySet = new TreeSet<>();
            mBooleanMap = new TreeMap<>();
            mByteMap = new TreeMap<>();
            mShortMap = new TreeMap<>();
            mIntegerMap = new TreeMap<>();
            mLongMap = new TreeMap<>();
            mDoubleMap = new TreeMap<>();
            mStringMap = new TreeMap<>();
            mBinaryMap = new TreeMap<>();
            mEnumList = new LinkedList<>();
            mEnumSet = new TreeSet<>();
            mEnumMap = new TreeMap<>();
            mMessageList = new LinkedList<>();
            mMessageSet = new TreeSet<>();
            mMessageMap = new TreeMap<>();
        }

        public _Builder(Containers base) {
            this();

            if (base.numBooleanList() > 0) {
                optionals.set(0);
                mBooleanList.addAll(base.mBooleanList);
            }
            if (base.numByteList() > 0) {
                optionals.set(1);
                mByteList.addAll(base.mByteList);
            }
            if (base.numShortList() > 0) {
                optionals.set(2);
                mShortList.addAll(base.mShortList);
            }
            if (base.numIntegerList() > 0) {
                optionals.set(3);
                mIntegerList.addAll(base.mIntegerList);
            }
            if (base.numLongList() > 0) {
                optionals.set(4);
                mLongList.addAll(base.mLongList);
            }
            if (base.numDoubleList() > 0) {
                optionals.set(5);
                mDoubleList.addAll(base.mDoubleList);
            }
            if (base.numStringList() > 0) {
                optionals.set(6);
                mStringList.addAll(base.mStringList);
            }
            if (base.numBinaryList() > 0) {
                optionals.set(7);
                mBinaryList.addAll(base.mBinaryList);
            }
            if (base.numBooleanSet() > 0) {
                optionals.set(8);
                mBooleanSet.addAll(base.mBooleanSet);
            }
            if (base.numByteSet() > 0) {
                optionals.set(9);
                mByteSet.addAll(base.mByteSet);
            }
            if (base.numShortSet() > 0) {
                optionals.set(10);
                mShortSet.addAll(base.mShortSet);
            }
            if (base.numIntegerSet() > 0) {
                optionals.set(11);
                mIntegerSet.addAll(base.mIntegerSet);
            }
            if (base.numLongSet() > 0) {
                optionals.set(12);
                mLongSet.addAll(base.mLongSet);
            }
            if (base.numDoubleSet() > 0) {
                optionals.set(13);
                mDoubleSet.addAll(base.mDoubleSet);
            }
            if (base.numStringSet() > 0) {
                optionals.set(14);
                mStringSet.addAll(base.mStringSet);
            }
            if (base.numBinarySet() > 0) {
                optionals.set(15);
                mBinarySet.addAll(base.mBinarySet);
            }
            if (base.numBooleanMap() > 0) {
                optionals.set(16);
                mBooleanMap.putAll(base.mBooleanMap);
            }
            if (base.numByteMap() > 0) {
                optionals.set(17);
                mByteMap.putAll(base.mByteMap);
            }
            if (base.numShortMap() > 0) {
                optionals.set(18);
                mShortMap.putAll(base.mShortMap);
            }
            if (base.numIntegerMap() > 0) {
                optionals.set(19);
                mIntegerMap.putAll(base.mIntegerMap);
            }
            if (base.numLongMap() > 0) {
                optionals.set(20);
                mLongMap.putAll(base.mLongMap);
            }
            if (base.numDoubleMap() > 0) {
                optionals.set(21);
                mDoubleMap.putAll(base.mDoubleMap);
            }
            if (base.numStringMap() > 0) {
                optionals.set(22);
                mStringMap.putAll(base.mStringMap);
            }
            if (base.numBinaryMap() > 0) {
                optionals.set(23);
                mBinaryMap.putAll(base.mBinaryMap);
            }
            if (base.numEnumList() > 0) {
                optionals.set(24);
                mEnumList.addAll(base.mEnumList);
            }
            if (base.numEnumSet() > 0) {
                optionals.set(25);
                mEnumSet.addAll(base.mEnumSet);
            }
            if (base.numEnumMap() > 0) {
                optionals.set(26);
                mEnumMap.putAll(base.mEnumMap);
            }
            if (base.numMessageList() > 0) {
                optionals.set(27);
                mMessageList.addAll(base.mMessageList);
            }
            if (base.numMessageSet() > 0) {
                optionals.set(28);
                mMessageSet.addAll(base.mMessageSet);
            }
            if (base.numMessageMap() > 0) {
                optionals.set(29);
                mMessageMap.putAll(base.mMessageMap);
            }
            if (base.hasRequiredFields()) {
                optionals.set(30);
                mRequiredFields = base.mRequiredFields;
            }
            if (base.hasDefaultFields()) {
                optionals.set(31);
                mDefaultFields = base.mDefaultFields;
            }
            if (base.hasOptionalFields()) {
                optionals.set(32);
                mOptionalFields = base.mOptionalFields;
            }
            if (base.hasUnionFields()) {
                optionals.set(33);
                mUnionFields = base.mUnionFields;
            }
            if (base.hasExceptionFields()) {
                optionals.set(34);
                mExceptionFields = base.mExceptionFields;
            }
            if (base.hasDefaultValues()) {
                optionals.set(35);
                mDefaultValues = base.mDefaultValues;
            }
        }

        /** all types as list<x>. */
        public _Builder setBooleanList(Collection<Boolean> value) {
            optionals.set(0);
            mBooleanList.clear();
            mBooleanList.addAll(value);
            return this;
        }
        /** all types as list<x>. */
        public _Builder addToBooleanList(boolean... values) {
            optionals.set(0);
            for (boolean item : values) {
                mBooleanList.add(item);
            }
            return this;
        }

        public _Builder clearBooleanList() {
            optionals.set(0, false);
            mBooleanList.clear();
            return this;
        }
        public _Builder setByteList(Collection<Byte> value) {
            optionals.set(1);
            mByteList.clear();
            mByteList.addAll(value);
            return this;
        }
        public _Builder addToByteList(byte... values) {
            optionals.set(1);
            for (byte item : values) {
                mByteList.add(item);
            }
            return this;
        }

        public _Builder clearByteList() {
            optionals.set(1, false);
            mByteList.clear();
            return this;
        }
        public _Builder setShortList(Collection<Short> value) {
            optionals.set(2);
            mShortList.clear();
            mShortList.addAll(value);
            return this;
        }
        public _Builder addToShortList(short... values) {
            optionals.set(2);
            for (short item : values) {
                mShortList.add(item);
            }
            return this;
        }

        public _Builder clearShortList() {
            optionals.set(2, false);
            mShortList.clear();
            return this;
        }
        public _Builder setIntegerList(Collection<Integer> value) {
            optionals.set(3);
            mIntegerList.clear();
            mIntegerList.addAll(value);
            return this;
        }
        public _Builder addToIntegerList(int... values) {
            optionals.set(3);
            for (int item : values) {
                mIntegerList.add(item);
            }
            return this;
        }

        public _Builder clearIntegerList() {
            optionals.set(3, false);
            mIntegerList.clear();
            return this;
        }
        public _Builder setLongList(Collection<Long> value) {
            optionals.set(4);
            mLongList.clear();
            mLongList.addAll(value);
            return this;
        }
        public _Builder addToLongList(long... values) {
            optionals.set(4);
            for (long item : values) {
                mLongList.add(item);
            }
            return this;
        }

        public _Builder clearLongList() {
            optionals.set(4, false);
            mLongList.clear();
            return this;
        }
        public _Builder setDoubleList(Collection<Double> value) {
            optionals.set(5);
            mDoubleList.clear();
            mDoubleList.addAll(value);
            return this;
        }
        public _Builder addToDoubleList(double... values) {
            optionals.set(5);
            for (double item : values) {
                mDoubleList.add(item);
            }
            return this;
        }

        public _Builder clearDoubleList() {
            optionals.set(5, false);
            mDoubleList.clear();
            return this;
        }
        public _Builder setStringList(Collection<String> value) {
            optionals.set(6);
            mStringList.clear();
            mStringList.addAll(value);
            return this;
        }
        public _Builder addToStringList(String... values) {
            optionals.set(6);
            for (String item : values) {
                mStringList.add(item);
            }
            return this;
        }

        public _Builder clearStringList() {
            optionals.set(6, false);
            mStringList.clear();
            return this;
        }
        public _Builder setBinaryList(Collection<Binary> value) {
            optionals.set(7);
            mBinaryList.clear();
            mBinaryList.addAll(value);
            return this;
        }
        public _Builder addToBinaryList(Binary... values) {
            optionals.set(7);
            for (Binary item : values) {
                mBinaryList.add(item);
            }
            return this;
        }

        public _Builder clearBinaryList() {
            optionals.set(7, false);
            mBinaryList.clear();
            return this;
        }
        /** all types as set<x>. */
        public _Builder setBooleanSet(Collection<Boolean> value) {
            optionals.set(8);
            mBooleanSet.clear();
            mBooleanSet.addAll(value);
            return this;
        }
        /** all types as set<x>. */
        public _Builder addToBooleanSet(boolean... values) {
            optionals.set(8);
            for (boolean item : values) {
                mBooleanSet.add(item);
            }
            return this;
        }

        public _Builder clearBooleanSet() {
            optionals.set(8, false);
            mBooleanSet.clear();
            return this;
        }
        public _Builder setByteSet(Collection<Byte> value) {
            optionals.set(9);
            mByteSet.clear();
            mByteSet.addAll(value);
            return this;
        }
        public _Builder addToByteSet(byte... values) {
            optionals.set(9);
            for (byte item : values) {
                mByteSet.add(item);
            }
            return this;
        }

        public _Builder clearByteSet() {
            optionals.set(9, false);
            mByteSet.clear();
            return this;
        }
        public _Builder setShortSet(Collection<Short> value) {
            optionals.set(10);
            mShortSet.clear();
            mShortSet.addAll(value);
            return this;
        }
        public _Builder addToShortSet(short... values) {
            optionals.set(10);
            for (short item : values) {
                mShortSet.add(item);
            }
            return this;
        }

        public _Builder clearShortSet() {
            optionals.set(10, false);
            mShortSet.clear();
            return this;
        }
        public _Builder setIntegerSet(Collection<Integer> value) {
            optionals.set(11);
            mIntegerSet.clear();
            mIntegerSet.addAll(value);
            return this;
        }
        public _Builder addToIntegerSet(int... values) {
            optionals.set(11);
            for (int item : values) {
                mIntegerSet.add(item);
            }
            return this;
        }

        public _Builder clearIntegerSet() {
            optionals.set(11, false);
            mIntegerSet.clear();
            return this;
        }
        public _Builder setLongSet(Collection<Long> value) {
            optionals.set(12);
            mLongSet.clear();
            mLongSet.addAll(value);
            return this;
        }
        public _Builder addToLongSet(long... values) {
            optionals.set(12);
            for (long item : values) {
                mLongSet.add(item);
            }
            return this;
        }

        public _Builder clearLongSet() {
            optionals.set(12, false);
            mLongSet.clear();
            return this;
        }
        public _Builder setDoubleSet(Collection<Double> value) {
            optionals.set(13);
            mDoubleSet.clear();
            mDoubleSet.addAll(value);
            return this;
        }
        public _Builder addToDoubleSet(double... values) {
            optionals.set(13);
            for (double item : values) {
                mDoubleSet.add(item);
            }
            return this;
        }

        public _Builder clearDoubleSet() {
            optionals.set(13, false);
            mDoubleSet.clear();
            return this;
        }
        public _Builder setStringSet(Collection<String> value) {
            optionals.set(14);
            mStringSet.clear();
            mStringSet.addAll(value);
            return this;
        }
        public _Builder addToStringSet(String... values) {
            optionals.set(14);
            for (String item : values) {
                mStringSet.add(item);
            }
            return this;
        }

        public _Builder clearStringSet() {
            optionals.set(14, false);
            mStringSet.clear();
            return this;
        }
        public _Builder setBinarySet(Collection<Binary> value) {
            optionals.set(15);
            mBinarySet.clear();
            mBinarySet.addAll(value);
            return this;
        }
        public _Builder addToBinarySet(Binary... values) {
            optionals.set(15);
            for (Binary item : values) {
                mBinarySet.add(item);
            }
            return this;
        }

        public _Builder clearBinarySet() {
            optionals.set(15, false);
            mBinarySet.clear();
            return this;
        }
        /** all types as map<x,x>. */
        public _Builder setBooleanMap(Map<Boolean,Boolean> value) {
            optionals.set(16);
            mBooleanMap.clear();
            mBooleanMap.putAll(value);
            return this;
        }
        /** all types as map<x,x>. */
        public _Builder putInBooleanMap(boolean key, boolean value) {
            optionals.set(16);
            mBooleanMap.put(key, value);
            return this;
        }

        public _Builder clearBooleanMap() {
            optionals.set(16, false);
            mBooleanMap.clear();
            return this;
        }
        public _Builder setByteMap(Map<Byte,Byte> value) {
            optionals.set(17);
            mByteMap.clear();
            mByteMap.putAll(value);
            return this;
        }
        public _Builder putInByteMap(byte key, byte value) {
            optionals.set(17);
            mByteMap.put(key, value);
            return this;
        }

        public _Builder clearByteMap() {
            optionals.set(17, false);
            mByteMap.clear();
            return this;
        }
        public _Builder setShortMap(Map<Short,Short> value) {
            optionals.set(18);
            mShortMap.clear();
            mShortMap.putAll(value);
            return this;
        }
        public _Builder putInShortMap(short key, short value) {
            optionals.set(18);
            mShortMap.put(key, value);
            return this;
        }

        public _Builder clearShortMap() {
            optionals.set(18, false);
            mShortMap.clear();
            return this;
        }
        public _Builder setIntegerMap(Map<Integer,Integer> value) {
            optionals.set(19);
            mIntegerMap.clear();
            mIntegerMap.putAll(value);
            return this;
        }
        public _Builder putInIntegerMap(int key, int value) {
            optionals.set(19);
            mIntegerMap.put(key, value);
            return this;
        }

        public _Builder clearIntegerMap() {
            optionals.set(19, false);
            mIntegerMap.clear();
            return this;
        }
        public _Builder setLongMap(Map<Long,Long> value) {
            optionals.set(20);
            mLongMap.clear();
            mLongMap.putAll(value);
            return this;
        }
        public _Builder putInLongMap(long key, long value) {
            optionals.set(20);
            mLongMap.put(key, value);
            return this;
        }

        public _Builder clearLongMap() {
            optionals.set(20, false);
            mLongMap.clear();
            return this;
        }
        public _Builder setDoubleMap(Map<Double,Double> value) {
            optionals.set(21);
            mDoubleMap.clear();
            mDoubleMap.putAll(value);
            return this;
        }
        public _Builder putInDoubleMap(double key, double value) {
            optionals.set(21);
            mDoubleMap.put(key, value);
            return this;
        }

        public _Builder clearDoubleMap() {
            optionals.set(21, false);
            mDoubleMap.clear();
            return this;
        }
        public _Builder setStringMap(Map<String,String> value) {
            optionals.set(22);
            mStringMap.clear();
            mStringMap.putAll(value);
            return this;
        }
        public _Builder putInStringMap(String key, String value) {
            optionals.set(22);
            mStringMap.put(key, value);
            return this;
        }

        public _Builder clearStringMap() {
            optionals.set(22, false);
            mStringMap.clear();
            return this;
        }
        public _Builder setBinaryMap(Map<Binary,Binary> value) {
            optionals.set(23);
            mBinaryMap.clear();
            mBinaryMap.putAll(value);
            return this;
        }
        public _Builder putInBinaryMap(Binary key, Binary value) {
            optionals.set(23);
            mBinaryMap.put(key, value);
            return this;
        }

        public _Builder clearBinaryMap() {
            optionals.set(23, false);
            mBinaryMap.clear();
            return this;
        }
        /** Using enum as key and value in containers. */
        public _Builder setEnumList(Collection<Value> value) {
            optionals.set(24);
            mEnumList.clear();
            mEnumList.addAll(value);
            return this;
        }
        /** Using enum as key and value in containers. */
        public _Builder addToEnumList(Value... values) {
            optionals.set(24);
            for (Value item : values) {
                mEnumList.add(item);
            }
            return this;
        }

        public _Builder clearEnumList() {
            optionals.set(24, false);
            mEnumList.clear();
            return this;
        }
        public _Builder setEnumSet(Collection<Value> value) {
            optionals.set(25);
            mEnumSet.clear();
            mEnumSet.addAll(value);
            return this;
        }
        public _Builder addToEnumSet(Value... values) {
            optionals.set(25);
            for (Value item : values) {
                mEnumSet.add(item);
            }
            return this;
        }

        public _Builder clearEnumSet() {
            optionals.set(25, false);
            mEnumSet.clear();
            return this;
        }
        public _Builder setEnumMap(Map<Value,Value> value) {
            optionals.set(26);
            mEnumMap.clear();
            mEnumMap.putAll(value);
            return this;
        }
        public _Builder putInEnumMap(Value key, Value value) {
            optionals.set(26);
            mEnumMap.put(key, value);
            return this;
        }

        public _Builder clearEnumMap() {
            optionals.set(26, false);
            mEnumMap.clear();
            return this;
        }
        /** Using struct as key and value in containers. */
        public _Builder setMessageList(Collection<DefaultFields> value) {
            optionals.set(27);
            mMessageList.clear();
            mMessageList.addAll(value);
            return this;
        }
        /** Using struct as key and value in containers. */
        public _Builder addToMessageList(DefaultFields... values) {
            optionals.set(27);
            for (DefaultFields item : values) {
                mMessageList.add(item);
            }
            return this;
        }

        public _Builder clearMessageList() {
            optionals.set(27, false);
            mMessageList.clear();
            return this;
        }
        public _Builder setMessageSet(Collection<DefaultFields> value) {
            optionals.set(28);
            mMessageSet.clear();
            mMessageSet.addAll(value);
            return this;
        }
        public _Builder addToMessageSet(DefaultFields... values) {
            optionals.set(28);
            for (DefaultFields item : values) {
                mMessageSet.add(item);
            }
            return this;
        }

        public _Builder clearMessageSet() {
            optionals.set(28, false);
            mMessageSet.clear();
            return this;
        }
        public _Builder setMessageMap(Map<String,DefaultFields> value) {
            optionals.set(29);
            mMessageMap.clear();
            mMessageMap.putAll(value);
            return this;
        }
        public _Builder putInMessageMap(String key, DefaultFields value) {
            optionals.set(29);
            mMessageMap.put(key, value);
            return this;
        }

        public _Builder clearMessageMap() {
            optionals.set(29, false);
            mMessageMap.clear();
            return this;
        }
        public _Builder setRequiredFields(RequiredFields value) {
            optionals.set(30);
            mRequiredFields = value;
            return this;
        }
        public _Builder clearRequiredFields() {
            optionals.set(30, false);
            mRequiredFields = null;
            return this;
        }
        public _Builder setDefaultFields(DefaultFields value) {
            optionals.set(31);
            mDefaultFields = value;
            return this;
        }
        public _Builder clearDefaultFields() {
            optionals.set(31, false);
            mDefaultFields = null;
            return this;
        }
        public _Builder setOptionalFields(OptionalFields value) {
            optionals.set(32);
            mOptionalFields = value;
            return this;
        }
        public _Builder clearOptionalFields() {
            optionals.set(32, false);
            mOptionalFields = null;
            return this;
        }
        public _Builder setUnionFields(UnionFields value) {
            optionals.set(33);
            mUnionFields = value;
            return this;
        }
        public _Builder clearUnionFields() {
            optionals.set(33, false);
            mUnionFields = null;
            return this;
        }
        public _Builder setExceptionFields(ExceptionFields value) {
            optionals.set(34);
            mExceptionFields = value;
            return this;
        }
        public _Builder clearExceptionFields() {
            optionals.set(34, false);
            mExceptionFields = null;
            return this;
        }
        public _Builder setDefaultValues(DefaultValues value) {
            optionals.set(35);
            mDefaultValues = value;
            return this;
        }
        public _Builder clearDefaultValues() {
            optionals.set(35, false);
            mDefaultValues = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setBooleanList((List<Boolean>) value); break;
                case 2: setByteList((List<Byte>) value); break;
                case 3: setShortList((List<Short>) value); break;
                case 4: setIntegerList((List<Integer>) value); break;
                case 5: setLongList((List<Long>) value); break;
                case 6: setDoubleList((List<Double>) value); break;
                case 7: setStringList((List<String>) value); break;
                case 8: setBinaryList((List<Binary>) value); break;
                case 11: setBooleanSet((Set<Boolean>) value); break;
                case 12: setByteSet((Set<Byte>) value); break;
                case 13: setShortSet((Set<Short>) value); break;
                case 14: setIntegerSet((Set<Integer>) value); break;
                case 15: setLongSet((Set<Long>) value); break;
                case 16: setDoubleSet((Set<Double>) value); break;
                case 17: setStringSet((Set<String>) value); break;
                case 18: setBinarySet((Set<Binary>) value); break;
                case 21: setBooleanMap((Map<Boolean,Boolean>) value); break;
                case 22: setByteMap((Map<Byte,Byte>) value); break;
                case 23: setShortMap((Map<Short,Short>) value); break;
                case 24: setIntegerMap((Map<Integer,Integer>) value); break;
                case 25: setLongMap((Map<Long,Long>) value); break;
                case 26: setDoubleMap((Map<Double,Double>) value); break;
                case 27: setStringMap((Map<String,String>) value); break;
                case 28: setBinaryMap((Map<Binary,Binary>) value); break;
                case 31: setEnumList((List<Value>) value); break;
                case 32: setEnumSet((Set<Value>) value); break;
                case 33: setEnumMap((Map<Value,Value>) value); break;
                case 41: setMessageList((List<DefaultFields>) value); break;
                case 42: setMessageSet((Set<DefaultFields>) value); break;
                case 43: setMessageMap((Map<String,DefaultFields>) value); break;
                case 51: setRequiredFields((RequiredFields) value); break;
                case 52: setDefaultFields((DefaultFields) value); break;
                case 53: setOptionalFields((OptionalFields) value); break;
                case 54: setUnionFields((UnionFields) value); break;
                case 55: setExceptionFields((ExceptionFields) value); break;
                case 56: setDefaultValues((DefaultValues) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 1: addToBooleanList((boolean) value); break;
                case 2: addToByteList((byte) value); break;
                case 3: addToShortList((short) value); break;
                case 4: addToIntegerList((int) value); break;
                case 5: addToLongList((long) value); break;
                case 6: addToDoubleList((double) value); break;
                case 7: addToStringList((String) value); break;
                case 8: addToBinaryList((Binary) value); break;
                case 11: addToBooleanSet((boolean) value); break;
                case 12: addToByteSet((byte) value); break;
                case 13: addToShortSet((short) value); break;
                case 14: addToIntegerSet((int) value); break;
                case 15: addToLongSet((long) value); break;
                case 16: addToDoubleSet((double) value); break;
                case 17: addToStringSet((String) value); break;
                case 18: addToBinarySet((Binary) value); break;
                case 31: addToEnumList((Value) value); break;
                case 32: addToEnumSet((Value) value); break;
                case 41: addToMessageList((DefaultFields) value); break;
                case 42: addToMessageSet((DefaultFields) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearBooleanList(); break;
                case 2: clearByteList(); break;
                case 3: clearShortList(); break;
                case 4: clearIntegerList(); break;
                case 5: clearLongList(); break;
                case 6: clearDoubleList(); break;
                case 7: clearStringList(); break;
                case 8: clearBinaryList(); break;
                case 11: clearBooleanSet(); break;
                case 12: clearByteSet(); break;
                case 13: clearShortSet(); break;
                case 14: clearIntegerSet(); break;
                case 15: clearLongSet(); break;
                case 16: clearDoubleSet(); break;
                case 17: clearStringSet(); break;
                case 18: clearBinarySet(); break;
                case 21: clearBooleanMap(); break;
                case 22: clearByteMap(); break;
                case 23: clearShortMap(); break;
                case 24: clearIntegerMap(); break;
                case 25: clearLongMap(); break;
                case 26: clearDoubleMap(); break;
                case 27: clearStringMap(); break;
                case 28: clearBinaryMap(); break;
                case 31: clearEnumList(); break;
                case 32: clearEnumSet(); break;
                case 33: clearEnumMap(); break;
                case 41: clearMessageList(); break;
                case 42: clearMessageSet(); break;
                case 43: clearMessageMap(); break;
                case 51: clearRequiredFields(); break;
                case 52: clearDefaultFields(); break;
                case 53: clearOptionalFields(); break;
                case 54: clearUnionFields(); break;
                case 55: clearExceptionFields(); break;
                case 56: clearDefaultValues(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Containers build() {
            return new Containers(this);
        }
    }
}
