package net.morimekta.test.providence;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/** @compact */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class CompactFields
        implements PMessage<CompactFields>, Serializable, Comparable<CompactFields>, Parcelable {
    private final static long serialVersionUID = 4165755115179900852L;

    private final static int kDefaultId = 0;

    private final String mName;
    private final int mId;
    private final String mLabel;
    
    private volatile int tHashCode;

    private CompactFields(_Builder builder) {
        mName = builder.mName;
        mId = builder.mId;
        mLabel = builder.mLabel;
    }

    @JsonCreator
    public CompactFields(@JsonProperty("name") String pName,
                         @JsonProperty("id") int pId,
                         @JsonProperty("label") String pLabel) {
        mName = pName;
        mId = pId;
        mLabel = pLabel;
    }

    public boolean hasName() {
        return mName != null;
    }

    @JsonProperty("name")
    public String getName() {
        return mName;
    }

    public boolean hasId() {
        return true;
    }

    @JsonProperty("id")
    public int getId() {
        return mId;
    }

    public boolean hasLabel() {
        return mLabel != null;
    }

    @JsonProperty("label")
    public String getLabel() {
        return mLabel;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasName();
            case 2: return true;
            case 3: return hasLabel();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasName() ? 1 : 0;
            case 2: return 1;
            case 3: return hasLabel() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getName();
            case 2: return getId();
            case 3: return getLabel();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        boolean missing = false;
        if (hasName()) {
            if (missing) return false;
        } else {
            missing = true;
        }
        if (missing) return false;
        if (hasLabel()) {
            if (missing) return false;
        } else {
            missing = true;
        }
        return true;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompactFields)) return false;
        CompactFields other = (CompactFields) o;
        return Objects.equals(mName, other.mName) &&
               Objects.equals(mId, other.mId) &&
               Objects.equals(mLabel, other.mLabel);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    CompactFields.class,
                    _Field.NAME, mName,
                    _Field.ID, mId,
                    _Field.LABEL, mLabel);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "test.CompactFields" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasName()) {
            first = false;
            out.append("name:");
            out.append('\"').append(mName).append('\"');
        }
        if (hasId()) {
            if (!first) out.append(',');
            first = false;
            out.append("id:");
            out.append(Integer.toString(mId));
        }
        if (hasLabel()) {
            if (!first) out.append(',');
            first = false;
            out.append("label:");
            out.append('\"').append(mLabel).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(CompactFields other) {
        int c;

        c = Boolean.compare(mName != null, other.mName != null);
        if (c != 0) return c;
        if (mName != null) {
            c = mName.compareTo(other.mName);
            if (c != 0) return c;
        }

        c = Integer.compare(mId, other.mId);
        if (c != 0) return c;

        c = Boolean.compare(mLabel != null, other.mLabel != null);
        if (c != 0) return c;
        if (mLabel != null) {
            c = mLabel.compareTo(other.mLabel);
            if (c != 0) return c;
        }

        return 0;
    }

    public enum _Field implements PField {
        NAME(1, PRequirement.REQUIRED, "name", PPrimitive.STRING.provider(), null),
        ID(2, PRequirement.REQUIRED, "id", PPrimitive.I32.provider(), null),
        LABEL(3, PRequirement.DEFAULT, "label", PPrimitive.STRING.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("CompactFields._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.NAME;
                case 2: return _Field.ID;
                case 3: return _Field.LABEL;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "name": return _Field.NAME;
                case "id": return _Field.ID;
                case "label": return _Field.LABEL;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<CompactFields,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<CompactFields,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<CompactFields,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<CompactFields,_Field> {
        public _Descriptor() {
            super(null, "test", "CompactFields", new _Factory(), true, true);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<CompactFields,_Field> {
        @Override
        public PStructDescriptor<CompactFields,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<CompactFields> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (hasName()) {
            dest.writeInt(1);
            dest.writeString(mName);
        }
        dest.writeInt(2);
        dest.writeInt(mId);
        if (hasLabel()) {
            dest.writeInt(3);
            dest.writeString(mLabel);
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<CompactFields> CREATOR = new Parcelable.Creator<CompactFields>() {
        @Override
        public CompactFields createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setName(source.readString());
                        break;
                    }
                    case 2: {
                        builder.setId(source.readInt());
                        break;
                    }
                    case 3: {
                        builder.setLabel(source.readString());
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public CompactFields[] newArray(int size) {
            return new CompactFields[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<CompactFields> {
        private BitSet optionals;

        private String mName;
        private int mId;
        private String mLabel;


        public _Builder() {
            optionals = new BitSet(3);
            mId = kDefaultId;
        }

        public _Builder(CompactFields base) {
            this();

            if (base.hasName()) {
                optionals.set(0);
                mName = base.mName;
            }
            optionals.set(1);
            mId = base.mId;
            if (base.hasLabel()) {
                optionals.set(2);
                mLabel = base.mLabel;
            }
        }

        public _Builder setName(String value) {
            optionals.set(0);
            mName = value;
            return this;
        }
        public _Builder clearName() {
            optionals.set(0, false);
            mName = null;
            return this;
        }
        public _Builder setId(int value) {
            optionals.set(1);
            mId = value;
            return this;
        }
        public _Builder clearId() {
            optionals.set(1, false);
            mId = kDefaultId;
            return this;
        }
        public _Builder setLabel(String value) {
            optionals.set(2);
            mLabel = value;
            return this;
        }
        public _Builder clearLabel() {
            optionals.set(2, false);
            mLabel = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setName((String) value); break;
                case 2: setId((int) value); break;
                case 3: setLabel((String) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearName(); break;
                case 2: clearId(); break;
                case 3: clearLabel(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return optionals.get(0) &&
                   optionals.get(1);
        }

        @Override
        public CompactFields build() {
            return new CompactFields(this);
        }
    }
}
