package net.morimekta.test.number;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Imaginary
        implements PMessage<Imaginary>, Serializable, Comparable<Imaginary>, Parcelable {
    private final static long serialVersionUID = 7869796731524194936L;

    private final static double kDefaultV = 0.0d;
    private final static double kDefaultI = 0.0d;

    private final double mV;
    private final double mI;
    
    private volatile int tHashCode;

    private Imaginary(_Builder builder) {
        mV = builder.mV;
        mI = builder.mI;
    }

    @JsonCreator
    public Imaginary(@JsonProperty("v") double pV,
                     @JsonProperty("i") double pI) {
        mV = pV;
        mI = pI;
    }

    public boolean hasV() {
        return true;
    }

    @JsonProperty("v")
    public double getV() {
        return mV;
    }

    public boolean hasI() {
        return true;
    }

    @JsonProperty("i")
    public double getI() {
        return mI;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return true;
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return 1;
            case 2: return 1;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getV();
            case 2: return getI();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Imaginary)) return false;
        Imaginary other = (Imaginary) o;
        return Objects.equals(mV, other.mV) &&
               Objects.equals(mI, other.mI);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Imaginary.class,
                    _Field.V, mV,
                    _Field.I, mI);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "number.Imaginary" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasV()) {
            first = false;
            out.append("v:");
            out.append(PTypeUtils.toString(mV));
        }
        if (hasI()) {
            if (!first) out.append(',');
            first = false;
            out.append("i:");
            out.append(PTypeUtils.toString(mI));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Imaginary other) {
        int c;

        c = Double.compare(mV, other.mV);
        if (c != 0) return c;

        c = Double.compare(mI, other.mI);
        if (c != 0) return c;

        return 0;
    }

    public enum _Field implements PField {
        V(1, PRequirement.REQUIRED, "v", PPrimitive.DOUBLE.provider(), null),
        I(2, PRequirement.DEFAULT, "i", PPrimitive.DOUBLE.provider(), new PDefaultValueProvider<>(kDefaultI)),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Imaginary._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.V;
                case 2: return _Field.I;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "v": return _Field.V;
                case "i": return _Field.I;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<Imaginary,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<Imaginary,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<Imaginary,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<Imaginary,_Field> {
        public _Descriptor() {
            super(null, "number", "Imaginary", new _Factory(), true, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<Imaginary,_Field> {
        @Override
        public PStructDescriptor<Imaginary,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Imaginary> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeDouble(mV);
        dest.writeInt(2);
        dest.writeDouble(mI);
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Imaginary> CREATOR = new Parcelable.Creator<Imaginary>() {
        @Override
        public Imaginary createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setV(source.readDouble());
                        break;
                    }
                    case 2: {
                        builder.setI(source.readDouble());
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Imaginary[] newArray(int size) {
            return new Imaginary[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Imaginary> {
        private BitSet optionals;

        private double mV;
        private double mI;


        public _Builder() {
            optionals = new BitSet(2);
            mV = kDefaultV;
            mI = kDefaultI;
        }

        public _Builder(Imaginary base) {
            this();

            optionals.set(0);
            mV = base.mV;
            optionals.set(1);
            mI = base.mI;
        }

        public _Builder setV(double value) {
            optionals.set(0);
            mV = value;
            return this;
        }
        public _Builder clearV() {
            optionals.set(0, false);
            mV = kDefaultV;
            return this;
        }
        public _Builder setI(double value) {
            optionals.set(1);
            mI = value;
            return this;
        }
        public _Builder clearI() {
            optionals.set(1, false);
            mI = kDefaultI;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setV((double) value); break;
                case 2: setI((double) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearV(); break;
                case 2: clearI(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return optionals.get(0);
        }

        @Override
        public Imaginary build() {
            return new Imaginary(this);
        }
    }
}
