package net.morimekta.test.naming;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Provider
        implements PMessage<Provider>, Serializable, Comparable<Provider>, Parcelable {
    private final static long serialVersionUID = -3787668908799447771L;

    private final static int kDefaultDescriptor = 0;
    private final static int kDefaultKDescriptor = 0;

    private final Provider mProvider;
    private final Factory mFactory;
    private final Builder mBuilder;
    private final Fields mFields;
    private final int mDescriptor;
    private final int mKDescriptor;
    
    private volatile int tHashCode;

    private Provider(_Builder builder) {
        mProvider = builder.mProvider;
        mFactory = builder.mFactory;
        mBuilder = builder.mBuilder;
        mFields = builder.mFields;
        mDescriptor = builder.mDescriptor;
        mKDescriptor = builder.mKDescriptor;
    }

    @JsonCreator
    public Provider(@JsonProperty("Provider") Provider pProvider,
                    @JsonProperty("Factory") Factory pFactory,
                    @JsonProperty("Builder") Builder pBuilder,
                    @JsonProperty("Fields") Fields pFields,
                    @JsonProperty("descriptor") int pDescriptor,
                    @JsonProperty("kDescriptor") int pKDescriptor) {
        mProvider = pProvider;
        mFactory = pFactory;
        mBuilder = pBuilder;
        mFields = pFields;
        mDescriptor = pDescriptor;
        mKDescriptor = pKDescriptor;
    }

    public boolean hasProvider() {
        return mProvider != null;
    }

    @JsonProperty("Provider")
    public Provider getProvider() {
        return mProvider;
    }

    public boolean hasFactory() {
        return mFactory != null;
    }

    @JsonProperty("Factory")
    public Factory getFactory() {
        return mFactory;
    }

    public boolean hasBuilder() {
        return mBuilder != null;
    }

    @JsonProperty("Builder")
    public Builder getBuilder() {
        return mBuilder;
    }

    public boolean hasFields() {
        return mFields != null;
    }

    @JsonProperty("Fields")
    public Fields getFields() {
        return mFields;
    }

    public boolean hasDescriptor() {
        return true;
    }

    @JsonProperty("descriptor")
    public int getDescriptor() {
        return mDescriptor;
    }

    public boolean hasKDescriptor() {
        return true;
    }

    @JsonProperty("kDescriptor")
    public int getKDescriptor() {
        return mKDescriptor;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasProvider();
            case 2: return hasFactory();
            case 3: return hasBuilder();
            case 4: return hasFields();
            case 5: return true;
            case 6: return true;
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasProvider() ? 1 : 0;
            case 2: return hasFactory() ? 1 : 0;
            case 3: return hasBuilder() ? 1 : 0;
            case 4: return hasFields() ? 1 : 0;
            case 5: return 1;
            case 6: return 1;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getProvider();
            case 2: return getFactory();
            case 3: return getBuilder();
            case 4: return getFields();
            case 5: return getDescriptor();
            case 6: return getKDescriptor();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Provider)) return false;
        Provider other = (Provider) o;
        return Objects.equals(mProvider, other.mProvider) &&
               Objects.equals(mFactory, other.mFactory) &&
               Objects.equals(mBuilder, other.mBuilder) &&
               Objects.equals(mFields, other.mFields) &&
               Objects.equals(mDescriptor, other.mDescriptor) &&
               Objects.equals(mKDescriptor, other.mKDescriptor);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Provider.class,
                    _Field.PROVIDER, mProvider,
                    _Field.FACTORY, mFactory,
                    _Field.BUILDER, mBuilder,
                    _Field.FIELDS, mFields,
                    _Field.DESCRIPTOR, mDescriptor,
                    _Field.K_DESCRIPTOR, mKDescriptor);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "naming.Provider" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasProvider()) {
            first = false;
            out.append("Provider:");
            out.append(mProvider.asString());
        }
        if (hasFactory()) {
            if (!first) out.append(',');
            first = false;
            out.append("Factory:");
            out.append(mFactory.asString());
        }
        if (hasBuilder()) {
            if (!first) out.append(',');
            first = false;
            out.append("Builder:");
            out.append(mBuilder.asString());
        }
        if (hasFields()) {
            if (!first) out.append(',');
            first = false;
            out.append("Fields:");
            out.append(mFields.getName());
        }
        if (hasDescriptor()) {
            if (!first) out.append(',');
            first = false;
            out.append("descriptor:");
            out.append(Integer.toString(mDescriptor));
        }
        if (hasKDescriptor()) {
            if (!first) out.append(',');
            first = false;
            out.append("kDescriptor:");
            out.append(Integer.toString(mKDescriptor));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Provider other) {
        int c;

        c = Boolean.compare(mProvider != null, other.mProvider != null);
        if (c != 0) return c;
        if (mProvider != null) {
            c = mProvider.compareTo(other.mProvider);
            if (c != 0) return c;
        }

        c = Boolean.compare(mFactory != null, other.mFactory != null);
        if (c != 0) return c;
        if (mFactory != null) {
            c = mFactory.compareTo(other.mFactory);
            if (c != 0) return c;
        }

        c = Boolean.compare(mBuilder != null, other.mBuilder != null);
        if (c != 0) return c;
        if (mBuilder != null) {
            c = mBuilder.compareTo(other.mBuilder);
            if (c != 0) return c;
        }

        c = Boolean.compare(mFields != null, other.mFields != null);
        if (c != 0) return c;
        if (mFields != null) {
            c = Integer.compare(mFields.getValue(), mFields.getValue());
            if (c != 0) return c;
        }

        c = Integer.compare(mDescriptor, other.mDescriptor);
        if (c != 0) return c;

        c = Integer.compare(mKDescriptor, other.mKDescriptor);
        if (c != 0) return c;

        return 0;
    }

    public enum _Field implements PField {
        PROVIDER(1, PRequirement.DEFAULT, "Provider", Provider.provider(), null),
        FACTORY(2, PRequirement.DEFAULT, "Factory", Factory.provider(), null),
        BUILDER(3, PRequirement.DEFAULT, "Builder", Builder.provider(), null),
        FIELDS(4, PRequirement.DEFAULT, "Fields", Fields.provider(), null),
        DESCRIPTOR(5, PRequirement.DEFAULT, "descriptor", PPrimitive.I32.provider(), null),
        K_DESCRIPTOR(6, PRequirement.DEFAULT, "kDescriptor", PPrimitive.I32.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Provider._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.PROVIDER;
                case 2: return _Field.FACTORY;
                case 3: return _Field.BUILDER;
                case 4: return _Field.FIELDS;
                case 5: return _Field.DESCRIPTOR;
                case 6: return _Field.K_DESCRIPTOR;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "Provider": return _Field.PROVIDER;
                case "Factory": return _Field.FACTORY;
                case "Builder": return _Field.BUILDER;
                case "Fields": return _Field.FIELDS;
                case "descriptor": return _Field.DESCRIPTOR;
                case "kDescriptor": return _Field.K_DESCRIPTOR;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<Provider,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<Provider,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<Provider,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<Provider,_Field> {
        public _Descriptor() {
            super(null, "naming", "Provider", new _Factory(), false, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<Provider,_Field> {
        @Override
        public PStructDescriptor<Provider,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Provider> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (hasProvider()) {
            dest.writeInt(1);
            dest.writeTypedObject(mProvider, 0);
        }
        if (hasFactory()) {
            dest.writeInt(2);
            dest.writeTypedObject(mFactory, 0);
        }
        if (hasBuilder()) {
            dest.writeInt(3);
            dest.writeTypedObject(mBuilder, 0);
        }
        if (hasFields()) {
            dest.writeInt(4);
            dest.writeInt(mFields.getValue());
        }
        dest.writeInt(5);
        dest.writeInt(mDescriptor);
        dest.writeInt(6);
        dest.writeInt(mKDescriptor);
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Provider> CREATOR = new Parcelable.Creator<Provider>() {
        @Override
        public Provider createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setProvider((Provider) source.readTypedObject(Provider.CREATOR));
                        break;
                    }
                    case 2: {
                        builder.setFactory((Factory) source.readTypedObject(Factory.CREATOR));
                        break;
                    }
                    case 3: {
                        builder.setBuilder((Builder) source.readTypedObject(Builder.CREATOR));
                        break;
                    }
                    case 4: {
                        builder.setFields(Fields.forValue(source.readInt()));
                        break;
                    }
                    case 5: {
                        builder.setDescriptor(source.readInt());
                        break;
                    }
                    case 6: {
                        builder.setKDescriptor(source.readInt());
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Provider[] newArray(int size) {
            return new Provider[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Provider> {
        private BitSet optionals;

        private Provider mProvider;
        private Factory mFactory;
        private Builder mBuilder;
        private Fields mFields;
        private int mDescriptor;
        private int mKDescriptor;


        public _Builder() {
            optionals = new BitSet(6);
            mDescriptor = kDefaultDescriptor;
            mKDescriptor = kDefaultKDescriptor;
        }

        public _Builder(Provider base) {
            this();

            if (base.hasProvider()) {
                optionals.set(0);
                mProvider = base.mProvider;
            }
            if (base.hasFactory()) {
                optionals.set(1);
                mFactory = base.mFactory;
            }
            if (base.hasBuilder()) {
                optionals.set(2);
                mBuilder = base.mBuilder;
            }
            if (base.hasFields()) {
                optionals.set(3);
                mFields = base.mFields;
            }
            optionals.set(4);
            mDescriptor = base.mDescriptor;
            optionals.set(5);
            mKDescriptor = base.mKDescriptor;
        }

        public _Builder setProvider(Provider value) {
            optionals.set(0);
            mProvider = value;
            return this;
        }
        public _Builder clearProvider() {
            optionals.set(0, false);
            mProvider = null;
            return this;
        }
        public _Builder setFactory(Factory value) {
            optionals.set(1);
            mFactory = value;
            return this;
        }
        public _Builder clearFactory() {
            optionals.set(1, false);
            mFactory = null;
            return this;
        }
        public _Builder setBuilder(Builder value) {
            optionals.set(2);
            mBuilder = value;
            return this;
        }
        public _Builder clearBuilder() {
            optionals.set(2, false);
            mBuilder = null;
            return this;
        }
        public _Builder setFields(Fields value) {
            optionals.set(3);
            mFields = value;
            return this;
        }
        public _Builder clearFields() {
            optionals.set(3, false);
            mFields = null;
            return this;
        }
        public _Builder setDescriptor(int value) {
            optionals.set(4);
            mDescriptor = value;
            return this;
        }
        public _Builder clearDescriptor() {
            optionals.set(4, false);
            mDescriptor = kDefaultDescriptor;
            return this;
        }
        public _Builder setKDescriptor(int value) {
            optionals.set(5);
            mKDescriptor = value;
            return this;
        }
        public _Builder clearKDescriptor() {
            optionals.set(5, false);
            mKDescriptor = kDefaultKDescriptor;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setProvider((Provider) value); break;
                case 2: setFactory((Factory) value); break;
                case 3: setBuilder((Builder) value); break;
                case 4: setFields((Fields) value); break;
                case 5: setDescriptor((int) value); break;
                case 6: setKDescriptor((int) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearProvider(); break;
                case 2: clearFactory(); break;
                case 3: clearBuilder(); break;
                case 4: clearFields(); break;
                case 5: clearDescriptor(); break;
                case 6: clearKDescriptor(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Provider build() {
            return new Provider(this);
        }
    }
}
