package net.morimekta.test.naming;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Fields implements PEnumValue<Fields> {
    SDESCRIPTOR(0, "sDescriptor"),
    MNAME(1, "mName"),
    MVALUE(2, "mValue"),
    FIELD(3, "Field"),
    ;

    private final int mValue;
    private final String mName;

    Fields(int value, String name) {
        mValue = value;
        mName = name;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public int getValue() {
        return mValue;
    }

    @JsonValue
    @Override
    public String getName() {
        return mName;
    }

    public static Fields forValue(int value) {
        switch (value) {
            case 0: return Fields.SDESCRIPTOR;
            case 1: return Fields.MNAME;
            case 2: return Fields.MVALUE;
            case 3: return Fields.FIELD;
            default: return null;
        }
    }

    @JsonCreator
    public static Fields forName(String name) {
        switch (name) {
            case "sDescriptor": return Fields.SDESCRIPTOR;
            case "mName": return Fields.MNAME;
            case "mValue": return Fields.MVALUE;
            case "Field": return Fields.FIELD;
            default: return null;
        }
    }

    public static class _Builder extends PEnumBuilder<Fields> {
        Fields mValue;

        @Override
        public _Builder setByValue(int value) {
            mValue = Fields.forValue(value);
            return this;
        }

        @Override
        public _Builder setByName(String name) {
            mValue = Fields.forName(name);
            return this;
        }

        @Override
        public boolean isValid() {
            return mValue != null;
        }

        @Override
        public Fields build() {
            return mValue;
        }
    }

    public static final PEnumDescriptor<Fields> kDescriptor;

    @Override
    public PEnumDescriptor<Fields> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<Fields> provider() {
        return new PEnumDescriptorProvider<Fields>(kDescriptor);
    }

    private static class _Factory
            extends PEnumBuilderFactory<Fields> {
        @Override
        public Fields._Builder builder() {
            return new Fields._Builder();
        }
    }

    private static class _Descriptor
            extends PEnumDescriptor<Fields> {
        public _Descriptor() {
            super(null, "naming", "Fields", new _Factory());
        }

        @Override
        public Fields[] getValues() {
            return Fields.values();
        }

        @Override
        public Fields getValueById(int id) {
            return Fields.forValue(id);
        }

        @Override
        public Fields getValueByName(String name) {
            return Fields.forName(name);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }
}
