package net.morimekta.test.naming;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class FieldNames
        implements PMessage<FieldNames>, Serializable, Comparable<FieldNames>, Parcelable {
    private final static long serialVersionUID = -4756841040616339832L;

    private final static int kDefaultLowercase = 0;
    private final static int kDefaultCamelCase = 0;
    private final static int kDefaultPascalCase = 0;
    private final static int kDefaultCCase = 0;
    private final static int kDefaultUPPERCASE = 0;
    private final static int kDefaultMixedCase = 0;

    private final int mLowercase;
    private final int mCamelCase;
    private final int mPascalCase;
    private final int mCCase;
    private final int mUPPERCASE;
    private final int mMixedCase;
    
    private volatile int tHashCode;

    private FieldNames(_Builder builder) {
        mLowercase = builder.mLowercase;
        mCamelCase = builder.mCamelCase;
        mPascalCase = builder.mPascalCase;
        mCCase = builder.mCCase;
        mUPPERCASE = builder.mUPPERCASE;
        mMixedCase = builder.mMixedCase;
    }

    @JsonCreator
    public FieldNames(@JsonProperty("lowercase") int pLowercase,
                      @JsonProperty("camelCase") int pCamelCase,
                      @JsonProperty("PascalCase") int pPascalCase,
                      @JsonProperty("c_case") int pCCase,
                      @JsonProperty("UPPER_CASE") int pUPPERCASE,
                      @JsonProperty("Mixed_Case") int pMixedCase) {
        mLowercase = pLowercase;
        mCamelCase = pCamelCase;
        mPascalCase = pPascalCase;
        mCCase = pCCase;
        mUPPERCASE = pUPPERCASE;
        mMixedCase = pMixedCase;
    }

    public boolean hasLowercase() {
        return true;
    }

    @JsonProperty("lowercase")
    public int getLowercase() {
        return mLowercase;
    }

    public boolean hasCamelCase() {
        return true;
    }

    @JsonProperty("camelCase")
    public int getCamelCase() {
        return mCamelCase;
    }

    public boolean hasPascalCase() {
        return true;
    }

    @JsonProperty("PascalCase")
    public int getPascalCase() {
        return mPascalCase;
    }

    public boolean hasCCase() {
        return true;
    }

    @JsonProperty("c_case")
    public int getCCase() {
        return mCCase;
    }

    public boolean hasUPPERCASE() {
        return true;
    }

    @JsonProperty("UPPER_CASE")
    public int getUPPERCASE() {
        return mUPPERCASE;
    }

    public boolean hasMixedCase() {
        return true;
    }

    @JsonProperty("Mixed_Case")
    public int getMixedCase() {
        return mMixedCase;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return true;
            case 2: return true;
            case 3: return true;
            case 4: return true;
            case 5: return true;
            case 6: return true;
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return 1;
            case 2: return 1;
            case 3: return 1;
            case 4: return 1;
            case 5: return 1;
            case 6: return 1;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getLowercase();
            case 2: return getCamelCase();
            case 3: return getPascalCase();
            case 4: return getCCase();
            case 5: return getUPPERCASE();
            case 6: return getMixedCase();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof FieldNames)) return false;
        FieldNames other = (FieldNames) o;
        return Objects.equals(mLowercase, other.mLowercase) &&
               Objects.equals(mCamelCase, other.mCamelCase) &&
               Objects.equals(mPascalCase, other.mPascalCase) &&
               Objects.equals(mCCase, other.mCCase) &&
               Objects.equals(mUPPERCASE, other.mUPPERCASE) &&
               Objects.equals(mMixedCase, other.mMixedCase);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    FieldNames.class,
                    _Field.LOWERCASE, mLowercase,
                    _Field.CAMEL_CASE, mCamelCase,
                    _Field.PASCAL_CASE, mPascalCase,
                    _Field.C_CASE, mCCase,
                    _Field.UPPER_CASE, mUPPERCASE,
                    _Field.MIXED_CASE, mMixedCase);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "naming.FieldNames" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasLowercase()) {
            first = false;
            out.append("lowercase:");
            out.append(Integer.toString(mLowercase));
        }
        if (hasCamelCase()) {
            if (!first) out.append(',');
            first = false;
            out.append("camelCase:");
            out.append(Integer.toString(mCamelCase));
        }
        if (hasPascalCase()) {
            if (!first) out.append(',');
            first = false;
            out.append("PascalCase:");
            out.append(Integer.toString(mPascalCase));
        }
        if (hasCCase()) {
            if (!first) out.append(',');
            first = false;
            out.append("c_case:");
            out.append(Integer.toString(mCCase));
        }
        if (hasUPPERCASE()) {
            if (!first) out.append(',');
            first = false;
            out.append("UPPER_CASE:");
            out.append(Integer.toString(mUPPERCASE));
        }
        if (hasMixedCase()) {
            if (!first) out.append(',');
            first = false;
            out.append("Mixed_Case:");
            out.append(Integer.toString(mMixedCase));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(FieldNames other) {
        int c;

        c = Integer.compare(mLowercase, other.mLowercase);
        if (c != 0) return c;

        c = Integer.compare(mCamelCase, other.mCamelCase);
        if (c != 0) return c;

        c = Integer.compare(mPascalCase, other.mPascalCase);
        if (c != 0) return c;

        c = Integer.compare(mCCase, other.mCCase);
        if (c != 0) return c;

        c = Integer.compare(mUPPERCASE, other.mUPPERCASE);
        if (c != 0) return c;

        c = Integer.compare(mMixedCase, other.mMixedCase);
        if (c != 0) return c;

        return 0;
    }

    public enum _Field implements PField {
        LOWERCASE(1, PRequirement.DEFAULT, "lowercase", PPrimitive.I32.provider(), null),
        CAMEL_CASE(2, PRequirement.DEFAULT, "camelCase", PPrimitive.I32.provider(), null),
        PASCAL_CASE(3, PRequirement.DEFAULT, "PascalCase", PPrimitive.I32.provider(), null),
        C_CASE(4, PRequirement.DEFAULT, "c_case", PPrimitive.I32.provider(), null),
        UPPER_CASE(5, PRequirement.DEFAULT, "UPPER_CASE", PPrimitive.I32.provider(), null),
        MIXED_CASE(6, PRequirement.DEFAULT, "Mixed_Case", PPrimitive.I32.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FieldNames._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.LOWERCASE;
                case 2: return _Field.CAMEL_CASE;
                case 3: return _Field.PASCAL_CASE;
                case 4: return _Field.C_CASE;
                case 5: return _Field.UPPER_CASE;
                case 6: return _Field.MIXED_CASE;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "lowercase": return _Field.LOWERCASE;
                case "camelCase": return _Field.CAMEL_CASE;
                case "PascalCase": return _Field.PASCAL_CASE;
                case "c_case": return _Field.C_CASE;
                case "UPPER_CASE": return _Field.UPPER_CASE;
                case "Mixed_Case": return _Field.MIXED_CASE;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<FieldNames,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<FieldNames,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<FieldNames,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<FieldNames,_Field> {
        public _Descriptor() {
            super(null, "naming", "FieldNames", new _Factory(), true, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<FieldNames,_Field> {
        @Override
        public PStructDescriptor<FieldNames,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<FieldNames> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(1);
        dest.writeInt(mLowercase);
        dest.writeInt(2);
        dest.writeInt(mCamelCase);
        dest.writeInt(3);
        dest.writeInt(mPascalCase);
        dest.writeInt(4);
        dest.writeInt(mCCase);
        dest.writeInt(5);
        dest.writeInt(mUPPERCASE);
        dest.writeInt(6);
        dest.writeInt(mMixedCase);
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<FieldNames> CREATOR = new Parcelable.Creator<FieldNames>() {
        @Override
        public FieldNames createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setLowercase(source.readInt());
                        break;
                    }
                    case 2: {
                        builder.setCamelCase(source.readInt());
                        break;
                    }
                    case 3: {
                        builder.setPascalCase(source.readInt());
                        break;
                    }
                    case 4: {
                        builder.setCCase(source.readInt());
                        break;
                    }
                    case 5: {
                        builder.setUPPERCASE(source.readInt());
                        break;
                    }
                    case 6: {
                        builder.setMixedCase(source.readInt());
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public FieldNames[] newArray(int size) {
            return new FieldNames[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<FieldNames> {
        private BitSet optionals;

        private int mLowercase;
        private int mCamelCase;
        private int mPascalCase;
        private int mCCase;
        private int mUPPERCASE;
        private int mMixedCase;


        public _Builder() {
            optionals = new BitSet(6);
            mLowercase = kDefaultLowercase;
            mCamelCase = kDefaultCamelCase;
            mPascalCase = kDefaultPascalCase;
            mCCase = kDefaultCCase;
            mUPPERCASE = kDefaultUPPERCASE;
            mMixedCase = kDefaultMixedCase;
        }

        public _Builder(FieldNames base) {
            this();

            optionals.set(0);
            mLowercase = base.mLowercase;
            optionals.set(1);
            mCamelCase = base.mCamelCase;
            optionals.set(2);
            mPascalCase = base.mPascalCase;
            optionals.set(3);
            mCCase = base.mCCase;
            optionals.set(4);
            mUPPERCASE = base.mUPPERCASE;
            optionals.set(5);
            mMixedCase = base.mMixedCase;
        }

        public _Builder setLowercase(int value) {
            optionals.set(0);
            mLowercase = value;
            return this;
        }
        public _Builder clearLowercase() {
            optionals.set(0, false);
            mLowercase = kDefaultLowercase;
            return this;
        }
        public _Builder setCamelCase(int value) {
            optionals.set(1);
            mCamelCase = value;
            return this;
        }
        public _Builder clearCamelCase() {
            optionals.set(1, false);
            mCamelCase = kDefaultCamelCase;
            return this;
        }
        public _Builder setPascalCase(int value) {
            optionals.set(2);
            mPascalCase = value;
            return this;
        }
        public _Builder clearPascalCase() {
            optionals.set(2, false);
            mPascalCase = kDefaultPascalCase;
            return this;
        }
        public _Builder setCCase(int value) {
            optionals.set(3);
            mCCase = value;
            return this;
        }
        public _Builder clearCCase() {
            optionals.set(3, false);
            mCCase = kDefaultCCase;
            return this;
        }
        public _Builder setUPPERCASE(int value) {
            optionals.set(4);
            mUPPERCASE = value;
            return this;
        }
        public _Builder clearUPPERCASE() {
            optionals.set(4, false);
            mUPPERCASE = kDefaultUPPERCASE;
            return this;
        }
        public _Builder setMixedCase(int value) {
            optionals.set(5);
            mMixedCase = value;
            return this;
        }
        public _Builder clearMixedCase() {
            optionals.set(5, false);
            mMixedCase = kDefaultMixedCase;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setLowercase((int) value); break;
                case 2: setCamelCase((int) value); break;
                case 3: setPascalCase((int) value); break;
                case 4: setCCase((int) value); break;
                case 5: setUPPERCASE((int) value); break;
                case 6: setMixedCase((int) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearLowercase(); break;
                case 2: clearCamelCase(); break;
                case 3: clearPascalCase(); break;
                case 4: clearCCase(); break;
                case 5: clearUPPERCASE(); break;
                case 6: clearMixedCase(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public FieldNames build() {
            return new FieldNames(this);
        }
    }
}
