package net.morimekta.test.naming;

import java.io.Serializable;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Factory
        implements PUnion<Factory>, Serializable, Comparable<Factory>, Parcelable {
    private final static long serialVersionUID = 3315959901235104548L;

    private final Provider mFactory;

    private final _Field tUnionField;
    
    private volatile int tHashCode;

    private Factory(_Builder builder) {
        tUnionField = builder.tUnionField;

        mFactory = tUnionField == _Field.FACTORY ? builder.mFactory : null;
    }

    public static Factory withFactory(Provider value) {
        return new _Builder().setFactory(value).build();
    }

    public boolean hasFactory() {
        return tUnionField == _Field.FACTORY && mFactory != null;
    }

    @JsonProperty("Factory")
    public Provider getFactory() {
        return mFactory;
    }

    @Override
    public _Field unionField() {
        return tUnionField;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasFactory();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasFactory() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getFactory();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Factory)) return false;
        Factory other = (Factory) o;
        return Objects.equals(tUnionField, other.tUnionField) &&
               Objects.equals(mFactory, other.mFactory);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Factory.class,
                    _Field.FACTORY, mFactory);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "naming.Factory" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        switch (tUnionField) {
            case FACTORY: {
                out.append("Factory:");
                out.append(mFactory.asString());
                break;
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Factory other) {
        int c = Integer.compare(tUnionField.getKey(), other.tUnionField.getKey());
        if (c != 0) return c;

        switch (tUnionField) {
            case FACTORY:
                return mFactory.compareTo(other.mFactory);
            default: return 0;
        }
    }

    public enum _Field implements PField {
        FACTORY(1, PRequirement.DEFAULT, "Factory", Provider.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Factory._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.FACTORY;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "Factory": return _Field.FACTORY;
            }
            return null;
        }
    }

    public static PUnionDescriptorProvider<Factory,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PUnionDescriptor<Factory,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PUnionDescriptor<Factory,_Field> kDescriptor;

    private static class _Descriptor
            extends PUnionDescriptor<Factory,_Field> {
        public _Descriptor() {
            super(null, "naming", "Factory", new _Factory(), false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PUnionDescriptorProvider<Factory,_Field> {
        @Override
        public PUnionDescriptor<Factory,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Factory> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (tUnionField != null) {
            switch (tUnionField) {
                case FACTORY:
                    dest.writeInt(1);
                    dest.writeTypedObject(mFactory, 0);
                    break;
            }
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Factory> CREATOR = new Parcelable.Creator<Factory>() {
        @Override
        public Factory createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setFactory((Provider) source.readTypedObject(Provider.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Factory[] newArray(int size) {
            return new Factory[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Factory> {
        private _Field tUnionField;

        private Provider mFactory;


        public _Builder() {
        }

        public _Builder(Factory base) {
            this();

            tUnionField = base.tUnionField;

            mFactory = base.mFactory;
        }

        public _Builder setFactory(Provider value) {
            tUnionField = _Field.FACTORY;
            mFactory = value;
            return this;
        }
        public _Builder clearFactory() {
            if (tUnionField == _Field.FACTORY) tUnionField = null;
            mFactory = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setFactory((Provider) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearFactory(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return tUnionField != null;
        }

        @Override
        public Factory build() {
            return new Factory(this);
        }
    }
}
