package net.morimekta.test.naming;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum EnumNames implements PEnumValue<EnumNames> {
    LOWERCASE(0, "lowercase"),
    CAMELCASE(1, "camelCase"),
    PASCALCASE(2, "PascalCase"),
    C_CASE(3, "c_case"),
    UPPER_CASE(4, "UPPER_CASE"),
    MIXED_CASE(5, "Mixed_Case"),
    ;

    private final int mValue;
    private final String mName;

    EnumNames(int value, String name) {
        mValue = value;
        mName = name;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public int getValue() {
        return mValue;
    }

    @JsonValue
    @Override
    public String getName() {
        return mName;
    }

    public static EnumNames forValue(int value) {
        switch (value) {
            case 0: return EnumNames.LOWERCASE;
            case 1: return EnumNames.CAMELCASE;
            case 2: return EnumNames.PASCALCASE;
            case 3: return EnumNames.C_CASE;
            case 4: return EnumNames.UPPER_CASE;
            case 5: return EnumNames.MIXED_CASE;
            default: return null;
        }
    }

    @JsonCreator
    public static EnumNames forName(String name) {
        switch (name) {
            case "lowercase": return EnumNames.LOWERCASE;
            case "camelCase": return EnumNames.CAMELCASE;
            case "PascalCase": return EnumNames.PASCALCASE;
            case "c_case": return EnumNames.C_CASE;
            case "UPPER_CASE": return EnumNames.UPPER_CASE;
            case "Mixed_Case": return EnumNames.MIXED_CASE;
            default: return null;
        }
    }

    public static class _Builder extends PEnumBuilder<EnumNames> {
        EnumNames mValue;

        @Override
        public _Builder setByValue(int value) {
            mValue = EnumNames.forValue(value);
            return this;
        }

        @Override
        public _Builder setByName(String name) {
            mValue = EnumNames.forName(name);
            return this;
        }

        @Override
        public boolean isValid() {
            return mValue != null;
        }

        @Override
        public EnumNames build() {
            return mValue;
        }
    }

    public static final PEnumDescriptor<EnumNames> kDescriptor;

    @Override
    public PEnumDescriptor<EnumNames> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<EnumNames> provider() {
        return new PEnumDescriptorProvider<EnumNames>(kDescriptor);
    }

    private static class _Factory
            extends PEnumBuilderFactory<EnumNames> {
        @Override
        public EnumNames._Builder builder() {
            return new EnumNames._Builder();
        }
    }

    private static class _Descriptor
            extends PEnumDescriptor<EnumNames> {
        public _Descriptor() {
            super(null, "naming", "EnumNames", new _Factory());
        }

        @Override
        public EnumNames[] getValues() {
            return EnumNames.values();
        }

        @Override
        public EnumNames getValueById(int id) {
            return EnumNames.forValue(id);
        }

        @Override
        public EnumNames getValueByName(String name) {
            return EnumNames.forName(name);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }
}
