package net.morimekta.test.naming;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PException;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.descriptor.PExceptionDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PValueProvider;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/** @deprecated */
@Deprecated
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Builder
        extends PException
        implements PMessage<Builder>, Serializable, Comparable<Builder>, Parcelable {
    private final static long serialVersionUID = 642363033467540783L;

    private final Builder mBuilder;
    
    private volatile int tHashCode;

    private Builder(_Builder builder) {
        super(builder.createMessage());

        mBuilder = builder.mBuilder;
    }

    public boolean hasBuilder() {
        return mBuilder != null;
    }

    /** @deprecated */
    @Deprecated
    @JsonProperty("Builder")
    public Builder getBuilder() {
        return mBuilder;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasBuilder();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasBuilder() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getBuilder();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Builder)) return false;
        Builder other = (Builder) o;
        return Objects.equals(mBuilder, other.mBuilder);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Builder.class,
                    _Field.BUILDER, mBuilder);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "naming.Builder" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasBuilder()) {
            first = false;
            out.append("Builder:");
            out.append(mBuilder.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Builder other) {
        int c;

        c = Boolean.compare(mBuilder != null, other.mBuilder != null);
        if (c != 0) return c;
        if (mBuilder != null) {
            c = mBuilder.compareTo(other.mBuilder);
            if (c != 0) return c;
        }

        return 0;
    }

    public enum _Field implements PField {
        BUILDER(1, PRequirement.DEFAULT, "Builder", Builder.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Builder._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.BUILDER;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "Builder": return _Field.BUILDER;
            }
            return null;
        }
    }

    public static PExceptionDescriptorProvider<Builder,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PExceptionDescriptor<Builder,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PExceptionDescriptor<Builder,_Field> kDescriptor;

    private static class _Descriptor
            extends PExceptionDescriptor<Builder,_Field> {
        public _Descriptor() {
            super(null, "naming", "Builder", new _Factory(), false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PExceptionDescriptorProvider<Builder,_Field> {
        @Override
        public PExceptionDescriptor<Builder,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Builder> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (hasBuilder()) {
            dest.writeInt(1);
            dest.writeTypedObject(mBuilder, 0);
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Builder> CREATOR = new Parcelable.Creator<Builder>() {
        @Override
        public Builder createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setBuilder((Builder) source.readTypedObject(Builder.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Builder[] newArray(int size) {
            return new Builder[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Builder> {
        private BitSet optionals;

        private Builder mBuilder;


        public _Builder() {
            optionals = new BitSet(1);
        }

        public _Builder(Builder base) {
            this();

            if (base.hasBuilder()) {
                optionals.set(0);
                mBuilder = base.mBuilder;
            }
        }

        /** @deprecated */
        @Deprecated
        public _Builder setBuilder(Builder value) {
            optionals.set(0);
            mBuilder = value;
            return this;
        }
        public _Builder clearBuilder() {
            optionals.set(0, false);
            mBuilder = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setBuilder((Builder) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearBuilder(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        protected String createMessage() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            boolean first = true;
            if (mBuilder != null) {
                if (first) first = false;
                else builder.append(',');
                builder.append("Builder:")
                       .append(mBuilder.asString());
            }
            builder.append('}');
            return builder.toString();
        }

        @Override
        public Builder build() {
            return new Builder(this);
        }
    }
}
