package net.morimekta.test.calculator;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Operation
        implements PMessage<Operation>, Serializable, Comparable<Operation>, Parcelable {
    private final static long serialVersionUID = -2122462501055525645L;

    private final Operator mOperator;
    private final List<Operand> mOperands;
    
    private volatile int tHashCode;

    private Operation(_Builder builder) {
        mOperator = builder.mOperator;
        mOperands = Collections.unmodifiableList(new LinkedList<>(builder.mOperands));
    }

    @JsonCreator
    public Operation(@JsonProperty("operator") Operator pOperator,
                     @JsonProperty("operands") List<Operand> pOperands) {
        mOperator = pOperator;
        mOperands = Collections.unmodifiableList(new LinkedList<>(pOperands));
    }

    public boolean hasOperator() {
        return mOperator != null;
    }

    @JsonProperty("operator")
    public Operator getOperator() {
        return mOperator;
    }

    public int numOperands() {
        return mOperands != null ? mOperands.size() : 0;
    }

    @JsonProperty("operands")
    public List<Operand> getOperands() {
        return mOperands;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasOperator();
            case 2: return numOperands() > 0;
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasOperator() ? 1 : 0;
            case 2: return numOperands();
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getOperator();
            case 2: return getOperands();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Operation)) return false;
        Operation other = (Operation) o;
        return Objects.equals(mOperator, other.mOperator) &&
               PTypeUtils.equals(mOperands, other.mOperands);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Operation.class,
                    _Field.OPERATOR, mOperator,
                    _Field.OPERANDS, PTypeUtils.hashCode(mOperands));
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "calculator.Operation" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        boolean first = true;
        if (hasOperator()) {
            first = false;
            out.append("operator:");
            out.append(mOperator.getName());
        }
        if (numOperands() > 0) {
            if (!first) out.append(',');
            first = false;
            out.append("operands:");
            out.append(PTypeUtils.toString(mOperands));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Operation other) {
        int c;

        c = Boolean.compare(mOperator != null, other.mOperator != null);
        if (c != 0) return c;
        if (mOperator != null) {
            c = Integer.compare(mOperator.getValue(), mOperator.getValue());
            if (c != 0) return c;
        }

        c = Boolean.compare(mOperands != null, other.mOperands != null);
        if (c != 0) return c;
        if (mOperands != null) {
            c = Integer.compare(mOperands.hashCode(), other.mOperands.hashCode());
            if (c != 0) return c;
        }

        return 0;
    }

    public enum _Field implements PField {
        OPERATOR(1, PRequirement.DEFAULT, "operator", Operator.provider(), null),
        OPERANDS(2, PRequirement.DEFAULT, "operands", PList.provider(Operand.provider()), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Operation._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.OPERATOR;
                case 2: return _Field.OPERANDS;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "operator": return _Field.OPERATOR;
                case "operands": return _Field.OPERANDS;
            }
            return null;
        }
    }

    public static PStructDescriptorProvider<Operation,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PStructDescriptor<Operation,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PStructDescriptor<Operation,_Field> kDescriptor;

    private static class _Descriptor
            extends PStructDescriptor<Operation,_Field> {
        public _Descriptor() {
            super(null, "calculator", "Operation", new _Factory(), false, false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PStructDescriptorProvider<Operation,_Field> {
        @Override
        public PStructDescriptor<Operation,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Operation> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (hasOperator()) {
            dest.writeInt(1);
            dest.writeInt(mOperator.getValue());
        }
        if (numOperands() > 0) {
            dest.writeInt(2);
            dest.writeTypedList(mOperands);
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Operation> CREATOR = new Parcelable.Creator<Operation>() {
        @Override
        public Operation createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setOperator(Operator.forValue(source.readInt()));
                        break;
                    }
                    case 2: {
                        builder.setOperands(source.createTypedArrayList(Operand.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Operation[] newArray(int size) {
            return new Operation[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Operation> {
        private BitSet optionals;

        private Operator mOperator;
        private List<Operand> mOperands;


        public _Builder() {
            optionals = new BitSet(2);
            mOperands = new LinkedList<>();
        }

        public _Builder(Operation base) {
            this();

            if (base.hasOperator()) {
                optionals.set(0);
                mOperator = base.mOperator;
            }
            if (base.numOperands() > 0) {
                optionals.set(1);
                mOperands.addAll(base.mOperands);
            }
        }

        public _Builder setOperator(Operator value) {
            optionals.set(0);
            mOperator = value;
            return this;
        }
        public _Builder clearOperator() {
            optionals.set(0, false);
            mOperator = null;
            return this;
        }
        public _Builder setOperands(Collection<Operand> value) {
            optionals.set(1);
            mOperands.clear();
            mOperands.addAll(value);
            return this;
        }
        public _Builder addToOperands(Operand... values) {
            optionals.set(1);
            for (Operand item : values) {
                mOperands.add(item);
            }
            return this;
        }

        public _Builder clearOperands() {
            optionals.set(1, false);
            mOperands.clear();
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setOperator((Operator) value); break;
                case 2: setOperands((List<Operand>) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 2: addToOperands((Operand) value); break;
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearOperator(); break;
                case 2: clearOperands(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Operation build() {
            return new Operation(this);
        }
    }
}
