package net.morimekta.test.calculator;

import java.io.Serializable;
import java.util.Objects;

import android.os.Parcel;
import android.os.Parcelable;

import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.morimekta.test.number.Imaginary;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@SuppressWarnings("unused")
public class Operand
        implements PUnion<Operand>, Serializable, Comparable<Operand>, Parcelable {
    private final static long serialVersionUID = -7034870678901672325L;

    private final static double kDefaultNumber = 0.0d;

    private final Operation mOperation;
    private final double mNumber;
    private final Imaginary mImaginary;

    private final _Field tUnionField;
    
    private volatile int tHashCode;

    private Operand(_Builder builder) {
        tUnionField = builder.tUnionField;

        mOperation = tUnionField == _Field.OPERATION ? builder.mOperation : null;
        mNumber = tUnionField == _Field.NUMBER ? builder.mNumber : kDefaultNumber;
        mImaginary = tUnionField == _Field.IMAGINARY ? builder.mImaginary : null;
    }

    public static Operand withOperation(Operation value) {
        return new _Builder().setOperation(value).build();
    }

    public static Operand withNumber(double value) {
        return new _Builder().setNumber(value).build();
    }

    public static Operand withImaginary(Imaginary value) {
        return new _Builder().setImaginary(value).build();
    }

    public boolean hasOperation() {
        return tUnionField == _Field.OPERATION && mOperation != null;
    }

    @JsonProperty("operation")
    public Operation getOperation() {
        return mOperation;
    }

    public boolean hasNumber() {
        return tUnionField == _Field.NUMBER;
    }

    @JsonProperty("number")
    public double getNumber() {
        return mNumber;
    }

    public boolean hasImaginary() {
        return tUnionField == _Field.IMAGINARY && mImaginary != null;
    }

    @JsonProperty("imaginary")
    public Imaginary getImaginary() {
        return mImaginary;
    }

    @Override
    public _Field unionField() {
        return tUnionField;
    }

    @Override
    public boolean has(int key) {
        switch(key) {
            case 1: return hasOperation();
            case 2: return hasNumber();
            case 3: return hasImaginary();
            default: return false;
        }
    }

    @Override
    public int num(int key) {
        switch(key) {
            case 1: return hasOperation() ? 1 : 0;
            case 2: return hasNumber() ? 1 : 0;
            case 3: return hasImaginary() ? 1 : 0;
            default: return 0;
        }
    }

    @Override
    public Object get(int key) {
        switch(key) {
            case 1: return getOperation();
            case 2: return getNumber();
            case 3: return getImaginary();
            default: return null;
        }
    }

    @JsonIgnore
    @Override
    public boolean isCompact() {
        return false;
    }

    @JsonIgnore
    @Override
    public boolean isSimple() {
        return descriptor().isSimple();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Operand)) return false;
        Operand other = (Operand) o;
        return Objects.equals(tUnionField, other.tUnionField) &&
               Objects.equals(mOperation, other.mOperation) &&
               Objects.equals(mNumber, other.mNumber) &&
               Objects.equals(mImaginary, other.mImaginary);
    }

    @Override
    public int hashCode() {
        if (tHashCode == 0) {
            tHashCode = Objects.hash(
                    Operand.class,
                    _Field.OPERATION, mOperation,
                    _Field.NUMBER, mNumber,
                    _Field.IMAGINARY, mImaginary);
        }
        return tHashCode;
    }

    @Override
    public String toString() {
        return "calculator.Operand" + asString();
    }

    @Override
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");

        switch (tUnionField) {
            case OPERATION: {
                out.append("operation:");
                out.append(mOperation.asString());
                break;
            }
            case NUMBER: {
                out.append("number:");
                out.append(PTypeUtils.toString(mNumber));
                break;
            }
            case IMAGINARY: {
                out.append("imaginary:");
                out.append(mImaginary.asString());
                break;
            }
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Operand other) {
        int c = Integer.compare(tUnionField.getKey(), other.tUnionField.getKey());
        if (c != 0) return c;

        switch (tUnionField) {
            case OPERATION:
                return mOperation.compareTo(other.mOperation);
            case NUMBER:
                return Double.compare(mNumber, other.mNumber);
            case IMAGINARY:
                return mImaginary.compareTo(other.mImaginary);
            default: return 0;
        }
    }

    public enum _Field implements PField {
        OPERATION(1, PRequirement.DEFAULT, "operation", Operation.provider(), null),
        NUMBER(2, PRequirement.DEFAULT, "number", PPrimitive.DOUBLE.provider(), null),
        IMAGINARY(3, PRequirement.DEFAULT, "imaginary", Imaginary.provider(), null),
        ;

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            mKey = key;
            mRequired = required;
            mName = name;
            mTypeProvider = typeProvider;
            mDefaultValue = defaultValue;
        }

        @Override
        public String getComment() { return null; }

        @Override
        public int getKey() { return mKey; }

        @Override
        public PRequirement getRequirement() { return mRequired; }

        @Override
        public PType getType() { return getDescriptor().getType(); }

        @Override
        public PDescriptor<?> getDescriptor() { return mTypeProvider.descriptor(); }

        @Override
        public String getName() { return mName; }

        @Override
        public boolean hasDefaultValue() { return mDefaultValue != null; }

        @Override
        public Object getDefaultValue() {
            return hasDefaultValue() ? mDefaultValue.get() : null;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Operand._Field(")
                   .append(mKey)
                   .append(": ");
            if (mRequired != PRequirement.DEFAULT) {
                builder.append(mRequired.label).append(" ");
            }
            builder.append(getDescriptor().getQualifiedName(null))
                   .append(' ')
                   .append(mName)
                   .append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: return _Field.OPERATION;
                case 2: return _Field.NUMBER;
                case 3: return _Field.IMAGINARY;
                default: return null;
            }
        }

        public static _Field forName(String name) {
            switch (name) {
                case "operation": return _Field.OPERATION;
                case "number": return _Field.NUMBER;
                case "imaginary": return _Field.IMAGINARY;
            }
            return null;
        }
    }

    public static PUnionDescriptorProvider<Operand,_Field> provider() {
        return new _Provider();
    }

    @Override
    public PUnionDescriptor<Operand,_Field> descriptor() {
        return kDescriptor;
    }

    public static final PUnionDescriptor<Operand,_Field> kDescriptor;

    private static class _Descriptor
            extends PUnionDescriptor<Operand,_Field> {
        public _Descriptor() {
            super(null, "calculator", "Operand", new _Factory(), false);
        }

        @Override
        public _Field[] getFields() {
            return _Field.values();
        }

        @Override
        public _Field getField(String name) {
            return _Field.forName(name);
        }

        @Override
        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private final static class _Provider extends PUnionDescriptorProvider<Operand,_Field> {
        @Override
        public PUnionDescriptor<Operand,_Field> descriptor() {
            return kDescriptor;
        }
    }

    private final static class _Factory
            extends PMessageBuilderFactory<Operand> {
        @Override
        public _Builder builder() {
            return new _Builder();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (tUnionField != null) {
            switch (tUnionField) {
                case OPERATION:
                    dest.writeInt(1);
                    dest.writeTypedObject(mOperation, 0);
                    break;
                case NUMBER:
                    dest.writeInt(2);
                    dest.writeDouble(mNumber);
                    break;
                case IMAGINARY:
                    dest.writeInt(3);
                    dest.writeTypedObject(mImaginary, 0);
                    break;
            }
        }
        dest.writeInt(0);
    }

    public static final Parcelable.Creator<Operand> CREATOR = new Parcelable.Creator<Operand>() {
        @Override
        public Operand createFromParcel(Parcel source) {
            _Builder builder = new _Builder();
            loop: while (source.dataAvail() > 0) {
                int field = source.readInt();
                switch (field) {
                    case 0: break loop;
                    case 1: {
                        builder.setOperation((Operation) source.readTypedObject(Operation.CREATOR));
                        break;
                    }
                    case 2: {
                        builder.setNumber(source.readDouble());
                        break;
                    }
                    case 3: {
                        builder.setImaginary((Imaginary) source.readTypedObject(Imaginary.CREATOR));
                        break;
                    }
                    default: throw new IllegalArgumentException("Unknown field ID: " + field);
                }
            }

            return builder.build();
        }

        @Override
        public Operand[] newArray(int size) {
            return new Operand[size];
        }
    };

    @Override
    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
            extends PMessageBuilder<Operand> {
        private _Field tUnionField;

        private Operation mOperation;
        private double mNumber;
        private Imaginary mImaginary;


        public _Builder() {
            mNumber = kDefaultNumber;
        }

        public _Builder(Operand base) {
            this();

            tUnionField = base.tUnionField;

            mOperation = base.mOperation;
            mNumber = base.mNumber;
            mImaginary = base.mImaginary;
        }

        public _Builder setOperation(Operation value) {
            tUnionField = _Field.OPERATION;
            mOperation = value;
            return this;
        }
        public _Builder clearOperation() {
            if (tUnionField == _Field.OPERATION) tUnionField = null;
            mOperation = null;
            return this;
        }
        public _Builder setNumber(double value) {
            tUnionField = _Field.NUMBER;
            mNumber = value;
            return this;
        }
        public _Builder clearNumber() {
            if (tUnionField == _Field.NUMBER) tUnionField = null;
            mNumber = kDefaultNumber;
            return this;
        }
        public _Builder setImaginary(Imaginary value) {
            tUnionField = _Field.IMAGINARY;
            mImaginary = value;
            return this;
        }
        public _Builder clearImaginary() {
            if (tUnionField == _Field.IMAGINARY) tUnionField = null;
            mImaginary = null;
            return this;
        }
        @Override
        public _Builder set(int key, Object value) {
            if (value == null) return clear(key);
            switch (key) {
                case 1: setOperation((Operation) value); break;
                case 2: setNumber((double) value); break;
                case 3: setImaginary((Imaginary) value); break;
            }
            return this;
        }

        @Override
        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: break;
            }
            return this;
        }

        @Override
        public _Builder clear(int key) {
            switch (key) {
                case 1: clearOperation(); break;
                case 2: clearNumber(); break;
                case 3: clearImaginary(); break;
            }
            return this;
        }

        @Override
        public boolean isValid() {
            return tUnionField != null;
        }

        @Override
        public Operand build() {
            return new Operand(this);
        }
    }
}
