/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class Any
implements PMessage<Any, _Field>,
Comparable<Any>,
Serializable,
BinaryWriter {
    private static final long serialVersionUID = 8306176226829184051L;
    private static final String kDefaultType = "";
    private static final String kDefaultMediaType = "application/vnd.apache.thrift.binary";
    private final transient String mType;
    private final transient String mMediaType;
    private final transient Binary mBin;
    private final transient String mStr;
    private volatile transient int tHashCode;
    private transient Any tSerializeInstance;
    public static final PStructDescriptor<Any, _Field> kDescriptor = new _Descriptor();

    private Any(_Builder builder) {
        this.mType = builder.isSetType() ? builder.mType : kDefaultType;
        this.mMediaType = builder.mMediaType;
        this.mBin = builder.mBin;
        this.mStr = builder.mStr;
    }

    public boolean hasType() {
        return true;
    }

    @Nonnull
    public String getType() {
        return this.mType;
    }

    public boolean hasMediaType() {
        return this.mMediaType != null;
    }

    public String getMediaType() {
        return this.hasMediaType() ? this.mMediaType : kDefaultMediaType;
    }

    @Nonnull
    public Optional<String> optionalMediaType() {
        return Optional.ofNullable(this.mMediaType);
    }

    public boolean hasBin() {
        return this.mBin != null;
    }

    public Binary getBin() {
        return this.mBin;
    }

    @Nonnull
    public Optional<Binary> optionalBin() {
        return Optional.ofNullable(this.mBin);
    }

    public boolean hasStr() {
        return this.mStr != null;
    }

    public String getStr() {
        return this.mStr;
    }

    @Nonnull
    public Optional<String> optionalStr() {
        return Optional.ofNullable(this.mStr);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return true;
            }
            case 2: {
                return this.mMediaType != null;
            }
            case 4: {
                return this.mBin != null;
            }
            case 5: {
                return this.mStr != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)this.mType;
            }
            case 2: {
                return (T)this.mMediaType;
            }
            case 4: {
                return (T)this.mBin;
            }
            case 5: {
                return (T)this.mStr;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Any other = (Any)o;
        return Objects.equals(this.mType, other.mType) && Objects.equals(this.mMediaType, other.mMediaType) && Objects.equals(this.mBin, other.mBin) && Objects.equals(this.mStr, other.mStr);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Any.class, _Field.TYPE, this.mType, _Field.MEDIA_TYPE, this.mMediaType, _Field.BIN, this.mBin, _Field.STR, this.mStr});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "providence.Any" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        out.append("type:").append('\"').append(Strings.escape((CharSequence)this.mType)).append('\"');
        if (this.hasMediaType()) {
            out.append(',');
            out.append("media_type:").append('\"').append(Strings.escape((CharSequence)this.mMediaType)).append('\"');
        }
        if (this.hasBin()) {
            out.append(',');
            out.append("bin:").append("b64(").append(this.mBin.toBase64()).append(')');
        }
        if (this.hasStr()) {
            out.append(',');
            out.append("str:").append('\"').append(Strings.escape((CharSequence)this.mStr)).append('\"');
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Any other) {
        int c = this.mType.compareTo(other.mType);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mMediaType != null, other.mMediaType != null);
        if (c != 0) {
            return c;
        }
        if (this.mMediaType != null && (c = this.mMediaType.compareTo(other.mMediaType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mBin != null, other.mBin != null);
        if (c != 0) {
            return c;
        }
        if (this.mBin != null && (c = this.mBin.compareTo(other.mBin)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mStr != null, other.mStr != null);
        if (c != 0) {
            return c;
        }
        if (this.mStr != null && (c = this.mStr.compareTo(other.mStr)) != 0) {
            return c;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        BinarySerializer serializer = new BinarySerializer(false);
        serializer.serialize((OutputStream)oos, (PMessage)this);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        BinarySerializer serializer = new BinarySerializer(false);
        this.tSerializeInstance = (Any)serializer.deserialize((InputStream)ois, kDescriptor);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.tSerializeInstance;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        length += writer.writeByte((byte)11);
        length += writer.writeShort((short)1);
        Binary tmp_1 = Binary.wrap((byte[])this.mType.getBytes(StandardCharsets.UTF_8));
        length += writer.writeUInt32(tmp_1.length());
        length += writer.writeBinary(tmp_1);
        if (this.hasMediaType()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_2 = Binary.wrap((byte[])this.mMediaType.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasBin()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)4);
            length += writer.writeUInt32(this.mBin.length());
            length += writer.writeBinary(this.mBin);
        }
        if (this.hasStr()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)5);
            Binary tmp_3 = Binary.wrap((byte[])this.mStr.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_3.length());
            length += writer.writeBinary(tmp_3);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<Any, _Field> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<Any, _Field> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Any, _Field>
    implements BinaryReader {
        private BitSet optionals = new BitSet(4);
        private BitSet modified = new BitSet(4);
        private String mType = "";
        private String mMediaType;
        private Binary mBin;
        private String mStr;

        public _Builder() {
        }

        public _Builder(Any base) {
            this();
            this.optionals.set(0);
            this.mType = base.mType;
            if (base.hasMediaType()) {
                this.optionals.set(1);
                this.mMediaType = base.mMediaType;
            }
            if (base.hasBin()) {
                this.optionals.set(2);
                this.mBin = base.mBin;
            }
            if (base.hasStr()) {
                this.optionals.set(3);
                this.mStr = base.mStr;
            }
        }

        @Nonnull
        public _Builder merge(Any from) {
            this.optionals.set(0);
            this.modified.set(0);
            this.mType = from.getType();
            if (from.hasMediaType()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mMediaType = from.getMediaType();
            }
            if (from.hasBin()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mBin = from.getBin();
            }
            if (from.hasStr()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mStr = from.getStr();
            }
            return this;
        }

        @Nonnull
        public _Builder setType(String value) {
            if (value == null) {
                return this.clearType();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mType = value;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(0);
        }

        public boolean isModifiedType() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearType() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mType = Any.kDefaultType;
            return this;
        }

        public String getType() {
            return this.mType;
        }

        @Nonnull
        public _Builder setMediaType(String value) {
            if (value == null) {
                return this.clearMediaType();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mMediaType = value;
            return this;
        }

        public boolean isSetMediaType() {
            return this.optionals.get(1);
        }

        public boolean isModifiedMediaType() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearMediaType() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mMediaType = null;
            return this;
        }

        public String getMediaType() {
            return this.isSetMediaType() ? this.mMediaType : Any.kDefaultMediaType;
        }

        @Nonnull
        public _Builder setBin(Binary value) {
            if (value == null) {
                return this.clearBin();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mBin = value;
            return this;
        }

        public boolean isSetBin() {
            return this.optionals.get(2);
        }

        public boolean isModifiedBin() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearBin() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mBin = null;
            return this;
        }

        public Binary getBin() {
            return this.mBin;
        }

        @Nonnull
        public _Builder setStr(String value) {
            if (value == null) {
                return this.clearStr();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mStr = value;
            return this;
        }

        public boolean isSetStr() {
            return this.optionals.get(3);
        }

        public boolean isModifiedStr() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearStr() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mStr = null;
            return this;
        }

        public String getStr() {
            return this.mStr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                return false;
            }
            _Builder other = (_Builder)((Object)o);
            return Objects.equals(this.optionals, other.optionals) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mMediaType, other.mMediaType) && Objects.equals(this.mBin, other.mBin) && Objects.equals(this.mStr, other.mStr);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Any.class, this.optionals, _Field.TYPE, this.mType, _Field.MEDIA_TYPE, this.mMediaType, _Field.BIN, this.mBin, _Field.STR, this.mStr});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                default: 
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setType((String)value);
                    break;
                }
                case 2: {
                    this.setMediaType((String)value);
                    break;
                }
                case 4: {
                    this.setBin((Binary)value);
                    break;
                }
                case 5: {
                    this.setStr((String)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 4: {
                    return this.optionals.get(2);
                }
                case 5: {
                    return this.optionals.get(3);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 4: {
                    return this.modified.get(2);
                }
                case 5: {
                    return this.modified.get(3);
                }
            }
            return false;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearType();
                    break;
                }
                case 2: {
                    this.clearMediaType();
                    break;
                }
                case 4: {
                    this.clearBin();
                    break;
                }
                case 5: {
                    this.clearStr();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(0);
        }

        public void validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("type");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message providence.Any");
            }
        }

        @Nonnull
        public PStructDescriptor<Any, _Field> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mType = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for providence.Any.type, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mMediaType = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for providence.Any.media_type, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 11) {
                            int len_3 = reader.expectUInt32();
                            this.mBin = reader.expectBinary(len_3);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for providence.Any.bin, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 11) {
                            int len_4 = reader.expectUInt32();
                            this.mStr = new String(reader.expectBytes(len_4), StandardCharsets.UTF_8);
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for providence.Any.str, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        public Any build() {
            return new Any(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Any, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<Any, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<Any, _Field> {
        public _Descriptor() {
            super("providence", "Any", _Builder::new, true);
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField
    {
        TYPE(1, PRequirement.REQUIRED, "type", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        MEDIA_TYPE(2, PRequirement.OPTIONAL, "media_type", (PDescriptorProvider)PPrimitive.STRING.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)"application/vnd.apache.thrift.binary")),
        BIN(4, PRequirement.OPTIONAL, "bin", (PDescriptorProvider)PPrimitive.BINARY.provider(), null),
        STR(5, PRequirement.OPTIONAL, "str", (PDescriptorProvider)PPrimitive.STRING.provider(), null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return MEDIA_TYPE;
                }
                case 4: {
                    return BIN;
                }
                case 5: {
                    return STR;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            switch (name) {
                case "type": {
                    return TYPE;
                }
                case "media_type": {
                    return MEDIA_TYPE;
                }
                case "bin": {
                    return BIN;
                }
                case "str": {
                    return STR;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in providence.Any");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in providence.Any");
            }
            return field;
        }
    }
}

