/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.graphql.GQLDefinition;
import net.morimekta.providence.graphql.directives.IncludeArguments;
import net.morimekta.providence.graphql.directives.SkipArguments;
import net.morimekta.providence.graphql.gql.GQLDirective;
import net.morimekta.providence.graphql.gql.GQLField;
import net.morimekta.providence.graphql.gql.GQLFragmentDefinition;
import net.morimekta.providence.graphql.gql.GQLFragmentReference;
import net.morimekta.providence.graphql.gql.GQLInlineFragment;
import net.morimekta.providence.graphql.gql.GQLIntrospection;
import net.morimekta.providence.graphql.gql.GQLMethodCall;
import net.morimekta.providence.graphql.gql.GQLOperation;
import net.morimekta.providence.graphql.gql.GQLQuery;
import net.morimekta.providence.graphql.gql.GQLScalar;
import net.morimekta.providence.graphql.gql.GQLSelection;
import net.morimekta.providence.graphql.introspection.Type;
import net.morimekta.providence.graphql.introspection.TypeKind;
import net.morimekta.providence.graphql.parser.GQLException;
import net.morimekta.providence.graphql.parser.GQLLexer;
import net.morimekta.providence.graphql.parser.GQLToken;
import net.morimekta.providence.graphql.parser.GQLTokenType;
import net.morimekta.providence.util.MessageUtil;
import net.morimekta.util.Binary;
import net.morimekta.util.Pair;
import net.morimekta.util.Strings;
import net.morimekta.util.lexer.LexerException;

public class GQLParser {
    private final GQLDefinition definition;

    public GQLParser(GQLDefinition definition) {
        this.definition = definition;
    }

    @Nonnull
    public GQLQuery parseQuery(String query, Map<String, Object> rawVariables) throws IOException {
        try {
            return this.parseQueryInternal(query, rawVariables);
        }
        catch (LexerException e) {
            throw new GQLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public GQLQuery parseQueryInternal(String query, Map<String, Object> rawVariables) throws IOException {
        if (Strings.isNullOrEmpty((String)query)) {
            throw new IOException("Empty query");
        }
        StringReader in = new StringReader(query);
        GQLLexer tokenizer = new GQLLexer(in);
        String queryName = null;
        boolean isMutation = false;
        LinkedHashMap<String, GQLOperation> operationMap = new LinkedHashMap<String, GQLOperation>();
        LinkedHashMap<String, GQLFragmentDefinition> fragmentDefinitions = new LinkedHashMap<String, GQLFragmentDefinition>();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        ArrayList<Pair<GQLToken, GQLFragmentReference>> fragmentReferences = new ArrayList<Pair<GQLToken, GQLFragmentReference>>();
        GQLToken token = (GQLToken)tokenizer.expect("query or mutation");
        block10: do {
            PService service;
            if (token.isIdentifier()) {
                void var13_16;
                switch (token.toString()) {
                    case "query": {
                        if (operationMap.containsKey("")) {
                            throw tokenizer.failure(token, "Default operation already defined", new Object[0]);
                        }
                        service = this.definition.getQuery();
                        token = (GQLToken)tokenizer.expect("query name", GQLToken::isIdentifier);
                        queryName = token.toString();
                        if (operationMap.containsKey(queryName)) {
                            throw tokenizer.failure(token, "Operation with name " + queryName + " already defined", new Object[0]);
                        }
                        boolean bl = ((GQLToken)tokenizer.expectSymbol("query start", new char[]{'{', '('})).isSymbol('(');
                        break;
                    }
                    case "mutation": {
                        if (operationMap.containsKey("")) {
                            throw tokenizer.failure(token, "Default operation already defined", new Object[0]);
                        }
                        service = this.definition.getMutation();
                        if (service == null) {
                            throw tokenizer.failure(token, "No mutation defined", new Object[0]);
                        }
                        token = (GQLToken)tokenizer.expect("mutation name", GQLToken::isIdentifier);
                        queryName = token.toString();
                        if (operationMap.containsKey(queryName)) {
                            throw tokenizer.failure(token, "Operation with name " + queryName + " already defined", new Object[0]);
                        }
                        isMutation = true;
                        boolean bl = ((GQLToken)tokenizer.expectSymbol("mutation start", new char[]{'{', '('})).isSymbol('(');
                        break;
                    }
                    case "fragment": {
                        this.parseFragment(tokenizer, fragmentReferences, fragmentDefinitions, variables);
                        token = tokenizer.next();
                        continue block10;
                    }
                    default: {
                        throw tokenizer.failure(token, "Expected query, mutation or fragment, got '%s'", new Object[]{token.toString()});
                    }
                }
                if (var13_16 != false) {
                    variables.putAll(this.parseVariables(tokenizer, rawVariables));
                    tokenizer.expectSymbol("fields start", new char[]{'{'});
                }
            } else if (token.isSymbol('{')) {
                if (operationMap.size() > 0) {
                    throw tokenizer.failure(token, "Operation already defined, default operation not allowed with named operations", new Object[0]);
                }
                service = this.definition.getQuery();
            } else {
                throw tokenizer.failure(token, "Unexpected symbol '%s'", new Object[]{token.toString()});
            }
            List<GQLSelection> list = this.parseOperation(tokenizer, service, variables, fragmentReferences, fragmentDefinitions);
            if (queryName == null) {
                operationMap.put("", new GQLOperation(service, isMutation, queryName, list));
            } else {
                operationMap.put(queryName, new GQLOperation(service, isMutation, queryName, list));
            }
            token = tokenizer.next();
        } while (token != null);
        for (Pair pair : fragmentReferences) {
            GQLFragmentDefinition definition = ((GQLFragmentReference)pair.second).getDefinition();
            if (definition == null) {
                throw tokenizer.failure((GQLToken)((Object)pair.first), "No fragment for reference %s", new Object[]{((GQLFragmentReference)pair.second).getName()});
            }
            if (!this.isFragmentTypeUnreachable(((GQLFragmentReference)pair.second).getParentDescriptor(), definition.getTypeCondition())) continue;
            throw tokenizer.failure((GQLToken)((Object)pair.first), "Fragment %s condition not valid for %s", new Object[]{((GQLFragmentReference)pair.second).getName(), ((GQLFragmentReference)pair.second).getParentDescriptor().getQualifiedName()});
        }
        if (operationMap.isEmpty()) {
            throw tokenizer.failure(tokenizer.getLastToken(), "No operation in query", new Object[0]);
        }
        return new GQLQuery(operationMap, fragmentDefinitions);
    }

    private boolean isFragmentTypeUnreachable(@Nonnull PMessageDescriptor containedInType, @Nonnull PMessageDescriptor typeCondition) {
        PMessageDescriptor description = containedInType;
        if (containedInType.getImplementing() != null) {
            description = description.getImplementing();
        }
        if (typeCondition.equals((Object)description) || typeCondition.equals((Object)containedInType) || description.equals((Object)typeCondition.getImplementing())) {
            return false;
        }
        if (containedInType.getVariant() == PMessageVariant.UNION && description != containedInType) {
            for (PField field : containedInType.getFields()) {
                if (!field.getDescriptor().equals(typeCondition)) continue;
                return false;
            }
        }
        return true;
    }

    private void parseFragment(GQLLexer tokenizer, List<Pair<GQLToken, GQLFragmentReference>> fragmentReferences, Map<String, GQLFragmentDefinition> fragmentDefinitions, Map<String, Object> variables) throws IOException {
        GQLToken token = (GQLToken)tokenizer.expect("fragment name", GQLToken::isIdentifier);
        String fragmentName = token.toString();
        token = (GQLToken)tokenizer.expect("fragment of", GQLToken::isIdentifier);
        if (!token.toString().equals("on")) {
            throw tokenizer.failure(token, "expected on after fragment name", new Object[0]);
        }
        token = (GQLToken)tokenizer.expect("fragment type", GQLToken::isIdentifier);
        PDescriptor type = this.definition.getType(token.toString());
        if (type == null) {
            throw tokenizer.failure(token, "unknown type: %s", new Object[]{token.toString()});
        }
        if (type.getType() != PType.MESSAGE) {
            throw tokenizer.failure(token, "not an object type: %s", new Object[]{token.toString()});
        }
        tokenizer.expectSymbol("fragment start", new char[]{'{'});
        List<GQLSelection> entries = this.parseFields((PMessageDescriptor)type, tokenizer, fragmentReferences, fragmentDefinitions, variables);
        fragmentDefinitions.put(fragmentName, new GQLFragmentDefinition(fragmentName, (PMessageDescriptor)type, entries));
    }

    private Map<String, Object> parseVariables(GQLLexer tokenizer, Map<String, Object> rawVariables) throws IOException {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GQLToken token = (GQLToken)tokenizer.expect("variable name");
        do {
            String name;
            if (!(name = token.toString()).startsWith("$") || name.length() < 2) {
                throw tokenizer.failure(token, "Bad variable name, must start with '$' and have length > 1", new Object[0]);
            }
            name = name.substring(1);
            tokenizer.expectSymbol("var value sep", new char[]{':'});
            PDescriptor type = this.parseType(tokenizer);
            token = (GQLToken)tokenizer.expect("after variable");
            Object defaultValue = null;
            if (token.isSymbol('=')) {
                defaultValue = this.parseArgumentValue(tokenizer, type, null, variables);
                token = (GQLToken)tokenizer.expect("after default value");
            }
            variables.put(name, MessageUtil.coerce((PDescriptor)type, (Object)rawVariables.get(name)).orElse(defaultValue));
        } while (!token.isSymbol(')'));
        return variables;
    }

    private PDescriptor parseType(GQLLexer tokenizer) throws IOException {
        PDescriptor itemType;
        GQLToken token = (GQLToken)tokenizer.expect("type");
        if (token.isSymbol('[')) {
            PDescriptor itemType2 = this.parseType(tokenizer);
            tokenizer.expectSymbol("after list", new char[]{']'});
            return PList.provider(() -> itemType2).descriptor();
        }
        GQLScalar scalar = GQLScalar.findByName(token.toString());
        if (scalar != null) {
            switch (scalar) {
                case ID: 
                case String: {
                    itemType = PPrimitive.STRING;
                    break;
                }
                case Int: {
                    itemType = PPrimitive.I64;
                    break;
                }
                case Float: {
                    itemType = PPrimitive.DOUBLE;
                    break;
                }
                case Boolean: {
                    itemType = PPrimitive.BOOL;
                    break;
                }
                default: {
                    itemType = null;
                    break;
                }
            }
        } else {
            itemType = this.definition.getType(token.toString());
        }
        if (itemType == null) {
            throw tokenizer.failure(token, "Unknown type " + token.toString(), new Object[0]);
        }
        if (((GQLToken)tokenizer.peek("after type")).isSymbol('!')) {
            tokenizer.next();
        }
        return itemType;
    }

    private List<GQLSelection> parseOperation(GQLLexer tokenizer, PService service, Map<String, Object> variables, List<Pair<GQLToken, GQLFragmentReference>> fragmentReferences, Map<String, GQLFragmentDefinition> fragmentDefinitions) throws IOException {
        ArrayList<GQLSelection> rootSelection = new ArrayList<GQLSelection>();
        GQLToken token = (GQLToken)tokenizer.expect("alias or method", GQLToken::isIdentifier);
        do {
            Object params;
            String methodName;
            GQLIntrospection.Field intro;
            if (!token.isIdentifier()) {
                throw tokenizer.failure(token, "Unexpected symbol '%s', expected call name or end of query", new Object[]{token.toString()});
            }
            String alias = null;
            if (((GQLToken)tokenizer.peek("after name")).isSymbol(':')) {
                alias = token.toString();
                if (alias.startsWith("__")) {
                    throw tokenizer.failure(token, "Unknown introspection %s", new Object[]{token.toString()});
                }
                tokenizer.next();
                token = (GQLToken)tokenizer.expect("method", GQLToken::isIdentifier);
            }
            if ((intro = GQLIntrospection.findFieldByName(methodName = token.toString())) != null) {
                PMessage<?> args = null;
                List<GQLSelection> selection = null;
                if (intro.arguments != null && ((GQLToken)tokenizer.peek("introspection arguments start")).isSymbol('(')) {
                    tokenizer.next();
                    args = (PMessage<?>)this.parseArguments(intro.arguments, tokenizer, variables);
                }
                if (intro.response instanceof PMessageDescriptor) {
                    tokenizer.expectSymbol("introspection fields start", new char[]{'{'});
                    selection = this.parseFields((PMessageDescriptor)intro.response, tokenizer, fragmentReferences, fragmentDefinitions, variables);
                }
                rootSelection.add(new GQLIntrospection(intro, alias, args, selection));
                token = (GQLToken)tokenizer.expect("method or end");
                continue;
            }
            if (methodName.startsWith("__")) {
                throw tokenizer.failure(token, "Unknown introspection %s", new Object[]{token.toString()});
            }
            PServiceMethod method = service.getMethod(methodName);
            if (method == null) {
                throw tokenizer.failure(token, "No method " + methodName + " in " + service.getQualifiedName(), new Object[0]);
            }
            token = (GQLToken)tokenizer.expect("after method");
            if (token.isSymbol('(')) {
                params = this.parseArguments(method.getRequestType(), tokenizer, variables);
                token = (GQLToken)tokenizer.expect("after params");
            } else {
                params = method.getRequestType().builder().build();
            }
            List<GQLSelection> selectionSet = null;
            if (token.isSymbol('{')) {
                PUnionDescriptor mrd = method.getResponseType();
                if (mrd == null) {
                    throw tokenizer.failure(token, "Unexpected field list", new Object[0]);
                }
                PField success = mrd.findFieldById(0);
                if (success == null) {
                    throw tokenizer.failure(token, "Unexpected no success field for method " + methodName + " in " + service.getQualifiedName(), new Object[0]);
                }
                if (success.getType() == PType.LIST || success.getType() == PType.SET) {
                    PContainer container = (PContainer)success.getDescriptor();
                    if (container.itemDescriptor().getType() == PType.MESSAGE) {
                        selectionSet = this.parseFields((PMessageDescriptor)container.itemDescriptor(), tokenizer, fragmentReferences, fragmentDefinitions, variables);
                    }
                } else if (success.getType() == PType.MESSAGE) {
                    selectionSet = this.parseFields((PMessageDescriptor)success.getDescriptor(), tokenizer, fragmentReferences, fragmentDefinitions, variables);
                }
                token = (GQLToken)tokenizer.expect("method or end");
            }
            rootSelection.add(new GQLMethodCall(method, alias, (PMessage<?>)params, selectionSet));
            if (!token.isSymbol(',')) continue;
            token = (GQLToken)tokenizer.expect("method or end");
        } while (!token.isSymbol('}'));
        return rootSelection;
    }

    private PMessageDescriptor fragmentTypeDescriptor(@Nonnull GQLToken fragmentType) throws GQLException {
        String fragmentTypeName = fragmentType.toString();
        PDescriptor type = this.definition.getType(fragmentTypeName);
        Type introspectionType = this.definition.getIntrospectionType(fragmentTypeName);
        if (type == null || introspectionType == null) {
            throw new GQLException("Unknown type " + fragmentTypeName, fragmentType);
        }
        if (type.getType() != PType.MESSAGE) {
            throw new GQLException("Not an OBJECT type " + fragmentTypeName, fragmentType);
        }
        if (introspectionType.getKind() != TypeKind.OBJECT && introspectionType.getKind() != TypeKind.INTERFACE) {
            throw new GQLException("Fragment type must be OBJECT or INPUT, is " + (Object)((Object)introspectionType.getKind()) + " for " + fragmentTypeName, fragmentType);
        }
        return (PMessageDescriptor)type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<GQLSelection> parseFields(PMessageDescriptor descriptor, GQLLexer tokenizer, List<Pair<GQLToken, GQLFragmentReference>> fragmentReferences, Map<String, GQLFragmentDefinition> fragmentDefinitions, Map<String, Object> variables) throws IOException {
        ArrayList<GQLSelection> fields = new ArrayList<GQLSelection>();
        PMessageDescriptor baseDescriptor = descriptor;
        if (descriptor instanceof PUnionDescriptor && descriptor.getImplementing() != null) {
            descriptor = descriptor.getImplementing();
        }
        GQLToken token = (GQLToken)tokenizer.expect("field or end");
        do {
            if (!token.isIdentifier()) {
                if (!"...".equals(token.toString())) throw tokenizer.failure(token, "Expected alias or field name, git '%s'", new Object[]{token.toString()});
                token = (GQLToken)tokenizer.expect("inline fragment", GQLToken::isIdentifier);
                if ("on".equals(token.toString())) {
                    token = (GQLToken)tokenizer.expect("type name", GQLToken::isIdentifier);
                    PMessageDescriptor typeCondition = this.fragmentTypeDescriptor(token);
                    if (this.isFragmentTypeUnreachable(baseDescriptor, typeCondition)) {
                        throw tokenizer.failure(token, "Type %s not reachable from base of %s", new Object[]{token.toString(), baseDescriptor.getName()});
                    }
                    tokenizer.expectSymbol("fragment fields start", new char[]{'{'});
                    GQLInlineFragment fragment = new GQLInlineFragment(typeCondition, this.parseFields(typeCondition, tokenizer, fragmentReferences, fragmentDefinitions, variables));
                    fields.add(fragment);
                } else {
                    GQLFragmentReference reference = new GQLFragmentReference(token.toString(), baseDescriptor, fragmentDefinitions);
                    fragmentReferences.add((Pair<GQLToken, GQLFragmentReference>)Pair.create((Object)((Object)token), (Object)reference));
                    fields.add(reference);
                }
                token = (GQLToken)tokenizer.expect("field or end");
            } else if (token.toString().startsWith("__")) {
                GQLIntrospection.Field intro = GQLIntrospection.findFieldByName(token.toString());
                if (intro == null) throw tokenizer.failure(token, "Unknown introspection %s", new Object[]{token.toString()});
                List<GQLSelection> introFields = null;
                if (intro.response instanceof PMessageDescriptor) {
                    tokenizer.expectSymbol("field list", new char[]{'{'});
                    introFields = this.parseFields((PMessageDescriptor)intro.response, tokenizer, fragmentReferences, fragmentDefinitions, variables);
                }
                fields.add(new GQLIntrospection(intro, null, null, introFields));
                token = (GQLToken)tokenizer.expect("after fields");
            } else {
                PField field;
                String alias = null;
                if (((GQLToken)tokenizer.peek("after field")).isSymbol(':')) {
                    alias = token.toString();
                    if (alias.startsWith("__")) {
                        throw tokenizer.failure(token, "Unknown introspection %s", new Object[]{token.toString()});
                    }
                    tokenizer.next();
                    token = (GQLToken)tokenizer.expect("field name", GQLToken::isIdentifier);
                }
                if ((field = descriptor.findFieldByName(token.toString())) == null || this.definition.isIgnoredField(field)) {
                    throw tokenizer.failure(token, "Unknown field '%s' in %s", new Object[]{token.toString(), descriptor.getQualifiedName()});
                }
                token = (GQLToken)tokenizer.expect("after field");
                PMessage<?> arguments = null;
                if (token.isSymbol('(')) {
                    if (field.getArgumentsType() == null) {
                        throw tokenizer.failure(token, "Unexpected arguments for non-argument field %s in %s", new Object[]{field.getName(), descriptor.getQualifiedName()});
                    }
                    arguments = (PMessage<?>)this.parseArguments(field.getArgumentsType(), tokenizer, variables);
                    token = (GQLToken)tokenizer.expect("after arguments");
                }
                boolean included = true;
                while (token.isDirectve()) {
                    GQLDirective directive = GQLDirective.findByName(token.toString().substring(1));
                    if (directive == null) {
                        throw tokenizer.failure(token, "Unknown directive %s", new Object[]{token.toString()});
                    }
                    switch (directive) {
                        case include: {
                            tokenizer.expectSymbol("include argument", new char[]{'('});
                            PMessageOrBuilder<IncludeArguments> args = this.parseArguments(IncludeArguments.kDescriptor, tokenizer, variables);
                            included = args.isIf();
                            break;
                        }
                        case skip: {
                            tokenizer.expectSymbol("skip argument", new char[]{'('});
                            PMessageOrBuilder<IncludeArguments> args = this.parseArguments(SkipArguments.kDescriptor, tokenizer, variables);
                            included = !args.isIf();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled directive " + directive.name());
                        }
                    }
                    token = (GQLToken)tokenizer.expect("after directive");
                }
                List<GQLSelection> subFields = null;
                if (token.isSymbol('{')) {
                    PDescriptor fieldDesc = field.getDescriptor();
                    if (fieldDesc.getType() == PType.LIST || fieldDesc.getType() == PType.SET || fieldDesc.getType() == PType.MAP) {
                        fieldDesc = ((PContainer)fieldDesc).itemDescriptor();
                    }
                    if (fieldDesc.getType() != PType.MESSAGE) {
                        throw tokenizer.failure(token, "Unexpected field set for non-message field %s in %s", new Object[]{field.getName(), descriptor.getQualifiedName()});
                    }
                    subFields = this.parseFields((PMessageDescriptor)fieldDesc, tokenizer, fragmentReferences, fragmentDefinitions, variables);
                    token = (GQLToken)tokenizer.expect("after fields");
                }
                if (included) {
                    fields.add(new GQLField(field, alias, arguments, subFields));
                }
            }
            if (!token.isSymbol(',')) continue;
            token = (GQLToken)tokenizer.expect("after sep");
        } while (!token.isSymbol('}'));
        return fields;
    }

    private <M extends PMessage<M>> M parseArguments(PStructDescriptor<M> descriptor, GQLLexer tokenizer, Map<String, Object> variables) throws IOException {
        PMessageBuilder builder = descriptor.builder();
        GQLToken token = (GQLToken)tokenizer.expect("field id", GQLToken::isIdentifier);
        do {
            if (!token.isIdentifier()) {
                throw tokenizer.failure(token, "expected field name or end, got '%s'", new Object[]{token.toString()});
            }
            PField field = descriptor.findFieldByName(token.toString());
            if (field == null || this.definition.isIgnoredField(field)) {
                throw tokenizer.failure(token, "unknown field %s in %s", new Object[]{token.toString(), descriptor.getQualifiedName()});
            }
            tokenizer.expectSymbol("Field value sep", new char[]{':'});
            builder.set(field.getId(), this.parseArgumentValue(tokenizer, field.getDescriptor(), field.getDefaultValue(), variables));
            token = (GQLToken)tokenizer.expect("field, sep, or end");
            if (!token.isSymbol(',')) continue;
            token = (GQLToken)tokenizer.expect("field or end");
        } while (!token.isSymbol(')'));
        return (M)builder.build();
    }

    private Object parseArgumentValue(GQLLexer tokenizer, PDescriptor descriptor, Object defaultValue, Map<String, Object> variables) throws IOException {
        GQLToken token = (GQLToken)tokenizer.peek("variable");
        if (token.toString().startsWith("$")) {
            String name = token.toString().substring(1);
            if (!variables.containsKey(name)) {
                throw tokenizer.failure(token, "No such variable $%s", new Object[]{name});
            }
            tokenizer.next();
            return MessageUtil.coerce((PDescriptor)descriptor, (Object)variables.get(name)).orElse(defaultValue);
        }
        switch (descriptor.getType()) {
            case VOID: 
            case BOOL: {
                return Boolean.parseBoolean(((GQLToken)tokenizer.expect("bool value", GQLToken::isIdentifier)).toString());
            }
            case BYTE: {
                return (byte)((GQLToken)tokenizer.expect("byte value", GQLTokenType.INTEGER)).parseInteger();
            }
            case I16: {
                return (short)((GQLToken)tokenizer.expect("i16 value", GQLTokenType.INTEGER)).parseInteger();
            }
            case I32: {
                return (int)((GQLToken)tokenizer.expect("i32 value", GQLTokenType.INTEGER)).parseInteger();
            }
            case I64: {
                return ((GQLToken)tokenizer.expect("i64 value", GQLTokenType.INTEGER)).parseInteger();
            }
            case DOUBLE: {
                return ((GQLToken)tokenizer.expect("double value", t -> t.type() == GQLTokenType.INTEGER || t.type() == GQLTokenType.FLOAT)).parseDouble();
            }
            case ENUM: {
                PEnumDescriptor ed = (PEnumDescriptor)descriptor;
                GQLToken id = (GQLToken)tokenizer.expect("enum name", GQLToken::isIdentifier);
                try {
                    return ed.valueForName(id.toString());
                }
                catch (IllegalArgumentException e) {
                    throw tokenizer.failure(id, "No %s enum value '%s'", new Object[]{ed.getName(), id.toString()});
                }
            }
            case BINARY: {
                GQLToken value = (GQLToken)tokenizer.expect("binary literal", GQLTokenType.STRING);
                try {
                    return Binary.fromBase64((String)value.substring(1, -1).toString());
                }
                catch (IllegalArgumentException e) {
                    throw tokenizer.failure(value, "Bad base64 binary: %s", new Object[]{e.getMessage()});
                }
            }
            case STRING: {
                return ((GQLToken)tokenizer.expect("string literal", GQLTokenType.STRING)).decodeString(false);
            }
            case MESSAGE: {
                tokenizer.expectSymbol("message start", new char[]{'{'});
                PMessageDescriptor md = (PMessageDescriptor)descriptor;
                PMessageBuilder builder = md.builder();
                token = (GQLToken)tokenizer.expect("field name or end");
                while (!token.isSymbol('}')) {
                    if (!token.isIdentifier()) {
                        throw tokenizer.failure(token, "expected field name or end, got '%s'", new Object[]{token.toString()});
                    }
                    PField field = md.findFieldByName(token.toString());
                    if (field == null || this.definition.isIgnoredField(field)) {
                        throw tokenizer.failure(token, "unknown field %s in %s", new Object[]{token.toString(), md.getQualifiedName()});
                    }
                    tokenizer.expectSymbol("field value sep", new char[]{':'});
                    builder.set(field.getId(), this.parseArgumentValue(tokenizer, field.getDescriptor(), field.getDefaultValue(), variables));
                    token = (GQLToken)tokenizer.expect("field, sep or end");
                    if (!token.isSymbol(',')) continue;
                    token = (GQLToken)tokenizer.expect("field name", GQLToken::isIdentifier);
                }
                return builder.build();
            }
            case LIST: {
                tokenizer.expectSymbol("list start", new char[]{'['});
                PList ld = (PList)descriptor;
                PList.Builder builder = ld.builder(4);
                GQLToken next = (GQLToken)tokenizer.peek("list end or entry");
                while (!next.isSymbol(']')) {
                    builder.add(this.parseArgumentValue(tokenizer, ld.itemDescriptor(), null, variables));
                    next = (GQLToken)tokenizer.peek("list end or entry");
                    if (!next.isSymbol(',')) continue;
                    tokenizer.next();
                    next = (GQLToken)tokenizer.peek("list end or entry");
                }
                tokenizer.expectSymbol("list end", new char[]{']'});
                return builder.build();
            }
            case SET: {
                tokenizer.expectSymbol("set start", new char[]{'['});
                PSet ld = (PSet)descriptor;
                PSet.Builder builder = ld.builder(4);
                GQLToken next = (GQLToken)tokenizer.peek("set end or entry");
                while (!next.isSymbol(']')) {
                    builder.add(this.parseArgumentValue(tokenizer, ld.itemDescriptor(), null, variables));
                    next = (GQLToken)tokenizer.peek("set end or entry");
                    if (!next.isSymbol(',')) continue;
                    tokenizer.next();
                    next = (GQLToken)tokenizer.peek("set end or entry");
                }
                tokenizer.expectSymbol("set end", new char[]{']'});
                return builder.build();
            }
        }
        throw new IOException("Unhandled type " + descriptor.getType().toString());
    }
}

