/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.introspection;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.graphql.introspection.EnumValue;
import net.morimekta.providence.graphql.introspection.Field;
import net.morimekta.providence.graphql.introspection.FieldsArguments;
import net.morimekta.providence.graphql.introspection.InputValue;
import net.morimekta.providence.graphql.introspection.TypeKind;
import net.morimekta.providence.graphql.introspection.Type_OrBuilder;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.providence.serializer.binary.BinaryFormatUtils;
import net.morimekta.providence.serializer.binary.BinaryReader;
import net.morimekta.providence.serializer.binary.BinaryType;
import net.morimekta.providence.serializer.binary.BinaryWriter;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;

@Immutable
public class Type
implements Type_OrBuilder,
PMessage<Type>,
Comparable<Type>,
BinaryWriter {
    private final transient TypeKind mKind;
    private final transient String mName;
    private final transient String mDescription;
    private final transient List<Field> mFields;
    private final transient List<Type> mInterfaces;
    private final transient List<Type> mPossibleTypes;
    private final transient List<EnumValue> mEnumValues;
    private final transient List<InputValue> mInputFields;
    private final transient Type mOfType;
    private volatile transient int tHashCode;
    public static final PStructDescriptor<Type> kDescriptor = new _Descriptor();

    private Type(_Builder builder) {
        this.mKind = builder.mKind;
        this.mName = builder.mName;
        this.mDescription = builder.mDescription;
        this.mFields = builder.isSetFields() ? UnmodifiableList.copyOf((Collection)builder.mFields) : null;
        this.mInterfaces = builder.isSetInterfaces() ? UnmodifiableList.copyOf((Collection)builder.mInterfaces) : null;
        this.mPossibleTypes = builder.isSetPossibleTypes() ? UnmodifiableList.copyOf((Collection)builder.mPossibleTypes) : null;
        this.mEnumValues = builder.isSetEnumValues() ? UnmodifiableList.copyOf((Collection)builder.mEnumValues) : null;
        this.mInputFields = builder.isSetInputFields() ? UnmodifiableList.copyOf((Collection)builder.mInputFields) : null;
        this.mOfType = builder.mOfType_builder != null ? builder.mOfType_builder.build() : builder.mOfType;
    }

    @Override
    public boolean hasKind() {
        return this.mKind != null;
    }

    @Override
    public TypeKind getKind() {
        return this.mKind;
    }

    @Override
    @Nonnull
    public Optional<TypeKind> optionalKind() {
        return Optional.ofNullable(this.mKind);
    }

    @Override
    public boolean hasName() {
        return this.mName != null;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    @Nonnull
    public Optional<String> optionalName() {
        return Optional.ofNullable(this.mName);
    }

    @Override
    public boolean hasDescription() {
        return this.mDescription != null;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    @Nonnull
    public Optional<String> optionalDescription() {
        return Optional.ofNullable(this.mDescription);
    }

    @Override
    public int numFields() {
        return this.mFields != null ? this.mFields.size() : 0;
    }

    @Override
    public boolean hasFields() {
        return this.mFields != null;
    }

    @Override
    public List<Field> getFields() {
        return this.mFields;
    }

    @Override
    @Nonnull
    public Optional<List<Field>> optionalFields() {
        return Optional.ofNullable(this.mFields);
    }

    @Override
    public int numInterfaces() {
        return this.mInterfaces != null ? this.mInterfaces.size() : 0;
    }

    @Override
    public boolean hasInterfaces() {
        return this.mInterfaces != null;
    }

    @Override
    public List<Type> getInterfaces() {
        return this.mInterfaces;
    }

    @Override
    @Nonnull
    public Optional<List<Type>> optionalInterfaces() {
        return Optional.ofNullable(this.mInterfaces);
    }

    @Override
    public int numPossibleTypes() {
        return this.mPossibleTypes != null ? this.mPossibleTypes.size() : 0;
    }

    @Override
    public boolean hasPossibleTypes() {
        return this.mPossibleTypes != null;
    }

    @Override
    public List<Type> getPossibleTypes() {
        return this.mPossibleTypes;
    }

    @Override
    @Nonnull
    public Optional<List<Type>> optionalPossibleTypes() {
        return Optional.ofNullable(this.mPossibleTypes);
    }

    @Override
    public int numEnumValues() {
        return this.mEnumValues != null ? this.mEnumValues.size() : 0;
    }

    @Override
    public boolean hasEnumValues() {
        return this.mEnumValues != null;
    }

    @Override
    public List<EnumValue> getEnumValues() {
        return this.mEnumValues;
    }

    @Override
    @Nonnull
    public Optional<List<EnumValue>> optionalEnumValues() {
        return Optional.ofNullable(this.mEnumValues);
    }

    @Override
    public int numInputFields() {
        return this.mInputFields != null ? this.mInputFields.size() : 0;
    }

    @Override
    public boolean hasInputFields() {
        return this.mInputFields != null;
    }

    @Override
    public List<InputValue> getInputFields() {
        return this.mInputFields;
    }

    @Override
    @Nonnull
    public Optional<List<InputValue>> optionalInputFields() {
        return Optional.ofNullable(this.mInputFields);
    }

    @Override
    public boolean hasOfType() {
        return this.mOfType != null;
    }

    @Override
    public Type getOfType() {
        return this.mOfType;
    }

    @Override
    @Nonnull
    public Optional<Type> optionalOfType() {
        return Optional.ofNullable(this.mOfType);
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.mKind != null;
            }
            case 2: {
                return this.mName != null;
            }
            case 3: {
                return this.mDescription != null;
            }
            case 4: {
                return this.mFields != null;
            }
            case 5: {
                return this.mInterfaces != null;
            }
            case 6: {
                return this.mPossibleTypes != null;
            }
            case 7: {
                return this.mEnumValues != null;
            }
            case 8: {
                return this.mInputFields != null;
            }
            case 9: {
                return this.mOfType != null;
            }
        }
        return false;
    }

    public <T> T get(int key) {
        switch (key) {
            case 1: {
                return (T)((Object)this.mKind);
            }
            case 2: {
                return (T)this.mName;
            }
            case 3: {
                return (T)this.mDescription;
            }
            case 4: {
                return (T)this.mFields;
            }
            case 5: {
                return (T)this.mInterfaces;
            }
            case 6: {
                return (T)this.mPossibleTypes;
            }
            case 7: {
                return (T)this.mEnumValues;
            }
            case 8: {
                return (T)this.mInputFields;
            }
            case 9: {
                return (T)this.mOfType;
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Type other = (Type)o;
        return Objects.equals((Object)this.mKind, (Object)other.mKind) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mFields, other.mFields) && Objects.equals(this.mInterfaces, other.mInterfaces) && Objects.equals(this.mPossibleTypes, other.mPossibleTypes) && Objects.equals(this.mEnumValues, other.mEnumValues) && Objects.equals(this.mInputFields, other.mInputFields) && Objects.equals(this.mOfType, other.mOfType);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{Type.class, _Field.KIND, this.mKind, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.FIELDS, this.mFields, _Field.INTERFACES, this.mInterfaces, _Field.POSSIBLE_TYPES, this.mPossibleTypes, _Field.ENUM_VALUES, this.mEnumValues, _Field.INPUT_FIELDS, this.mInputFields, _Field.OF_TYPE, this.mOfType});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "gql_introspection.__Type" + this.asString();
    }

    @Nonnull
    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasKind()) {
            first = false;
            out.append("kind:").append(this.mKind.asString());
        }
        if (this.hasName()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        if (this.hasDescription()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("description:").append('\"').append(Strings.escape((CharSequence)this.mDescription)).append('\"');
        }
        if (this.hasFields()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("fields:").append(Strings.asString(this.mFields));
        }
        if (this.hasInterfaces()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("interfaces:").append(Strings.asString(this.mInterfaces));
        }
        if (this.hasPossibleTypes()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("possibleTypes:").append(Strings.asString(this.mPossibleTypes));
        }
        if (this.hasEnumValues()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("enumValues:").append(Strings.asString(this.mEnumValues));
        }
        if (this.hasInputFields()) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("inputFields:").append(Strings.asString(this.mInputFields));
        }
        if (this.hasOfType()) {
            if (!first) {
                out.append(',');
            }
            out.append("ofType:").append(this.mOfType.asString());
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(Type other) {
        int c = Boolean.compare(this.mKind != null, other.mKind != null);
        if (c != 0) {
            return c;
        }
        if (this.mKind != null && (c = Integer.compare(this.mKind.ordinal(), this.mKind.ordinal())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDescription != null, other.mDescription != null);
        if (c != 0) {
            return c;
        }
        if (this.mDescription != null && (c = this.mDescription.compareTo(other.mDescription)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mFields != null, other.mFields != null);
        if (c != 0) {
            return c;
        }
        if (this.mFields != null && (c = Integer.compare(this.mFields.hashCode(), other.mFields.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mInterfaces != null, other.mInterfaces != null);
        if (c != 0) {
            return c;
        }
        if (this.mInterfaces != null && (c = Integer.compare(this.mInterfaces.hashCode(), other.mInterfaces.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mPossibleTypes != null, other.mPossibleTypes != null);
        if (c != 0) {
            return c;
        }
        if (this.mPossibleTypes != null && (c = Integer.compare(this.mPossibleTypes.hashCode(), other.mPossibleTypes.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mEnumValues != null, other.mEnumValues != null);
        if (c != 0) {
            return c;
        }
        if (this.mEnumValues != null && (c = Integer.compare(this.mEnumValues.hashCode(), other.mEnumValues.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mInputFields != null, other.mInputFields != null);
        if (c != 0) {
            return c;
        }
        if (this.mInputFields != null && (c = Integer.compare(this.mInputFields.hashCode(), other.mInputFields.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mOfType != null, other.mOfType != null);
        if (c != 0) {
            return c;
        }
        if (this.mOfType != null && (c = this.mOfType.compareTo(other.mOfType)) != 0) {
            return c;
        }
        return 0;
    }

    public int writeBinary(BigEndianBinaryWriter writer) throws IOException {
        int length = 0;
        if (this.hasKind()) {
            length += writer.writeByte((byte)8);
            length += writer.writeShort((short)1);
            length += writer.writeInt(this.mKind.asInteger());
        }
        if (this.hasName()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)2);
            Binary tmp_1 = Binary.wrap((byte[])this.mName.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_1.length());
            length += writer.writeBinary(tmp_1);
        }
        if (this.hasDescription()) {
            length += writer.writeByte((byte)11);
            length += writer.writeShort((short)3);
            Binary tmp_2 = Binary.wrap((byte[])this.mDescription.getBytes(StandardCharsets.UTF_8));
            length += writer.writeUInt32(tmp_2.length());
            length += writer.writeBinary(tmp_2);
        }
        if (this.hasFields()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)4);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mFields.size());
            for (Field entry_3 : this.mFields) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_3);
            }
        }
        if (this.hasInterfaces()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)5);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mInterfaces.size());
            for (Type entry_4 : this.mInterfaces) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_4);
            }
        }
        if (this.hasPossibleTypes()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)6);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mPossibleTypes.size());
            for (Type entry_5 : this.mPossibleTypes) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_5);
            }
        }
        if (this.hasEnumValues()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)7);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mEnumValues.size());
            for (EnumValue entry_6 : this.mEnumValues) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_6);
            }
        }
        if (this.hasInputFields()) {
            length += writer.writeByte((byte)15);
            length += writer.writeShort((short)8);
            length += writer.writeByte((byte)12);
            length += writer.writeUInt32(this.mInputFields.size());
            for (InputValue entry_7 : this.mInputFields) {
                length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)entry_7);
            }
        }
        if (this.hasOfType()) {
            length += writer.writeByte((byte)12);
            length += writer.writeShort((short)9);
            length += BinaryFormatUtils.writeMessage((BigEndianBinaryWriter)writer, (PMessageOrBuilder)this.mOfType);
        }
        return length += writer.writeByte((byte)0);
    }

    @Nonnull
    public _Builder mutate() {
        return new _Builder(this);
    }

    @Nonnull
    public static PStructDescriptorProvider<Type> provider() {
        return new _Provider();
    }

    @Nonnull
    public PStructDescriptor<Type> descriptor() {
        return kDescriptor;
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<Type>
    implements Type_OrBuilder,
    BinaryReader {
        private BitSet optionals = new BitSet(9);
        private BitSet modified = new BitSet(9);
        private TypeKind mKind;
        private String mName;
        private String mDescription;
        private List<Field> mFields;
        private List<Type> mInterfaces;
        private List<Type> mPossibleTypes;
        private List<EnumValue> mEnumValues;
        private List<InputValue> mInputFields;
        private Type mOfType;
        private _Builder mOfType_builder;

        public _Builder() {
        }

        public _Builder(Type base) {
            this();
            if (base.hasKind()) {
                this.optionals.set(0);
                this.mKind = base.mKind;
            }
            if (base.hasName()) {
                this.optionals.set(1);
                this.mName = base.mName;
            }
            if (base.hasDescription()) {
                this.optionals.set(2);
                this.mDescription = base.mDescription;
            }
            if (base.hasFields()) {
                this.optionals.set(3);
                this.mFields = base.mFields;
            }
            if (base.hasInterfaces()) {
                this.optionals.set(4);
                this.mInterfaces = base.mInterfaces;
            }
            if (base.hasPossibleTypes()) {
                this.optionals.set(5);
                this.mPossibleTypes = base.mPossibleTypes;
            }
            if (base.hasEnumValues()) {
                this.optionals.set(6);
                this.mEnumValues = base.mEnumValues;
            }
            if (base.hasInputFields()) {
                this.optionals.set(7);
                this.mInputFields = base.mInputFields;
            }
            if (base.hasOfType()) {
                this.optionals.set(8);
                this.mOfType = base.mOfType;
            }
        }

        @Nonnull
        public _Builder merge(Type from) {
            if (from.hasKind()) {
                this.optionals.set(0);
                this.modified.set(0);
                this.mKind = from.getKind();
            }
            if (from.hasName()) {
                this.optionals.set(1);
                this.modified.set(1);
                this.mName = from.getName();
            }
            if (from.hasDescription()) {
                this.optionals.set(2);
                this.modified.set(2);
                this.mDescription = from.getDescription();
            }
            if (from.hasFields()) {
                this.optionals.set(3);
                this.modified.set(3);
                this.mFields = from.getFields();
            }
            if (from.hasInterfaces()) {
                this.optionals.set(4);
                this.modified.set(4);
                this.mInterfaces = from.getInterfaces();
            }
            if (from.hasPossibleTypes()) {
                this.optionals.set(5);
                this.modified.set(5);
                this.mPossibleTypes = from.getPossibleTypes();
            }
            if (from.hasEnumValues()) {
                this.optionals.set(6);
                this.modified.set(6);
                this.mEnumValues = from.getEnumValues();
            }
            if (from.hasInputFields()) {
                this.optionals.set(7);
                this.modified.set(7);
                this.mInputFields = from.getInputFields();
            }
            if (from.hasOfType()) {
                this.optionals.set(8);
                this.modified.set(8);
                if (this.mOfType_builder != null) {
                    this.mOfType_builder.merge(from.getOfType());
                } else if (this.mOfType != null) {
                    this.mOfType_builder = this.mOfType.mutate().merge(from.getOfType());
                    this.mOfType = null;
                } else {
                    this.mOfType = from.getOfType();
                }
            }
            return this;
        }

        @Nonnull
        public _Builder setKind(TypeKind value) {
            if (value == null) {
                return this.clearKind();
            }
            this.optionals.set(0);
            this.modified.set(0);
            this.mKind = value;
            return this;
        }

        public boolean isSetKind() {
            return this.optionals.get(0);
        }

        @Override
        public boolean hasKind() {
            return this.optionals.get(0);
        }

        public boolean isModifiedKind() {
            return this.modified.get(0);
        }

        @Nonnull
        public _Builder clearKind() {
            this.optionals.clear(0);
            this.modified.set(0);
            this.mKind = null;
            return this;
        }

        @Override
        public TypeKind getKind() {
            return this.mKind;
        }

        @Override
        @Nonnull
        public Optional<TypeKind> optionalKind() {
            return Optional.ofNullable(this.mKind);
        }

        @Nonnull
        public _Builder setName(String value) {
            if (value == null) {
                return this.clearName();
            }
            this.optionals.set(1);
            this.modified.set(1);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(1);
        }

        @Override
        public boolean hasName() {
            return this.optionals.get(1);
        }

        public boolean isModifiedName() {
            return this.modified.get(1);
        }

        @Nonnull
        public _Builder clearName() {
            this.optionals.clear(1);
            this.modified.set(1);
            this.mName = null;
            return this;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        @Nonnull
        public Optional<String> optionalName() {
            return Optional.ofNullable(this.mName);
        }

        @Nonnull
        public _Builder setDescription(String value) {
            if (value == null) {
                return this.clearDescription();
            }
            this.optionals.set(2);
            this.modified.set(2);
            this.mDescription = value;
            return this;
        }

        public boolean isSetDescription() {
            return this.optionals.get(2);
        }

        @Override
        public boolean hasDescription() {
            return this.optionals.get(2);
        }

        public boolean isModifiedDescription() {
            return this.modified.get(2);
        }

        @Nonnull
        public _Builder clearDescription() {
            this.optionals.clear(2);
            this.modified.set(2);
            this.mDescription = null;
            return this;
        }

        @Override
        public String getDescription() {
            return this.mDescription;
        }

        @Override
        @Nonnull
        public Optional<String> optionalDescription() {
            return Optional.ofNullable(this.mDescription);
        }

        @Nonnull
        public _Builder setFields(Collection<Field> value) {
            if (value == null) {
                return this.clearFields();
            }
            this.optionals.set(3);
            this.modified.set(3);
            this.mFields = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToFields(Field ... values) {
            this.optionals.set(3);
            this.modified.set(3);
            List<Field> _container = this.mutableFields();
            for (Field item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetFields() {
            return this.optionals.get(3);
        }

        @Override
        public boolean hasFields() {
            return this.optionals.get(3);
        }

        public boolean isModifiedFields() {
            return this.modified.get(3);
        }

        @Nonnull
        public _Builder clearFields() {
            this.optionals.clear(3);
            this.modified.set(3);
            this.mFields = null;
            return this;
        }

        public List<Field> mutableFields() {
            this.optionals.set(3);
            this.modified.set(3);
            if (this.mFields == null) {
                this.mFields = new ArrayList<Field>();
            } else if (!(this.mFields instanceof ArrayList)) {
                this.mFields = new ArrayList<Field>(this.mFields);
            }
            return this.mFields;
        }

        @Override
        public List<Field> getFields() {
            return this.mFields;
        }

        @Override
        @Nonnull
        public Optional<List<Field>> optionalFields() {
            return Optional.ofNullable(this.mFields);
        }

        @Override
        public int numFields() {
            return this.mFields != null ? this.mFields.size() : 0;
        }

        @Nonnull
        public _Builder setInterfaces(Collection<Type> value) {
            if (value == null) {
                return this.clearInterfaces();
            }
            this.optionals.set(4);
            this.modified.set(4);
            this.mInterfaces = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToInterfaces(Type ... values) {
            this.optionals.set(4);
            this.modified.set(4);
            List<Type> _container = this.mutableInterfaces();
            for (Type item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetInterfaces() {
            return this.optionals.get(4);
        }

        @Override
        public boolean hasInterfaces() {
            return this.optionals.get(4);
        }

        public boolean isModifiedInterfaces() {
            return this.modified.get(4);
        }

        @Nonnull
        public _Builder clearInterfaces() {
            this.optionals.clear(4);
            this.modified.set(4);
            this.mInterfaces = null;
            return this;
        }

        public List<Type> mutableInterfaces() {
            this.optionals.set(4);
            this.modified.set(4);
            if (this.mInterfaces == null) {
                this.mInterfaces = new ArrayList<Type>();
            } else if (!(this.mInterfaces instanceof ArrayList)) {
                this.mInterfaces = new ArrayList<Type>(this.mInterfaces);
            }
            return this.mInterfaces;
        }

        @Override
        public List<Type> getInterfaces() {
            return this.mInterfaces;
        }

        @Override
        @Nonnull
        public Optional<List<Type>> optionalInterfaces() {
            return Optional.ofNullable(this.mInterfaces);
        }

        @Override
        public int numInterfaces() {
            return this.mInterfaces != null ? this.mInterfaces.size() : 0;
        }

        @Nonnull
        public _Builder setPossibleTypes(Collection<Type> value) {
            if (value == null) {
                return this.clearPossibleTypes();
            }
            this.optionals.set(5);
            this.modified.set(5);
            this.mPossibleTypes = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToPossibleTypes(Type ... values) {
            this.optionals.set(5);
            this.modified.set(5);
            List<Type> _container = this.mutablePossibleTypes();
            for (Type item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetPossibleTypes() {
            return this.optionals.get(5);
        }

        @Override
        public boolean hasPossibleTypes() {
            return this.optionals.get(5);
        }

        public boolean isModifiedPossibleTypes() {
            return this.modified.get(5);
        }

        @Nonnull
        public _Builder clearPossibleTypes() {
            this.optionals.clear(5);
            this.modified.set(5);
            this.mPossibleTypes = null;
            return this;
        }

        public List<Type> mutablePossibleTypes() {
            this.optionals.set(5);
            this.modified.set(5);
            if (this.mPossibleTypes == null) {
                this.mPossibleTypes = new ArrayList<Type>();
            } else if (!(this.mPossibleTypes instanceof ArrayList)) {
                this.mPossibleTypes = new ArrayList<Type>(this.mPossibleTypes);
            }
            return this.mPossibleTypes;
        }

        @Override
        public List<Type> getPossibleTypes() {
            return this.mPossibleTypes;
        }

        @Override
        @Nonnull
        public Optional<List<Type>> optionalPossibleTypes() {
            return Optional.ofNullable(this.mPossibleTypes);
        }

        @Override
        public int numPossibleTypes() {
            return this.mPossibleTypes != null ? this.mPossibleTypes.size() : 0;
        }

        @Nonnull
        public _Builder setEnumValues(Collection<EnumValue> value) {
            if (value == null) {
                return this.clearEnumValues();
            }
            this.optionals.set(6);
            this.modified.set(6);
            this.mEnumValues = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToEnumValues(EnumValue ... values) {
            this.optionals.set(6);
            this.modified.set(6);
            List<EnumValue> _container = this.mutableEnumValues();
            for (EnumValue item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetEnumValues() {
            return this.optionals.get(6);
        }

        @Override
        public boolean hasEnumValues() {
            return this.optionals.get(6);
        }

        public boolean isModifiedEnumValues() {
            return this.modified.get(6);
        }

        @Nonnull
        public _Builder clearEnumValues() {
            this.optionals.clear(6);
            this.modified.set(6);
            this.mEnumValues = null;
            return this;
        }

        public List<EnumValue> mutableEnumValues() {
            this.optionals.set(6);
            this.modified.set(6);
            if (this.mEnumValues == null) {
                this.mEnumValues = new ArrayList<EnumValue>();
            } else if (!(this.mEnumValues instanceof ArrayList)) {
                this.mEnumValues = new ArrayList<EnumValue>(this.mEnumValues);
            }
            return this.mEnumValues;
        }

        @Override
        public List<EnumValue> getEnumValues() {
            return this.mEnumValues;
        }

        @Override
        @Nonnull
        public Optional<List<EnumValue>> optionalEnumValues() {
            return Optional.ofNullable(this.mEnumValues);
        }

        @Override
        public int numEnumValues() {
            return this.mEnumValues != null ? this.mEnumValues.size() : 0;
        }

        @Nonnull
        public _Builder setInputFields(Collection<InputValue> value) {
            if (value == null) {
                return this.clearInputFields();
            }
            this.optionals.set(7);
            this.modified.set(7);
            this.mInputFields = UnmodifiableList.copyOf(value);
            return this;
        }

        @Nonnull
        public _Builder addToInputFields(InputValue ... values) {
            this.optionals.set(7);
            this.modified.set(7);
            List<InputValue> _container = this.mutableInputFields();
            for (InputValue item : values) {
                _container.add(item);
            }
            return this;
        }

        public boolean isSetInputFields() {
            return this.optionals.get(7);
        }

        @Override
        public boolean hasInputFields() {
            return this.optionals.get(7);
        }

        public boolean isModifiedInputFields() {
            return this.modified.get(7);
        }

        @Nonnull
        public _Builder clearInputFields() {
            this.optionals.clear(7);
            this.modified.set(7);
            this.mInputFields = null;
            return this;
        }

        public List<InputValue> mutableInputFields() {
            this.optionals.set(7);
            this.modified.set(7);
            if (this.mInputFields == null) {
                this.mInputFields = new ArrayList<InputValue>();
            } else if (!(this.mInputFields instanceof ArrayList)) {
                this.mInputFields = new ArrayList<InputValue>(this.mInputFields);
            }
            return this.mInputFields;
        }

        @Override
        public List<InputValue> getInputFields() {
            return this.mInputFields;
        }

        @Override
        @Nonnull
        public Optional<List<InputValue>> optionalInputFields() {
            return Optional.ofNullable(this.mInputFields);
        }

        @Override
        public int numInputFields() {
            return this.mInputFields != null ? this.mInputFields.size() : 0;
        }

        @Nonnull
        public _Builder setOfType(Type_OrBuilder value) {
            if (value == null) {
                return this.clearOfType();
            }
            this.optionals.set(8);
            this.modified.set(8);
            if (value instanceof _Builder) {
                value = ((_Builder)value).build();
            } else if (!(value instanceof Type)) {
                throw new IllegalArgumentException("Invalid type for gql_introspection.__Type: " + value.getClass().getName());
            }
            this.mOfType = (Type)value;
            this.mOfType_builder = null;
            return this;
        }

        public boolean isSetOfType() {
            return this.optionals.get(8);
        }

        @Override
        public boolean hasOfType() {
            return this.optionals.get(8);
        }

        public boolean isModifiedOfType() {
            return this.modified.get(8);
        }

        @Nonnull
        public _Builder clearOfType() {
            this.optionals.clear(8);
            this.modified.set(8);
            this.mOfType = null;
            this.mOfType_builder = null;
            return this;
        }

        @Nonnull
        public _Builder mutableOfType() {
            this.optionals.set(8);
            this.modified.set(8);
            if (this.mOfType != null) {
                this.mOfType_builder = this.mOfType.mutate();
                this.mOfType = null;
            } else if (this.mOfType_builder == null) {
                this.mOfType_builder = Type.builder();
            }
            return this.mOfType_builder;
        }

        @Override
        public Type getOfType() {
            return this.mOfType_builder != null ? this.mOfType_builder.build() : this.mOfType;
        }

        @Override
        @Nonnull
        public Optional<Type> optionalOfType() {
            return Optional.ofNullable(this.mOfType_builder != null ? this.mOfType_builder.build() : this.mOfType);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !o.getClass().equals(this.getClass())) {
                return false;
            }
            _Builder other = (_Builder)o;
            return Objects.equals(this.optionals, other.optionals) && Objects.equals((Object)this.mKind, (Object)other.mKind) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDescription, other.mDescription) && Objects.equals(this.mFields, other.mFields) && Objects.equals(this.mInterfaces, other.mInterfaces) && Objects.equals(this.mPossibleTypes, other.mPossibleTypes) && Objects.equals(this.mEnumValues, other.mEnumValues) && Objects.equals(this.mInputFields, other.mInputFields) && Objects.equals(this.getOfType(), other.getOfType());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{Type.class, this.optionals, _Field.KIND, this.mKind, _Field.NAME, this.mName, _Field.DESCRIPTION, this.mDescription, _Field.FIELDS, this.mFields, _Field.INTERFACES, this.mInterfaces, _Field.POSSIBLE_TYPES, this.mPossibleTypes, _Field.ENUM_VALUES, this.mEnumValues, _Field.INPUT_FIELDS, this.mInputFields, _Field.OF_TYPE, this.getOfType()});
        }

        public PMessageBuilder mutator(int key) {
            switch (key) {
                case 9: {
                    return this.mutableOfType();
                }
            }
            throw new IllegalArgumentException("Not a message field ID: " + key);
        }

        @Nonnull
        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setKind((TypeKind)((Object)value));
                    break;
                }
                case 2: {
                    this.setName((String)value);
                    break;
                }
                case 3: {
                    this.setDescription((String)value);
                    break;
                }
                case 4: {
                    this.setFields((List)value);
                    break;
                }
                case 5: {
                    this.setInterfaces((List)value);
                    break;
                }
                case 6: {
                    this.setPossibleTypes((List)value);
                    break;
                }
                case 7: {
                    this.setEnumValues((List)value);
                    break;
                }
                case 8: {
                    this.setInputFields((List)value);
                    break;
                }
                case 9: {
                    this.setOfType((Type)value);
                    break;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            switch (key) {
                case 1: {
                    return this.optionals.get(0);
                }
                case 2: {
                    return this.optionals.get(1);
                }
                case 3: {
                    return this.optionals.get(2);
                }
                case 4: {
                    return this.optionals.get(3);
                }
                case 5: {
                    return this.optionals.get(4);
                }
                case 6: {
                    return this.optionals.get(5);
                }
                case 7: {
                    return this.optionals.get(6);
                }
                case 8: {
                    return this.optionals.get(7);
                }
                case 9: {
                    return this.optionals.get(8);
                }
            }
            return false;
        }

        public boolean isModified(int key) {
            switch (key) {
                case 1: {
                    return this.modified.get(0);
                }
                case 2: {
                    return this.modified.get(1);
                }
                case 3: {
                    return this.modified.get(2);
                }
                case 4: {
                    return this.modified.get(3);
                }
                case 5: {
                    return this.modified.get(4);
                }
                case 6: {
                    return this.modified.get(5);
                }
                case 7: {
                    return this.modified.get(6);
                }
                case 8: {
                    return this.modified.get(7);
                }
                case 9: {
                    return this.modified.get(8);
                }
            }
            return false;
        }

        public <T> T get(int key) {
            switch (key) {
                case 1: {
                    return (T)((Object)this.getKind());
                }
                case 2: {
                    return (T)this.getName();
                }
                case 3: {
                    return (T)this.getDescription();
                }
                case 4: {
                    return (T)this.getFields();
                }
                case 5: {
                    return (T)this.getInterfaces();
                }
                case 6: {
                    return (T)this.getPossibleTypes();
                }
                case 7: {
                    return (T)this.getEnumValues();
                }
                case 8: {
                    return (T)this.getInputFields();
                }
                case 9: {
                    return (T)this.getOfType();
                }
            }
            return null;
        }

        public boolean has(int key) {
            switch (key) {
                case 1: {
                    return this.mKind != null;
                }
                case 2: {
                    return this.mName != null;
                }
                case 3: {
                    return this.mDescription != null;
                }
                case 4: {
                    return this.mFields != null;
                }
                case 5: {
                    return this.mInterfaces != null;
                }
                case 6: {
                    return this.mPossibleTypes != null;
                }
                case 7: {
                    return this.mEnumValues != null;
                }
                case 8: {
                    return this.mInputFields != null;
                }
                case 9: {
                    return this.mOfType != null || this.mOfType_builder != null;
                }
            }
            return false;
        }

        @Nonnull
        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 4: {
                    this.addToFields((Field)value);
                    break;
                }
                case 5: {
                    this.addToInterfaces((Type)value);
                    break;
                }
                case 6: {
                    this.addToPossibleTypes((Type)value);
                    break;
                }
                case 7: {
                    this.addToEnumValues((EnumValue)value);
                    break;
                }
                case 8: {
                    this.addToInputFields((InputValue)value);
                    break;
                }
            }
            return this;
        }

        @Nonnull
        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearKind();
                    break;
                }
                case 2: {
                    this.clearName();
                    break;
                }
                case 3: {
                    this.clearDescription();
                    break;
                }
                case 4: {
                    this.clearFields();
                    break;
                }
                case 5: {
                    this.clearInterfaces();
                    break;
                }
                case 6: {
                    this.clearPossibleTypes();
                    break;
                }
                case 7: {
                    this.clearEnumValues();
                    break;
                }
                case 8: {
                    this.clearInputFields();
                    break;
                }
                case 9: {
                    this.clearOfType();
                    break;
                }
            }
            return this;
        }

        public boolean valid() {
            return this.optionals.get(0);
        }

        public _Builder validate() {
            if (!this.valid()) {
                ArrayList<String> missing = new ArrayList<String>();
                if (!this.optionals.get(0)) {
                    missing.add("kind");
                }
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message gql_introspection.__Type");
            }
            return this;
        }

        @Nonnull
        public PStructDescriptor<Type> descriptor() {
            return kDescriptor;
        }

        public void readBinary(BigEndianBinaryReader reader, boolean strict) throws IOException {
            byte type = reader.expectByte();
            while (type != 0) {
                short field = reader.expectShort();
                switch (field) {
                    case 1: {
                        if (type == 8) {
                            this.mKind = TypeKind.findById(reader.expectInt());
                            this.optionals.set(0);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.kind, should be struct(12)", new Object[0]);
                    }
                    case 2: {
                        if (type == 11) {
                            int len_1 = reader.expectUInt32();
                            this.mName = new String(reader.expectBytes(len_1), StandardCharsets.UTF_8);
                            this.optionals.set(1);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.name, should be struct(12)", new Object[0]);
                    }
                    case 3: {
                        if (type == 11) {
                            int len_2 = reader.expectUInt32();
                            this.mDescription = new String(reader.expectBytes(len_2), StandardCharsets.UTF_8);
                            this.optionals.set(2);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.description, should be struct(12)", new Object[0]);
                    }
                    case 4: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_3;
                            byte t_5 = reader.expectByte();
                            if (t_5 == 12) {
                                int len_4 = reader.expectUInt32();
                                b_3 = UnmodifiableList.builder((int)len_4);
                                for (int i_6 = 0; i_6 < len_4; ++i_6) {
                                    Field key_7 = (Field)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, Field.kDescriptor, (boolean)strict);
                                    b_3.add((Object)key_7);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_5) + " for gql_introspection.__Type.fields, should be struct(12)", new Object[0]);
                            }
                            this.mFields = b_3.build();
                            this.optionals.set(3);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.fields, should be struct(12)", new Object[0]);
                    }
                    case 5: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_8;
                            byte t_10 = reader.expectByte();
                            if (t_10 == 12) {
                                int len_9 = reader.expectUInt32();
                                b_8 = UnmodifiableList.builder((int)len_9);
                                for (int i_11 = 0; i_11 < len_9; ++i_11) {
                                    Type key_12 = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, kDescriptor, (boolean)strict);
                                    b_8.add((Object)key_12);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_10) + " for gql_introspection.__Type.interfaces, should be struct(12)", new Object[0]);
                            }
                            this.mInterfaces = b_8.build();
                            this.optionals.set(4);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.interfaces, should be struct(12)", new Object[0]);
                    }
                    case 6: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_13;
                            byte t_15 = reader.expectByte();
                            if (t_15 == 12) {
                                int len_14 = reader.expectUInt32();
                                b_13 = UnmodifiableList.builder((int)len_14);
                                for (int i_16 = 0; i_16 < len_14; ++i_16) {
                                    Type key_17 = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, kDescriptor, (boolean)strict);
                                    b_13.add((Object)key_17);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_15) + " for gql_introspection.__Type.possibleTypes, should be struct(12)", new Object[0]);
                            }
                            this.mPossibleTypes = b_13.build();
                            this.optionals.set(5);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.possibleTypes, should be struct(12)", new Object[0]);
                    }
                    case 7: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_18;
                            byte t_20 = reader.expectByte();
                            if (t_20 == 12) {
                                int len_19 = reader.expectUInt32();
                                b_18 = UnmodifiableList.builder((int)len_19);
                                for (int i_21 = 0; i_21 < len_19; ++i_21) {
                                    EnumValue key_22 = (EnumValue)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, EnumValue.kDescriptor, (boolean)strict);
                                    b_18.add((Object)key_22);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_20) + " for gql_introspection.__Type.enumValues, should be struct(12)", new Object[0]);
                            }
                            this.mEnumValues = b_18.build();
                            this.optionals.set(6);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.enumValues, should be struct(12)", new Object[0]);
                    }
                    case 8: {
                        if (type == 15) {
                            UnmodifiableList.Builder b_23;
                            byte t_25 = reader.expectByte();
                            if (t_25 == 12) {
                                int len_24 = reader.expectUInt32();
                                b_23 = UnmodifiableList.builder((int)len_24);
                                for (int i_26 = 0; i_26 < len_24; ++i_26) {
                                    InputValue key_27 = (InputValue)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, InputValue.kDescriptor, (boolean)strict);
                                    b_23.add((Object)key_27);
                                }
                            } else {
                                throw new SerializerException("Wrong item type " + BinaryType.asString((byte)t_25) + " for gql_introspection.__Type.inputFields, should be struct(12)", new Object[0]);
                            }
                            this.mInputFields = b_23.build();
                            this.optionals.set(7);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.inputFields, should be struct(12)", new Object[0]);
                    }
                    case 9: {
                        if (type == 12) {
                            this.mOfType = (Type)BinaryFormatUtils.readMessage((BigEndianBinaryReader)reader, kDescriptor, (boolean)strict);
                            this.optionals.set(8);
                            break;
                        }
                        throw new SerializerException("Wrong type " + BinaryType.asString((byte)type) + " for gql_introspection.__Type.ofType, should be struct(12)", new Object[0]);
                    }
                    default: {
                        BinaryFormatUtils.readFieldValue((BigEndianBinaryReader)reader, (BinaryFormatUtils.FieldInfo)new BinaryFormatUtils.FieldInfo((int)field, type), null, (boolean)false);
                    }
                }
                type = reader.expectByte();
            }
        }

        @Nonnull
        public Type build() {
            return new Type(this);
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<Type> {
        private _Provider() {
        }

        @Nonnull
        public PStructDescriptor<Type> descriptor() {
            return kDescriptor;
        }
    }

    private static final class _Descriptor
    extends PStructDescriptor<Type> {
        public _Descriptor() {
            super("gql_introspection", "__Type", _Builder::new, false);
        }

        @Nonnull
        public boolean isInnerType() {
            return false;
        }

        @Nonnull
        public boolean isAutoType() {
            return false;
        }

        @Nonnull
        public _Field[] getFields() {
            return _Field.values();
        }

        @Nullable
        public _Field findFieldByName(String name) {
            return _Field.findByName(name);
        }

        @Nullable
        public _Field findFieldByPojoName(String name) {
            return _Field.findByPojoName(name);
        }

        @Nullable
        public _Field findFieldById(int id) {
            return _Field.findById(id);
        }
    }

    public static enum _Field implements PField<Type>
    {
        KIND(1, PRequirement.REQUIRED, "kind", "kind", (PDescriptorProvider)TypeKind.provider(), null, null),
        NAME(2, PRequirement.OPTIONAL, "name", "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        DESCRIPTION(3, PRequirement.OPTIONAL, "description", "description", (PDescriptorProvider)PPrimitive.STRING.provider(), null, null),
        FIELDS(4, PRequirement.OPTIONAL, "fields", "fields", (PDescriptorProvider)PList.provider(Field.provider()), FieldsArguments.provider(), null),
        INTERFACES(5, PRequirement.OPTIONAL, "interfaces", "interfaces", (PDescriptorProvider)PList.provider(Type.provider()), null, null),
        POSSIBLE_TYPES(6, PRequirement.OPTIONAL, "possibleTypes", "possibleTypes", (PDescriptorProvider)PList.provider(Type.provider()), null, null),
        ENUM_VALUES(7, PRequirement.OPTIONAL, "enumValues", "enumValues", (PDescriptorProvider)PList.provider(EnumValue.provider()), FieldsArguments.provider(), null),
        INPUT_FIELDS(8, PRequirement.OPTIONAL, "inputFields", "inputFields", (PDescriptorProvider)PList.provider(InputValue.provider()), null, null),
        OF_TYPE(9, PRequirement.OPTIONAL, "ofType", "ofType", (PDescriptorProvider)Type.provider(), null, null);

        private final int mId;
        private final PRequirement mRequired;
        private final String mName;
        private final String mPojoName;
        private final PDescriptorProvider mTypeProvider;
        private final PStructDescriptorProvider mArgumentsProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int id, PRequirement required, String name, String pojoName, PDescriptorProvider typeProvider, PStructDescriptorProvider argumentsProvider, PValueProvider<?> defaultValue) {
            this.mId = id;
            this.mRequired = required;
            this.mName = name;
            this.mPojoName = pojoName;
            this.mTypeProvider = typeProvider;
            this.mArgumentsProvider = argumentsProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getId() {
            return this.mId;
        }

        @Nonnull
        public PRequirement getRequirement() {
            return this.mRequired;
        }

        @Nonnull
        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        @Nullable
        public PStructDescriptor getArgumentsType() {
            return this.mArgumentsProvider == null ? null : this.mArgumentsProvider.descriptor();
        }

        @Nonnull
        public String getName() {
            return this.mName;
        }

        @Nonnull
        public String getPojoName() {
            return this.mPojoName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        @Nonnull
        public PMessageDescriptor<Type> onMessageType() {
            return kDescriptor;
        }

        public String toString() {
            return PField.asString((PField)this);
        }

        public static _Field findById(int id) {
            switch (id) {
                case 1: {
                    return KIND;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return DESCRIPTION;
                }
                case 4: {
                    return FIELDS;
                }
                case 5: {
                    return INTERFACES;
                }
                case 6: {
                    return POSSIBLE_TYPES;
                }
                case 7: {
                    return ENUM_VALUES;
                }
                case 8: {
                    return INPUT_FIELDS;
                }
                case 9: {
                    return OF_TYPE;
                }
            }
            return null;
        }

        public static _Field findByName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "kind": {
                    return KIND;
                }
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "fields": {
                    return FIELDS;
                }
                case "interfaces": {
                    return INTERFACES;
                }
                case "possibleTypes": {
                    return POSSIBLE_TYPES;
                }
                case "enumValues": {
                    return ENUM_VALUES;
                }
                case "inputFields": {
                    return INPUT_FIELDS;
                }
                case "ofType": {
                    return OF_TYPE;
                }
            }
            return null;
        }

        public static _Field findByPojoName(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "kind": {
                    return KIND;
                }
                case "name": {
                    return NAME;
                }
                case "description": {
                    return DESCRIPTION;
                }
                case "fields": {
                    return FIELDS;
                }
                case "interfaces": {
                    return INTERFACES;
                }
                case "possibleTypes": {
                    return POSSIBLE_TYPES;
                }
                case "enumValues": {
                    return ENUM_VALUES;
                }
                case "inputFields": {
                    return INPUT_FIELDS;
                }
                case "ofType": {
                    return OF_TYPE;
                }
            }
            return null;
        }

        public static _Field fieldForId(int id) {
            _Field field = _Field.findById(id);
            if (field == null) {
                throw new IllegalArgumentException("No such field id " + id + " in gql_introspection.__Type");
            }
            return field;
        }

        public static _Field fieldForName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Type");
            }
            return field;
        }

        public static _Field fieldForPojoName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Null name argument");
            }
            _Field field = _Field.findByPojoName(name);
            if (field == null) {
                throw new IllegalArgumentException("No such field \"" + name + "\" in gql_introspection.__Type");
            }
            return field;
        }
    }
}

