/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.graphql.gql;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.json.JsonWriter;

public class GQLUtil {
    public static PField<?> baseField(PField<?> field) {
        PField base;
        PInterfaceDescriptor ifd = field.onMessageType().getImplementing();
        if (ifd != null && (base = ifd.findFieldByName(field.getName())) != null) {
            return base;
        }
        return field;
    }

    public static String toArgumentString(Object o) {
        if (o instanceof PMessage) {
            PMessage m = (PMessage)o;
            StringBuilder builder = new StringBuilder("{");
            boolean first = true;
            for (PField pf : m.descriptor().getFields()) {
                if (!m.has(pf.getId())) continue;
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(pf.getName()).append(": ").append(GQLUtil.toArgumentString(m.get(pf.getId())));
            }
            return builder.append("}").toString();
        }
        if (o instanceof Binary) {
            return "\"" + ((Binary)o).toBase64() + "\"";
        }
        if (o instanceof CharSequence) {
            StringWriter writer = new StringWriter();
            new JsonWriter(new PrintWriter(writer)).value((CharSequence)o).flush();
            return writer.toString();
        }
        return Strings.asString((Object)o);
    }
}

